/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.codeInsight.ExternalAnnotationsArtifactsResolver;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.data.ExternalAnnotationsDataServiceKt;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Order(value=1000)
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J6\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/data/ExternalAnnotationsDataService;", "Lcom/intellij/openapi/externalSystem/service/project/manage/AbstractProjectDataService;", "Lcom/intellij/openapi/externalSystem/model/project/LibraryData;", "Lcom/intellij/openapi/roots/libraries/Library;", "()V", "getTargetDataKey", "Lcom/intellij/openapi/externalSystem/model/Key;", "onSuccessImport", "", "imported", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "Companion", "intellij.gradle.java"})
public final class ExternalAnnotationsDataService
extends AbstractProjectDataService<LibraryData, Library> {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"ProjectKeys.LIBRARY");
        return key;
    }

    /*
     * WARNING - void declaration
     */
    public void onSuccessImport(@NotNull Collection<DataNode<LibraryData>> imported, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        void $this$mapNotNullTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull(imported, (String)"imported");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        ExtensionPointName extensionPointName = ExternalAnnotationsArtifactsResolver.EP_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"ExternalAnnotationsArtifactsResolver.EP_NAME");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ExternalAnnotationsArtif\u2026ver.EP_NAME.extensionList");
        ExternalAnnotationsArtifactsResolver externalAnnotationsArtifactsResolver = (ExternalAnnotationsArtifactsResolver)CollectionsKt.firstOrNull((List)list);
        if (externalAnnotationsArtifactsResolver == null) {
            return;
        }
        ExternalAnnotationsArtifactsResolver resolver = externalAnnotationsArtifactsResolver;
        Iterable $this$mapNotNull$iv = imported;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Pair<Library, Collection<AnnotationsLocation>> pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            DataNode it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            Object object2 = it.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"it.data");
            LibraryData libData = (LibraryData)object2;
            if (modelsProvider.getLibraryByName(libData.getInternalName()) == null) {
                pair = null;
            } else {
                Library lib;
                Intrinsics.checkExpressionValueIsNotNull((Object)lib, (String)"modelsProvider.getLibrar\u2026?: return@mapNotNull null");
                pair = ExternalAnnotationsDataServiceKt.lookForLocations(lib, libData);
            }
            if (pair == null) continue;
            Pair<Library, Collection<AnnotationsLocation>> pair2 = pair;
            boolean bl3 = false;
            boolean bl4 = false;
            Pair<Library, Collection<AnnotationsLocation>> it$iv$iv = pair2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map providedAnnotations = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        ExternalAnnotationsDataServiceKt.resolveProvidedAnnotations(providedAnnotations, resolver, project);
        if (!Registry.is((String)"external.system.import.resolve.annotations")) {
            return;
        }
        if (imported.isEmpty()) {
            return;
        }
        ProjectData projectData2 = projectData;
        if (projectData2 != null) {
            boolean importRepositories;
            Object v9;
            block9: {
                $this$mapNotNull$iv = projectData2;
                $i$f$mapNotNull = false;
                boolean $this$mapNotNullTo$iv$iv2 = false;
                Iterable $this$apply = $this$mapNotNull$iv;
                boolean bl = false;
                GradleSettings gradleSettings = GradleSettings.getInstance((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)gradleSettings, (String)"GradleSettings\n          .getInstance(project)");
                Collection collection = gradleSettings.getLinkedProjectsSettings();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"GradleSettings\n         \u2026  .linkedProjectsSettings");
                Iterable iterable2 = collection;
                boolean bl6 = false;
                object = iterable2;
                boolean bl7 = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    GradleProjectSettings settings = (GradleProjectSettings)t;
                    boolean bl8 = false;
                    GradleProjectSettings gradleProjectSettings = settings;
                    Intrinsics.checkExpressionValueIsNotNull((Object)gradleProjectSettings, (String)"settings");
                    if (!Intrinsics.areEqual((Object)gradleProjectSettings.getExternalProjectPath(), (Object)$this$apply.getLinkedExternalProjectPath())) continue;
                    v9 = t;
                    break block9;
                }
                v9 = null;
            }
            GradleProjectSettings gradleProjectSettings = v9;
            boolean bl = importRepositories = gradleProjectSettings != null ? gradleProjectSettings.isResolveExternalAnnotations() : false;
            if (!importRepositories) {
                return;
            }
        }
        int totalSize = imported.size();
        String title$iv = "Resolving external annotations";
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title$iv, cancellable$iv, project, title$iv, cancellable$iv, imported, modelsProvider, resolver, project, totalSize){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ Collection $imported$inlined;
            final /* synthetic */ IdeModelsProvider $modelsProvider$inlined;
            final /* synthetic */ ExternalAnnotationsArtifactsResolver $resolver$inlined;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ int $totalSize$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$imported$inlined = collection;
                this.$modelsProvider$inlined = ideModelsProvider;
                this.$resolver$inlined = externalAnnotationsArtifactsResolver;
                this.$project$inlined = project;
                this.$totalSize$inlined = n;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                indicator2.setIndeterminate(false);
                Iterable $this$forEachIndexed$iv = this.$imported$inlined;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (T item$iv : $this$forEachIndexed$iv) {
                    String libraryName;
                    void dataNode;
                    int n = index$iv++;
                    boolean bl2 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    DataNode dataNode2 = (DataNode)item$iv;
                    int index = n2;
                    boolean bl3 = false;
                    if (indicator2.isCanceled()) break;
                    Object object = dataNode.getData();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dataNode.data");
                    LibraryData libraryData = (LibraryData)object;
                    Intrinsics.checkExpressionValueIsNotNull((Object)libraryData.getInternalName(), (String)"libraryData.internalName");
                    Library library = this.$modelsProvider$inlined.getLibraryByName(libraryName);
                    if (library != null) {
                        indicator2.setText("Looking for annotations for '" + libraryName + '\'');
                        String mavenId = libraryData.getGroupId() + ':' + libraryData.getArtifactId() + ':' + libraryData.getVersion();
                        this.$resolver$inlined.resolve(this.$project$inlined, library, mavenId);
                    }
                    indicator2.setFraction((double)(index + 1) / (double)this.$totalSize$inlined);
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ExternalAnnotationsDataService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Exter\u2026sDataService::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/data/ExternalAnnotationsDataService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle.java"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

