/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
public class JavaGradleProjectResolver
extends AbstractProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(JavaGradleProjectResolver.class);

    public void populateProjectExtraModels(@NotNull IdeaProject gradleProject, @NotNull DataNode<ProjectData> ideProject) {
        if (gradleProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(0);
        }
        if (ideProject == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(1);
        }
        String projectDirPath = this.resolverCtx.getProjectPath();
        IdeaProject ideaProject = this.resolverCtx.getModels().getIdeaProject();
        JavaProjectData javaProjectData = new JavaProjectData(GradleConstants.SYSTEM_ID, projectDirPath + "/build/classes");
        javaProjectData.setJdkVersion(ideaProject.getJdkName());
        LanguageLevel resolvedLanguageLevel = null;
        String languageLevel = ideaProject.getLanguageLevel().getLevel();
        for (LanguageLevel level : LanguageLevel.values()) {
            if (!level.name().equals(languageLevel)) continue;
            resolvedLanguageLevel = level;
            break;
        }
        if (resolvedLanguageLevel != null) {
            javaProjectData.setLanguageLevel(resolvedLanguageLevel);
        } else {
            javaProjectData.setLanguageLevel(languageLevel);
        }
        ideProject.createChild(JavaProjectData.KEY, (Object)javaProjectData);
        this.nextResolver.populateProjectExtraModels(gradleProject, ideProject);
    }

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        BuildScriptClasspathModel buildScriptClasspathModel;
        if (gradleModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(2);
        }
        if (ideModule == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(3);
        }
        List classpathEntries = (buildScriptClasspathModel = (BuildScriptClasspathModel)this.resolverCtx.getExtraProject(gradleModule, BuildScriptClasspathModel.class)) != null ? ContainerUtil.map((Collection)buildScriptClasspathModel.getClasspath(), model -> BuildScriptClasspathData.ClasspathEntry.create((Set)model.getClasses(), (Set)model.getSources(), (Set)model.getJavadoc())) : ContainerUtil.emptyList();
        BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
        buildScriptClasspathData.setGradleHomeDir(buildScriptClasspathModel != null ? buildScriptClasspathModel.getGradleHomeDir() : null);
        ideModule.createChild(BuildScriptClasspathData.KEY, GradleProjectResolverUtil.intern((ProjectResolverContext)this.resolverCtx, (Object)buildScriptClasspathData));
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    @NotNull
    public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        ExternalSystemException friendlyError;
        if (error == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(4);
        }
        if (projectPath == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(5);
        }
        if ((friendlyError = new JavaProjectImportErrorHandler().getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath)) != null) {
            if (friendlyError.getCause() == null) {
                friendlyError.initCause(error);
            }
            ExternalSystemException externalSystemException = friendlyError;
            if (externalSystemException == null) {
                JavaGradleProjectResolver.$$$reportNull$$$0(6);
            }
            return externalSystemException;
        }
        ExternalSystemException externalSystemException = super.getUserFriendlyError(buildEnvironment, error, projectPath, buildFilePath);
        if (externalSystemException == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(7);
        }
        return externalSystemException;
    }

    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull Consumer<String> initScriptConsumer, boolean testExecutionExpected) {
        if (taskNames == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(8);
        }
        if (initScriptConsumer == null) {
            JavaGradleProjectResolver.$$$reportNull$$$0(9);
        }
        if (testExecutionExpected) {
            try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/org/jetbrains/plugins/gradle/java/addTestListener.groovy");){
                String addTestListenerScript = StreamUtil.readText((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                initScriptConsumer.consume((Object)addTestListenerScript);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/project/JavaGradleProjectResolver";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScriptConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/project/JavaGradleProjectResolver";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserFriendlyError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "populateProjectExtraModels";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleExtraModels";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUserFriendlyError";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "enhanceTaskProcessing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JavaProjectImportErrorHandler
    extends AbstractProjectImportErrorHandler {
        private JavaProjectImportErrorHandler() {
        }

        @Nullable
        public ExternalSystemException getUserFriendlyError(@Nullable BuildEnvironment buildEnvironment, @NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
            String rootCauseText;
            GradleExecutionErrorHandler executionErrorHandler;
            ExternalSystemException friendlyError;
            if (error == null) {
                JavaProjectImportErrorHandler.$$$reportNull$$$0(0);
            }
            if (projectPath == null) {
                JavaProjectImportErrorHandler.$$$reportNull$$$0(1);
            }
            if ((friendlyError = (executionErrorHandler = new GradleExecutionErrorHandler(error, projectPath, buildFilePath)).getUserFriendlyError()) != null) {
                return friendlyError;
            }
            Throwable rootCause = executionErrorHandler.getRootCause();
            String location = executionErrorHandler.getLocation();
            if (location == null && !StringUtil.isEmpty((String)buildFilePath)) {
                location = String.format("Build file: '%1$s'", buildFilePath);
            }
            if (StringUtil.startsWith((CharSequence)(rootCauseText = rootCause.toString()), (CharSequence)"org.gradle.api.internal.MissingMethodException")) {
                String method = this.parseMissingMethod(rootCauseText);
                String msg = "Build script error, unsupported Gradle DSL method found: '" + method + "'!";
                msg = msg + "\n\nPossible causes could be:  ";
                msg = msg + String.format("%s  - you are using Gradle version where the method is absent (<a href=\"%s\">Fix Gradle settings</a>)", Character.valueOf('\n'), "open_gradle_settings");
                msg = msg + String.format("%s  - you didn't apply Gradle plugin which provides the method (<a href=\"%s\">Apply Gradle plugin</a>)", Character.valueOf('\n'), "apply_gradle_plugin");
                msg = msg + String.format("%s  - or there is a mistake in a build script (<a href=\"%s\">Goto source</a>)", Character.valueOf('\n'), "goto_source");
                return this.createUserFriendlyError(msg, location, new String[]{"open_gradle_settings", "apply_gradle_plugin", "goto_source"});
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "error";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "projectPath";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/service/project/JavaGradleProjectResolver$JavaProjectImportErrorHandler";
            objectArray[2] = "getUserFriendlyError";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

