/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.build;

import com.intellij.build.BuildViewManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.task.ExecuteRunConfigurationTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ModuleResourcesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.JpsProjectTaskRunner;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.execution.build.GradleBuildTasksProvider;
import org.jetbrains.plugins.gradle.execution.build.GradleExecutionEnvironmentProvider;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectTaskRunner
extends ProjectTaskRunner {
    @Language(value="Groovy")
    private static final String FORCE_COMPILE_TASKS_INIT_SCRIPT_TEMPLATE = "projectsEvaluated { \n  rootProject.findProject('%s')?.tasks?.withType(AbstractCompile) {  \n    outputs.upToDateWhen { false } \n  } \n}\n";

    public void run(final @NotNull Project project, @NotNull ProjectTaskContext context, final @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks) {
        if (project == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(1);
        }
        if (tasks == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(2);
        }
        MultiMap buildTasksMap = MultiMap.createLinkedSet();
        MultiMap cleanTasksMap = MultiMap.createLinkedSet();
        MultiMap initScripts = MultiMap.createLinkedSet();
        Map taskMap = JpsProjectTaskRunner.groupBy(tasks);
        final List<Module> modulesToBuild = GradleProjectTaskRunner.addModulesBuildTasks((Collection)taskMap.get(ModuleBuildTask.class), (MultiMap<String, String>)buildTasksMap, (MultiMap<String, String>)initScripts);
        final List<Module> modulesOfResourcesToBuild = GradleProjectTaskRunner.addModulesBuildTasks((Collection)taskMap.get(ModuleResourcesBuildTask.class), (MultiMap<String, String>)buildTasksMap, (MultiMap<String, String>)initScripts);
        final List<Module> modulesOfFiles = GradleProjectTaskRunner.addModulesBuildTasks((Collection)taskMap.get(ModuleFilesBuildTask.class), (MultiMap<String, String>)buildTasksMap, (MultiMap<String, String>)initScripts);
        GradleProjectTaskRunner.addArtifactsBuildTasks((Collection)taskMap.get(ProjectModelBuildTask.class), (MultiMap<String, String>)cleanTasksMap, (MultiMap<String, String>)buildTasksMap);
        final Set rootPaths = buildTasksMap.keySet();
        final AtomicInteger successCounter = new AtomicInteger();
        final AtomicInteger errorCounter = new AtomicInteger();
        TaskCallback taskCallback = callback == null ? null : new TaskCallback(){

            public void onSuccess() {
                this.handle(true);
            }

            public void onFailure() {
                this.handle(false);
            }

            private void handle(boolean success) {
                int errors;
                int successes = success ? successCounter.incrementAndGet() : successCounter.get();
                int n = errors = success ? errorCounter.get() : errorCounter.incrementAndGet();
                if (successes + errors == rootPaths.size()) {
                    List affectedModules;
                    HashSet affectedRoots;
                    if (!project.isDisposed() && !(affectedRoots = ContainerUtil.newHashSet((Object[])CompilerPaths.getOutputPaths((Module[])(affectedModules = ContainerUtil.concat((List[])new List[]{modulesToBuild, modulesOfResourcesToBuild, modulesOfFiles})).toArray(Module.EMPTY_ARRAY)))).isEmpty()) {
                        CompilerUtil.refreshOutputRoots((Collection)affectedRoots);
                    }
                    callback.finished(new ProjectTaskResult(false, errors, 0));
                }
            }
        };
        String gradleVmOptions = GradleSettings.getInstance((Project)project).getGradleVmOptions();
        for (String rootProjectPath : rootPaths) {
            Collection buildTasks = buildTasksMap.get((Object)rootProjectPath);
            if (buildTasks.isEmpty()) continue;
            Collection cleanTasks = cleanTasksMap.get((Object)rootProjectPath);
            ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
            File projectFile = new File(rootProjectPath);
            String projectName = projectFile.isFile() ? projectFile.getParentFile().getName() : projectFile.getName();
            String executionName = "Build " + projectName;
            settings.setExecutionName(executionName);
            settings.setExternalProjectPath(rootProjectPath);
            settings.setTaskNames(ContainerUtil.collect(ContainerUtil.concat((Iterable[])new Iterable[]{cleanTasks, buildTasks}).iterator()));
            settings.setVmOptions(gradleVmOptions);
            settings.setExternalSystemIdString(GradleConstants.SYSTEM_ID.getId());
            UserDataHolderBase userData = new UserDataHolderBase();
            userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, BuildViewManager.class);
            Collection scripts = initScripts.getModifiable((Object)rootProjectPath);
            userData.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)StringUtil.join((Collection)scripts, (String)SystemProperties.getLineSeparator()));
            userData.putUserData(GradleTaskManager.INIT_SCRIPT_PREFIX_KEY, (Object)executionName);
            ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings, (String)DefaultRunExecutor.EXECUTOR_ID, (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)taskCallback, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC, (boolean)false, (UserDataHolderBase)userData);
        }
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        ProjectModelBuildTask buildTask;
        if (projectTask == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(3);
        }
        if (projectTask instanceof ModuleBuildTask) {
            Module module = ((ModuleBuildTask)projectTask).getModule();
            if (!GradleProjectSettings.isDelegatedBuildEnabled((Module)module)) {
                return false;
            }
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module);
        }
        if (projectTask instanceof ProjectModelBuildTask && (buildTask = (ProjectModelBuildTask)projectTask).getBuildableElement() instanceof Artifact) {
            for (GradleBuildTasksProvider gradleBuildTasksProvider : (GradleBuildTasksProvider[])GradleBuildTasksProvider.EP_NAME.getExtensions()) {
                if (!gradleBuildTasksProvider.isApplicable(buildTask)) continue;
                return true;
            }
        }
        if (projectTask instanceof ExecuteRunConfigurationTask) {
            RunConfigurationModule module;
            RunProfile runProfile = ((ExecuteRunConfigurationTask)projectTask).getRunProfile();
            if (!(!(runProfile instanceof ModuleBasedConfiguration) || ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)(module = ((ModuleBasedConfiguration)runProfile).getConfigurationModule()).getModule()) && GradleProjectSettings.isDelegatedBuildEnabled((Module)module.getModule()))) {
                return false;
            }
            for (GradleBuildTasksProvider gradleBuildTasksProvider : (GradleExecutionEnvironmentProvider[])GradleExecutionEnvironmentProvider.EP_NAME.getExtensions()) {
                if (!gradleBuildTasksProvider.isApplicable((ExecuteRunConfigurationTask)projectTask)) continue;
                return true;
            }
        }
        return false;
    }

    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ExecuteRunConfigurationTask task, @Nullable Executor executor) {
        if (project == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(4);
        }
        if (task == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(5);
        }
        for (GradleExecutionEnvironmentProvider environmentProvider : (GradleExecutionEnvironmentProvider[])GradleExecutionEnvironmentProvider.EP_NAME.getExtensions()) {
            if (!environmentProvider.isApplicable(task)) continue;
            return environmentProvider.createExecutionEnvironment(project, task, executor);
        }
        return null;
    }

    private static List<Module> addModulesBuildTasks(@Nullable Collection<? extends ProjectTask> projectTasks, @NotNull MultiMap<String, String> buildTasksMap, @NotNull MultiMap<String, String> initScripts) {
        if (buildTasksMap == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(6);
        }
        if (initScripts == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(7);
        }
        if (ContainerUtil.isEmpty(projectTasks)) {
            return Collections.emptyList();
        }
        SmartList affectedModules = new SmartList();
        Map rootPathsMap = FactoryMap.create(module -> StringUtil.notNullize((String)GradleRunnerUtil.resolveProjectPath(module)));
        CachedModuleDataFinder moduleDataFinder = new CachedModuleDataFinder();
        for (ProjectTask projectTask : projectTasks) {
            String buildTaskSuffix;
            String gradlePath;
            DataNode moduleDataNode;
            String externalProjectPath;
            String projectId;
            if (!(projectTask instanceof ModuleBuildTask)) continue;
            ModuleBuildTask moduleBuildTask = (ModuleBuildTask)projectTask;
            GradleProjectTaskRunner.collectAffectedModules((List<Module>)affectedModules, moduleBuildTask);
            Module module2 = moduleBuildTask.getModule();
            String rootProjectPath = (String)rootPathsMap.get(module2);
            if (StringUtil.isEmpty((String)rootProjectPath) || (projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module2)) == null || (externalProjectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module2)) == null || StringUtil.endsWith((CharSequence)externalProjectPath, (CharSequence)"buildSrc") || (moduleDataNode = moduleDataFinder.findMainModuleData(module2)) == null || Boolean.parseBoolean(((ModuleData)moduleDataNode.getData()).getProperty("buildSrcModule")) || (gradlePath = GradleProjectResolverUtil.getGradlePath((Module)module2)) == null) continue;
            String taskPathPrefix = StringUtil.endsWithChar((CharSequence)gradlePath, (char)':') ? gradlePath : gradlePath + ':';
            List gradleModuleTasks = ContainerUtil.mapNotNull((Collection)ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ProjectKeys.TASK), node -> ((TaskData)node.getData()).isInherited() ? null : StringUtil.trimStart((String)((TaskData)node.getData()).getName(), (String)taskPathPrefix));
            Collection projectInitScripts = initScripts.getModifiable((Object)rootProjectPath);
            Collection buildRootTasks = buildTasksMap.getModifiable((Object)rootProjectPath);
            String moduleType = ExternalSystemApiUtil.getExternalModuleType((Module)module2);
            if (!moduleBuildTask.isIncrementalBuild() && !(moduleBuildTask instanceof ModuleFilesBuildTask)) {
                projectInitScripts.add(String.format(FORCE_COMPILE_TASKS_INIT_SCRIPT_TEMPLATE, gradlePath));
            }
            String assembleTask = "assemble";
            boolean buildOnlyResources = projectTask instanceof ModuleResourcesBuildTask;
            String buildTaskPrefix = buildOnlyResources ? "process" : "";
            String string = buildTaskSuffix = buildOnlyResources ? "resources" : "classes";
            if ("sourceSet".equals(moduleType)) {
                String sourceSetName = GradleProjectResolverUtil.getSourceSetName((Module)module2);
                String gradleTask = GradleProjectTaskRunner.getTaskName(buildTaskPrefix, buildTaskSuffix, sourceSetName);
                if (GradleProjectTaskRunner.addIfContains(taskPathPrefix, gradleTask, gradleModuleTasks, buildRootTasks) || !"main".equals(sourceSetName) && !"test".equals(sourceSetName)) continue;
                buildRootTasks.add(taskPathPrefix + assembleTask);
                continue;
            }
            String gradleTask = GradleProjectTaskRunner.getTaskName(buildTaskPrefix, buildTaskSuffix, null);
            if (GradleProjectTaskRunner.addIfContains(taskPathPrefix, gradleTask, gradleModuleTasks, buildRootTasks)) {
                String gradleTestTask = GradleProjectTaskRunner.getTaskName(buildTaskPrefix, buildTaskSuffix, "test");
                GradleProjectTaskRunner.addIfContains(taskPathPrefix, gradleTestTask, gradleModuleTasks, buildRootTasks);
                continue;
            }
            if (!gradleModuleTasks.contains(assembleTask)) continue;
            buildRootTasks.add(taskPathPrefix + assembleTask);
        }
        return affectedModules;
    }

    private static void collectAffectedModules(@NotNull List<Module> affectedModules, @NotNull ModuleBuildTask moduleBuildTask) {
        if (affectedModules == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(8);
        }
        if (moduleBuildTask == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(9);
        }
        Module module = moduleBuildTask.getModule();
        if (moduleBuildTask.isIncludeDependentModules()) {
            OrderEnumerator enumerator = ModuleRootManager.getInstance((Module)module).orderEntries().recursively();
            if (!moduleBuildTask.isIncludeRuntimeDependencies()) {
                enumerator = enumerator.compileOnly();
            }
            enumerator.forEachModule((Processor)new CommonProcessors.CollectProcessor(affectedModules));
        } else {
            affectedModules.add(module);
        }
    }

    @NotNull
    private static String getTaskName(@NotNull String taskPrefix, @NotNull String taskSuffix, @Nullable String sourceSetName) {
        if (taskPrefix == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(10);
        }
        if (taskSuffix == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(11);
        }
        String string = StringUtil.isEmpty((String)sourceSetName) || "main".equals(sourceSetName) ? taskPrefix + (taskPrefix.isEmpty() ? taskSuffix : StringUtil.capitalize((String)taskSuffix)) : taskPrefix + (taskPrefix.isEmpty() ? sourceSetName : StringUtil.capitalize((String)sourceSetName)) + StringUtil.capitalize((String)taskSuffix);
        if (string == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static boolean addIfContains(@NotNull String taskPathPrefix, @NotNull String gradleTask, @NotNull List<String> moduleTasks, @NotNull Collection<String> buildRootTasks) {
        if (taskPathPrefix == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(13);
        }
        if (gradleTask == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(14);
        }
        if (moduleTasks == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(15);
        }
        if (buildRootTasks == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(16);
        }
        if (moduleTasks.contains(gradleTask)) {
            buildRootTasks.add(taskPathPrefix + gradleTask);
            return true;
        }
        return false;
    }

    private static void addArtifactsBuildTasks(@Nullable Collection<? extends ProjectTask> tasks, @NotNull MultiMap<String, String> cleanTasksMap, @NotNull MultiMap<String, String> buildTasksMap) {
        if (cleanTasksMap == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(17);
        }
        if (buildTasksMap == null) {
            GradleProjectTaskRunner.$$$reportNull$$$0(18);
        }
        if (ContainerUtil.isEmpty(tasks)) {
            return;
        }
        for (ProjectTask projectTask : tasks) {
            if (!(projectTask instanceof ProjectModelBuildTask)) continue;
            ProjectModelBuildTask projectModelBuildTask = (ProjectModelBuildTask)projectTask;
            for (GradleBuildTasksProvider buildTasksProvider : (GradleBuildTasksProvider[])GradleBuildTasksProvider.EP_NAME.getExtensions()) {
                if (!buildTasksProvider.isApplicable(projectModelBuildTask)) continue;
                buildTasksProvider.addBuildTasks(projectModelBuildTask, (Consumer<ExternalTaskPojo>)((Consumer)task -> cleanTasksMap.putValue((Object)task.getLinkedExternalProjectPath(), (Object)task.getName())), (Consumer<ExternalTaskPojo>)((Consumer)task -> buildTasksMap.putValue((Object)task.getLinkedExternalProjectPath(), (Object)task.getName())));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTasksMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScripts";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedModules";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleBuildTask";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskPrefix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSuffix";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskPathPrefix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleTask";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTasks";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildRootTasks";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanTasksMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/build/GradleProjectTaskRunner";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionEnvironment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addModulesBuildTasks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedModules";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTaskName";
                break;
            }
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addIfContains";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addArtifactsBuildTasks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

