/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.documentation;

import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleDocumentationBundle;
import org.jetbrains.plugins.groovy.dsl.CustomMembersGenerator;
import org.jetbrains.plugins.groovy.dsl.holders.NonCodeMembersHolder;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;

public class GradleDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        String doc2;
        PsiElement navigationElement;
        PsiFile file = element.getContainingFile();
        if (file == null || !FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
            return null;
        }
        if (element instanceof GrLightVariable && (navigationElement = element.getNavigationElement()) != null && (doc2 = (String)navigationElement.getUserData(NonCodeMembersHolder.DOCUMENTATION)) != null) {
            return doc2;
        }
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        PsiFile file = element.getContainingFile();
        if (file == null || !FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
            return null;
        }
        return element instanceof GrLiteral ? GradleDocumentationProvider.findDoc(element, ((GrLiteral)element).getValue()) : null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (file == null || !FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
            return null;
        }
        String doc2 = GradleDocumentationProvider.findDoc(element, object);
        return !StringUtil.isEmpty((String)doc2) ? new CustomMembersGenerator.GdslNamedParameter(String.valueOf(object), doc2, element, null) : null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return JavaDocUtil.findReferenceTarget((PsiManager)psiManager, (String)link, (PsiElement)context);
    }

    @Nullable
    private static String findDoc(@Nullable PsiElement element, Object argValue) {
        GrCall grCall;
        PsiMethod psiMethod;
        GrLiteral grLiteral;
        PsiElement stmt;
        String result = null;
        if (element instanceof GrLiteral && (stmt = PsiTreeUtil.findFirstParent((PsiElement)(grLiteral = (GrLiteral)element), psiElement -> psiElement instanceof GrCall)) instanceof GrCall && (psiMethod = (grCall = (GrCall)stmt).resolveMethod()) != null && psiMethod.getContainingClass() != null) {
            String qualifiedName = psiMethod.getContainingClass().getQualifiedName();
            if (grLiteral.getParent() instanceof GrNamedArgument) {
                GrNamedArgument namedArgument = (GrNamedArgument)grLiteral.getParent();
                String key = StringUtil.join((String[])new String[]{"gradle.documentation", qualifiedName, psiMethod.getName(), namedArgument.getLabelName(), String.valueOf(argValue)}, (String)".");
                result = GradleDocumentationBundle.messageOrDefault((String)key, (String)"", (Object[])new Object[0]);
            }
        }
        return result;
    }
}

