/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.externalSystem.psi.search.ExternalModuleBuildGlobalSearchScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;

public final class GradleClassFinder
extends NonClasspathClassFinder {
    @NotNull
    private final GradleBuildClasspathManager myBuildClasspathManager;

    public GradleClassFinder(@NotNull Project project) {
        if (project == null) {
            GradleClassFinder.$$$reportNull$$$0(0);
        }
        super(project, new String[]{"java", "groovy"});
        this.myBuildClasspathManager = GradleBuildClasspathManager.getInstance(project);
    }

    protected List<VirtualFile> calcClassRoots() {
        return this.myBuildClasspathManager.getAllClasspathEntries();
    }

    @NotNull
    protected PackageDirectoryCache getCache(@Nullable GlobalSearchScope scope2) {
        if (scope2 instanceof ExternalModuleBuildGlobalSearchScope) {
            PackageDirectoryCache packageDirectoryCache = this.myBuildClasspathManager.getClassFinderCache().get(((ExternalModuleBuildGlobalSearchScope)scope2).getExternalModulePath());
            if (packageDirectoryCache == null) {
                GradleClassFinder.$$$reportNull$$$0(1);
            }
            return packageDirectoryCache;
        }
        PackageDirectoryCache packageDirectoryCache = super.getCache(scope2);
        if (packageDirectoryCache == null) {
            GradleClassFinder.$$$reportNull$$$0(2);
        }
        return packageDirectoryCache;
    }

    public void clearCache() {
        super.clearCache();
        this.myBuildClasspathManager.getClassFinderCache().clear();
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        PsiClass aClass;
        if (qualifiedName == null) {
            GradleClassFinder.$$$reportNull$$$0(3);
        }
        if (scope2 == null) {
            GradleClassFinder.$$$reportNull$$$0(4);
        }
        if ((aClass = super.findClass(qualifiedName, scope2)) == null || scope2 instanceof ExternalModuleBuildGlobalSearchScope || scope2 instanceof EverythingGlobalScope) {
            return aClass;
        }
        PsiFile containingFile = aClass.getContainingFile();
        VirtualFile file = containingFile != null ? containingFile.getVirtualFile() : null;
        return file != null && !ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isInContent(file) && !ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isInLibrary(file) ? aClass : null;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            GradleClassFinder.$$$reportNull$$$0(5);
        }
        if (scope2 == null) {
            GradleClassFinder.$$$reportNull$$$0(6);
        }
        PsiPackage[] psiPackageArray = scope2 instanceof ExternalModuleBuildGlobalSearchScope ? super.getSubPackages(psiPackage, scope2) : PsiPackage.EMPTY_ARRAY;
        if (psiPackageArray == null) {
            GradleClassFinder.$$$reportNull$$$0(7);
        }
        return psiPackageArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/config/GradleClassFinder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/config/GradleClassFinder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCache";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

