/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.codeInspection.GradleBaseInspection;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.MultipleRepositoryUrlsFix;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

public class MultipleRepositoryUrlsInspection
extends GradleBaseInspection {
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        MyVisitor myVisitor = new MyVisitor();
        if (myVisitor == null) {
            MultipleRepositoryUrlsInspection.$$$reportNull$$$0(0);
        }
        return myVisitor;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = PROBABLE_BUGS;
        if (string == null) {
            MultipleRepositoryUrlsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected String buildErrorString(Object ... args) {
        return GradleInspectionBundle.message("multiple.repository.urls", args);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GradleInspectionBundle.message("multiple.repository.urls", new Object[0]);
        if (string == null) {
            MultipleRepositoryUrlsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    static List<GrCallExpression> findUrlCallExpressions(@NotNull GrClosableBlock closure) {
        GrCallExpression[] applicationStatements;
        if (closure == null) {
            MultipleRepositoryUrlsInspection.$$$reportNull$$$0(3);
        }
        if ((applicationStatements = (GrCallExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)closure, GrCallExpression.class)) == null) {
            List<GrCallExpression> list = Collections.emptyList();
            if (list == null) {
                MultipleRepositoryUrlsInspection.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<GrCallExpression> statements = new ArrayList<GrCallExpression>();
        for (GrCallExpression statement : applicationStatements) {
            GrReferenceExpression[] referenceExpressions = (GrReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)statement, GrReferenceExpression.class);
            if (referenceExpressions == null) continue;
            for (GrReferenceExpression expression : referenceExpressions) {
                String expressionText = expression.getText();
                if (!"url".equals(expressionText) && !"setUrl".equals(expressionText)) continue;
                statements.add(statement);
            }
        }
        ArrayList<GrCallExpression> arrayList = statements;
        if (arrayList == null) {
            MultipleRepositoryUrlsInspection.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUrlCallExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findUrlCallExpressions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyVisitor
    extends BaseInspectionVisitor {
        private MyVisitor() {
        }

        public void visitClosure(@NotNull GrClosableBlock closure) {
            PsiFile file;
            if (closure == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if ((file = closure.getContainingFile()) == null || !FileUtilRt.extensionEquals((String)file.getName(), (String)"gradle")) {
                return;
            }
            super.visitClosure(closure);
            GrMethodCall mavenMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)closure, GrMethodCall.class);
            if (mavenMethodCall == null) {
                return;
            }
            GrExpression mavenMethodExpression = mavenMethodCall.getInvokedExpression();
            if (!ArrayUtil.contains((String)mavenMethodExpression.getText(), (String[])new String[]{"maven", "ivy"})) {
                return;
            }
            GrMethodCall repositoryMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)mavenMethodCall, GrMethodCall.class);
            if (repositoryMethodCall == null) {
                return;
            }
            GrExpression repositoryMethodExpression = repositoryMethodCall.getInvokedExpression();
            if (!repositoryMethodExpression.getText().equals("repositories")) {
                return;
            }
            List<GrCallExpression> statements = MultipleRepositoryUrlsInspection.findUrlCallExpressions(closure);
            if (statements.size() > 1) {
                this.registerError((PsiElement)closure);
                this.registerError((PsiElement)closure, GradleInspectionBundle.message("multiple.repository.urls", new Object[0]), new LocalQuickFix[]{new MultipleRepositoryUrlsFix(closure, mavenMethodExpression.getText())}, ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/gradle/codeInspection/MultipleRepositoryUrlsInspection$MyVisitor", "visitClosure"));
        }
    }
}

