/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VisibilityUtil {
    @NonNls
    public static final String ESCALATE_VISIBILITY = "EscalateVisible";
    private static final String[] visibilityModifiers = new String[]{"private", "packageLocal", "protected", "public"};

    private VisibilityUtil() {
    }

    public static int compare(@PsiModifier.ModifierConstant String v1, @PsiModifier.ModifierConstant String v2) {
        return ArrayUtilRt.find((Object[])visibilityModifiers, (Object)v2) - ArrayUtilRt.find((Object[])visibilityModifiers, (Object)v1);
    }

    @PsiModifier.ModifierConstant
    public static String getHighestVisibility(@PsiModifier.ModifierConstant String v1, @PsiModifier.ModifierConstant String v2) {
        return VisibilityUtil.compare(v1, v2) < 0 ? v1 : v2;
    }

    public static void escalateVisibility(PsiMember modifierListOwner, PsiElement place) throws IncorrectOperationException {
        String modifier;
        int index;
        String visibilityModifier = VisibilityUtil.getVisibilityModifier(modifierListOwner.getModifierList());
        for (index = 0; index < visibilityModifiers.length && !(modifier = visibilityModifiers[index]).equals(visibilityModifier); ++index) {
        }
        while (index < visibilityModifiers.length && !PsiUtil.isAccessible(modifierListOwner, place, null)) {
            modifier = visibilityModifiers[index];
            PsiUtil.setModifierProperty(modifierListOwner, modifier, true);
            ++index;
        }
    }

    public static void escalateVisibility(PsiModifierList modifierList, PsiElement place) throws IncorrectOperationException {
        PsiElement parent = modifierList.getParent();
        if (parent instanceof PsiMember) {
            VisibilityUtil.escalateVisibility((PsiMember)parent, place);
        }
    }

    @PsiModifier.ModifierConstant
    public static String getPossibleVisibility(PsiMember psiMethod, PsiElement place) {
        Project project = psiMethod.getProject();
        if (PsiUtil.isAccessible(project, psiMethod, place, null)) {
            return VisibilityUtil.getVisibilityModifier(psiMethod.getModifierList());
        }
        if (JavaPsiFacade.getInstance(project).arePackagesTheSame(psiMethod, place)) {
            return "packageLocal";
        }
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class), psiMethod.getContainingClass(), true)) {
            return "protected";
        }
        return "public";
    }

    @PsiModifier.ModifierConstant
    @NotNull
    public static String getVisibilityModifier(PsiModifierList list) {
        if (list == null) {
            if ("packageLocal" == null) {
                VisibilityUtil.$$$reportNull$$$0(0);
            }
            return "packageLocal";
        }
        for (String modifier : visibilityModifiers) {
            if (!list.hasModifierProperty(modifier)) continue;
            String string = modifier;
            if (string == null) {
                VisibilityUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        if ("packageLocal" == null) {
            VisibilityUtil.$$$reportNull$$$0(2);
        }
        return "packageLocal";
    }

    @NotNull
    @NonNls
    public static String getVisibilityString(@PsiModifier.ModifierConstant @NotNull String visibilityModifier) {
        if (visibilityModifier == null) {
            VisibilityUtil.$$$reportNull$$$0(3);
        }
        if ("packageLocal".equals(visibilityModifier)) {
            if ("" == null) {
                VisibilityUtil.$$$reportNull$$$0(4);
            }
            return "";
        }
        String string = visibilityModifier;
        if (string == null) {
            VisibilityUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String getVisibilityStringToDisplay(@NotNull PsiMember member) {
        if (member == null) {
            VisibilityUtil.$$$reportNull$$$0(6);
        }
        if (member.hasModifierProperty("public")) {
            String string = VisibilityUtil.toPresentableText("public");
            if (string == null) {
                VisibilityUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (member.hasModifierProperty("protected")) {
            String string = VisibilityUtil.toPresentableText("protected");
            if (string == null) {
                VisibilityUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (member.hasModifierProperty("private")) {
            String string = VisibilityUtil.toPresentableText("private");
            if (string == null) {
                VisibilityUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = VisibilityUtil.toPresentableText("packageLocal");
        if (string == null) {
            VisibilityUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String toPresentableText(@PsiModifier.ModifierConstant @NotNull String modifier) {
        if (modifier == null) {
            VisibilityUtil.$$$reportNull$$$0(11);
        }
        String string = PsiBundle.visibilityPresentation((String)modifier);
        if (string == null) {
            VisibilityUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static void fixVisibility(PsiElement[] elements, PsiMember member, @PsiModifier.ModifierConstant String newVisibility) {
        if (newVisibility == null) {
            return;
        }
        if (ESCALATE_VISIBILITY.equals(newVisibility)) {
            for (PsiElement element : elements) {
                if (element == null) continue;
                VisibilityUtil.escalateVisibility(member, element);
            }
        } else {
            VisibilityUtil.setVisibility(member.getModifierList(), newVisibility);
        }
    }

    public static void setVisibility(@NotNull PsiModifierList modifierList, @PsiModifier.ModifierConstant @NotNull String newVisibility) throws IncorrectOperationException {
        if (modifierList == null) {
            VisibilityUtil.$$$reportNull$$$0(13);
        }
        if (newVisibility == null) {
            VisibilityUtil.$$$reportNull$$$0(14);
        }
        modifierList.setModifierProperty(newVisibility, true);
    }

    public static void fixVisibility(PsiExpression[] expressions, PsiMember member, String newVisibility) {
        if (newVisibility == null) {
            return;
        }
        if (ESCALATE_VISIBILITY.equals(newVisibility)) {
            for (PsiExpression element : expressions) {
                VisibilityUtil.escalateVisibility(member, (PsiElement)element);
            }
        } else {
            VisibilityUtil.setVisibility(member.getModifierList(), newVisibility);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/VisibilityUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityModifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVisibility";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityModifier";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/VisibilityUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityString";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityStringToDisplay";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityString";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityStringToDisplay";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setVisibility";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

