/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypesDistinctProver;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeConversionUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.util.TypeConversionUtil");
    private static final boolean[][] IS_ASSIGNABLE_BIT_SET = new boolean[][]{{true, true, false, true, true, true, true}, {false, true, false, true, true, true, true}, {false, false, true, true, true, true, true}, {false, false, false, true, true, true, true}, {false, false, false, false, true, true, true}, {false, false, false, false, false, true, true}, {false, false, false, false, false, false, true}};
    private static final TObjectIntHashMap<PsiType> TYPE_TO_RANK_MAP = new TObjectIntHashMap();
    public static final int BYTE_RANK = 1;
    public static final int SHORT_RANK = 2;
    public static final int CHAR_RANK = 3;
    public static final int INT_RANK = 4;
    public static final int LONG_RANK = 5;
    public static final int FLOAT_RANK = 6;
    public static final int DOUBLE_RANK = 7;
    private static final int BOOL_RANK = 10;
    private static final int STRING_RANK = 100;
    private static final int MAX_NUMERIC_RANK = 7;
    public static final PsiType NULL_TYPE = new PsiEllipsisType(PsiType.NULL){

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        @NotNull
        public String getPresentableText(boolean annotated) {
            if ("FAKE TYPE" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "FAKE TYPE";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/TypeConversionUtil$1", "getPresentableText"));
        }
    };
    private static final Key<PsiElement> ORIGINAL_CONTEXT = Key.create((String)"ORIGINAL_CONTEXT");
    private static final Key<PsiType> LOWER_BOUND = Key.create((String)"LowBound");
    private static final Key<PsiType> UPPER_BOUND = Key.create((String)"UpperBound");
    private static final Key<CachedValue<Set<String>>> POSSIBLE_BOXED_HOLDER_TYPES;
    private static final RecursionGuard<PsiType> ourGuard;
    private static final Set<String> INTEGER_NUMBER_TYPES;
    private static final Set<String> PRIMITIVE_TYPES;
    private static final Set<String> PRIMITIVE_WRAPPER_TYPES;
    private static final Set<String> PRIMITIVE_WRAPPER_SIMPLE_NAMES;
    private static final Caster[][] caster;
    private static final Map<Class, PsiType> WRAPPER_TO_PRIMITIVE;

    private TypeConversionUtil() {
    }

    public static boolean areTypesConvertible(@NotNull PsiType fromType, @NotNull PsiType toType) {
        if (fromType == null) {
            TypeConversionUtil.$$$reportNull$$$0(0);
        }
        if (toType == null) {
            TypeConversionUtil.$$$reportNull$$$0(1);
        }
        return TypeConversionUtil.areTypesConvertible(fromType, toType, null);
    }

    public static boolean areTypesConvertible(@NotNull PsiType fromType, @NotNull PsiType toType, @Nullable LanguageLevel languageLevel) {
        if (fromType == null) {
            TypeConversionUtil.$$$reportNull$$$0(2);
        }
        if (toType == null) {
            TypeConversionUtil.$$$reportNull$$$0(3);
        }
        if (fromType == toType) {
            return true;
        }
        boolean fromIsPrimitive = TypeConversionUtil.isPrimitiveAndNotNull(fromType);
        boolean toIsPrimitive = TypeConversionUtil.isPrimitiveAndNotNull(toType);
        if (fromIsPrimitive || toIsPrimitive) {
            if (TypeConversionUtil.isVoidType(fromType) || TypeConversionUtil.isVoidType(toType)) {
                return false;
            }
            int fromTypeRank = TypeConversionUtil.getTypeRank(fromType);
            int toTypeRank = TypeConversionUtil.getTypeRank(toType);
            if (!toIsPrimitive) {
                if (fromTypeRank == toTypeRank) {
                    return true;
                }
                if (toType instanceof PsiIntersectionType) {
                    for (PsiType type : ((PsiIntersectionType)toType).getConjuncts()) {
                        if (TypeConversionUtil.areTypesConvertible(fromType, type)) continue;
                        return false;
                    }
                    return true;
                }
                if (!(toType instanceof PsiClassType)) {
                    return false;
                }
                PsiClass toClass = ((PsiClassType)toType).resolve();
                if (toClass == null || toClass instanceof PsiTypeParameter) {
                    return false;
                }
                PsiClassType boxedType = ((PsiPrimitiveType)fromType).getBoxedType(toClass.getManager(), toType.getResolveScope());
                return boxedType != null && TypeConversionUtil.areTypesConvertible(boxedType, toType);
            }
            if (!fromIsPrimitive) {
                if ((fromTypeRank == 2 || fromTypeRank == 1) && toTypeRank == 3) {
                    return false;
                }
                if (fromType instanceof PsiClassType) {
                    if (languageLevel == null) {
                        languageLevel = ((PsiClassType)fromType).getLanguageLevel();
                    }
                    if (languageLevel.isAtLeast(LanguageLevel.JDK_1_7)) {
                        PsiClassType classType = (PsiClassType)fromType;
                        PsiClass psiClass = classType.resolve();
                        if (psiClass == null) {
                            return false;
                        }
                        PsiClassType boxedType = ((PsiPrimitiveType)toType).getBoxedType(psiClass.getManager(), psiClass.getResolveScope());
                        if (boxedType != null && TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, boxedType)) {
                            return true;
                        }
                    }
                }
                return fromTypeRank == toTypeRank || fromTypeRank < toTypeRank && toTypeRank <= 7;
            }
            return fromTypeRank == toTypeRank || fromTypeRank <= 7 && toTypeRank <= 7;
        }
        if (TypeConversionUtil.isAssignable(toType, fromType)) {
            return true;
        }
        if (TypeConversionUtil.isNullType(fromType) || TypeConversionUtil.isNullType(toType)) {
            return true;
        }
        return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, toType);
    }

    private static boolean isNarrowingReferenceConversionAllowed(@NotNull PsiType fromType, @NotNull PsiType toType) {
        PsiSubstitutor derivedSubstitutor;
        PsiClass derived;
        PsiClassType.ClassResolveResult baseResult;
        if (fromType == null) {
            TypeConversionUtil.$$$reportNull$$$0(4);
        }
        if (toType == null) {
            TypeConversionUtil.$$$reportNull$$$0(5);
        }
        toType = TypeConversionUtil.uncapture(toType);
        fromType = TypeConversionUtil.uncapture(fromType);
        if (toType instanceof PsiPrimitiveType || fromType instanceof PsiPrimitiveType) {
            return fromType.equals(toType);
        }
        if (toType instanceof PsiDiamondType || fromType instanceof PsiDiamondType) {
            return false;
        }
        if (toType instanceof PsiArrayType && !(fromType instanceof PsiArrayType)) {
            PsiClass resolved;
            if (fromType instanceof PsiClassType && (resolved = ((PsiClassType)fromType).resolve()) instanceof PsiTypeParameter) {
                for (PsiClassType boundType : resolved.getExtendsListTypes()) {
                    if (TypeConversionUtil.isNarrowingReferenceConversionAllowed(boundType, toType)) continue;
                    return false;
                }
                return true;
            }
            return TypeConversionUtil.isAssignable(fromType, toType);
        }
        if (fromType instanceof PsiArrayType) {
            PsiClass resolved;
            if (toType instanceof PsiClassType && (resolved = ((PsiClassType)toType).resolve()) instanceof PsiTypeParameter) {
                for (PsiClassType boundType : resolved.getExtendsListTypes()) {
                    if (TypeConversionUtil.areTypesConvertible(fromType, boundType)) continue;
                    return false;
                }
                return true;
            }
            return toType instanceof PsiArrayType && TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiArrayType)fromType).getComponentType(), ((PsiArrayType)toType).getComponentType());
        }
        if (fromType instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)fromType).getConjuncts()) {
                if (!TypeConversionUtil.isNarrowingReferenceConversionAllowed(conjunct, toType)) continue;
                return true;
            }
            return false;
        }
        if (toType instanceof PsiIntersectionType) {
            if (fromType instanceof PsiClassType && ((PsiClassType)fromType).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_8)) {
                for (PsiType conjunct : ((PsiIntersectionType)toType).getConjuncts()) {
                    if (TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, conjunct)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (fromType instanceof PsiDisjunctionType) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiDisjunctionType)fromType).getLeastUpperBound(), toType);
        }
        if (toType instanceof PsiDisjunctionType) {
            return false;
        }
        if (fromType instanceof PsiWildcardType) {
            PsiWildcardType fromWildcard = (PsiWildcardType)fromType;
            PsiType bound = fromWildcard.getBound();
            if (bound == null) {
                return true;
            }
            if (fromWildcard.isSuper()) {
                return TypeConversionUtil.isAssignable(toType, bound);
            }
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(bound, toType);
        }
        if (toType instanceof PsiWildcardType) {
            PsiWildcardType toWildcard = (PsiWildcardType)toType;
            if (toWildcard.isSuper()) {
                return false;
            }
            PsiType bound = toWildcard.getBound();
            return bound == null || TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, bound);
        }
        if (TypeConversionUtil.isAssignable(fromType, toType)) {
            return true;
        }
        if (!(fromType instanceof PsiClassType) || !(toType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType fromClassType = (PsiClassType)fromType;
        PsiClassType toClassType = (PsiClassType)toType;
        PsiClassType.ClassResolveResult fromResult = fromClassType.resolveGenerics();
        PsiClass fromClass = fromResult.getElement();
        if (fromClass == null) {
            return false;
        }
        if (fromClass instanceof PsiTypeParameter) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(TypeConversionUtil.obtainSafeSuperType((PsiTypeParameter)fromClass), toType);
        }
        PsiClassType.ClassResolveResult toResult = toClassType.resolveGenerics();
        PsiClass toClass = toResult.getElement();
        if (toClass == null) {
            return false;
        }
        if (toClass instanceof PsiTypeParameter) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, TypeConversionUtil.obtainSafeSuperType((PsiTypeParameter)toClass));
        }
        PsiManager manager = fromClass.getManager();
        LanguageLevel languageLevel = toClassType.getLanguageLevel();
        if (!fromClass.isInterface()) {
            if (toClass.isInterface()) {
                return (!fromClass.hasModifierProperty("final") || fromClass.isInheritor(toClass, true)) && TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(toResult, fromClass, manager, fromResult.getSubstitutor(), null, languageLevel);
            }
            if (manager.areElementsEquivalent((PsiElement)fromClass, (PsiElement)toClass)) {
                return TypeConversionUtil.areSameParameterTypes(fromClassType, toClassType);
            }
            if (toClass.isInheritor(fromClass, true)) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(fromResult, toClass, manager, toResult.getSubstitutor(), null, languageLevel);
            }
            if (fromClass.isInheritor(toClass, true)) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(toResult, fromClass, manager, fromResult.getSubstitutor(), null, languageLevel);
            }
            return false;
        }
        if (!toClass.isInterface()) {
            if (!toClass.hasModifierProperty("final")) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(fromResult, toClass, manager, toResult.getSubstitutor(), null, languageLevel);
            }
            PsiSubstitutor toSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(fromClass, toClass, toResult.getSubstitutor());
            return toSubstitutor != null && TypeConversionUtil.areSameArgumentTypes(fromClass, fromResult.getSubstitutor(), toSubstitutor);
        }
        if (languageLevel.compareTo(LanguageLevel.JDK_1_5) < 0) {
            Collection<HierarchicalMethodSignature> fromClassMethodSignatures = fromClass.getVisibleSignatures();
            Collection<HierarchicalMethodSignature> toClassMethodSignatures = toClass.getVisibleSignatures();
            for (HierarchicalMethodSignature fromMethodSignature : fromClassMethodSignatures) {
                for (HierarchicalMethodSignature toMethodSignature : toClassMethodSignatures) {
                    if (!fromMethodSignature.equals(toMethodSignature)) continue;
                    PsiType fromClassReturnType = fromMethodSignature.getMethod().getReturnType();
                    PsiType toClassReturnType = toMethodSignature.getMethod().getReturnType();
                    if (fromClassReturnType == null || toClassReturnType == null || fromClassReturnType.equals(toClassReturnType)) continue;
                    return false;
                }
            }
            return true;
        }
        if (toClass.isInheritor(fromClass, true)) {
            baseResult = fromResult;
            derived = toClass;
            derivedSubstitutor = toResult.getSubstitutor();
        } else {
            baseResult = toResult;
            derived = fromClass;
            derivedSubstitutor = fromResult.getSubstitutor();
        }
        return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(baseResult, derived, manager, derivedSubstitutor, null, languageLevel);
    }

    @NotNull
    private static PsiClassType obtainSafeSuperType(@NotNull PsiTypeParameter typeParameter) {
        PsiClassType superType;
        PsiClassType.ClassResolveResult result;
        PsiClass superClass;
        if (typeParameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(6);
        }
        if ((superClass = (result = (superType = typeParameter.getSuperTypes()[0]).resolveGenerics()).getElement()) != null) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(typeParameter.getProject());
            if (superClass instanceof PsiTypeParameter && InheritanceUtil.getCircularClass(superClass) != null) {
                PsiClassType psiClassType = factory.createTypeByFQClassName("java.lang.Object", typeParameter.getResolveScope());
                if (psiClassType == null) {
                    TypeConversionUtil.$$$reportNull$$$0(7);
                }
                return psiClassType;
            }
            PsiSubstitutor substitutor = result.getSubstitutor().put(typeParameter, null);
            PsiClassType psiClassType = factory.createType(superClass, substitutor);
            if (psiClassType == null) {
                TypeConversionUtil.$$$reportNull$$$0(8);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = superType;
        if (psiClassType == null) {
            TypeConversionUtil.$$$reportNull$$$0(9);
        }
        return psiClassType;
    }

    private static boolean checkSuperTypesWithDifferentTypeArguments(@NotNull PsiClassType.ClassResolveResult baseResult, @NotNull PsiClass derived, @NotNull PsiManager manager, @NotNull PsiSubstitutor derivedSubstitutor, Set<? super PsiClass> visited, @NotNull LanguageLevel languageLevel) {
        if (baseResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(10);
        }
        if (derived == null) {
            TypeConversionUtil.$$$reportNull$$$0(11);
        }
        if (manager == null) {
            TypeConversionUtil.$$$reportNull$$$0(12);
        }
        if (derivedSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(13);
        }
        if (languageLevel == null) {
            TypeConversionUtil.$$$reportNull$$$0(14);
        }
        if (visited != null && visited.contains(derived)) {
            return true;
        }
        if (languageLevel.compareTo(LanguageLevel.JDK_1_5) < 0) {
            return true;
        }
        PsiClass base = baseResult.getElement();
        PsiClass[] supers = derived.getSupers();
        if (manager.areElementsEquivalent((PsiElement)base, (PsiElement)derived)) {
            derivedSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(derived, derived, derivedSubstitutor);
            return TypeConversionUtil.areSameArgumentTypes(derived, baseResult.getSubstitutor(), derivedSubstitutor, 1);
        }
        PsiSubstitutor baseSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(derived, base, baseResult.getSubstitutor());
        if (baseSubstitutor != null && !TypeConversionUtil.areSameArgumentTypes(derived, baseSubstitutor, derivedSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(derived, derived, derivedSubstitutor))) {
            return false;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        visited.add((PsiClass)derived);
        for (PsiClass aSuper : supers) {
            PsiSubstitutor s = TypeConversionUtil.getSuperClassSubstitutor(aSuper, derived, derivedSubstitutor);
            if (TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(baseResult, aSuper, manager, s, (Set<? super PsiClass>)visited, languageLevel)) continue;
            return false;
        }
        return true;
    }

    private static boolean areSameParameterTypes(@NotNull PsiClassType type1, @NotNull PsiClassType type2) {
        if (type1 == null) {
            TypeConversionUtil.$$$reportNull$$$0(15);
        }
        if (type2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(16);
        }
        PsiClassType.ClassResolveResult resolveResult1 = type1.resolveGenerics();
        PsiClassType.ClassResolveResult resolveResult2 = type2.resolveGenerics();
        PsiClass aClass = resolveResult1.getElement();
        PsiClass bClass = resolveResult2.getElement();
        return aClass != null && bClass != null && aClass.getManager().areElementsEquivalent((PsiElement)aClass, (PsiElement)bClass) && TypeConversionUtil.areSameArgumentTypes(aClass, resolveResult1.getSubstitutor(), resolveResult2.getSubstitutor(), 1);
    }

    private static boolean areSameArgumentTypes(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2) {
        if (aClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(17);
        }
        if (substitutor1 == null) {
            TypeConversionUtil.$$$reportNull$$$0(18);
        }
        if (substitutor2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(19);
        }
        return TypeConversionUtil.areSameArgumentTypes(aClass, substitutor1, substitutor2, 0);
    }

    private static boolean areSameArgumentTypes(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2, int level) {
        if (aClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(20);
        }
        if (substitutor1 == null) {
            TypeConversionUtil.$$$reportNull$$$0(21);
        }
        if (substitutor2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(22);
        }
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
            PsiType typeArg1 = substitutor1.substitute(typeParameter);
            PsiType typeArg2 = substitutor2.substitute(typeParameter);
            if (typeArg1 == null || typeArg2 == null) {
                return true;
            }
            if (!TypesDistinctProver.provablyDistinct(typeArg1, typeArg2, level)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> false")
    public static boolean isPrimitiveAndNotNull(PsiType type) {
        return type instanceof PsiPrimitiveType && !TypeConversionUtil.isNullType(type);
    }

    @Contract(value="null -> false")
    public static boolean isEnumType(PsiType type) {
        if ((type = TypeConversionUtil.uncapture(type)) instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            if (psiClass instanceof PsiTypeParameter) {
                return InheritanceUtil.isInheritor(psiClass, true, "java.lang.Enum");
            }
            return psiClass != null && psiClass.isEnum();
        }
        return false;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNullType(PsiType type) {
        return PsiType.NULL.equals(type);
    }

    @Contract(value="null -> false")
    public static boolean isFloatOrDoubleType(PsiType type) {
        return TypeConversionUtil.isFloatType(type) || TypeConversionUtil.isDoubleType(type);
    }

    @Contract(value="null -> false")
    public static boolean isDoubleType(PsiType type) {
        return PsiType.DOUBLE.equals(type = TypeConversionUtil.uncapture(type)) || PsiType.DOUBLE.equals(PsiPrimitiveType.getUnboxedType(type));
    }

    @Contract(value="null -> false")
    public static boolean isFloatType(PsiType type) {
        return PsiType.FLOAT.equals(type = TypeConversionUtil.uncapture(type)) || PsiType.FLOAT.equals(PsiPrimitiveType.getUnboxedType(type));
    }

    @Contract(value="null -> false")
    public static boolean isLongType(PsiType type) {
        return PsiType.LONG.equals(type = TypeConversionUtil.uncapture(type)) || PsiType.LONG.equals(PsiPrimitiveType.getUnboxedType(type));
    }

    public static boolean isVoidType(PsiType type) {
        return PsiType.VOID.equals(type);
    }

    public static boolean isBooleanType(@Nullable PsiType type) {
        return PsiType.BOOLEAN.equals(type = TypeConversionUtil.uncapture(type)) || PsiType.BOOLEAN.equals(PsiPrimitiveType.getUnboxedType(type));
    }

    @Contract(value="null -> null")
    private static PsiType uncapture(PsiType type) {
        while (type instanceof PsiCapturedWildcardType) {
            type = ((PsiCapturedWildcardType)type).getUpperBound();
        }
        return type;
    }

    public static boolean isNumericType(int typeRank) {
        return typeRank <= 7;
    }

    public static boolean isNumericType(PsiType type) {
        return type != null && TypeConversionUtil.isNumericType(TypeConversionUtil.getTypeRank(type));
    }

    public static boolean isIntegralNumberType(PsiType type) {
        return type != null && TypeConversionUtil.getTypeRank(type) <= 5;
    }

    public static int getTypeRank(@NotNull PsiType type) {
        int rank;
        PsiPrimitiveType unboxedType;
        if (type == null) {
            TypeConversionUtil.$$$reportNull$$$0(23);
        }
        if ((unboxedType = PsiPrimitiveType.getUnboxedType(type = TypeConversionUtil.uncapture(type))) != null) {
            type = unboxedType;
        }
        if ((rank = TYPE_TO_RANK_MAP.get((Object)type)) != 0) {
            return rank;
        }
        if (type.equalsToText("java.lang.String")) {
            return 100;
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isBinaryOperatorApplicable(IElementType tokenType, PsiExpression lOperand, PsiExpression rOperand, boolean strict) {
        if (lOperand == null || rOperand == null) {
            return true;
        }
        PsiType ltype = lOperand.getType();
        PsiType rtype = rOperand.getType();
        return TypeConversionUtil.isBinaryOperatorApplicable(tokenType, ltype, rtype, strict);
    }

    public static boolean isBinaryOperatorApplicable(IElementType tokenType, PsiType ltype, PsiType rtype, boolean strict) {
        if (ltype == null || rtype == null) {
            return true;
        }
        int resultTypeRank = 10;
        boolean isApplicable = false;
        int ltypeRank = TypeConversionUtil.getTypeRank(ltype);
        int rtypeRank = TypeConversionUtil.getTypeRank(rtype);
        if (tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.GT || tokenType == JavaTokenType.GE) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.EQEQ || tokenType == JavaTokenType.NE) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype) && (TypeConversionUtil.isPrimitiveAndNotNull(ltype) || TypeConversionUtil.isPrimitiveAndNotNull(rtype))) {
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7 || ltypeRank == 10 && rtypeRank == 10;
            } else {
                if (TypeConversionUtil.isPrimitiveAndNotNull(ltype)) {
                    LanguageLevel languageLevel;
                    return rtype instanceof PsiClassType && (languageLevel = ((PsiClassType)rtype).getLanguageLevel()).isAtLeast(LanguageLevel.JDK_1_5) && !languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && TypeConversionUtil.areTypesConvertible(ltype, rtype);
                }
                if (TypeConversionUtil.isPrimitiveAndNotNull(rtype)) {
                    LanguageLevel level;
                    return ltype instanceof PsiClassType && (level = ((PsiClassType)ltype).getLanguageLevel()).isAtLeast(LanguageLevel.JDK_1_7) && !level.isAtLeast(LanguageLevel.JDK_1_8) && TypeConversionUtil.areTypesConvertible(rtype, ltype);
                }
                isApplicable = TypeConversionUtil.areTypesConvertible(ltype, rtype) || TypeConversionUtil.areTypesConvertible(rtype, ltype);
            }
        } else if (tokenType == JavaTokenType.PLUS) {
            if (ltype.equalsToText("java.lang.String")) {
                isApplicable = !TypeConversionUtil.isVoidType(rtype);
                resultTypeRank = 100;
            } else if (rtype.equalsToText("java.lang.String")) {
                isApplicable = !TypeConversionUtil.isVoidType(ltype);
                resultTypeRank = 100;
            } else if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                resultTypeRank = Math.max(ltypeRank, rtypeRank);
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.ASTERISK || tokenType == JavaTokenType.DIV || tokenType == JavaTokenType.PERC || tokenType == JavaTokenType.MINUS) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                resultTypeRank = Math.max(ltypeRank, rtypeRank);
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.LTLT || tokenType == JavaTokenType.GTGT || tokenType == JavaTokenType.GTGTGT) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 5 && rtypeRank <= 5;
                resultTypeRank = 4;
            }
        } else if (tokenType == JavaTokenType.AND || tokenType == JavaTokenType.OR || tokenType == JavaTokenType.XOR) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 5 && rtypeRank <= 5 || TypeConversionUtil.isBooleanType(ltype) && TypeConversionUtil.isBooleanType(rtype);
                resultTypeRank = ltypeRank <= 5 ? 4 : 10;
            }
        } else if ((tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
            boolean bl = isApplicable = TypeConversionUtil.isBooleanType(ltype) && TypeConversionUtil.isBooleanType(rtype);
        }
        if (isApplicable && strict) {
            if (resultTypeRank > 7) {
                isApplicable = ltypeRank == resultTypeRank || ltype.equalsToText("java.lang.Object");
            } else assert (ltypeRank <= 7);
        }
        return isApplicable;
    }

    public static boolean isPrimitiveAndNotNullOrWrapper(PsiType type) {
        if ((type = TypeConversionUtil.uncapture(type)) instanceof PsiClassType) {
            return PsiPrimitiveType.getUnboxedType(type) != null;
        }
        return TypeConversionUtil.isPrimitiveAndNotNull(type);
    }

    public static boolean isUnaryOperatorApplicable(@NotNull PsiJavaToken token, PsiExpression operand) {
        if (token == null) {
            TypeConversionUtil.$$$reportNull$$$0(24);
        }
        if (operand == null) {
            return false;
        }
        PsiType type = operand.getType();
        return type != null && TypeConversionUtil.isUnaryOperatorApplicable(token, type);
    }

    public static boolean isUnaryOperatorApplicable(@NotNull PsiJavaToken token, @NotNull PsiType type) {
        if (token == null) {
            TypeConversionUtil.$$$reportNull$$$0(25);
        }
        if (type == null) {
            TypeConversionUtil.$$$reportNull$$$0(26);
        }
        IElementType i = token.getTokenType();
        int typeRank = TypeConversionUtil.getTypeRank(type);
        if (i == JavaTokenType.MINUSMINUS || i == JavaTokenType.PLUSPLUS) {
            return typeRank <= 7;
        }
        if (i == JavaTokenType.MINUS || i == JavaTokenType.PLUS) {
            return typeRank <= 7;
        }
        if (i == JavaTokenType.TILDE) {
            return typeRank <= 5;
        }
        if (i == JavaTokenType.EXCL) {
            return typeRank == 10;
        }
        LOG.error("unknown token: " + token);
        return true;
    }

    public static boolean isLValue(PsiExpression element) {
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression expression = (PsiReferenceExpression)element;
            PsiElement resolved = expression.resolve();
            return resolved instanceof PsiVariable;
        }
        if (element instanceof PsiParenthesizedExpression) {
            return TypeConversionUtil.isLValue(((PsiParenthesizedExpression)element).getExpression());
        }
        if (element instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)element;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            PsiType type = arrayExpression.getType();
            if (!(type instanceof PsiArrayType)) {
                return false;
            }
            PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
            if (indexExpression == null) {
                return false;
            }
            PsiType indexType = indexExpression.getType();
            if (indexType == null) {
                return false;
            }
            if (TypeConversionUtil.getTypeRank(indexType) <= 4) {
                return true;
            }
        }
        return false;
    }

    public static boolean areTypesAssignmentCompatible(PsiType lType, PsiExpression rExpr) {
        if (lType == null || rExpr == null) {
            return true;
        }
        PsiType rType = rExpr.getType();
        if (rType == null) {
            return false;
        }
        if (TypeConversionUtil.isAssignable(lType, rType)) {
            return true;
        }
        if (lType instanceof PsiClassType && (lType = PsiPrimitiveType.getUnboxedType(lType)) == null) {
            return false;
        }
        int rTypeRank = TypeConversionUtil.getTypeRank(rType);
        if (lType instanceof PsiPrimitiveType && rType instanceof PsiPrimitiveType && rTypeRank >= 1 && rTypeRank <= 4) {
            long value;
            Object rValue = JavaPsiFacade.getInstance(rExpr.getProject()).getConstantEvaluationHelper().computeConstantExpression(rExpr);
            if (rValue instanceof Number) {
                value = ((Number)rValue).longValue();
            } else if (rValue instanceof Character) {
                value = ((Character)rValue).charValue();
            } else {
                return false;
            }
            if (PsiType.BYTE.equals(lType)) {
                return -128L <= value && value <= 127L;
            }
            if (PsiType.SHORT.equals(lType)) {
                return -32768L <= value && value <= 32767L;
            }
            if (PsiType.CHAR.equals(lType)) {
                return 0L <= value && value <= 65535L;
            }
        }
        return false;
    }

    public static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(27);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(28);
        }
        return TypeConversionUtil.isAssignable(left, right, true);
    }

    public static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right, boolean allowUncheckedConversion) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(29);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(30);
        }
        return TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion, true);
    }

    private static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right, boolean allowUncheckedConversion, boolean capture) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(31);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(32);
        }
        if (left == right || left.equals(right)) {
            return true;
        }
        if (TypeConversionUtil.isNullType(right)) {
            return !(left instanceof PsiPrimitiveType) || TypeConversionUtil.isNullType(left);
        }
        if (right instanceof PsiMethodReferenceType) {
            PsiMethodReferenceExpression methodReferenceExpression = ((PsiMethodReferenceType)right).getExpression();
            if (left instanceof PsiLambdaExpressionType) {
                PsiType rType = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType lType = ((PsiLambdaExpressionType)left).getExpression().getFunctionalInterfaceType();
                return Comparing.equal((Object)rType, (Object)lType);
            }
            if (left instanceof PsiMethodReferenceType) {
                PsiType rType = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType lType = ((PsiMethodReferenceType)left).getExpression().getFunctionalInterfaceType();
                return Comparing.equal((Object)rType, (Object)lType);
            }
            return !(left instanceof PsiArrayType) && methodReferenceExpression.isAcceptable(left);
        }
        if (right instanceof PsiLambdaExpressionType) {
            PsiLambdaExpression rLambdaExpression = ((PsiLambdaExpressionType)right).getExpression();
            if (left instanceof PsiLambdaExpressionType) {
                PsiLambdaExpression lLambdaExpression = ((PsiLambdaExpressionType)left).getExpression();
                PsiType rType = rLambdaExpression.getFunctionalInterfaceType();
                PsiType lType = lLambdaExpression.getFunctionalInterfaceType();
                return Comparing.equal((Object)rType, (Object)lType);
            }
            return !(left instanceof PsiArrayType) && rLambdaExpression.isAcceptable(left);
        }
        if (left instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)left).getConjuncts()) {
                if (TypeConversionUtil.isAssignable(conjunct, right, allowUncheckedConversion, capture)) continue;
                return false;
            }
            return true;
        }
        if (right instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)right).getConjuncts()) {
                if (!TypeConversionUtil.isAssignable(left, conjunct, allowUncheckedConversion, capture)) continue;
                return true;
            }
            return false;
        }
        if (right instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isAssignable(left, ((PsiCapturedWildcardType)right).getUpperBound(capture), allowUncheckedConversion, capture);
        }
        if (left instanceof PsiCapturedWildcardType) {
            return left.equals(right) || TypeConversionUtil.isAssignable(((PsiCapturedWildcardType)left).getLowerBound(), right, allowUncheckedConversion, capture);
        }
        if (left instanceof PsiWildcardType) {
            return TypeConversionUtil.isAssignableToWildcard((PsiWildcardType)left, right);
        }
        if (right instanceof PsiWildcardType) {
            return TypeConversionUtil.isAssignableFromWildcard(left, (PsiWildcardType)right);
        }
        if (right instanceof PsiArrayType) {
            if (!(left instanceof PsiArrayType)) {
                if (left instanceof PsiPrimitiveType || PsiUtil.resolveClassInType(left) == null) {
                    return false;
                }
                PsiClass lClass = PsiUtil.resolveClassInType(left);
                if (lClass == null) {
                    return false;
                }
                if (lClass.isInterface()) {
                    String qualifiedName = lClass.getQualifiedName();
                    return "java.io.Serializable".equals(qualifiedName) || "java.lang.Cloneable".equals(qualifiedName);
                }
                return left.equalsToText("java.lang.Object");
            }
            PsiType lCompType = ((PsiArrayType)left).getComponentType();
            PsiType rCompType = ((PsiArrayType)right).getComponentType();
            if (lCompType instanceof PsiPrimitiveType) {
                return lCompType.equals(rCompType);
            }
            return !(rCompType instanceof PsiPrimitiveType) && TypeConversionUtil.isAssignable(lCompType, rCompType, allowUncheckedConversion, capture);
        }
        if (left instanceof PsiDisjunctionType) {
            for (PsiType type : ((PsiDisjunctionType)left).getDisjunctions()) {
                if (!TypeConversionUtil.isAssignable(type, right, allowUncheckedConversion, capture)) continue;
                return true;
            }
            return false;
        }
        if (right instanceof PsiDisjunctionType) {
            return TypeConversionUtil.isAssignable(left, ((PsiDisjunctionType)right).getLeastUpperBound(), allowUncheckedConversion, capture);
        }
        if (left instanceof PsiArrayType) {
            PsiClass aClass;
            if (right instanceof PsiClassType && (aClass = ((PsiClassType)right).resolve()) instanceof PsiTypeParameter) {
                PsiType upperBound = TypeConversionUtil.getInferredUpperBoundForSynthetic((PsiTypeParameter)aClass);
                return upperBound != null && TypeConversionUtil.isAssignable(left, upperBound, allowUncheckedConversion, capture);
            }
            return false;
        }
        if (right instanceof PsiPrimitiveType) {
            if (TypeConversionUtil.isVoidType(right)) {
                return false;
            }
            if (!(left instanceof PsiPrimitiveType)) {
                return left instanceof PsiClassType && TypeConversionUtil.isBoxable((PsiClassType)left, (PsiPrimitiveType)right);
            }
            int leftTypeIndex = TYPE_TO_RANK_MAP.get((Object)left) - 1;
            int rightTypeIndex = TYPE_TO_RANK_MAP.get((Object)right) - 1;
            return leftTypeIndex >= 0 && rightTypeIndex >= 0 && rightTypeIndex < IS_ASSIGNABLE_BIT_SET.length && leftTypeIndex < IS_ASSIGNABLE_BIT_SET.length && IS_ASSIGNABLE_BIT_SET[rightTypeIndex][leftTypeIndex];
        }
        if (!(right instanceof PsiClassType)) {
            return false;
        }
        if (left instanceof PsiPrimitiveType) {
            return TypeConversionUtil.isUnboxable((PsiPrimitiveType)left, (PsiClassType)right, new HashSet());
        }
        PsiClassType.ClassResolveResult leftResult = PsiUtil.resolveGenericsClassInType(left);
        PsiClassType.ClassResolveResult rightResult = PsiUtil.resolveGenericsClassInType(right);
        if (leftResult.getElement() == null || rightResult.getElement() == null) {
            String rText;
            if (leftResult.getElement() != rightResult.getElement()) {
                return false;
            }
            String lText = left.getPresentableText();
            if (lText.equals(rText = right.getPresentableText())) {
                return true;
            }
            if (lText.length() > rText.length() && lText.endsWith(rText) && lText.charAt(lText.length() - rText.length() - 1) == '.') {
                return true;
            }
            return rText.length() > lText.length() && rText.endsWith(lText) && rText.charAt(rText.length() - lText.length() - 1) == '.';
        }
        return TypeConversionUtil.isClassAssignable(leftResult, rightResult, allowUncheckedConversion, left.getResolveScope(), capture);
    }

    private static boolean isAssignableFromWildcard(@NotNull PsiType left, @NotNull PsiWildcardType rightWildcardType) {
        PsiClass aClass;
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(33);
        }
        if (rightWildcardType == null) {
            TypeConversionUtil.$$$reportNull$$$0(34);
        }
        if (rightWildcardType.isSuper() && (aClass = PsiUtil.resolveClassInType(rightWildcardType.getSuperBound())) instanceof PsiTypeParameter) {
            PsiClassType[] types;
            for (PsiClassType type : types = aClass.getExtendsListTypes()) {
                if (!TypeConversionUtil.isAssignable(left, type)) continue;
                return true;
            }
        }
        return TypeConversionUtil.isAssignable(left, rightWildcardType.getExtendsBound());
    }

    private static boolean isAssignableToWildcard(@NotNull PsiWildcardType wildcardType, @NotNull PsiType right) {
        if (wildcardType == null) {
            TypeConversionUtil.$$$reportNull$$$0(35);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(36);
        }
        if (wildcardType.isSuper()) {
            return TypeConversionUtil.isAssignable(wildcardType.getSuperBound(), right);
        }
        return TypeConversionUtil.isAssignable(wildcardType.getExtendsBound(), right);
    }

    private static boolean isUnboxable(@NotNull PsiPrimitiveType left, @NotNull PsiClassType right, @NotNull Set<? super PsiClassType> types) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(37);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(38);
        }
        if (types == null) {
            TypeConversionUtil.$$$reportNull$$$0(39);
        }
        if (!right.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
            return false;
        }
        PsiClass psiClass = right.resolve();
        if (psiClass == null) {
            return false;
        }
        if (psiClass instanceof PsiTypeParameter) {
            for (PsiClassType bound : psiClass.getExtendsListTypes()) {
                if (!types.add(bound) || !TypeConversionUtil.isUnboxable(left, bound, types)) continue;
                return true;
            }
            return false;
        }
        PsiPrimitiveType rightUnboxedType = PsiPrimitiveType.getUnboxedType(right);
        return rightUnboxedType != null && TypeConversionUtil.isAssignable(left, rightUnboxedType);
    }

    public static boolean boxingConversionApplicable(PsiType left, PsiType right) {
        if (left instanceof PsiPrimitiveType && !PsiType.NULL.equals(left)) {
            return right instanceof PsiClassType && TypeConversionUtil.isAssignable(left, right);
        }
        if (left instanceof PsiIntersectionType) {
            for (PsiType lConjunct : ((PsiIntersectionType)left).getConjuncts()) {
                if (TypeConversionUtil.boxingConversionApplicable(lConjunct, right)) continue;
                return false;
            }
            return true;
        }
        return left instanceof PsiClassType && right instanceof PsiPrimitiveType && !PsiType.NULL.equals(right) && TypeConversionUtil.isAssignable(left, right);
    }

    private static boolean isBoxable(@NotNull PsiClassType left, @NotNull PsiPrimitiveType right) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(40);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(41);
        }
        if (!left.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
            return false;
        }
        PsiClass psiClass = left.resolve();
        if (psiClass == null) {
            return false;
        }
        String qname = psiClass.getQualifiedName();
        if (qname == null || !(psiClass instanceof PsiTypeParameter) && !TypeConversionUtil.getAllBoxedTypeSupers(psiClass).contains(qname)) {
            return false;
        }
        PsiClassType rightBoxed = right.getBoxedType(psiClass.getManager(), left.getResolveScope());
        return rightBoxed != null && TypeConversionUtil.isAssignable(left, rightBoxed);
    }

    @NotNull
    private static Set<String> getAllBoxedTypeSupers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(42);
        }
        PsiManager manager = psiClass.getManager();
        Project project = psiClass.getProject();
        CachedValue boxedHolderTypes = (CachedValue)project.getUserData(POSSIBLE_BOXED_HOLDER_TYPES);
        if (boxedHolderTypes == null) {
            boxedHolderTypes = CachedValuesManager.getManager((Project)manager.getProject()).createCachedValue(() -> {
                JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
                THashSet set = new THashSet();
                for (String qname : JvmPrimitiveTypeKind.getBoxedFqns()) {
                    PsiClass boxedClass = facade.findClass(qname, GlobalSearchScope.allScope((Project)project));
                    InheritanceUtil.processSupers(boxedClass, true, (Processor<? super PsiClass>)((Processor)arg_0 -> TypeConversionUtil.lambda$null$0((Set)set, arg_0)));
                }
                return CachedValueProvider.Result.create((Object)set, (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)project)});
            }, false);
            project.putUserData(POSSIBLE_BOXED_HOLDER_TYPES, (Object)boxedHolderTypes);
        }
        Set set = (Set)boxedHolderTypes.getValue();
        if (set == null) {
            TypeConversionUtil.$$$reportNull$$$0(43);
        }
        return set;
    }

    private static boolean isClassAssignable(@NotNull PsiClassType.ClassResolveResult leftResult, @NotNull PsiClassType.ClassResolveResult rightResult, boolean allowUncheckedConversion, GlobalSearchScope resolveScope, boolean capture) {
        if (leftResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(44);
        }
        if (rightResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(45);
        }
        PsiClass leftClass = leftResult.getElement();
        PsiClass rightClass = rightResult.getElement();
        if (leftClass == null || rightClass == null) {
            return false;
        }
        PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(leftClass, rightClass, resolveScope, rightResult.getSubstitutor());
        return superSubstitutor != null && TypeConversionUtil.typeParametersAgree(leftResult, rightResult, allowUncheckedConversion, superSubstitutor, capture);
    }

    private static boolean typeParametersAgree(@NotNull PsiClassType.ClassResolveResult leftResult, @NotNull PsiClassType.ClassResolveResult rightResult, boolean allowUncheckedConversion, PsiSubstitutor superSubstitutor, boolean capture) {
        if (leftResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(46);
        }
        if (rightResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(47);
        }
        PsiSubstitutor rightSubstitutor = rightResult.getSubstitutor();
        PsiClass leftClass = leftResult.getElement();
        PsiClass rightClass = rightResult.getElement();
        Iterator<PsiTypeParameter> li = PsiUtil.typeParametersIterator(leftClass);
        if (!li.hasNext()) {
            return true;
        }
        PsiSubstitutor leftSubstitutor = leftResult.getSubstitutor();
        if (!leftClass.getManager().areElementsEquivalent((PsiElement)leftClass, (PsiElement)rightClass)) {
            rightSubstitutor = superSubstitutor;
            rightClass = leftClass;
        } else if (!PsiUtil.typeParametersIterator(rightClass).hasNext()) {
            return true;
        }
        Iterator<PsiTypeParameter> ri = PsiUtil.typeParametersIterator(rightClass);
        while (li.hasNext()) {
            PsiType typeRight;
            if (!ri.hasNext()) {
                return false;
            }
            PsiTypeParameter lp = li.next();
            PsiTypeParameter rp = ri.next();
            PsiType typeLeft = leftSubstitutor.substitute(lp);
            if (typeLeft == null) continue;
            PsiType psiType = typeRight = PsiCapturedWildcardType.isCapture() && capture ? rightSubstitutor.substituteWithBoundsPromotion(rp) : rightSubstitutor.substitute(rp);
            if (typeRight == null) {
                return allowUncheckedConversion;
            }
            if (TypeConversionUtil.typesAgree(typeLeft, typeRight, allowUncheckedConversion)) continue;
            return false;
        }
        return true;
    }

    public static boolean typesAgree(@NotNull PsiType typeLeft, @NotNull PsiType typeRight, boolean allowUncheckedConversion) {
        if (typeLeft == null) {
            TypeConversionUtil.$$$reportNull$$$0(48);
        }
        if (typeRight == null) {
            TypeConversionUtil.$$$reportNull$$$0(49);
        }
        if (typeLeft instanceof PsiWildcardType) {
            PsiWildcardType leftWildcard = (PsiWildcardType)typeLeft;
            PsiType leftBound = leftWildcard.getBound();
            if (leftBound == null) {
                return true;
            }
            if (leftBound.equalsToText("java.lang.Object")) {
                if (!leftWildcard.isSuper()) {
                    return true;
                }
                if (typeRight.equalsToText("java.lang.Object")) {
                    return true;
                }
            }
            if (typeRight instanceof PsiWildcardType) {
                PsiWildcardType rightWildcard = (PsiWildcardType)typeRight;
                PsiType bound = rightWildcard.getBound();
                if (leftWildcard.isExtends() && bound != null) {
                    return rightWildcard.isExtends() && TypeConversionUtil.isAssignable(leftBound, bound, allowUncheckedConversion, false);
                }
                if (rightWildcard.isSuper() && bound != null) {
                    NotNullComputable checkAssignable = () -> TypeConversionUtil.isAssignable(bound, leftBound, allowUncheckedConversion, false);
                    Boolean assignable = (Boolean)ourGuard.doPreventingRecursion((Object)rightWildcard, true, (Computable)checkAssignable);
                    return assignable != null && assignable != false;
                }
                return false;
            }
            if (leftWildcard.isExtends()) {
                return TypeConversionUtil.isAssignable(leftBound, typeRight, false, false);
            }
            NotNullComputable checkAssignable = () -> TypeConversionUtil.isAssignable(typeRight, leftBound, false, false);
            Boolean assignable = (Boolean)ourGuard.doPreventingRecursion((Object)leftWildcard, true, (Computable)checkAssignable);
            return assignable == null || assignable != false;
        }
        return typeLeft.equals(typeRight);
    }

    @Nullable
    public static PsiSubstitutor getClassSubstitutor(@NotNull PsiClass superClassCandidate, @NotNull PsiClass derivedClassCandidate, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClassCandidate == null) {
            TypeConversionUtil.$$$reportNull$$$0(50);
        }
        if (derivedClassCandidate == null) {
            TypeConversionUtil.$$$reportNull$$$0(51);
        }
        if (derivedSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(52);
        }
        if (superClassCandidate.getManager().areElementsEquivalent((PsiElement)superClassCandidate, (PsiElement)derivedClassCandidate)) {
            PsiTypeParameter[] baseParams = superClassCandidate.getTypeParameters();
            PsiTypeParameter[] derivedParams = derivedClassCandidate.getTypeParameters();
            if (baseParams.length > 0 && derivedParams.length == 0) {
                return JavaPsiFacade.getElementFactory(superClassCandidate.getProject()).createRawSubstitutor(superClassCandidate);
            }
            return derivedSubstitutor;
        }
        return TypeConversionUtil.getMaybeSuperClassSubstitutor(superClassCandidate, derivedClassCandidate, derivedSubstitutor);
    }

    @NotNull
    public static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(53);
        }
        if (derivedClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(54);
        }
        if (derivedSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(55);
        }
        if (!superClass.hasTypeParameters() && superClass.getContainingClass() == null) {
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                TypeConversionUtil.$$$reportNull$$$0(56);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(superClass, derivedClass, derivedSubstitutor);
        if (substitutor == null) {
            JavaClassSupers.getInstance().reportHierarchyInconsistency(superClass, derivedClass);
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                TypeConversionUtil.$$$reportNull$$$0(57);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = substitutor;
        if (psiSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(58);
        }
        return psiSubstitutor;
    }

    @Nullable
    public static PsiSubstitutor getMaybeSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(59);
        }
        if (derivedClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(60);
        }
        if (derivedSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(61);
        }
        return JavaClassSupers.getInstance().getSuperClassSubstitutor(superClass, derivedClass, derivedClass.getResolveScope(), derivedSubstitutor);
    }

    @NotNull
    public static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClassType classType) {
        if (superClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(62);
        }
        if (classType == null) {
            TypeConversionUtil.$$$reportNull$$$0(63);
        }
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, classResolveResult.getElement(), classResolveResult.getSubstitutor());
        if (psiSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(64);
        }
        return psiSubstitutor;
    }

    @NotNull
    public static PsiType binaryNumericPromotion(PsiType type1, PsiType type2) {
        if (TypeConversionUtil.isDoubleType(type1)) {
            PsiType psiType = TypeConversionUtil.unbox(type1);
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(65);
            }
            return psiType;
        }
        if (TypeConversionUtil.isDoubleType(type2)) {
            PsiType psiType = TypeConversionUtil.unbox(type2);
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(66);
            }
            return psiType;
        }
        if (TypeConversionUtil.isFloatType(type1)) {
            PsiType psiType = TypeConversionUtil.unbox(type1);
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(67);
            }
            return psiType;
        }
        if (TypeConversionUtil.isFloatType(type2)) {
            PsiType psiType = TypeConversionUtil.unbox(type2);
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(68);
            }
            return psiType;
        }
        if (TypeConversionUtil.isLongType(type1)) {
            PsiType psiType = TypeConversionUtil.unbox(type1);
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(69);
            }
            return psiType;
        }
        if (TypeConversionUtil.isLongType(type2)) {
            PsiType psiType = TypeConversionUtil.unbox(type2);
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(70);
            }
            return psiType;
        }
        PsiPrimitiveType psiPrimitiveType = PsiType.INT;
        if (psiPrimitiveType == null) {
            TypeConversionUtil.$$$reportNull$$$0(71);
        }
        return psiPrimitiveType;
    }

    @NotNull
    private static PsiType unbox(@NotNull PsiType type) {
        if (type == null) {
            TypeConversionUtil.$$$reportNull$$$0(72);
        }
        if (type instanceof PsiPrimitiveType) {
            PsiType psiType = type;
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(73);
            }
            return psiType;
        }
        if (type instanceof PsiClassType) {
            LOG.assertTrue((type = PsiPrimitiveType.getUnboxedType(type)) != null);
            PsiType psiType = type;
            if (psiType == null) {
                TypeConversionUtil.$$$reportNull$$$0(74);
            }
            return psiType;
        }
        LOG.error("Invalid type for unboxing " + type);
        PsiType psiType = type;
        if (psiType == null) {
            TypeConversionUtil.$$$reportNull$$$0(75);
        }
        return psiType;
    }

    public static boolean isIntegerNumber(String typeName) {
        return INTEGER_NUMBER_TYPES.contains(typeName);
    }

    public static boolean isPrimitive(String typeName) {
        return PRIMITIVE_TYPES.contains(typeName);
    }

    public static boolean isPrimitiveWrapper(String typeName) {
        return PRIMITIVE_WRAPPER_TYPES.contains(typeName);
    }

    @Contract(value="null -> false")
    public static boolean isAssignableFromPrimitiveWrapper(PsiType type) {
        if (type == null) {
            return false;
        }
        return TypeConversionUtil.isPrimitiveWrapper(type) || type.equalsToText("java.lang.Object") || type.equalsToText("java.lang.Number");
    }

    @Contract(value="null -> false")
    public static boolean isPrimitiveWrapper(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        String name = ((PsiClassType)type).getClassName();
        return PRIMITIVE_WRAPPER_SIMPLE_NAMES.contains(name) && TypeConversionUtil.isPrimitiveWrapper(type.getCanonicalText());
    }

    @Contract(value="null -> false")
    public static boolean isComposite(PsiType type) {
        return type instanceof PsiDisjunctionType || type instanceof PsiIntersectionType;
    }

    public static PsiType typeParameterErasure(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(76);
        }
        return TypeConversionUtil.typeParameterErasure(typeParameter, PsiSubstitutor.EMPTY);
    }

    private static PsiType typeParameterErasure(@NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor beforeSubstitutor) {
        PsiClassType[] extendsList;
        if (typeParameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(77);
        }
        if (beforeSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(78);
        }
        if ((extendsList = typeParameter.getExtendsList().getReferencedTypes()).length > 0) {
            PsiClass psiClass = extendsList[0].resolve();
            if (psiClass instanceof PsiTypeParameter) {
                THashSet visited = new THashSet();
                visited.add(psiClass);
                PsiTypeParameter boundTypeParameter = (PsiTypeParameter)psiClass;
                if (beforeSubstitutor.getSubstitutionMap().containsKey(boundTypeParameter)) {
                    return TypeConversionUtil.erasure(beforeSubstitutor.substitute(boundTypeParameter));
                }
                return TypeConversionUtil.typeParameterErasureInner(boundTypeParameter, (Set<? super PsiClass>)visited, beforeSubstitutor);
            }
            if (psiClass != null) {
                return JavaPsiFacade.getElementFactory(typeParameter.getProject()).createType(psiClass);
            }
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    private static PsiClassType typeParameterErasureInner(PsiTypeParameter typeParameter, Set<? super PsiClass> visited, PsiSubstitutor beforeSubstitutor) {
        PsiClassType[] extendsList = typeParameter.getExtendsList().getReferencedTypes();
        if (extendsList.length > 0) {
            PsiClass psiClass = extendsList[0].resolve();
            if (psiClass instanceof PsiTypeParameter) {
                if (!visited.contains(psiClass)) {
                    visited.add(psiClass);
                    if (beforeSubstitutor.getSubstitutionMap().containsKey(psiClass)) {
                        return (PsiClassType)TypeConversionUtil.erasure(beforeSubstitutor.substitute((PsiTypeParameter)psiClass));
                    }
                    return TypeConversionUtil.typeParameterErasureInner((PsiTypeParameter)psiClass, visited, beforeSubstitutor);
                }
            } else if (psiClass != null) {
                return JavaPsiFacade.getElementFactory(typeParameter.getProject()).createType(psiClass);
            }
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    @Contract(value="null -> null")
    public static PsiType erasure(@Nullable PsiType type) {
        return TypeConversionUtil.erasure(type, PsiSubstitutor.EMPTY);
    }

    @Contract(value="null, _ -> null")
    public static PsiType erasure(@Nullable PsiType type, final @NotNull PsiSubstitutor beforeSubstitutor) {
        if (beforeSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(79);
        }
        if (type == null) {
            return null;
        }
        return type.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            @Nullable
            public PsiType visitType(PsiType type) {
                return type;
            }

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                PsiClass aClass = classType.resolve();
                if (aClass instanceof PsiTypeParameter && !TypeConversionUtil.isFreshVariable((PsiTypeParameter)aClass)) {
                    return TypeConversionUtil.typeParameterErasure((PsiTypeParameter)aClass, beforeSubstitutor);
                }
                return classType.rawType();
            }

            @Override
            public PsiType visitWildcardType(PsiWildcardType wildcardType) {
                return wildcardType;
            }

            @Override
            @Nullable
            public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return capturedWildcardType.getUpperBound().accept(this);
            }

            @Override
            public PsiType visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return primitiveType;
            }

            @Override
            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                return this.visitArrayType(ellipsisType);
            }

            @Override
            public PsiType visitArrayType(PsiArrayType arrayType) {
                PsiType componentType = arrayType.getComponentType();
                PsiType newComponentType = componentType.accept(this);
                if (newComponentType == componentType) {
                    return arrayType;
                }
                return newComponentType != null ? newComponentType.createArrayType() : null;
            }

            @Override
            public PsiType visitDisjunctionType(PsiDisjunctionType disjunctionType) {
                PsiClassType lub = PsiTypesUtil.getLowestUpperBoundClassType(disjunctionType);
                return lub != null ? TypeConversionUtil.erasure(lub, beforeSubstitutor) : disjunctionType;
            }
        });
    }

    public static Object computeCastTo(Object operand, PsiType castType) {
        Object value;
        if (operand == null || castType == null) {
            return null;
        }
        if (operand instanceof String && castType.equalsToText("java.lang.String") || operand instanceof Boolean && PsiType.BOOLEAN.equals(castType)) {
            value = operand;
        } else {
            PsiType primitiveType = TypeConversionUtil.wrapperToPrimitive(operand);
            if (primitiveType == null) {
                return null;
            }
            if (castType.equals(primitiveType)) {
                return operand;
            }
            int rankFrom = TypeConversionUtil.getTypeRank(primitiveType);
            if (rankFrom > caster.length) {
                return null;
            }
            int rankTo = TypeConversionUtil.getTypeRank(castType);
            if (rankTo > caster.length) {
                return null;
            }
            value = caster[rankFrom - 1][rankTo - 1].cast(operand);
        }
        return value;
    }

    @NotNull
    public static PsiType unboxAndBalanceTypes(PsiType type1, PsiType type2) {
        if (type1 instanceof PsiClassType) {
            type1 = PsiPrimitiveType.getUnboxedType(type1);
        }
        if (type2 instanceof PsiClassType) {
            type2 = PsiPrimitiveType.getUnboxedType(type2);
        }
        if (PsiType.DOUBLE.equals(type1) || PsiType.DOUBLE.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.DOUBLE;
            if (psiPrimitiveType == null) {
                TypeConversionUtil.$$$reportNull$$$0(80);
            }
            return psiPrimitiveType;
        }
        if (PsiType.FLOAT.equals(type1) || PsiType.FLOAT.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.FLOAT;
            if (psiPrimitiveType == null) {
                TypeConversionUtil.$$$reportNull$$$0(81);
            }
            return psiPrimitiveType;
        }
        if (PsiType.LONG.equals(type1) || PsiType.LONG.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.LONG;
            if (psiPrimitiveType == null) {
                TypeConversionUtil.$$$reportNull$$$0(82);
            }
            return psiPrimitiveType;
        }
        PsiPrimitiveType psiPrimitiveType = PsiType.INT;
        if (psiPrimitiveType == null) {
            TypeConversionUtil.$$$reportNull$$$0(83);
        }
        return psiPrimitiveType;
    }

    public static IElementType convertEQtoOperation(IElementType eqOpSign) {
        IElementType opSign = null;
        if (eqOpSign == JavaTokenType.ANDEQ) {
            opSign = JavaTokenType.AND;
        } else if (eqOpSign == JavaTokenType.ASTERISKEQ) {
            opSign = JavaTokenType.ASTERISK;
        } else if (eqOpSign == JavaTokenType.DIVEQ) {
            opSign = JavaTokenType.DIV;
        } else if (eqOpSign == JavaTokenType.GTGTEQ) {
            opSign = JavaTokenType.GTGT;
        } else if (eqOpSign == JavaTokenType.GTGTGTEQ) {
            opSign = JavaTokenType.GTGTGT;
        } else if (eqOpSign == JavaTokenType.LTLTEQ) {
            opSign = JavaTokenType.LTLT;
        } else if (eqOpSign == JavaTokenType.MINUSEQ) {
            opSign = JavaTokenType.MINUS;
        } else if (eqOpSign == JavaTokenType.OREQ) {
            opSign = JavaTokenType.OR;
        } else if (eqOpSign == JavaTokenType.PERCEQ) {
            opSign = JavaTokenType.PERC;
        } else if (eqOpSign == JavaTokenType.PLUSEQ) {
            opSign = JavaTokenType.PLUS;
        } else if (eqOpSign == JavaTokenType.XOREQ) {
            opSign = JavaTokenType.XOR;
        }
        return opSign;
    }

    @Nullable
    public static PsiType calcTypeForBinaryExpression(PsiType lType, PsiType rType, @NotNull IElementType sign, boolean accessLType) {
        if (sign == null) {
            TypeConversionUtil.$$$reportNull$$$0(84);
        }
        if (sign == JavaTokenType.PLUS) {
            if (rType == null) {
                return null;
            }
            if (rType.equalsToText("java.lang.String")) {
                return rType;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            if (lType.equalsToText("java.lang.String")) {
                return lType;
            }
            return TypeConversionUtil.unboxAndBalanceTypes(lType, rType);
        }
        if (sign == JavaTokenType.MINUS || sign == JavaTokenType.ASTERISK || sign == JavaTokenType.DIV || sign == JavaTokenType.PERC) {
            if (rType == null) {
                return null;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            return TypeConversionUtil.unboxAndBalanceTypes(lType, rType);
        }
        if (sign == JavaTokenType.LTLT || sign == JavaTokenType.GTGT || sign == JavaTokenType.GTGTGT) {
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (PsiType.BYTE.equals(lType) || PsiType.CHAR.equals(lType) || PsiType.SHORT.equals(lType)) {
                return PsiType.INT;
            }
            if (lType instanceof PsiClassType) {
                lType = PsiPrimitiveType.getUnboxedType(lType);
            }
            return lType;
        }
        if (PsiBinaryExpression.BOOLEAN_OPERATION_TOKENS.contains(sign)) {
            return PsiType.BOOLEAN;
        }
        if (sign == JavaTokenType.OR || sign == JavaTokenType.XOR || sign == JavaTokenType.AND) {
            if (rType instanceof PsiClassType) {
                rType = PsiPrimitiveType.getUnboxedType(rType);
            }
            if (lType instanceof PsiClassType) {
                lType = PsiPrimitiveType.getUnboxedType(lType);
            }
            if (rType == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals(rType)) {
                return PsiType.BOOLEAN;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals(lType)) {
                return PsiType.BOOLEAN;
            }
            if (PsiType.LONG.equals(lType) || PsiType.LONG.equals(rType)) {
                return PsiType.LONG;
            }
            return PsiType.INT;
        }
        LOG.error("Unknown token: " + sign);
        return null;
    }

    public static boolean isFPZero(@NotNull String text) {
        if (text == null) {
            TypeConversionUtil.$$$reportNull$$$0(85);
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c) && c != '0') {
                return false;
            }
            char d = Character.toUpperCase(c);
            if (d == 'E' || d == 'P') break;
        }
        return true;
    }

    public static boolean areSameFreshVariables(PsiTypeParameter p1, PsiTypeParameter p2) {
        PsiElement originalContext = (PsiElement)p1.getUserData(ORIGINAL_CONTEXT);
        return originalContext != null && originalContext == p2.getUserData(ORIGINAL_CONTEXT);
    }

    public static boolean isFreshVariable(PsiTypeParameter typeParameter) {
        return typeParameter.getUserData(ORIGINAL_CONTEXT) != null;
    }

    public static void markAsFreshVariable(PsiTypeParameter parameter, PsiElement context) {
        parameter.putUserData(ORIGINAL_CONTEXT, context);
    }

    public static PsiType getInferredUpperBoundForSynthetic(@NotNull PsiTypeParameter psiClass) {
        if (psiClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(86);
        }
        return (PsiType)psiClass.getUserData(UPPER_BOUND);
    }

    public static PsiType getInferredLowerBoundForSynthetic(@NotNull PsiTypeParameter psiClass) {
        if (psiClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(87);
        }
        return (PsiType)psiClass.getUserData(LOWER_BOUND);
    }

    public static void setInferredBoundsForSynthetic(@NotNull PsiTypeParameter parameter, PsiType lowerBound, @NotNull PsiType upperBound) {
        if (parameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(88);
        }
        if (upperBound == null) {
            TypeConversionUtil.$$$reportNull$$$0(89);
        }
        assert (!parameter.isPhysical()) : parameter;
        parameter.putUserData(UPPER_BOUND, upperBound);
        parameter.putUserData(LOWER_BOUND, lowerBound);
    }

    public static boolean isSafeConversion(PsiType target, PsiType source) {
        if (target == null || source == null) {
            return false;
        }
        if (target.equals(source)) {
            return true;
        }
        int sourceRank = TYPE_TO_RANK_MAP.get((Object)source);
        int targetRank = TYPE_TO_RANK_MAP.get((Object)target);
        if (sourceRank == 0 || sourceRank > 7 || targetRank == 0 || targetRank > 7 || !IS_ASSIGNABLE_BIT_SET[sourceRank - 1][targetRank - 1]) {
            return false;
        }
        if (PsiType.INT.equals(source) && PsiType.FLOAT.equals(target)) {
            return false;
        }
        return !PsiType.LONG.equals(source) || !TypeConversionUtil.isFloatOrDoubleType(target);
    }

    private static PsiType wrapperToPrimitive(@NotNull Object o) {
        if (o == null) {
            TypeConversionUtil.$$$reportNull$$$0(90);
        }
        return WRAPPER_TO_PRIMITIVE.get(o.getClass());
    }

    private static /* synthetic */ boolean lambda$null$0(Set set, PsiClass psiClass1) {
        ContainerUtil.addIfNotNull((Collection)set, (Object)psiClass1.getQualifiedName());
        return true;
    }

    static {
        TYPE_TO_RANK_MAP.put((Object)PsiType.BYTE, 1);
        TYPE_TO_RANK_MAP.put((Object)PsiType.SHORT, 2);
        TYPE_TO_RANK_MAP.put((Object)PsiType.CHAR, 3);
        TYPE_TO_RANK_MAP.put((Object)PsiType.INT, 4);
        TYPE_TO_RANK_MAP.put((Object)PsiType.LONG, 5);
        TYPE_TO_RANK_MAP.put((Object)PsiType.FLOAT, 6);
        TYPE_TO_RANK_MAP.put((Object)PsiType.DOUBLE, 7);
        TYPE_TO_RANK_MAP.put((Object)PsiType.BOOLEAN, 10);
        POSSIBLE_BOXED_HOLDER_TYPES = Key.create((String)"Types that may be possibly assigned from primitive ones");
        ourGuard = RecursionManager.createGuard((String)"isAssignable");
        INTEGER_NUMBER_TYPES = new THashSet(5);
        INTEGER_NUMBER_TYPES.add(PsiType.BYTE.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.CHAR.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.LONG.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.INT.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.SHORT.getCanonicalText());
        PRIMITIVE_TYPES = new THashSet(9);
        PRIMITIVE_TYPES.add(PsiType.VOID.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.BYTE.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.CHAR.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.DOUBLE.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.FLOAT.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.LONG.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.INT.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.SHORT.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.BOOLEAN.getCanonicalText());
        PRIMITIVE_WRAPPER_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Long", "java.lang.Integer", "java.lang.Short", "java.lang.Boolean"});
        PRIMITIVE_WRAPPER_SIMPLE_NAMES = ContainerUtil.map2Set(PRIMITIVE_WRAPPER_TYPES, StringUtil::getShortName);
        caster = new Caster[][]{{operand -> operand, operand -> (short)((Number)operand).intValue(), operand -> Character.valueOf((char)((Number)operand).intValue()), operand -> ((Number)operand).intValue(), operand -> (long)((Number)operand).intValue(), operand -> Float.valueOf(((Number)operand).intValue()), operand -> (double)((Number)operand).intValue()}, {operand -> (byte)((Short)operand).shortValue(), operand -> operand, operand -> Character.valueOf((char)((Short)operand).shortValue()), operand -> (int)((Short)operand).shortValue(), operand -> (long)((Short)operand).shortValue(), operand -> Float.valueOf(((Short)operand).shortValue()), operand -> (double)((Short)operand).shortValue()}, {operand -> (byte)((Character)operand).charValue(), operand -> (short)((Character)operand).charValue(), operand -> operand, operand -> (int)((Character)operand).charValue(), operand -> (long)((Character)operand).charValue(), operand -> Float.valueOf(((Character)operand).charValue()), operand -> (double)((Character)operand).charValue()}, {operand -> (byte)((Integer)operand).intValue(), operand -> (short)((Integer)operand).intValue(), operand -> Character.valueOf((char)((Integer)operand).intValue()), operand -> operand, operand -> (long)((Integer)operand).intValue(), operand -> Float.valueOf(((Integer)operand).intValue()), operand -> (double)((Integer)operand).intValue()}, {operand -> (byte)((Long)operand).longValue(), operand -> (short)((Long)operand).longValue(), operand -> Character.valueOf((char)((Long)operand).longValue()), operand -> (int)((Long)operand).longValue(), operand -> operand, operand -> Float.valueOf(((Long)operand).longValue()), operand -> (double)((Long)operand).longValue()}, {operand -> (byte)((Float)operand).floatValue(), operand -> (short)((Float)operand).floatValue(), operand -> Character.valueOf((char)((Float)operand).floatValue()), operand -> (int)((Float)operand).floatValue(), operand -> (long)((Float)operand).floatValue(), operand -> operand, operand -> (double)((Float)operand).floatValue()}, {operand -> (byte)((Double)operand).doubleValue(), operand -> (short)((Double)operand).doubleValue(), operand -> Character.valueOf((char)((Double)operand).doubleValue()), operand -> (int)((Double)operand).doubleValue(), operand -> (long)((Double)operand).doubleValue(), operand -> new Float((Double)operand), operand -> operand}};
        WRAPPER_TO_PRIMITIVE = new THashMap(8);
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, PsiType.BOOLEAN);
        WRAPPER_TO_PRIMITIVE.put(Byte.class, PsiType.BYTE);
        WRAPPER_TO_PRIMITIVE.put(Character.class, PsiType.CHAR);
        WRAPPER_TO_PRIMITIVE.put(Short.class, PsiType.SHORT);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, PsiType.INT);
        WRAPPER_TO_PRIMITIVE.put(Long.class, PsiType.LONG);
        WRAPPER_TO_PRIMITIVE.put(Float.class, PsiType.FLOAT);
        WRAPPER_TO_PRIMITIVE.put(Double.class, PsiType.DOUBLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 43: 
            case 56: 
            case 57: 
            case 58: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 43: 
            case 56: 
            case 57: 
            case 58: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 6: 
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 43: 
            case 56: 
            case 57: 
            case 58: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/TypeConversionUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseResult";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derived";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 13: 
            case 52: 
            case 55: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedSubstitutor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor1";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor2";
                break;
            }
            case 23: 
            case 26: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 36: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightWildcardType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wildcardType";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 42: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftResult";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightResult";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeLeft";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRight";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassCandidate";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedClassCandidate";
                break;
            }
            case 53: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 54: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedClass";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeSubstitutor";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperBound";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/TypeConversionUtil";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainSafeSuperType";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBoxedTypeSupers";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassSubstitutor";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "binaryNumericPromotion";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "unbox";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxAndBalanceTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areTypesConvertible";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isNarrowingReferenceConversionAllowed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "obtainSafeSuperType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 43: 
            case 56: 
            case 57: 
            case 58: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperTypesWithDifferentTypeArguments";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "areSameParameterTypes";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "areSameArgumentTypes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeRank";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isUnaryOperatorApplicable";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFromWildcard";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableToWildcard";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isUnboxable";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isBoxable";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAllBoxedTypeSupers";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isClassAssignable";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "typeParametersAgree";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "typesAgree";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getClassSubstitutor";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassSubstitutor";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getMaybeSuperClassSubstitutor";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "unbox";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "typeParameterErasure";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "erasure";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "calcTypeForBinaryExpression";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isFPZero";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getInferredUpperBoundForSynthetic";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getInferredLowerBoundForSynthetic";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "setInferredBoundsForSynthetic";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "wrapperToPrimitive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 43: 
            case 56: 
            case 57: 
            case 58: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface Caster {
        @NotNull
        public Object cast(@NotNull Object var1);
    }
}

