/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.pom.java.LanguageFeatureProvider;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;

public enum JavaFeature {
    MULTI_CATCH(LanguageLevel.JDK_1_7),
    STREAMS(LanguageLevel.JDK_1_8),
    ADVANCED_COLLECTIONS_API(LanguageLevel.JDK_1_8),
    THREAD_LOCAL_WITH_INITIAL(LanguageLevel.JDK_1_8);

    private final LanguageLevel myMinLevel;

    private JavaFeature(LanguageLevel minLevel) {
        this.myMinLevel = minLevel;
    }

    public boolean isFeatureSupported(@NotNull PsiFile context) {
        LanguageFeatureProvider[] extensions2;
        LanguageLevel languageLevel;
        if (context == null) {
            JavaFeature.$$$reportNull$$$0(0);
        }
        if (!(languageLevel = PsiUtil.getLanguageLevel((PsiElement)context)).isAtLeast(this.myMinLevel)) {
            return false;
        }
        for (LanguageFeatureProvider extension : extensions2 = (LanguageFeatureProvider[])LanguageFeatureProvider.EXTENSION_POINT_NAME.getExtensions()) {
            ThreeState threeState = extension.isFeatureSupported(this, context);
            if (threeState == ThreeState.UNSURE) continue;
            return threeState.toBoolean();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/pom/java/JavaFeature", "isFeatureSupported"));
    }
}

