/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.jsp.JspFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SourcePosition
implements Navigatable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.SourcePosition");

    @NotNull
    public abstract PsiFile getFile();

    public abstract PsiElement getElementAt();

    public abstract int getLine();

    public abstract int getOffset();

    public abstract Editor openEditor(boolean var1);

    public static SourcePosition createFromLineComputable(@NotNull PsiFile file, final Computable<Integer> line) {
        if (file == null) {
            SourcePosition.$$$reportNull$$$0(0);
        }
        return new SourcePositionCache(file){

            @Override
            protected int calcLine() {
                return (Integer)line.compute();
            }
        };
    }

    public static SourcePosition createFromLine(@NotNull PsiFile file, final int line) {
        if (file == null) {
            SourcePosition.$$$reportNull$$$0(1);
        }
        return new SourcePositionCache(file){

            @Override
            protected int calcLine() {
                return line;
            }

            public String toString() {
                return this.getFile().getName() + ":" + line;
            }
        };
    }

    public static SourcePosition createFromOffset(@NotNull PsiFile file, final int offset) {
        if (file == null) {
            SourcePosition.$$$reportNull$$$0(2);
        }
        return new SourcePositionCache(file){

            @Override
            protected int calcOffset() {
                return offset;
            }

            public String toString() {
                return this.getFile().getName() + " offset " + offset;
            }
        };
    }

    @Nullable
    public static SourcePosition createFromElement(@NotNull PsiElement element) {
        if (element == null) {
            SourcePosition.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement navigationElement = element.getNavigationElement();
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)navigationElement.getProject()).createSmartPsiElementPointer(navigationElement);
        JspFile psiFile = JspPsiUtil.isInJspFile(navigationElement) ? JspPsiUtil.getJspFile(navigationElement) : navigationElement.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        return new SourcePositionCache(psiFile){

            @Override
            protected PsiElement calcPsiElement() {
                return pointer.getElement();
            }

            @Override
            protected int calcOffset() {
                return (Integer)ReadAction.compute(() -> {
                    PsiElement elem = pointer.getElement();
                    return elem != null ? elem.getTextOffset() : -1;
                });
            }
        };
    }

    public boolean equals(Object o) {
        if (o instanceof SourcePosition) {
            SourcePosition sourcePosition = (SourcePosition)o;
            return Comparing.equal((Object)sourcePosition.getFile(), (Object)this.getFile()) && sourcePosition.getOffset() == this.getOffset();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/SourcePosition";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromLineComputable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromLine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createFromElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class SourcePositionCache
    extends SourcePosition {
        @NotNull
        private final PsiFile myFile;
        @Nullable
        private final SmartPsiElementPointer<PsiFile> myFilePointer;
        private long myModificationStamp;
        private WeakReference<PsiElement> myPsiElementRef;
        private Integer myLine;
        private Integer myOffset;

        SourcePositionCache(@NotNull PsiFile file) {
            if (file == null) {
                SourcePositionCache.$$$reportNull$$$0(0);
            }
            this.myFile = file;
            this.myFilePointer = (SmartPsiElementPointer)ReadAction.compute(() -> file.isValid() ? SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiElementPointer((PsiElement)file) : null);
            this.myModificationStamp = file.getModificationStamp();
        }

        @Override
        @NotNull
        public PsiFile getFile() {
            PsiFile file = this.myFilePointer != null ? (PsiFile)ReadAction.compute(() -> this.myFilePointer.getElement()) : null;
            PsiFile psiFile = file != null ? file : this.myFile;
            if (psiFile == null) {
                SourcePositionCache.$$$reportNull$$$0(1);
            }
            return psiFile;
        }

        public boolean canNavigate() {
            return this.getFile().isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public void navigate(boolean requestFocus) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.canNavigate()) {
                    return;
                }
                this.openEditor(requestFocus);
            });
        }

        @Override
        public Editor openEditor(boolean requestFocus) {
            PsiFile psiFile = this.getFile();
            Project project = psiFile.getProject();
            if (project.isDisposed()) {
                return null;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null || !virtualFile.isValid()) {
                return null;
            }
            int offset = this.getOffset();
            if (offset < 0) {
                return null;
            }
            return FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, offset), requestFocus);
        }

        private void updateData() {
            if (this.dataUpdateNeeded()) {
                this.myModificationStamp = this.getFile().getModificationStamp();
                this.myLine = null;
                this.myOffset = null;
                this.myPsiElementRef = null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean dataUpdateNeeded() {
            if (this.myModificationStamp != this.getFile().getModificationStamp()) {
                return true;
            }
            PsiElement psiElement = (PsiElement)SoftReference.dereference(this.myPsiElementRef);
            if (psiElement == null) return false;
            if ((Boolean)ReadAction.compute(() -> ((PsiElement)psiElement).isValid()) != false) return false;
            return true;
        }

        @Override
        public int getLine() {
            this.updateData();
            if (this.myLine == null) {
                this.myLine = this.calcLine();
            }
            return this.myLine;
        }

        @Override
        public int getOffset() {
            this.updateData();
            if (this.myOffset == null) {
                this.myOffset = this.calcOffset();
            }
            return this.myOffset;
        }

        @Override
        public PsiElement getElementAt() {
            this.updateData();
            PsiElement element = (PsiElement)SoftReference.dereference(this.myPsiElementRef);
            if (element == null) {
                element = (PsiElement)ReadAction.compute(this::calcPsiElement);
                this.myPsiElementRef = new WeakReference<PsiElement>(element);
                return element;
            }
            return element;
        }

        protected int calcLine() {
            PsiFile file = this.getFile();
            Document document = null;
            try {
                document = SourcePositionCache.getDocument(file);
                if (document == null) {
                    document = SourcePositionCache.getDocument(file.getOriginalFile());
                }
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            if (document != null) {
                try {
                    return document.getLineNumber(this.calcOffset());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return -1;
        }

        @Nullable
        private static Document getDocument(@NotNull PsiFile file) {
            Project project;
            if (file == null) {
                SourcePositionCache.$$$reportNull$$$0(2);
            }
            if ((project = file.getProject()).isDisposed()) {
                return null;
            }
            return PsiDocumentManager.getInstance((Project)project).getDocument(file);
        }

        protected int calcOffset() {
            PsiFile file = this.getFile();
            Document document = SourcePositionCache.getDocument(file);
            if (document != null) {
                try {
                    return document.getLineStartOffset(this.calcLine());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return -1;
        }

        @Nullable
        protected PsiElement calcPsiElement() {
            PsiClass[] classes;
            PsiClassOwner owner;
            PsiFile psiFile = this.getFile();
            if (!psiFile.isValid()) {
                return null;
            }
            int lineNumber = this.getLine();
            if (lineNumber < 0) {
                return psiFile;
            }
            Document document = SourcePositionCache.getDocument(psiFile);
            if (document == null) {
                return null;
            }
            if (lineNumber >= document.getLineCount()) {
                return psiFile;
            }
            int startOffset = document.getLineStartOffset(lineNumber);
            if (startOffset == -1) {
                return null;
            }
            Object rootElement = psiFile;
            List allFiles = psiFile.getViewProvider().getAllFiles();
            if (allFiles.size() > 1 && (owner = (PsiClassOwner)ContainerUtil.findInstance((Iterable)allFiles, PsiClassOwner.class)) != null && (classes = owner.getClasses()).length == 1 && classes[0] instanceof SyntheticElement) {
                rootElement = classes[0];
            }
            PsiElement element = null;
            int offset = this.getOffset();
            while (true) {
                char c;
                CharSequence charsSequence = document.getCharsSequence();
                while (offset < charsSequence.length() && ((c = charsSequence.charAt(offset)) == ' ' || c == '\t')) {
                    ++offset;
                }
                if (offset >= charsSequence.length() || !((element = rootElement.findElementAt(offset)) instanceof PsiComment)) break;
                offset = element.getTextRange().getEndOffset() + 1;
            }
            if (element != null && element.getParent() instanceof PsiForStatement) {
                return ((PsiForStatement)element.getParent()).getInitialization();
            }
            return element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/SourcePosition$SourcePositionCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/SourcePosition$SourcePositionCache";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDocument";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

