/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class NlsCapitalizationUtil {
    public static boolean isCapitalizationSatisfied(String value, Nls.Capitalization capitalization) {
        if (StringUtil.isEmpty((String)value) || capitalization == Nls.Capitalization.NotSpecified) {
            return true;
        }
        value = value.replace("&", "");
        return capitalization == Nls.Capitalization.Title ? StringUtil.wordsToBeginFromUpperCase((String)value).equals(value) : NlsCapitalizationUtil.checkSentenceCapitalization(value);
    }

    private static boolean checkSentenceCapitalization(@NotNull String value) {
        List words;
        int wordCount;
        if (value == null) {
            NlsCapitalizationUtil.$$$reportNull$$$0(0);
        }
        if ((wordCount = (words = StringUtil.split((String)value, (String)" ")).size()) == 0) {
            return true;
        }
        if (Character.isLetter(((String)words.get(0)).charAt(0)) && !NlsCapitalizationUtil.isCapitalizedWord((String)words.get(0))) {
            return false;
        }
        if (wordCount == 1) {
            return true;
        }
        int capitalized = 1;
        for (int i = 1; i < wordCount; ++i) {
            String word = (String)words.get(i);
            if (!NlsCapitalizationUtil.isCapitalizedWord(word) || word.length() == 1 || !Character.isLowerCase(word.charAt(1))) continue;
            ++capitalized;
        }
        if (capitalized == 1 && wordCount == 2) {
            return true;
        }
        double ratio = ((double)capitalized - 1.0) / (double)wordCount;
        return ratio <= 0.4;
    }

    private static boolean isCapitalizedWord(String word) {
        return !word.isEmpty() && Character.isLetter(word.charAt(0)) && Character.isUpperCase(word.charAt(0));
    }

    @NotNull
    public static String fixValue(String string, Nls.Capitalization capitalization) {
        String string2 = capitalization == Nls.Capitalization.Title ? StringUtil.wordsToBeginFromUpperCase((String)string) : StringUtil.capitalize((String)StringUtil.wordsToBeginFromLowerCase((String)string));
        if (string2 == null) {
            NlsCapitalizationUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public static Nls.Capitalization getCapitalizationFromAnno(PsiModifierListOwner modifierListOwner) {
        PsiAnnotation nls = AnnotationUtil.findAnnotationInHierarchy(modifierListOwner, Collections.singleton(Nls.class.getName()));
        if (nls == null) {
            Nls.Capitalization capitalization = Nls.Capitalization.NotSpecified;
            if (capitalization == null) {
                NlsCapitalizationUtil.$$$reportNull$$$0(2);
            }
            return capitalization;
        }
        PsiAnnotationMemberValue capitalization = nls.findAttributeValue("capitalization");
        Object cap = JavaPsiFacade.getInstance(modifierListOwner.getProject()).getConstantEvaluationHelper().computeConstantExpression(capitalization);
        Nls.Capitalization capitalization2 = cap instanceof Nls.Capitalization ? (Nls.Capitalization)cap : Nls.Capitalization.NotSpecified;
        if (capitalization2 == null) {
            NlsCapitalizationUtil.$$$reportNull$$$0(3);
        }
        return capitalization2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/NlsCapitalizationUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/NlsCapitalizationUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fixValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapitalizationFromAnno";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkSentenceCapitalization";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

