/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.wizards.MavenAddArchetypeDialog;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilder;

public class MavenArchetypesStep
extends ModuleWizardStep
implements Disposable {
    private JCheckBox myUseArchetypeCheckBox;
    private JButton myAddArchetypeButton;
    private JPanel myArchetypesPanel;
    private final Tree myArchetypesTree;
    private JScrollPane myArchetypeDescriptionScrollPane;
    private JPanel myMainPanel;
    private JTextArea myArchetypeDescriptionField;
    private Object myCurrentUpdaterMarker;
    private final AsyncProcessIcon myLoadingIcon;
    private boolean skipUpdateUI;
    private final MavenModuleBuilder myBuilder;
    @Nullable
    private final StepAdapter myStep;

    public MavenArchetypesStep(MavenModuleBuilder builder, @Nullable StepAdapter step) {
        this.$$$setupUI$$$();
        this.myLoadingIcon = new AsyncProcessIcon.Big(((Object)((Object)this)).getClass() + ".loading");
        this.myBuilder = builder;
        this.myStep = step;
        Disposer.register((Disposable)this, (Disposable)this.myLoadingIcon);
        this.myArchetypesTree = new Tree();
        this.myArchetypesTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        JScrollPane archetypesScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myArchetypesTree);
        this.myArchetypesPanel.add((Component)archetypesScrollPane, "archetypes");
        JPanel loadingPanel = new JPanel(new GridBagLayout());
        JPanel bp = new JPanel(new BorderLayout(10, 10));
        bp.add((Component)new JLabel("Loading archetype list..."), "North");
        bp.add((Component)this.myLoadingIcon, "Center");
        loadingPanel.add((Component)bp, new GridBagConstraints());
        this.myArchetypesPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)loadingPanel), "loading");
        ((CardLayout)this.myArchetypesPanel.getLayout()).show(this.myArchetypesPanel, "archetypes");
        this.myUseArchetypeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MavenArchetypesStep.this.updateComponents();
                MavenArchetypesStep.this.archetypeMayBeChanged();
            }
        });
        this.myAddArchetypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenArchetypesStep.this.doAddArchetype();
            }
        });
        this.myArchetypesTree.setRootVisible(false);
        this.myArchetypesTree.setShowsRootHandles(true);
        this.myArchetypesTree.setCellRenderer((TreeCellRenderer)((Object)new MyRenderer()));
        this.myArchetypesTree.getSelectionModel().setSelectionMode(1);
        this.myArchetypesTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MavenArchetypesStep.this.updateArchetypeDescription();
                MavenArchetypesStep.this.archetypeMayBeChanged();
            }
        });
        new TreeSpeedSearch(this.myArchetypesTree, path -> {
            MavenArchetype info = MavenArchetypesStep.getArchetypeInfoFromPathComponent(path.getLastPathComponent());
            return info.groupId + ":" + info.artifactId + ":" + info.version;
        }).setComparator(new SpeedSearchComparator(false));
        this.myArchetypeDescriptionField.setEditable(false);
        this.myArchetypeDescriptionField.setBackground(UIUtil.getPanelBackground());
        this.requestUpdate();
        this.updateComponents();
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private void updateComponents() {
        boolean archetypesEnabled = this.myUseArchetypeCheckBox.isSelected();
        this.myAddArchetypeButton.setEnabled(archetypesEnabled);
        this.myArchetypesTree.setEnabled(archetypesEnabled);
        this.myArchetypesTree.setBackground(archetypesEnabled ? UIUtil.getListBackground() : UIUtil.getPanelBackground());
    }

    @Nullable
    public MavenArchetype getSelectedArchetype() {
        if (!this.myUseArchetypeCheckBox.isSelected() || this.myArchetypesTree.isSelectionEmpty()) {
            return null;
        }
        return MavenArchetypesStep.getArchetypeInfoFromPathComponent(this.myArchetypesTree.getLastSelectedPathComponent());
    }

    private static MavenArchetype getArchetypeInfoFromPathComponent(Object sel) {
        return (MavenArchetype)((DefaultMutableTreeNode)sel).getUserObject();
    }

    private void updateArchetypeDescription() {
        String desc;
        MavenArchetype sel = this.getSelectedArchetype();
        String string = desc = sel == null ? null : sel.description;
        if (StringUtil.isEmptyOrSpaces((String)desc)) {
            this.myArchetypeDescriptionScrollPane.setVisible(false);
        } else {
            this.myArchetypeDescriptionScrollPane.setVisible(true);
            this.myArchetypeDescriptionField.setText(desc);
        }
    }

    @Nullable
    private static TreePath findNodePath(MavenArchetype object, TreeModel model, Object parent) {
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            DefaultMutableTreeNode each = (DefaultMutableTreeNode)model.getChild(parent, i);
            if (each.getUserObject().equals(object)) {
                return new TreePath(each.getPath());
            }
            TreePath result = MavenArchetypesStep.findNodePath(object, model, each);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static TreeNode groupAndSortArchetypes(Set<MavenArchetype> archetypes) {
        ArrayList<MavenArchetype> list = new ArrayList<MavenArchetype>(archetypes);
        Collections.sort(list, (o1, o2) -> {
            String key2;
            String key1 = o1.groupId + ":" + o1.artifactId;
            int result = key1.compareToIgnoreCase(key2 = o2.groupId + ":" + o2.artifactId);
            if (result != 0) {
                return result;
            }
            return o2.version.compareToIgnoreCase(o1.version);
        });
        TreeMap<String, ArrayList<MavenArchetype>> map = new TreeMap<String, ArrayList<MavenArchetype>>();
        for (MavenArchetype each : list) {
            String key = each.groupId + ":" + each.artifactId;
            ArrayList<MavenArchetype> versions = (ArrayList<MavenArchetype>)map.get(key);
            if (versions == null) {
                versions = new ArrayList<MavenArchetype>();
                map.put(key, versions);
            }
            versions.add(each);
        }
        DefaultMutableTreeNode result = new DefaultMutableTreeNode("root", true);
        for (List each : map.values()) {
            MavenArchetype eachArchetype = (MavenArchetype)each.get(0);
            DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(eachArchetype, true);
            for (MavenArchetype eachVersion : each) {
                DefaultMutableTreeNode versionNode = new DefaultMutableTreeNode(eachVersion, false);
                node2.add(versionNode);
            }
            result.add(node2);
        }
        return result;
    }

    public void requestUpdate() {
        MavenArchetype selectedArch = this.getSelectedArchetype();
        if (selectedArch == null) {
            selectedArch = this.myBuilder.getArchetype();
        }
        if (selectedArch != null) {
            this.myUseArchetypeCheckBox.setSelected(true);
        }
        if (this.myArchetypesTree.getRowCount() == 0) {
            this.updateArchetypesList(selectedArch);
        }
    }

    public void updateArchetypesList(MavenArchetype selected) {
        Object currentUpdaterMarker;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLoadingIcon.setBackground(this.myArchetypesTree.getBackground());
        ((CardLayout)this.myArchetypesPanel.getLayout()).show(this.myArchetypesPanel, "loading");
        this.myCurrentUpdaterMarker = currentUpdaterMarker = new Object();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Set<MavenArchetype> archetypes = MavenIndicesManager.getInstance().getArchetypes();
            SwingUtilities.invokeLater(() -> {
                TreePath path;
                if (currentUpdaterMarker != this.myCurrentUpdaterMarker) {
                    return;
                }
                ((CardLayout)this.myArchetypesPanel.getLayout()).show(this.myArchetypesPanel, "archetypes");
                TreeNode root = MavenArchetypesStep.groupAndSortArchetypes(archetypes);
                DefaultTreeModel model = new DefaultTreeModel(root);
                this.myArchetypesTree.setModel((TreeModel)model);
                if (selected != null && (path = MavenArchetypesStep.findNodePath(selected, model, model.getRoot())) != null) {
                    this.myArchetypesTree.expandPath(path.getParentPath());
                    TreeUtil.selectPath((JTree)this.myArchetypesTree, (TreePath)path, (boolean)true);
                }
                this.updateArchetypeDescription();
            });
        });
    }

    public boolean isSkipUpdateUI() {
        return this.skipUpdateUI;
    }

    private void archetypeMayBeChanged() {
        MavenArchetype selectedArchetype = this.getSelectedArchetype();
        if (this.myBuilder.getArchetype() == null != (selectedArchetype == null)) {
            this.myBuilder.setArchetype(selectedArchetype);
            this.skipUpdateUI = true;
            try {
                if (this.myStep != null) {
                    this.myStep.fireStateChanged();
                }
            }
            finally {
                this.skipUpdateUI = false;
            }
        }
    }

    private void doAddArchetype() {
        MavenAddArchetypeDialog dialog = new MavenAddArchetypeDialog(this.myMainPanel);
        if (!dialog.showAndGet()) {
            return;
        }
        MavenArchetype archetype = dialog.getArchetype();
        MavenIndicesManager.getInstance().addArchetype(archetype);
        this.updateArchetypesList(archetype);
    }

    public void dispose() {
    }

    public JComponent getComponent() {
        return this.getMainPanel();
    }

    public void updateDataModel() {
        MavenArchetype selectedArchetype = this.getSelectedArchetype();
        this.myBuilder.setArchetype(selectedArchetype);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JPanel jPanel;
        JButton jButton;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseArchetypeCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Create from archetype");
        jCheckBox.setMnemonic('A');
        jCheckBox.setDisplayedMnemonicIndex(12);
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAddArchetypeButton = jButton = new JButton();
        jButton.setText("Add Archetype...");
        jButton.setMnemonic('D');
        jButton.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myArchetypesPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 7, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        this.myArchetypeDescriptionScrollPane = jBScrollPane;
        jPanel2.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 3, 0, 3, 7, 0, null, null, null));
        this.myArchetypeDescriptionField = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class MyRenderer
    extends ColoredTreeCellRenderer {
        private MyRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            if (tree == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (!((userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof MavenArchetype)) {
                return;
            }
            MavenArchetype info = (MavenArchetype)userObject;
            if (leaf) {
                this.append(info.artifactId, SimpleTextAttributes.GRAY_ATTRIBUTES);
                this.append(":" + info.version, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                this.append(info.groupId + ":", SimpleTextAttributes.GRAY_ATTRIBUTES);
                this.append(info.artifactId, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/jetbrains/idea/maven/wizards/MavenArchetypesStep$MyRenderer", "customizeCellRenderer"));
        }
    }
}

