/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.rmi.RemoteProcessSupport;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.Attribute;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import javax.swing.event.HyperlinkEvent;
import org.apache.lucene.search.Query;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenEmbedderSettings;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerDownloadListener;
import org.jetbrains.idea.maven.server.MavenServerEmbedder;
import org.jetbrains.idea.maven.server.MavenServerIndexer;
import org.jetbrains.idea.maven.server.MavenServerLogger;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.ProfileApplicationResult;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.slf4j.Logger;
import org.slf4j.impl.Log4jLoggerFactory;

@com.intellij.openapi.components.State(name="MavenVersion", storages={@Storage(value="mavenVersion.xml")})
public class MavenServerManager
extends MavenRemoteObjectWrapper<MavenServer>
implements PersistentStateComponent<State>,
Disposable {
    public static final String BUNDLED_MAVEN_2 = "Bundled (Maven 2)";
    public static final String BUNDLED_MAVEN_3 = "Bundled (Maven 3)";
    @NonNls
    private static final String MAIN_CLASS = "org.jetbrains.idea.maven.server.RemoteMavenServer";
    @NonNls
    private static final String MAIN_CLASS36 = "org.jetbrains.idea.maven.server.RemoteMavenServer36";
    private static final String DEFAULT_VM_OPTIONS = "-Xmx768m";
    private static final String FORCE_MAVEN2_OPTION = "-Didea.force.maven2";
    private final RemoteProcessSupport<Object, MavenServer, Object> mySupport;
    private final RemoteMavenServerLogger myLogger = new RemoteMavenServerLogger();
    private final RemoteMavenServerDownloadListener myDownloadListener = new RemoteMavenServerDownloadListener();
    private boolean myLoggerExported;
    private boolean myDownloadListenerExported;
    private State myState = new State();

    public static MavenServerManager getInstance() {
        return (MavenServerManager)ServiceManager.getService(MavenServerManager.class);
    }

    public MavenServerManager() {
        super(null);
        this.mySupport = new RemoteProcessSupport<Object, MavenServer, Object>(MavenServer.class){

            protected void fireModificationCountChanged() {
            }

            protected String getName(@NotNull Object file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return MavenServerManager.class.getSimpleName();
            }

            protected RunProfileState getRunProfileState(@NotNull Object target, @NotNull Object configuration, @NotNull Executor executor) {
                if (target == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (configuration == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (executor == null) {
                    1.$$$reportNull$$$0(3);
                }
                return new MavenServerCMDState();
            }

            protected void sendDataAfterStart(ProcessHandler handler) {
                if (handler.getProcessInput() == null) {
                    return;
                }
                OutputStreamWriter writer = new OutputStreamWriter(handler.getProcessInput(), StandardCharsets.UTF_8);
                try {
                    writer.write("token=" + MavenRemoteObjectWrapper.ourToken);
                    writer.write(System.lineSeparator());
                    writer.flush();
                }
                catch (IOException e) {
                    MavenLog.LOG.warn("Cannot send token to maven server", (Throwable)e);
                }
            }

            protected void onProcessTerminated(ProcessEvent event) {
                Project[] openProjects;
                if (event.getExitCode() == 0) {
                    return;
                }
                for (Project p : openProjects = ProjectManager.getInstance().getOpenProjects()) {
                    ReadAction.run(() -> {
                        if (p.isDisposed()) {
                            return;
                        }
                        MavenProjectsManager manager = MavenProjectsManager.getInstance(p);
                        if (!manager.isMavenizedProject()) {
                            return;
                        }
                        manager.getSyncConsole().terminated(event.getExitCode());
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "configuration";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getRunProfileState";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public void dispose() {
        this.shutdown(false);
    }

    @Override
    @NotNull
    protected synchronized MavenServer create() throws RemoteException {
        MavenServer mavenServer;
        try {
            MavenServer result = (MavenServer)this.mySupport.acquire((Object)this, (Object)"");
            boolean bl = this.myLoggerExported = this.doWrapAndExport(this.myLogger) != null;
            if (!this.myLoggerExported) {
                throw new RemoteException("Cannot export logger object");
            }
            boolean bl2 = this.myDownloadListenerExported = this.doWrapAndExport(this.myDownloadListener) != null;
            if (!this.myDownloadListenerExported) {
                throw new RemoteException("Cannot export download listener object");
            }
            result.set((MavenServerLogger)this.myLogger, (MavenServerDownloadListener)this.myDownloadListener, ourToken);
            mavenServer = result;
        }
        catch (Exception e) {
            throw new RemoteException("Cannot start maven service", e);
        }
        if (mavenServer == null) {
            MavenServerManager.$$$reportNull$$$0(0);
        }
        return mavenServer;
    }

    public synchronized void shutdown(boolean wait) {
        this.mySupport.stopAll(wait);
        this.cleanup();
    }

    @Override
    protected synchronized void cleanup() {
        super.cleanup();
        if (this.myLoggerExported) {
            try {
                UnicastRemoteObject.unexportObject((Remote)((Object)this.myLogger), true);
            }
            catch (RemoteException e) {
                MavenLog.LOG.error((Throwable)e);
            }
            this.myLoggerExported = false;
        }
        if (this.myDownloadListenerExported) {
            try {
                UnicastRemoteObject.unexportObject((Remote)((Object)this.myDownloadListener), true);
            }
            catch (RemoteException e) {
                MavenLog.LOG.error((Throwable)e);
            }
            this.myDownloadListenerExported = false;
        }
    }

    @NotNull
    private Sdk getJdk() {
        String javaHome;
        if (this.myState.embedderJdk.equals("#JAVA_HOME") && !StringUtil.isEmptyOrSpaces((String)(javaHome = (String)EnvironmentUtil.getEnvironmentMap().get("JAVA_HOME")))) {
            Sdk sdk = JavaSdk.getInstance().createJdk("", javaHome);
            if (sdk == null) {
                MavenServerManager.$$$reportNull$$$0(1);
            }
            return sdk;
        }
        for (Sdk projectJdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!projectJdk.getName().equals(this.myState.embedderJdk)) continue;
            Sdk sdk = projectJdk;
            if (sdk == null) {
                MavenServerManager.$$$reportNull$$$0(2);
            }
            return sdk;
        }
        Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
        if (sdk == null) {
            MavenServerManager.$$$reportNull$$$0(3);
        }
        return sdk;
    }

    public static void verifyMavenSdkRequirements(@NotNull Sdk jdk, String mavenVersion, @NotNull String sdkConfigLocation) {
        if (jdk == null) {
            MavenServerManager.$$$reportNull$$$0(4);
        }
        if (sdkConfigLocation == null) {
            MavenServerManager.$$$reportNull$$$0(5);
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.3.1") >= 0 && StringUtil.compareVersionNumbers((String)version, (String)"1.7") < 0) {
            new Notification("Maven", "", "Maven 3.3.1+ requires JDK 1.7+. Please set appropriate JDK at <br>" + sdkConfigLocation, NotificationType.WARNING).notify(null);
        }
    }

    public static File getMavenEventListener() {
        return BundledMavenPathHolder.eventListenerJar;
    }

    public static File getMavenLibDirectory() {
        return new File(MavenServerManager.getInstance().getCurrentMavenHomeFile(), "lib");
    }

    @Nullable
    public String getMavenVersion(@Nullable String mavenHome) {
        return MavenUtil.getMavenVersion(MavenServerManager.getMavenHomeFile(mavenHome));
    }

    @Nullable
    public String getMavenVersion(@Nullable File mavenHome) {
        return MavenUtil.getMavenVersion(mavenHome);
    }

    @Nullable
    public String getCurrentMavenVersion() {
        return this.getMavenVersion(this.myState.mavenHome);
    }

    public static List<File> collectClassPathAndLibsFolder(@NotNull String mavenVersion, @NotNull File mavenHome) {
        if (mavenVersion == null) {
            MavenServerManager.$$$reportNull$$$0(6);
        }
        if (mavenHome == null) {
            MavenServerManager.$$$reportNull$$$0(7);
        }
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        ArrayList<File> classpath = new ArrayList<File>();
        if (pluginFileOrDir.isDirectory()) {
            MavenServerManager.prepareClassPathForLocalRunAndUnitTests(mavenVersion, classpath, root);
        } else {
            MavenServerManager.prepareClassPathForProduction(mavenVersion, classpath, root);
        }
        MavenServerManager.addMavenLibs(classpath, mavenHome);
        MavenLog.LOG.debug("Collected classpath = ", new Object[]{classpath});
        return classpath;
    }

    private static void prepareClassPathForProduction(@NotNull String mavenVersion, List<File> classpath, String root) {
        if (mavenVersion == null) {
            MavenServerManager.$$$reportNull$$$0(8);
        }
        classpath.add(new File(root, "maven-server-api.jar"));
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3") < 0) {
            classpath.add(new File(root, "maven2-server-impl.jar"));
            MavenServerManager.addDir(classpath, new File(root, "maven2-server-lib"), f -> true);
        } else {
            classpath.add(new File(root, "maven3-server-common.jar"));
            MavenServerManager.addDir(classpath, new File(root, "maven3-server-lib"), f -> true);
            if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.1") < 0) {
                classpath.add(new File(root, "maven30-server-impl.jar"));
            } else {
                classpath.add(new File(root, "maven3-server-impl.jar"));
                if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
                    classpath.add(new File(root, "maven36-server-impl.jar"));
                }
            }
        }
    }

    private static void prepareClassPathForLocalRunAndUnitTests(@NotNull String mavenVersion, List<File> classpath, String root) {
        if (mavenVersion == null) {
            MavenServerManager.$$$reportNull$$$0(9);
        }
        classpath.add(new File(root, "intellij.maven.server"));
        File parentFile = MavenServerManager.getMavenPluginParentFile();
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3") < 0) {
            classpath.add(new File(root, "intellij.maven.server.m2.impl"));
            MavenServerManager.addDir(classpath, new File(parentFile, "maven2-server-impl/lib"), f -> true);
        } else {
            classpath.add(new File(root, "intellij.maven.server.m3.common"));
            MavenServerManager.addDir(classpath, new File(parentFile, "maven3-server-common/lib"), f -> true);
            if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.1") < 0) {
                classpath.add(new File(root, "intellij.maven.server.m30.impl"));
            } else {
                classpath.add(new File(root, "intellij.maven.server.m3.impl"));
                if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
                    classpath.add(new File(root, "intellij.maven.server.m36.impl"));
                }
            }
        }
    }

    private static File getMavenPluginParentFile() {
        File luceneLib = new File(PathUtil.getJarPathForClass(Query.class));
        return luceneLib.getParentFile().getParentFile().getParentFile();
    }

    private static void addMavenLibs(List<File> classpath, File mavenHome) {
        MavenServerManager.addDir(classpath, new File(mavenHome, "lib"), f -> !f.getName().contains("maven-slf4j-provider"));
        File bootFolder = new File(mavenHome, "boot");
        File[] classworldsJars = bootFolder.listFiles((dir, name) -> StringUtil.contains((CharSequence)name, (CharSequence)"classworlds"));
        if (classworldsJars != null) {
            Collections.addAll(classpath, classworldsJars);
        }
    }

    private static void addDir(List<File> classpath, File dir, Predicate<File> filter) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File jar : files) {
            if (!jar.isFile() || !jar.getName().endsWith(".jar") || !filter.test(jar)) continue;
            classpath.add(jar);
        }
    }

    public MavenEmbedderWrapper createEmbedder(final Project project, final boolean alwaysOnline, final @Nullable String workingDirectory, final @Nullable String multiModuleProjectDirectory) {
        return new MavenEmbedderWrapper(this){

            @Override
            @NotNull
            protected MavenServerEmbedder create() throws RemoteException {
                MavenServerSettings settings = MavenServerManager.convertSettings(MavenProjectsManager.getInstance(project).getGeneralSettings());
                if (alwaysOnline && settings.isOffline()) {
                    settings = settings.clone();
                    settings.setOffline(false);
                }
                settings.setProjectJdk(MavenUtil.getSdkPath(ProjectRootManager.getInstance((Project)project).getProjectSdk()));
                MavenServerEmbedder mavenServerEmbedder = ((MavenServer)MavenServerManager.this.getOrCreateWrappee()).createEmbedder(new MavenEmbedderSettings(settings, workingDirectory, multiModuleProjectDirectory), ourToken);
                if (mavenServerEmbedder == null) {
                    2.$$$reportNull$$$0(0);
                }
                return mavenServerEmbedder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager$2", "create"));
            }
        };
    }

    public MavenIndexerWrapper createIndexer() {
        return new MavenIndexerWrapper(this){

            @Override
            @NotNull
            protected MavenServerIndexer create() throws RemoteException {
                MavenServerIndexer mavenServerIndexer = ((MavenServer)MavenServerManager.this.getOrCreateWrappee()).createIndexer(ourToken);
                if (mavenServerIndexer == null) {
                    3.$$$reportNull$$$0(0);
                }
                return mavenServerIndexer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager$3", "create"));
            }
        };
    }

    @NotNull
    public MavenModel interpolateAndAlignModel(MavenModel model, File basedir) {
        MavenModel mavenModel = this.perform(() -> ((MavenServer)this.getOrCreateWrappee()).interpolateAndAlignModel(model, basedir, ourToken));
        if (mavenModel == null) {
            MavenServerManager.$$$reportNull$$$0(10);
        }
        return mavenModel;
    }

    public MavenModel assembleInheritance(MavenModel model, MavenModel parentModel) {
        return this.perform(() -> ((MavenServer)this.getOrCreateWrappee()).assembleInheritance(model, parentModel, ourToken));
    }

    public ProfileApplicationResult applyProfiles(MavenModel model, File basedir, MavenExplicitProfiles explicitProfiles, Collection<String> alwaysOnProfiles) {
        return this.perform(() -> ((MavenServer)this.getOrCreateWrappee()).applyProfiles(model, basedir, explicitProfiles, alwaysOnProfiles, ourToken));
    }

    public void addDownloadListener(MavenServerDownloadListener listener) {
        this.myDownloadListener.myListeners.add(listener);
    }

    public void removeDownloadListener(MavenServerDownloadListener listener) {
        this.myDownloadListener.myListeners.remove(listener);
    }

    public static MavenServerSettings convertSettings(MavenGeneralSettings settings) {
        MavenServerSettings result = new MavenServerSettings();
        result.setLoggingLevel(settings.getOutputLevel().getLevel());
        result.setOffline(settings.isWorkOffline());
        result.setMavenHome(settings.getEffectiveMavenHome());
        result.setUserSettingsFile(settings.getEffectiveUserSettingsIoFile());
        result.setGlobalSettingsFile(settings.getEffectiveGlobalSettingsIoFile());
        result.setLocalRepository(settings.getEffectiveLocalRepository());
        result.setPluginUpdatePolicy(settings.getPluginUpdatePolicy().getServerPolicy());
        result.setSnapshotUpdatePolicy(settings.isAlwaysUpdateSnapshots() ? MavenServerSettings.UpdatePolicy.ALWAYS_UPDATE : MavenServerSettings.UpdatePolicy.DO_NOT_UPDATE);
        return result;
    }

    public boolean isUseMaven2() {
        String version = this.getCurrentMavenVersion();
        return version != null && StringUtil.compareVersionNumbers((String)version, (String)"3") < 0 && StringUtil.compareVersionNumbers((String)version, (String)"2") >= 0;
    }

    @Deprecated
    public void setUseMaven2() {
        String newMavenHome = BUNDLED_MAVEN_2;
        if (!StringUtil.equals((CharSequence)this.myState.mavenHome, (CharSequence)newMavenHome)) {
            this.myState.mavenHome = newMavenHome;
            this.shutdown(false);
        }
    }

    @Nullable
    public static File getMavenHomeFile(@Nullable String mavenHome) {
        if (mavenHome == null) {
            return null;
        }
        if (StringUtil.equals((CharSequence)BUNDLED_MAVEN_2, (CharSequence)mavenHome) && ApplicationManager.getApplication().isUnitTestMode()) {
            return BundledMavenPathHolder.myBundledMaven2Home;
        }
        if (StringUtil.equals((CharSequence)BUNDLED_MAVEN_3, (CharSequence)mavenHome)) {
            return BundledMavenPathHolder.myBundledMaven3Home;
        }
        File home = new File(mavenHome);
        return MavenUtil.isValidMavenHome(home) ? home : null;
    }

    @Nullable
    public File getCurrentMavenHomeFile() {
        return MavenServerManager.getMavenHomeFile(this.myState.mavenHome);
    }

    public void setMavenHome(@NotNull String mavenHome) {
        if (mavenHome == null) {
            MavenServerManager.$$$reportNull$$$0(11);
        }
        if (!StringUtil.equals((CharSequence)this.myState.mavenHome, (CharSequence)mavenHome)) {
            this.myState.mavenHome = mavenHome;
            this.shutdown(false);
        }
    }

    @NotNull
    public String getMavenEmbedderVMOptions() {
        String string = this.myState.vmOptions;
        if (string == null) {
            MavenServerManager.$$$reportNull$$$0(12);
        }
        return string;
    }

    public void setMavenEmbedderVMOptions(@NotNull String mavenEmbedderVMOptions) {
        if (mavenEmbedderVMOptions == null) {
            MavenServerManager.$$$reportNull$$$0(13);
        }
        if (!mavenEmbedderVMOptions.trim().equals(this.myState.vmOptions.trim())) {
            this.myState.vmOptions = mavenEmbedderVMOptions;
            this.shutdown(false);
        }
    }

    @NotNull
    public String getEmbedderJdk() {
        String string = this.myState.embedderJdk;
        if (string == null) {
            MavenServerManager.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void setEmbedderJdk(@NotNull String embedderJdk) {
        if (embedderJdk == null) {
            MavenServerManager.$$$reportNull$$$0(15);
        }
        if (!this.myState.embedderJdk.equals(embedderJdk)) {
            this.myState.embedderJdk = embedderJdk;
            this.shutdown(false);
        }
    }

    @NotNull
    public MavenExecutionOptions.LoggingLevel getLoggingLevel() {
        MavenExecutionOptions.LoggingLevel loggingLevel = this.myState.loggingLevel;
        if (loggingLevel == null) {
            MavenServerManager.$$$reportNull$$$0(16);
        }
        return loggingLevel;
    }

    public void setLoggingLevel(MavenExecutionOptions.LoggingLevel loggingLevel) {
        if (this.myState.loggingLevel != loggingLevel) {
            this.myState.loggingLevel = loggingLevel;
            this.shutdown(false);
        }
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            MavenServerManager.$$$reportNull$$$0(17);
        }
        if (state.vmOptions == null) {
            state.vmOptions = DEFAULT_VM_OPTIONS;
        }
        if (state.embedderJdk == null) {
            state.embedderJdk = "#JAVA_INTERNAL";
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkConfigLocation";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenVersion";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenHome";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenEmbedderVMOptions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedderJdk";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdk";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "interpolateAndAlignModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenEmbedderVMOptions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbedderJdk";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggingLevel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "verifyMavenSdkRequirements";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPathAndLibsFolder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForProduction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForLocalRunAndUnitTests";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setMavenHome";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setMavenEmbedderVMOptions";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setEmbedderJdk";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MavenServerCMDState
    extends CommandLineState {
        public MavenServerCMDState() {
            super(null);
        }

        SimpleJavaParameters createJavaParameters() {
            String mavenEmbedderCliOptions;
            String mavenEmbedderParameters;
            String mavenVersion;
            File mavenHome;
            File currentMavenHomeFile;
            boolean bl;
            SimpleJavaParameters params = new SimpleJavaParameters();
            Sdk jdk = MavenServerManager.this.getJdk();
            params.setJdk(jdk);
            params.setWorkingDirectory(PathManager.getBinPath());
            THashMap defs = new THashMap();
            defs.putAll(MavenUtil.getPropertiesFromMavenOpts());
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                Object key = entry.getKey();
                Iterator value = entry.getValue();
                if (!(key instanceof String) || !(value instanceof String) || !((String)key).startsWith("javax.net.ssl")) continue;
                defs.put((String)key, (String)((Object)value));
            }
            defs.put("java.awt.headless", "true");
            for (Map.Entry<Object, Object> entry : defs.entrySet()) {
                params.getVMParametersList().defineProperty((String)entry.getKey(), (String)entry.getValue());
            }
            params.getVMParametersList().addProperty("maven.defaultProjectBuilder.disableGlobalModelCache", "true");
            boolean xmxSet = false;
            boolean bl2 = false;
            if (((MavenServerManager)MavenServerManager.this).myState.vmOptions != null) {
                ParametersList mavenOptsList = new ParametersList();
                mavenOptsList.addParametersString(((MavenServerManager)MavenServerManager.this).myState.vmOptions);
                for (String param : mavenOptsList.getParameters()) {
                    if (param.startsWith("-Xmx")) {
                        xmxSet = true;
                    }
                    if (param.equals(MavenServerManager.FORCE_MAVEN2_OPTION)) {
                        MavenLog.LOG.warn("Forced maven 2 option");
                        bl = true;
                    }
                    params.getVMParametersList().add(param);
                }
            }
            File file = currentMavenHomeFile = bl ? BundledMavenPathHolder.myBundledMaven2Home : MavenServerManager.this.getCurrentMavenHomeFile();
            if (currentMavenHomeFile == null) {
                MavenLog.LOG.warn("Not found maven at " + ((MavenServerManager)MavenServerManager.this).myState.mavenHome);
                mavenHome = BundledMavenPathHolder.myBundledMaven3Home;
                mavenVersion = MavenServerManager.this.getMavenVersion(mavenHome);
                this.showInvalidMavenNotification(mavenVersion);
            } else {
                mavenHome = currentMavenHomeFile;
                mavenVersion = MavenServerManager.this.getMavenVersion(mavenHome);
            }
            MavenLog.LOG.debug("", new Object[]{currentMavenHomeFile, "with version ", mavenVersion, " chosen as maven home"});
            assert (mavenVersion != null);
            if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
                params.setMainClass(MavenServerManager.MAIN_CLASS36);
            } else {
                params.setMainClass(MavenServerManager.MAIN_CLASS);
            }
            params.getVMParametersList().addProperty("idea.maven.embedder.version", mavenVersion);
            String sdkConfigLocation = "Settings | Build, Execution, Deployment | Build Tools | Maven | Importing | JDK for Importer";
            MavenServerManager.verifyMavenSdkRequirements(jdk, mavenVersion, sdkConfigLocation);
            ArrayList<String> classPath = new ArrayList<String>();
            classPath.add(PathUtil.getJarPathForClass(org.apache.log4j.Logger.class));
            if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.1") < 0) {
                classPath.add(PathUtil.getJarPathForClass(Logger.class));
                classPath.add(PathUtil.getJarPathForClass(Log4jLoggerFactory.class));
            }
            classPath.add(PathUtil.getJarPathForClass(StringUtilRt.class));
            classPath.add(PathUtil.getJarPathForClass(NotNull.class));
            classPath.add(PathUtil.getJarPathForClass(Element.class));
            classPath.add(PathUtil.getJarPathForClass(TIntHashSet.class));
            ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(Query.class));
            params.getClassPath().add(PathManager.getResourceRoot(((Object)((Object)this)).getClass(), (String)"/messages/CommonBundle.properties"));
            params.getClassPath().addAll(classPath);
            params.getClassPath().addAllFiles(MavenServerManager.collectClassPathAndLibsFolder(mavenVersion, mavenHome));
            String embedderXmx = System.getProperty("idea.maven.embedder.xmx");
            if (embedderXmx != null) {
                params.getVMParametersList().add("-Xmx" + embedderXmx);
            } else if (!xmxSet) {
                params.getVMParametersList().add(MavenServerManager.DEFAULT_VM_OPTIONS);
            }
            String mavenEmbedderDebugPort = System.getProperty("idea.maven.embedder.debug.port");
            if (mavenEmbedderDebugPort != null) {
                params.getVMParametersList().addParametersString("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + mavenEmbedderDebugPort);
            }
            if ((mavenEmbedderParameters = System.getProperty("idea.maven.embedder.parameters")) != null) {
                params.getProgramParametersList().addParametersString(mavenEmbedderParameters);
            }
            if ((mavenEmbedderCliOptions = System.getProperty("idea.maven.embedder.ext.cli.args")) != null) {
                params.getVMParametersList().addProperty("idea.maven.embedder.ext.cli.args", mavenEmbedderCliOptions);
            }
            MavenUtil.addEventListener(mavenVersion, params);
            return params;
        }

        @NotNull
        public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            if (executor == null) {
                MavenServerCMDState.$$$reportNull$$$0(0);
            }
            if (runner == null) {
                MavenServerCMDState.$$$reportNull$$$0(1);
            }
            OSProcessHandler processHandler = this.startProcess();
            DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ProcessHandler)processHandler);
            if (defaultExecutionResult == null) {
                MavenServerCMDState.$$$reportNull$$$0(2);
            }
            return defaultExecutionResult;
        }

        @NotNull
        protected OSProcessHandler startProcess() throws ExecutionException {
            SimpleJavaParameters params = this.createJavaParameters();
            GeneralCommandLine commandLine = params.toCommandLine();
            OSProcessHandler processHandler = new OSProcessHandler(commandLine){

                @NotNull
                protected BaseOutputReader.Options readerOptions() {
                    BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                    if (options == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return options;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/MavenServerManager$MavenServerCMDState$1", "readerOptions"));
                }
            };
            processHandler.setShouldDestroyProcessRecursively(false);
            OSProcessHandler oSProcessHandler = processHandler;
            if (oSProcessHandler == null) {
                MavenServerCMDState.$$$reportNull$$$0(3);
            }
            return oSProcessHandler;
        }

        private void showInvalidMavenNotification(@Nullable String mavenVersion) {
            Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
            final Project project = openProjects.length == 1 ? openProjects[0] : null;
            String message = this.messageToShow(((MavenServerManager)MavenServerManager.this).myState.mavenHome, mavenVersion, project);
            NotificationListener listener = project == null ? null : new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, "Maven");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/idea/maven/server/MavenServerManager$MavenServerCMDState$2";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            new Notification("Maven", "", message, NotificationType.WARNING, listener).notify(null);
        }

        private String messageToShow(String mavenHome, String mavenVersion, Project project) {
            if (StringUtil.equals((CharSequence)MavenServerManager.BUNDLED_MAVEN_2, (CharSequence)mavenHome)) {
                if (project == null) {
                    return RunnerBundle.message("bundled.maven.maven2.not.supported", new Object[0]);
                }
                return RunnerBundle.message("bundled.maven.maven2.not.supported.with.fix", new Object[0]);
            }
            if (project == null) {
                return RunnerBundle.message("external.maven.home.invalid.substitution.warning", ((MavenServerManager)MavenServerManager.this).myState.mavenHome, mavenVersion);
            }
            return RunnerBundle.message("external.maven.home.invalid.substitution.warning.with.fix", ((MavenServerManager)MavenServerManager.this).myState.mavenHome, mavenVersion);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerManager$MavenServerCMDState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerManager$MavenServerCMDState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "execute";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startProcess";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RemoteMavenServerDownloadListener
    extends MavenRemoteObject
    implements MavenServerDownloadListener {
        private final List<MavenServerDownloadListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        private RemoteMavenServerDownloadListener() {
        }

        public void artifactDownloaded(File file, String relativePath) throws RemoteException {
            for (MavenServerDownloadListener each : this.myListeners) {
                each.artifactDownloaded(file, relativePath);
            }
        }
    }

    private static class RemoteMavenServerLogger
    extends MavenRemoteObject
    implements MavenServerLogger {
        private RemoteMavenServerLogger() {
        }

        public void info(Throwable e) {
            MavenLog.LOG.info(e);
        }

        public void warn(Throwable e) {
            MavenLog.LOG.warn(e);
        }

        public void error(Throwable e) {
            MavenLog.LOG.error(e);
        }

        public void print(String s) {
            System.out.println(s);
        }
    }

    private static class UseMavenConverter
    extends Converter<Boolean> {
        private UseMavenConverter() {
        }

        @Nullable
        public Boolean fromString(@NotNull String value) {
            if (value == null) {
                UseMavenConverter.$$$reportNull$$$0(0);
            }
            return "2.x".equals(value);
        }

        @NotNull
        public String toString(@NotNull Boolean value) {
            if (value == null) {
                UseMavenConverter.$$$reportNull$$$0(1);
            }
            String string = value != false ? "2.x" : "3.x";
            if (string == null) {
                UseMavenConverter.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerManager$UseMavenConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerManager$UseMavenConverter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class State {
        @Deprecated
        @Attribute(value="version", converter=UseMavenConverter.class)
        public boolean useMaven2;
        @Attribute
        public String vmOptions = "-Xmx768m";
        @Attribute
        public String embedderJdk = "#JAVA_INTERNAL";
        @Attribute
        public String mavenHome = "Bundled (Maven 3)";
        @Attribute
        public MavenExecutionOptions.LoggingLevel loggingLevel = MavenExecutionOptions.LoggingLevel.INFO;

        State() {
        }
    }

    private static class BundledMavenPathHolder {
        private static final File myBundledMaven2Home;
        private static final File myBundledMaven3Home;
        private static final File eventListenerJar;

        private BundledMavenPathHolder() {
        }

        private static File getEventSpyPathForLocalBuild() {
            File root = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
            return new File(root.getParent(), "intellij.maven.server.eventListener");
        }

        static {
            File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
            String root = pluginFileOrDir.getParent();
            if (pluginFileOrDir.isDirectory()) {
                File parentFile = MavenServerManager.getMavenPluginParentFile();
                myBundledMaven2Home = new File(parentFile, "maven2-server-impl/lib/maven2");
                myBundledMaven3Home = new File(parentFile, "maven36-server-impl/lib/maven3");
                eventListenerJar = BundledMavenPathHolder.getEventSpyPathForLocalBuild();
            } else {
                myBundledMaven2Home = new File(root, "maven2");
                myBundledMaven3Home = new File(root, "maven3");
                eventListenerJar = new File(root, "maven-event-listener.jar");
            }
            if (!myBundledMaven3Home.exists()) {
                if (ApplicationManager.getApplication().isInternal()) {
                    MavenLog.LOG.error("Cannot find bundled maven " + myBundledMaven3Home + " please run setupBundledMaven.gradle script");
                } else {
                    MavenLog.LOG.error("Cannot find bundled maven " + myBundledMaven3Home);
                }
            }
            if (!eventListenerJar.exists()) {
                MavenLog.LOG.error("Event listener does not exist " + eventListenerJar);
            }
        }
    }
}

