/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.io.PathKt;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.references.MavenFilteredPropertyPsiReferenceProvider;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.project.MavenArtifactDownloader;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectReader;
import org.jetbrains.idea.maven.project.MavenProjectReaderProjectLocator;
import org.jetbrains.idea.maven.project.MavenProjectReaderResult;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenConfigParseException;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Strings;

public class MavenProjectsTree {
    private static final Logger LOG = Logger.getInstance(MavenProjectsTree.class);
    private static final String STORAGE_VERSION = MavenProjectsTree.class.getSimpleName() + ".7";
    private final Object myStateLock = new Object();
    private final ReentrantReadWriteLock myStructureLock = new ReentrantReadWriteLock();
    private final Lock myStructureReadLock = this.myStructureLock.readLock();
    private final Lock myStructureWriteLock = this.myStructureLock.writeLock();
    private volatile Set<String> myManagedFilesPaths = new LinkedHashSet<String>();
    private volatile List<String> myIgnoredFilesPaths = new ArrayList<String>();
    private volatile List<String> myIgnoredFilesPatterns = new ArrayList<String>();
    private volatile Pattern myIgnoredFilesPatternsCache;
    private MavenExplicitProfiles myExplicitProfiles = MavenExplicitProfiles.NONE;
    private final MavenExplicitProfiles myTemporarilyRemovedExplicitProfiles = new MavenExplicitProfiles(new HashSet(), new HashSet());
    private final List<MavenProject> myRootProjects = new ArrayList<MavenProject>();
    private final Map<MavenProject, MavenProjectTimestamp> myTimestamps = new HashMap<MavenProject, MavenProjectTimestamp>();
    private final MavenWorkspaceMap myWorkspaceMap = new MavenWorkspaceMap();
    private final Map<MavenId, MavenProject> myMavenIdToProjectMapping = new HashMap<MavenId, MavenProject>();
    private final Map<VirtualFile, MavenProject> myVirtualFileToProjectMapping = new HashMap<VirtualFile, MavenProject>();
    private final Map<MavenProject, List<MavenProject>> myAggregatorToModuleMapping = new HashMap<MavenProject, List<MavenProject>>();
    private final Map<MavenProject, MavenProject> myModuleToAggregatorMapping = new HashMap<MavenProject, MavenProject>();
    private final List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Project myProject;
    private final MavenProjectReaderProjectLocator myProjectLocator = new MavenProjectReaderProjectLocator(){

        @Override
        public VirtualFile findProjectFile(MavenId coordinates) {
            MavenProject project = MavenProjectsTree.this.findProject(coordinates);
            return project == null ? null : project.getFile();
        }
    };

    public MavenProjectsTree(Project project) {
        this.myProject = project;
    }

    @Nullable
    public static MavenProjectsTree read(Project project, Path file) throws IOException {
        MavenProjectsTree result = new MavenProjectsTree(project);
        Throwable throwable = null;
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(PathKt.inputStream((Path)file)));){
            if (!STORAGE_VERSION.equals(in.readUTF())) {
                MavenProjectsTree mavenProjectsTree = null;
                return mavenProjectsTree;
            }
            try {
                result.myManagedFilesPaths = MavenProjectsTree.readCollection(in, new LinkedHashSet());
                result.myIgnoredFilesPaths = MavenProjectsTree.readCollection(in, new ArrayList());
                result.myIgnoredFilesPatterns = MavenProjectsTree.readCollection(in, new ArrayList());
                result.myExplicitProfiles = new MavenExplicitProfiles((Collection)MavenProjectsTree.readCollection(in, new THashSet()), (Collection)MavenProjectsTree.readCollection(in, new THashSet()));
                result.myRootProjects.addAll(MavenProjectsTree.readProjectsRecursively(in, result));
            }
            catch (IOException e) {
                in.close();
                PathKt.delete((Path)file);
                throw e;
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    private static <T extends Collection<String>> T readCollection(DataInputStream in, T result) throws IOException {
        int count = in.readInt();
        while (count-- > 0) {
            result.add((String)in.readUTF());
        }
        return result;
    }

    private static void writeCollection(DataOutputStream out, Collection<String> list) throws IOException {
        out.writeInt(list.size());
        for (String each : list) {
            out.writeUTF(each);
        }
    }

    private static List<MavenProject> readProjectsRecursively(DataInputStream in, MavenProjectsTree tree) throws IOException {
        int count = in.readInt();
        ArrayList<MavenProject> result = new ArrayList<MavenProject>(count);
        while (count-- > 0) {
            MavenProject project = MavenProject.read(in);
            MavenProjectTimestamp timestamp = MavenProjectTimestamp.read(in);
            List<MavenProject> modules = MavenProjectsTree.readProjectsRecursively(in, tree);
            if (project == null) continue;
            result.add(project);
            tree.myTimestamps.put(project, timestamp);
            tree.myVirtualFileToProjectMapping.put(project.getFile(), project);
            tree.fillIDMaps(project);
            tree.myAggregatorToModuleMapping.put(project, modules);
            for (MavenProject eachModule : modules) {
                tree.myModuleToAggregatorMapping.put(eachModule, project);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(@NotNull Path file) throws IOException {
        if (file == null) {
            MavenProjectsTree.$$$reportNull$$$0(0);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            this.readLock();
            try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(PathKt.outputStream((Path)file)));){
                out.writeUTF(STORAGE_VERSION);
                MavenProjectsTree.writeCollection(out, this.myManagedFilesPaths);
                MavenProjectsTree.writeCollection(out, this.myIgnoredFilesPaths);
                MavenProjectsTree.writeCollection(out, this.myIgnoredFilesPatterns);
                MavenProjectsTree.writeCollection(out, this.myExplicitProfiles.getEnabledProfiles());
                MavenProjectsTree.writeCollection(out, this.myExplicitProfiles.getDisabledProfiles());
                this.writeProjectsRecursively(out, this.myRootProjects);
            }
            finally {
                this.readUnlock();
            }
        }
    }

    private void writeProjectsRecursively(DataOutputStream out, List<MavenProject> list) throws IOException {
        out.writeInt(list.size());
        for (MavenProject each : list) {
            each.write(out);
            this.myTimestamps.get(each).write(out);
            this.writeProjectsRecursively(out, this.getModules(each));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getManagedFilesPaths() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myManagedFilesPaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetManagedFilesPathsAndProfiles(List<String> paths, MavenExplicitProfiles profiles) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myManagedFilesPaths = new LinkedHashSet<String>(paths);
        }
        this.setExplicitProfiles(profiles);
    }

    public void resetManagedFilesAndProfiles(List<VirtualFile> files, MavenExplicitProfiles profiles) {
        this.resetManagedFilesPathsAndProfiles(MavenUtil.collectPaths(files), profiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagedFilesWithProfiles(List<VirtualFile> files, MavenExplicitProfiles profiles) {
        MavenExplicitProfiles newProfiles;
        ArrayList<String> newFiles;
        Object object = this.myStateLock;
        synchronized (object) {
            newFiles = new ArrayList<String>(this.myManagedFilesPaths);
            newFiles.addAll(MavenUtil.collectPaths(files));
            newProfiles = this.myExplicitProfiles.clone();
            newProfiles.getEnabledProfiles().addAll(profiles.getEnabledProfiles());
            newProfiles.getDisabledProfiles().addAll(profiles.getDisabledProfiles());
        }
        this.resetManagedFilesPathsAndProfiles(newFiles, newProfiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagedFiles(List<VirtualFile> files) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myManagedFilesPaths.removeAll(MavenUtil.collectPaths(files));
        }
    }

    public List<VirtualFile> getExistingManagedFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (String path : this.getManagedFilesPaths()) {
            VirtualFile f = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            if (f == null) continue;
            result.add(f);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIgnoredFilesPaths() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myIgnoredFilesPaths);
        }
    }

    public void setIgnoredFilesPaths(List<String> paths) {
        this.doChangeIgnoreStatus(() -> {
            this.myIgnoredFilesPaths = new ArrayList<String>(paths);
        });
    }

    public void removeIgnoredFilesPaths(Collection<String> paths) {
        this.doChangeIgnoreStatus(() -> this.myIgnoredFilesPaths.removeAll(paths));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIgnoredState(MavenProject project) {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myIgnoredFilesPaths.contains(project.getPath());
        }
    }

    public void setIgnoredState(List<MavenProject> projects, boolean ignored) {
        this.setIgnoredState(projects, ignored, false);
    }

    public void setIgnoredState(List<MavenProject> projects, boolean ignored, boolean fromImport) {
        this.doSetIgnoredState(projects, ignored, fromImport);
    }

    private void doSetIgnoredState(List<MavenProject> projects, boolean ignored, boolean fromImport) {
        List<String> paths = MavenUtil.collectPaths(MavenUtil.collectFiles(projects));
        this.doChangeIgnoreStatus(() -> {
            if (ignored) {
                this.myIgnoredFilesPaths.addAll(paths);
            } else {
                this.myIgnoredFilesPaths.removeAll(paths);
            }
        }, fromImport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getIgnoredFilesPatterns() {
        Object object = this.myStateLock;
        synchronized (object) {
            return new ArrayList<String>(this.myIgnoredFilesPatterns);
        }
    }

    public void setIgnoredFilesPatterns(List<String> patterns) {
        this.doChangeIgnoreStatus(() -> {
            this.myIgnoredFilesPatternsCache = null;
            this.myIgnoredFilesPatterns = new ArrayList<String>(patterns);
        });
    }

    private void doChangeIgnoreStatus(Runnable runnable) {
        this.doChangeIgnoreStatus(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChangeIgnoreStatus(Runnable runnable, boolean fromImport) {
        List<MavenProject> ignoredAfter;
        List<MavenProject> ignoredBefore;
        Object object = this.myStateLock;
        synchronized (object) {
            ignoredBefore = this.getIgnoredProjects();
            runnable.run();
            ignoredAfter = this.getIgnoredProjects();
        }
        ArrayList<MavenProject> ignored = new ArrayList<MavenProject>(ignoredAfter);
        ignored.removeAll(ignoredBefore);
        ArrayList<MavenProject> unignored = new ArrayList<MavenProject>(ignoredBefore);
        unignored.removeAll(ignoredAfter);
        if (ignored.isEmpty() && unignored.isEmpty()) {
            return;
        }
        this.fireProjectsIgnoredStateChanged(ignored, unignored, fromImport);
    }

    private List<MavenProject> getIgnoredProjects() {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject each : this.getProjects()) {
            if (!this.isIgnored(each)) continue;
            result.add(each);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIgnored(MavenProject project) {
        String path = project.getPath();
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myIgnoredFilesPaths.contains(path) || this.matchesIgnoredFilesPatterns(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesIgnoredFilesPatterns(String path) {
        Object object = this.myStateLock;
        synchronized (object) {
            if (this.myIgnoredFilesPatternsCache == null) {
                this.myIgnoredFilesPatternsCache = Pattern.compile(Strings.translateMasks(this.myIgnoredFilesPatterns));
            }
            return this.myIgnoredFilesPatternsCache.matcher(path).matches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenExplicitProfiles getExplicitProfiles() {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myExplicitProfiles.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplicitProfiles(MavenExplicitProfiles explicitProfiles) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.myExplicitProfiles = explicitProfiles.clone();
        }
        this.fireProfilesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExplicitProfiles() {
        Collection<String> available = this.getAvailableProfiles();
        Object object = this.myStateLock;
        synchronized (object) {
            MavenProjectsTree.updateExplicitProfiles(this.myExplicitProfiles.getEnabledProfiles(), this.myTemporarilyRemovedExplicitProfiles.getEnabledProfiles(), available);
            MavenProjectsTree.updateExplicitProfiles(this.myExplicitProfiles.getDisabledProfiles(), this.myTemporarilyRemovedExplicitProfiles.getDisabledProfiles(), available);
        }
    }

    private static void updateExplicitProfiles(Collection<String> explicitProfiles, Collection<String> temporarilyRemovedExplicitProfiles, Collection<String> available) {
        THashSet removedProfiles = new THashSet(explicitProfiles);
        removedProfiles.removeAll(available);
        temporarilyRemovedExplicitProfiles.addAll((Collection<String>)removedProfiles);
        THashSet restoredProfiles = new THashSet(temporarilyRemovedExplicitProfiles);
        restoredProfiles.retainAll(available);
        temporarilyRemovedExplicitProfiles.removeAll((Collection<?>)restoredProfiles);
        explicitProfiles.removeAll((Collection<?>)removedProfiles);
        explicitProfiles.addAll((Collection<String>)restoredProfiles);
    }

    public Collection<String> getAvailableProfiles() {
        THashSet res = new THashSet();
        for (MavenProject each : this.getProjects()) {
            res.addAll(each.getProfilesIds());
        }
        return res;
    }

    public Collection<Pair<String, MavenProfileKind>> getProfilesWithStates() {
        ArrayListSet result = new ArrayListSet();
        THashSet available = new THashSet();
        THashSet active = new THashSet();
        for (MavenProject each : this.getProjects()) {
            available.addAll(each.getProfilesIds());
            active.addAll(each.getActivatedProfilesIds().getEnabledProfiles());
        }
        Collection enabledProfiles = this.getExplicitProfiles().getEnabledProfiles();
        Collection disabledProfiles = this.getExplicitProfiles().getDisabledProfiles();
        for (String each : available) {
            MavenProfileKind state = disabledProfiles.contains(each) ? MavenProfileKind.NONE : (enabledProfiles.contains(each) ? MavenProfileKind.EXPLICIT : (active.contains(each) ? MavenProfileKind.IMPLICIT : MavenProfileKind.NONE));
            result.add(Pair.create((Object)each, (Object)state));
        }
        return result;
    }

    public void updateAll(boolean force, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        List<VirtualFile> managedFiles = this.getExistingManagedFiles();
        MavenExplicitProfiles explicitProfiles = this.getExplicitProfiles();
        MavenProjectReader projectReader = new MavenProjectReader(this.myProject);
        this.update(managedFiles, true, force, explicitProfiles, projectReader, generalSettings, process2);
        List<VirtualFile> obsoleteFiles = this.getRootProjectsFiles();
        obsoleteFiles.removeAll(managedFiles);
        this.delete(projectReader, obsoleteFiles, explicitProfiles, generalSettings, process2);
    }

    public void update(Collection<VirtualFile> files, boolean force, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        this.update(files, false, force, this.getExplicitProfiles(), new MavenProjectReader(this.myProject), generalSettings, process2);
    }

    private void update(Collection<VirtualFile> files, boolean recursive, boolean force, MavenExplicitProfiles explicitProfiles, MavenProjectReader projectReader, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        if (files.isEmpty()) {
            return;
        }
        UpdateContext updateContext = new UpdateContext();
        Stack updateStack = new Stack();
        for (VirtualFile each : files) {
            MavenProject mavenProject = this.findProject(each);
            if (mavenProject == null) {
                this.doAdd(each, recursive, explicitProfiles, updateContext, (Stack<MavenProject>)updateStack, projectReader, generalSettings, process2);
                continue;
            }
            this.doUpdate(mavenProject, this.findAggregator(mavenProject), false, recursive, force, explicitProfiles, updateContext, (Stack<MavenProject>)updateStack, projectReader, generalSettings, process2);
        }
        this.updateExplicitProfiles();
        updateContext.fireUpdatedIfNecessary();
    }

    private void doAdd(VirtualFile f, boolean recursuve, MavenExplicitProfiles explicitProfiles, UpdateContext updateContext, Stack<MavenProject> updateStack, MavenProjectReader reader, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        MavenProject newMavenProject = new MavenProject(f);
        MavenProject intendedAggregator = null;
        for (MavenProject each : this.getProjects()) {
            if (!each.getExistingModuleFiles().contains(f)) continue;
            intendedAggregator = each;
            break;
        }
        this.doUpdate(newMavenProject, intendedAggregator, true, recursuve, false, explicitProfiles, updateContext, updateStack, reader, generalSettings, process2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(MavenProject mavenProject, MavenProject aggregator, boolean isNew, boolean recursive, boolean force, MavenExplicitProfiles explicitProfiles, UpdateContext updateContext, Stack<MavenProject> updateStack, MavenProjectReader reader, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        MavenProjectChanges changes;
        if (updateStack.contains((Object)mavenProject)) {
            MavenLog.LOG.info("Recursion detected in " + mavenProject.getFile());
            return;
        }
        updateStack.push((Object)mavenProject);
        process2.setText(ProjectBundle.message("maven.reading.pom", mavenProject.getPath()));
        process2.setText2("");
        List<MavenProject> prevModules = this.getModules(mavenProject);
        HashSet<MavenProject> prevInheritors = new HashSet<MavenProject>();
        if (!isNew) {
            prevInheritors.addAll(this.findInheritors(mavenProject));
        }
        MavenProjectTimestamp timestamp = this.calculateTimestamp(mavenProject, explicitProfiles, generalSettings);
        boolean isChanged = force || !timestamp.equals(this.myTimestamps.get(mavenProject));
        MavenProjectChanges mavenProjectChanges = changes = force ? MavenProjectChanges.ALL : MavenProjectChanges.NONE;
        if (isChanged) {
            this.writeLock();
            try {
                if (!isNew) {
                    this.clearIDMaps(mavenProject);
                }
            }
            finally {
                this.writeUnlock();
            }
            MavenId oldParentId = mavenProject.getParentId();
            changes = changes.mergedWith(mavenProject.read(generalSettings, explicitProfiles, reader, this.myProjectLocator));
            this.writeLock();
            try {
                this.myVirtualFileToProjectMapping.put(mavenProject.getFile(), mavenProject);
                this.fillIDMaps(mavenProject);
            }
            finally {
                this.writeUnlock();
            }
            if (!Comparing.equal((Object)oldParentId, (Object)mavenProject.getParentId())) {
                timestamp = this.calculateTimestamp(mavenProject, explicitProfiles, generalSettings);
            }
            this.myTimestamps.put(mavenProject, timestamp);
        }
        boolean reconnected = isNew;
        if (isNew) {
            this.connect(aggregator, mavenProject);
        } else {
            reconnected = this.reconnect(aggregator, mavenProject);
        }
        if (isChanged || reconnected) {
            updateContext.update(mavenProject, changes);
        }
        List<VirtualFile> existingModuleFiles = mavenProject.getExistingModuleFiles();
        ArrayList<MavenProject> modulesToRemove = new ArrayList<MavenProject>();
        ArrayList<MavenProject> modulesToBecomeRoots = new ArrayList<MavenProject>();
        for (MavenProject mavenProject2 : prevModules) {
            VirtualFile moduleFile = mavenProject2.getFile();
            if (existingModuleFiles.contains(moduleFile)) continue;
            if (this.isManagedFile(moduleFile)) {
                modulesToBecomeRoots.add(mavenProject2);
                continue;
            }
            modulesToRemove.add(mavenProject2);
        }
        for (MavenProject mavenProject3 : modulesToRemove) {
            this.removeModule(mavenProject, mavenProject3);
            this.doDelete(mavenProject, mavenProject3, updateContext);
            prevInheritors.removeAll(updateContext.deletedProjects);
        }
        for (MavenProject mavenProject4 : modulesToBecomeRoots) {
            if (!this.reconnect(null, mavenProject4)) continue;
            updateContext.update(mavenProject4, MavenProjectChanges.NONE);
        }
        for (VirtualFile virtualFile : existingModuleFiles) {
            boolean isNewModule;
            MavenProject module = this.findProject(virtualFile);
            boolean bl = isNewModule = module == null;
            if (isNewModule) {
                module = new MavenProject(virtualFile);
            } else {
                MavenProject currentAggregator = this.findAggregator(module);
                if (currentAggregator != null && currentAggregator != mavenProject) {
                    MavenLog.LOG.info("Module " + virtualFile + " is already included into " + mavenProject.getFile());
                    continue;
                }
            }
            if (isChanged || isNewModule || recursive) {
                this.doUpdate(module, mavenProject, isNewModule, recursive, recursive && force, explicitProfiles, updateContext, updateStack, reader, generalSettings, process2);
                continue;
            }
            if (!this.reconnect(mavenProject, module)) continue;
            updateContext.update(module, MavenProjectChanges.NONE);
        }
        prevInheritors.addAll(this.findInheritors(mavenProject));
        for (MavenProject mavenProject5 : prevInheritors) {
            this.doUpdate(mavenProject5, this.findAggregator(mavenProject5), false, false, false, explicitProfiles, updateContext, updateStack, reader, generalSettings, process2);
        }
        updateStack.pop();
    }

    private MavenProjectTimestamp calculateTimestamp(MavenProject mavenProject, MavenExplicitProfiles explicitProfiles, MavenGeneralSettings generalSettings) {
        return (MavenProjectTimestamp)ReadAction.compute(() -> {
            long pomTimestamp = MavenProjectsTree.getFileTimestamp(mavenProject.getFile());
            MavenProject parent = this.findParent(mavenProject);
            long parentLastReadStamp = parent == null ? -1L : parent.getLastReadStamp();
            VirtualFile profilesXmlFile = mavenProject.getProfilesXmlFile();
            long profilesTimestamp = MavenProjectsTree.getFileTimestamp(profilesXmlFile);
            VirtualFile jvmConfigFile = MavenUtil.getConfigFile(mavenProject, "/.mvn/jvm.config");
            long jvmConfigTimestamp = MavenProjectsTree.getFileTimestamp(jvmConfigFile);
            VirtualFile mavenConfigFile = MavenUtil.getConfigFile(mavenProject, "/.mvn/maven.config");
            long mavenConfigTimestamp = MavenProjectsTree.getFileTimestamp(mavenConfigFile);
            long userSettingsTimestamp = MavenProjectsTree.getFileTimestamp(generalSettings.getEffectiveUserSettingsFile());
            long globalSettingsTimestamp = MavenProjectsTree.getFileTimestamp(generalSettings.getEffectiveGlobalSettingsFile());
            int profilesHashCode = explicitProfiles.hashCode();
            return new MavenProjectTimestamp(pomTimestamp, parentLastReadStamp, profilesTimestamp, userSettingsTimestamp, globalSettingsTimestamp, profilesHashCode, jvmConfigTimestamp, mavenConfigTimestamp);
        });
    }

    public String toString() {
        return "MavenProjectsTree{myRootProjects=" + this.myRootProjects + ", myProject=" + this.myProject + '}';
    }

    private static long getFileTimestamp(VirtualFile file) {
        if (file == null || !file.isValid()) {
            return -1L;
        }
        return file.getTimeStamp();
    }

    public boolean isManagedFile(VirtualFile moduleFile) {
        return this.isManagedFile(moduleFile.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isManagedFile(String path) {
        Object object = this.myStateLock;
        synchronized (object) {
            for (String each : this.myManagedFilesPaths) {
                if (!FileUtil.pathsEqual((String)each, (String)path)) continue;
                return true;
            }
            return false;
        }
    }

    public boolean isPotentialProject(String path) {
        if (this.isManagedFile(path)) {
            return true;
        }
        for (MavenProject each : this.getProjects()) {
            if (FileUtil.pathsEqual((String)path, (String)each.getPath())) {
                return true;
            }
            if (!each.getModulePaths().contains(path)) continue;
            return true;
        }
        return false;
    }

    public void delete(List<VirtualFile> files, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        this.delete(new MavenProjectReader(this.myProject), files, this.getExplicitProfiles(), generalSettings, process2);
    }

    private void delete(MavenProjectReader projectReader, List<VirtualFile> files, MavenExplicitProfiles explicitProfiles, MavenGeneralSettings generalSettings, MavenProgressIndicator process2) {
        if (files.isEmpty()) {
            return;
        }
        UpdateContext updateContext = new UpdateContext();
        Stack updateStack = new Stack();
        THashSet inheritorsToUpdate = new THashSet();
        for (Object each : files) {
            MavenProject mavenProject = this.findProject((VirtualFile)each);
            if (mavenProject == null) {
                return;
            }
            inheritorsToUpdate.addAll(this.findInheritors(mavenProject));
            this.doDelete(this.findAggregator(mavenProject), mavenProject, updateContext);
        }
        inheritorsToUpdate.removeAll(updateContext.deletedProjects);
        for (Object each : inheritorsToUpdate) {
            this.doUpdate((MavenProject)each, null, false, false, false, explicitProfiles, updateContext, (Stack<MavenProject>)updateStack, projectReader, generalSettings, process2);
        }
        this.updateExplicitProfiles();
        updateContext.fireUpdatedIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(MavenProject aggregator, MavenProject project, UpdateContext updateContext) {
        for (MavenProject each : this.getModules(project)) {
            if (this.isManagedFile(each.getPath())) {
                if (!this.reconnect(null, each)) continue;
                updateContext.update(each, MavenProjectChanges.NONE);
                continue;
            }
            this.doDelete(project, each, updateContext);
        }
        this.writeLock();
        try {
            if (aggregator != null) {
                this.removeModule(aggregator, project);
            } else {
                this.myRootProjects.remove(project);
            }
            this.myTimestamps.remove(project);
            this.myVirtualFileToProjectMapping.remove(project.getFile());
            this.clearIDMaps(project);
            this.myAggregatorToModuleMapping.remove(project);
            this.myModuleToAggregatorMapping.remove(project);
        }
        finally {
            this.writeUnlock();
        }
        updateContext.deleted(project);
    }

    private void fillIDMaps(MavenProject mavenProject) {
        MavenId id = mavenProject.getMavenId();
        this.myWorkspaceMap.register(id, new File(mavenProject.getFile().getPath()));
        this.myMavenIdToProjectMapping.put(id, mavenProject);
    }

    private void clearIDMaps(MavenProject mavenProject) {
        MavenId id = mavenProject.getMavenId();
        this.myWorkspaceMap.unregister(id);
        this.myMavenIdToProjectMapping.remove(id);
    }

    private void connect(MavenProject newAggregator, MavenProject project) {
        this.writeLock();
        try {
            if (newAggregator != null) {
                this.addModule(newAggregator, project);
            } else {
                this.myRootProjects.add(project);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reconnect(MavenProject newAggregator, MavenProject project) {
        MavenProject prevAggregator = this.findAggregator(project);
        if (prevAggregator == newAggregator) {
            return false;
        }
        this.writeLock();
        try {
            if (prevAggregator != null) {
                this.removeModule(prevAggregator, project);
            } else {
                this.myRootProjects.remove(project);
            }
            if (newAggregator != null) {
                this.addModule(newAggregator, project);
            } else {
                this.myRootProjects.add(project);
            }
        }
        finally {
            this.writeUnlock();
        }
        return true;
    }

    public boolean hasProjects() {
        this.readLock();
        try {
            boolean bl = !this.myRootProjects.isEmpty();
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<MavenProject> getRootProjects() {
        this.readLock();
        try {
            ArrayList<MavenProject> arrayList = new ArrayList<MavenProject>(this.myRootProjects);
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    private static void updateCrc(CRC32 crc, int x) {
        crc.update(x & 0xFF);
        crc.update((x >>>= 8) & 0xFF);
        crc.update((x >>>= 8) & 0xFF);
        crc.update(x >>>= 8);
    }

    private static void updateCrc(CRC32 crc, long l) {
        MavenProjectsTree.updateCrc(crc, (int)l);
        MavenProjectsTree.updateCrc(crc, (int)(l >>> 32));
    }

    private static void updateCrc(CRC32 crc, @Nullable String s) {
        if (s == null) {
            crc.update(111);
        } else {
            MavenProjectsTree.updateCrc(crc, s.hashCode());
            crc.update(s.length() & 0xFF);
        }
    }

    @NotNull
    public static Collection<String> getFilterExclusions(MavenProject mavenProject) {
        Element config = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
        if (config == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                MavenProjectsTree.$$$reportNull$$$0(1);
            }
            return set;
        }
        List<String> customNonFilteredExtensions = MavenJDOMUtil.findChildrenValuesByPath(config, "nonFilteredFileExtensions", "nonFilteredFileExtension");
        if (customNonFilteredExtensions.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                MavenProjectsTree.$$$reportNull$$$0(2);
            }
            return set;
        }
        List<String> list = Collections.unmodifiableList(customNonFilteredExtensions);
        if (list == null) {
            MavenProjectsTree.$$$reportNull$$$0(3);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFilterConfigCrc(ProjectFileIndex fileIndex) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.readLock();
        try {
            final CRC32 crc = new CRC32();
            MavenExplicitProfiles profiles = this.myExplicitProfiles;
            if (profiles != null) {
                MavenProjectsTree.updateCrc(crc, profiles.hashCode());
            }
            Collection<MavenProject> allProjects = this.myVirtualFileToProjectMapping.values();
            crc.update(allProjects.size() & 0xFF);
            for (MavenProject mavenProject : allProjects) {
                VirtualFile pomFile = mavenProject.getFile();
                Module module = fileIndex.getModuleForFile(pomFile);
                if (module == null || !Comparing.equal((Object)fileIndex.getContentRootForFile(pomFile), (Object)pomFile.getParent())) continue;
                MavenProjectsTree.updateCrc(crc, module.getName());
                MavenId mavenId = mavenProject.getMavenId();
                MavenProjectsTree.updateCrc(crc, mavenId.getGroupId());
                MavenProjectsTree.updateCrc(crc, mavenId.getArtifactId());
                MavenProjectsTree.updateCrc(crc, mavenId.getVersion());
                MavenId parentId = mavenProject.getParentId();
                if (parentId != null) {
                    MavenProjectsTree.updateCrc(crc, parentId.getGroupId());
                    MavenProjectsTree.updateCrc(crc, parentId.getArtifactId());
                    MavenProjectsTree.updateCrc(crc, parentId.getVersion());
                }
                MavenProjectsTree.updateCrc(crc, mavenProject.getDirectory());
                MavenProjectsTree.updateCrc(crc, MavenFilteredPropertyPsiReferenceProvider.getDelimitersPattern(mavenProject).pattern());
                MavenProjectsTree.updateCrc(crc, mavenProject.getModelMap().hashCode());
                MavenProjectsTree.updateCrc(crc, mavenProject.getResources().hashCode());
                MavenProjectsTree.updateCrc(crc, mavenProject.getTestResources().hashCode());
                MavenProjectsTree.updateCrc(crc, MavenProjectsTree.getFilterExclusions(mavenProject).hashCode());
                MavenProjectsTree.updateCrc(crc, mavenProject.getProperties().hashCode());
                for (String each : mavenProject.getFilterPropertiesFiles()) {
                    File file = new File(each);
                    MavenProjectsTree.updateCrc(crc, file.lastModified());
                }
                XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
                Writer crcWriter = new Writer(){

                    @Override
                    public void write(char[] cbuf, int off, int len) throws IOException {
                        int end = off + len;
                        for (int i = off; i < end; ++i) {
                            crc.update(cbuf[i]);
                        }
                    }

                    @Override
                    public void flush() throws IOException {
                    }

                    @Override
                    public void close() throws IOException {
                    }
                };
                try {
                    Element warPluginCfg;
                    Element resourcePluginCfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-resources-plugin");
                    if (resourcePluginCfg != null) {
                        outputter.output(resourcePluginCfg, crcWriter);
                    }
                    if ((warPluginCfg = mavenProject.getPluginConfiguration("org.apache.maven.plugins", "maven-war-plugin")) == null) continue;
                    outputter.output(warPluginCfg, crcWriter);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            int n = (int)crc.getValue();
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<VirtualFile> getRootProjectsFiles() {
        return MavenUtil.collectFiles(this.getRootProjects());
    }

    public List<MavenProject> getProjects() {
        this.readLock();
        try {
            ArrayList<MavenProject> arrayList = new ArrayList<MavenProject>(this.myVirtualFileToProjectMapping.values());
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getNonIgnoredProjects() {
        this.readLock();
        try {
            ArrayList<MavenProject> result = new ArrayList<MavenProject>();
            for (MavenProject each : this.myVirtualFileToProjectMapping.values()) {
                if (this.isIgnored(each)) continue;
                result.add(each);
            }
            ArrayList<MavenProject> arrayList = result;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    public List<VirtualFile> getProjectsFiles() {
        this.readLock();
        try {
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myVirtualFileToProjectMapping.keySet());
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    @Nullable
    public MavenProject findProject(VirtualFile f) {
        this.readLock();
        try {
            MavenProject mavenProject = this.myVirtualFileToProjectMapping.get(f);
            return mavenProject;
        }
        finally {
            this.readUnlock();
        }
    }

    @Nullable
    public MavenProject findProject(MavenId id) {
        this.readLock();
        try {
            MavenProject mavenProject = this.myMavenIdToProjectMapping.get(id);
            return mavenProject;
        }
        finally {
            this.readUnlock();
        }
    }

    @Nullable
    public MavenProject findProject(MavenArtifact artifact) {
        return this.findProject(artifact.getMavenId());
    }

    private MavenWorkspaceMap getWorkspaceMap() {
        this.readLock();
        try {
            MavenWorkspaceMap mavenWorkspaceMap = this.myWorkspaceMap.copy();
            return mavenWorkspaceMap;
        }
        finally {
            this.readUnlock();
        }
    }

    public MavenProject findAggregator(MavenProject project) {
        this.readLock();
        try {
            MavenProject mavenProject = this.myModuleToAggregatorMapping.get(project);
            return mavenProject;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public MavenProject findRootProject(@NotNull MavenProject project) {
        if (project == null) {
            MavenProjectsTree.$$$reportNull$$$0(4);
        }
        this.readLock();
        try {
            MavenProject rootProject = project;
            while (true) {
                MavenProject aggregator;
                if ((aggregator = this.myModuleToAggregatorMapping.get(rootProject)) == null) {
                    MavenProject mavenProject = rootProject;
                    MavenProject mavenProject2 = mavenProject;
                    if (mavenProject2 == null) {
                        MavenProjectsTree.$$$reportNull$$$0(5);
                    }
                    return mavenProject2;
                }
                rootProject = aggregator;
            }
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean isRootProject(@NotNull MavenProject project) {
        if (project == null) {
            MavenProjectsTree.$$$reportNull$$$0(6);
        }
        this.readLock();
        try {
            boolean bl = this.myModuleToAggregatorMapping.get(project) == null;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getModules(MavenProject aggregator) {
        this.readLock();
        try {
            List<MavenProject> modules = this.myAggregatorToModuleMapping.get(aggregator);
            ArrayList<MavenProject> arrayList = modules == null ? Collections.emptyList() : new ArrayList<MavenProject>(modules);
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModule(MavenProject aggregator, MavenProject module) {
        this.writeLock();
        try {
            List<MavenProject> modules = this.myAggregatorToModuleMapping.get(aggregator);
            if (modules == null) {
                modules = new ArrayList<MavenProject>();
                this.myAggregatorToModuleMapping.put(aggregator, modules);
            }
            modules.add(module);
            this.myModuleToAggregatorMapping.put(module, aggregator);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModule(MavenProject aggregator, MavenProject module) {
        this.writeLock();
        try {
            List<MavenProject> modules = this.myAggregatorToModuleMapping.get(aggregator);
            if (modules == null) {
                return;
            }
            modules.remove(module);
            this.myModuleToAggregatorMapping.remove(module);
        }
        finally {
            this.writeUnlock();
        }
    }

    private MavenProject findParent(MavenProject project) {
        return this.findProject(project.getParentId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MavenProject> findInheritors(MavenProject project) {
        this.readLock();
        try {
            ArrayList<MavenProject> result = null;
            MavenId id = project.getMavenId();
            for (MavenProject each : this.myVirtualFileToProjectMapping.values()) {
                if (each == project || !id.equals((Object)each.getParentId())) continue;
                if (result == null) {
                    result = new ArrayList<MavenProject>();
                }
                result.add(each);
            }
            List<Object> list = result == null ? Collections.emptyList() : result;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenProject> getDependentProjects(Collection<MavenProject> projects) {
        this.readLock();
        try {
            ArrayList<MavenProject> result = null;
            THashSet projectIds = new THashSet((TObjectHashingStrategy)new MavenCoordinateHashCodeStrategy());
            for (MavenProject project : projects) {
                projectIds.add(project.getMavenId());
            }
            THashSet projectPaths = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            for (MavenProject project : projects) {
                projectPaths.add(new File(project.getFile().getPath()));
            }
            for (MavenProject project : this.myVirtualFileToProjectMapping.values()) {
                boolean isDependent = false;
                Set<String> pathsInStack = project.getModulePaths();
                for (String path : pathsInStack) {
                    if (!projectPaths.contains(new File(path))) continue;
                    isDependent = true;
                    break;
                }
                if (!isDependent) {
                    for (MavenArtifact dep : project.getDependencies()) {
                        if (!projectIds.contains(dep)) continue;
                        isDependent = true;
                        break;
                    }
                }
                if (!isDependent) continue;
                if (result == null) {
                    result = new ArrayList<MavenProject>();
                }
                result.add(project);
            }
            List<Object> list = result == null ? Collections.emptyList() : result;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public void resolve(@NotNull Project project, @NotNull MavenProject mavenProject, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console, @NotNull MavenProgressIndicator process2) throws MavenProcessCanceledException {
        if (project == null) {
            MavenProjectsTree.$$$reportNull$$$0(7);
        }
        if (mavenProject == null) {
            MavenProjectsTree.$$$reportNull$$$0(8);
        }
        if (generalSettings == null) {
            MavenProjectsTree.$$$reportNull$$$0(9);
        }
        if (embeddersManager == null) {
            MavenProjectsTree.$$$reportNull$$$0(10);
        }
        if (console == null) {
            MavenProjectsTree.$$$reportNull$$$0(11);
        }
        if (process2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(12);
        }
        this.resolve(project, Collections.singletonList(mavenProject), generalSettings, embeddersManager, console, new ResolveContext(), process2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(@NotNull Project project, @NotNull Collection<MavenProject> mavenProjects, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console, @NotNull ResolveContext context, @NotNull MavenProgressIndicator process2) throws MavenProcessCanceledException {
        if (project == null) {
            MavenProjectsTree.$$$reportNull$$$0(13);
        }
        if (mavenProjects == null) {
            MavenProjectsTree.$$$reportNull$$$0(14);
        }
        if (generalSettings == null) {
            MavenProjectsTree.$$$reportNull$$$0(15);
        }
        if (embeddersManager == null) {
            MavenProjectsTree.$$$reportNull$$$0(16);
        }
        if (console == null) {
            MavenProjectsTree.$$$reportNull$$$0(17);
        }
        if (context == null) {
            MavenProjectsTree.$$$reportNull$$$0(18);
        }
        if (process2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(19);
        }
        MultiMap<File, MavenProject> projectMultiMap = this.groupByBasedir(mavenProjects);
        for (Map.Entry entry : projectMultiMap.entrySet()) {
            block17: {
                String baseDir = ((File)entry.getKey()).getPath();
                MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(MavenEmbeddersManager.FOR_DEPENDENCIES_RESOLVE, baseDir, baseDir);
                try {
                    Properties userProperties = new Properties();
                    for (MavenProject mavenProject : mavenProjects) {
                        mavenProject.setConfigFileError(null);
                        for (MavenImporter mavenImporter : mavenProject.getSuitableImporters()) {
                            mavenImporter.customizeUserProperties(project, mavenProject, userProperties);
                        }
                    }
                    embedder.customizeForResolve(this.getWorkspaceMap(), console, process2, generalSettings.isAlwaysUpdateSnapshots(), userProperties);
                    this.doResolve(project, (Collection)entry.getValue(), generalSettings, embedder, context, process2);
                }
                catch (Throwable t) {
                    MavenConfigParseException cause = MavenProjectsTree.findParseException(t);
                    if (cause != null) {
                        for (MavenProject mavenProject : mavenProjects) {
                            if (!FileUtil.pathsEqual((String)mavenProject.getDirectory(), (String)cause.getDirectory())) continue;
                            MavenProjectsTree.showNotificationInvalidConfig(project, mavenProject, cause.getMessage());
                            mavenProject.setConfigFileError(cause.getMessage());
                        }
                        break block17;
                    }
                    throw t;
                }
                finally {
                    embeddersManager.release(embedder);
                }
            }
            MavenUtil.restartConfigHighlightning(mavenProjects);
        }
    }

    public static void showNotificationInvalidConfig(final @NotNull Project project, @Nullable MavenProject mavenProject, String message) {
        VirtualFile configFile;
        if (project == null) {
            MavenProjectsTree.$$$reportNull$$$0(20);
        }
        VirtualFile virtualFile = configFile = mavenProject == null ? null : MavenUtil.getConfigFile(mavenProject, "/.mvn/maven.config");
        if (configFile != null) {
            NotificationListener listener = new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    FileEditorManager.getInstance((Project)project).openFile(configFile, true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/idea/maven/project/MavenProjectsTree$3";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            new Notification("Maven", "", RunnerBundle.message("maven.invalid.config.file.with.link", message), NotificationType.ERROR, listener).notify(project);
        } else {
            new Notification("Maven", "", RunnerBundle.message("maven.invalid.config.file", message), NotificationType.ERROR).notify(project);
        }
    }

    private static MavenConfigParseException findParseException(Throwable t) {
        Throwable target;
        MavenConfigParseException parseException = (MavenConfigParseException)ExceptionUtil.findCause((Throwable)t, MavenConfigParseException.class);
        if (parseException != null) {
            return parseException;
        }
        Throwable cause = ExceptionUtil.getRootCause((Throwable)t);
        if (cause instanceof InvocationTargetException && (target = ((InvocationTargetException)cause).getTargetException()) != null) {
            return (MavenConfigParseException)ExceptionUtil.findCause((Throwable)target, MavenConfigParseException.class);
        }
        return null;
    }

    private void doResolve(@NotNull Project project, @NotNull Collection<MavenProject> mavenProjects, @NotNull MavenGeneralSettings generalSettings, @NotNull MavenEmbedderWrapper embedder, @NotNull ResolveContext context, @NotNull MavenProgressIndicator process2) throws MavenProcessCanceledException {
        if (project == null) {
            MavenProjectsTree.$$$reportNull$$$0(21);
        }
        if (mavenProjects == null) {
            MavenProjectsTree.$$$reportNull$$$0(22);
        }
        if (generalSettings == null) {
            MavenProjectsTree.$$$reportNull$$$0(23);
        }
        if (embedder == null) {
            MavenProjectsTree.$$$reportNull$$$0(24);
        }
        if (context == null) {
            MavenProjectsTree.$$$reportNull$$$0(25);
        }
        if (process2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(26);
        }
        if (mavenProjects.isEmpty()) {
            return;
        }
        process2.checkCanceled();
        List names = ContainerUtil.mapNotNull(mavenProjects, p -> p.getDisplayName());
        String text = StringUtil.shortenPathWithEllipsis((String)StringUtil.join((Collection)names, (String)", "), (int)200);
        process2.setText(ProjectBundle.message("maven.resolving.pom", text));
        process2.setText2("");
        MavenExplicitProfiles explicitProfiles = new MavenExplicitProfiles(new LinkedHashSet(), new LinkedHashSet());
        List files = ContainerUtil.map(mavenProjects, p -> {
            explicitProfiles.getEnabledProfiles().addAll(p.getActivatedProfilesIds().getEnabledProfiles());
            explicitProfiles.getDisabledProfiles().addAll(p.getActivatedProfilesIds().getDisabledProfiles());
            return p.getFile();
        });
        Collection<MavenProjectReaderResult> results = new MavenProjectReader(project).resolveProject(generalSettings, embedder, files, explicitProfiles, this.myProjectLocator);
        MavenUtil.notifySyncForUnresolved(project, results);
        for (MavenProjectReaderResult result : results) {
            MavenProject mavenProjectCandidate = null;
            for (MavenProject mavenProject : mavenProjects) {
                MavenId mavenId = result.mavenModel.getMavenId();
                if (mavenProject.getMavenId().equals((Object)mavenId)) {
                    mavenProjectCandidate = mavenProject;
                    break;
                }
                if (!mavenProject.getMavenId().equals(mavenId.getGroupId(), mavenId.getArtifactId())) continue;
                mavenProjectCandidate = mavenProject;
            }
            if (mavenProjectCandidate == null) continue;
            MavenProjectChanges changes = mavenProjectCandidate.set(result, generalSettings, false, result.readingProblems.isEmpty(), false);
            if (result.nativeMavenProject != null) {
                for (MavenImporter eachImporter : mavenProjectCandidate.getSuitableImporters()) {
                    eachImporter.resolve(project, mavenProjectCandidate, result.nativeMavenProject, embedder, context);
                }
            }
            this.fireProjectResolved((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)mavenProjectCandidate, (Object)changes), result.nativeMavenProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolvePlugins(@NotNull MavenProject mavenProject, @NotNull NativeMavenProjectHolder nativeMavenProject, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console, @NotNull MavenProgressIndicator process2) throws MavenProcessCanceledException {
        if (mavenProject == null) {
            MavenProjectsTree.$$$reportNull$$$0(27);
        }
        if (nativeMavenProject == null) {
            MavenProjectsTree.$$$reportNull$$$0(28);
        }
        if (embeddersManager == null) {
            MavenProjectsTree.$$$reportNull$$$0(29);
        }
        if (console == null) {
            MavenProjectsTree.$$$reportNull$$$0(30);
        }
        if (process2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(31);
        }
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(mavenProject, MavenEmbeddersManager.FOR_PLUGINS_RESOLVE);
        embedder.customizeForResolve(console, process2);
        embedder.clearCachesFor(mavenProject.getMavenId());
        HashSet<File> filesToRefresh = new HashSet<File>();
        try {
            process2.setText(ProjectBundle.message("maven.downloading.pom.plugins", mavenProject.getDisplayName()));
            for (MavenPlugin each : mavenProject.getDeclaredPlugins()) {
                process2.checkCanceled();
                Collection<MavenArtifact> artifacts = embedder.resolvePlugin(each, mavenProject.getRemoteRepositories(), nativeMavenProject, false);
                for (MavenArtifact artifact : artifacts) {
                    File pluginJar = artifact.getFile();
                    File pluginDir = pluginJar.getParentFile();
                    if (pluginDir == null) continue;
                    filesToRefresh.add(pluginDir);
                }
                if (!artifacts.isEmpty()) continue;
                MavenProjectsManager.getInstance(this.myProject).getSyncConsole().getListener(MavenServerProgressIndicator.ResolveType.PLUGIN).showError(each.getMavenId().getKey());
            }
            mavenProject.resetCache();
            this.firePluginsResolved(mavenProject);
        }
        finally {
            if (filesToRefresh.size() > 0) {
                LocalFileSystem.getInstance().refreshIoFiles(filesToRefresh);
            }
            embeddersManager.release(embedder);
        }
    }

    public void resolveFolders(final @NotNull MavenProject mavenProject, final @NotNull MavenImportingSettings importingSettings, @NotNull MavenEmbeddersManager embeddersManager, final @NotNull MavenConsole console, final @NotNull MavenProgressIndicator process2) throws MavenProcessCanceledException {
        if (mavenProject == null) {
            MavenProjectsTree.$$$reportNull$$$0(32);
        }
        if (importingSettings == null) {
            MavenProjectsTree.$$$reportNull$$$0(33);
        }
        if (embeddersManager == null) {
            MavenProjectsTree.$$$reportNull$$$0(34);
        }
        if (console == null) {
            MavenProjectsTree.$$$reportNull$$$0(35);
        }
        if (process2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(36);
        }
        this.executeWithEmbedder(mavenProject, embeddersManager, MavenEmbeddersManager.FOR_FOLDERS_RESOLVE, console, process2, new EmbedderTask(){

            @Override
            public void run(MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
                process2.checkCanceled();
                process2.setText(ProjectBundle.message("maven.updating.folders.pom", mavenProject.getDisplayName()));
                process2.setText2("");
                Pair<Boolean, MavenProjectChanges> resolveResult = mavenProject.resolveFolders(embedder, importingSettings, console);
                if (((Boolean)resolveResult.first).booleanValue()) {
                    MavenProjectsTree.this.fireFoldersResolved((Pair<MavenProject, MavenProjectChanges>)Pair.create((Object)mavenProject, (Object)resolveResult.second));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenArtifactDownloader.DownloadResult downloadSourcesAndJavadocs(@NotNull Project project, @NotNull Collection<MavenProject> projects, @Nullable Collection<MavenArtifact> artifacts, boolean downloadSources, boolean downloadDocs, @NotNull MavenEmbeddersManager embeddersManager, @NotNull MavenConsole console, @NotNull MavenProgressIndicator process2) throws MavenProcessCanceledException {
        if (project == null) {
            MavenProjectsTree.$$$reportNull$$$0(37);
        }
        if (projects == null) {
            MavenProjectsTree.$$$reportNull$$$0(38);
        }
        if (embeddersManager == null) {
            MavenProjectsTree.$$$reportNull$$$0(39);
        }
        if (console == null) {
            MavenProjectsTree.$$$reportNull$$$0(40);
        }
        if (process2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(41);
        }
        MultiMap<File, MavenProject> projectMultiMap = this.groupByBasedir(projects);
        MavenArtifactDownloader.DownloadResult result = new MavenArtifactDownloader.DownloadResult();
        for (Map.Entry entry : projectMultiMap.entrySet()) {
            String baseDir = ((File)entry.getKey()).getPath();
            MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(MavenEmbeddersManager.FOR_DOWNLOAD, baseDir, baseDir);
            try {
                embedder.customizeForResolve(console, process2);
                MavenArtifactDownloader.DownloadResult result1 = MavenArtifactDownloader.download(project, this, projects, artifacts, downloadSources, downloadDocs, embedder, process2);
                for (MavenProject each : projects) {
                    this.fireArtifactsDownloaded(each);
                }
                result.resolvedDocs.addAll(result1.resolvedDocs);
                result.resolvedSources.addAll(result1.resolvedSources);
                result.unresolvedDocs.addAll(result1.unresolvedDocs);
                result.unresolvedSources.addAll(result1.unresolvedSources);
            }
            finally {
                embeddersManager.release(embedder);
            }
        }
        return result;
    }

    @NotNull
    private MultiMap<File, MavenProject> groupByBasedir(@NotNull Collection<MavenProject> projects) {
        if (projects == null) {
            MavenProjectsTree.$$$reportNull$$$0(42);
        }
        MultiMap multiMap = ContainerUtil.groupBy(projects, p -> MavenUtil.getBaseDir(this.findRootProject((MavenProject)p).getDirectoryFile()));
        if (multiMap == null) {
            MavenProjectsTree.$$$reportNull$$$0(43);
        }
        return multiMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithEmbedder(@NotNull MavenProject mavenProject, @NotNull MavenEmbeddersManager embeddersManager, @NotNull Key embedderKind, @NotNull MavenConsole console, @NotNull MavenProgressIndicator process2, @NotNull EmbedderTask task) throws MavenProcessCanceledException {
        if (mavenProject == null) {
            MavenProjectsTree.$$$reportNull$$$0(44);
        }
        if (embeddersManager == null) {
            MavenProjectsTree.$$$reportNull$$$0(45);
        }
        if (embedderKind == null) {
            MavenProjectsTree.$$$reportNull$$$0(46);
        }
        if (console == null) {
            MavenProjectsTree.$$$reportNull$$$0(47);
        }
        if (process2 == null) {
            MavenProjectsTree.$$$reportNull$$$0(48);
        }
        if (task == null) {
            MavenProjectsTree.$$$reportNull$$$0(49);
        }
        MavenEmbedderWrapper embedder = embeddersManager.getEmbedder(mavenProject, embedderKind);
        embedder.customizeForResolve(this.getWorkspaceMap(), console, process2, false);
        embedder.clearCachesFor(mavenProject.getMavenId());
        try {
            task.run(embedder);
        }
        finally {
            embeddersManager.release(embedder);
        }
    }

    public <Result> Result visit(Visitor<Result> visitor) {
        for (MavenProject each : this.getRootProjects()) {
            if (visitor.isDone()) break;
            this.doVisit(each, visitor);
        }
        return visitor.getResult();
    }

    private <Result> void doVisit(MavenProject project, Visitor<Result> visitor) {
        if (!visitor.isDone() && visitor.shouldVisit(project)) {
            visitor.visit(project);
            for (MavenProject each : this.getModules(project)) {
                if (visitor.isDone()) break;
                this.doVisit(each, visitor);
            }
            visitor.leave(project);
        }
    }

    private void writeLock() {
        this.myStructureWriteLock.lock();
    }

    private void writeUnlock() {
        this.myStructureWriteLock.unlock();
    }

    private void readLock() {
        this.myStructureReadLock.lock();
    }

    private void readUnlock() {
        this.myStructureReadLock.unlock();
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    private void fireProfilesChanged() {
        for (Listener each : this.myListeners) {
            each.profilesChanged();
        }
    }

    private void fireProjectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
        if (ignored == null) {
            MavenProjectsTree.$$$reportNull$$$0(50);
        }
        if (unignored == null) {
            MavenProjectsTree.$$$reportNull$$$0(51);
        }
        for (Listener each : this.myListeners) {
            each.projectsIgnoredStateChanged(ignored, unignored, fromImport);
        }
    }

    private void fireProjectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
        if (updated == null) {
            MavenProjectsTree.$$$reportNull$$$0(52);
        }
        if (deleted == null) {
            MavenProjectsTree.$$$reportNull$$$0(53);
        }
        for (Listener each : this.myListeners) {
            each.projectsUpdated(updated, deleted);
        }
    }

    private void fireProjectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
        if (projectWithChanges == null) {
            MavenProjectsTree.$$$reportNull$$$0(54);
        }
        for (Listener each : this.myListeners) {
            each.projectResolved(projectWithChanges, nativeMavenProject);
        }
    }

    private void firePluginsResolved(@NotNull MavenProject project) {
        if (project == null) {
            MavenProjectsTree.$$$reportNull$$$0(55);
        }
        for (Listener each : this.myListeners) {
            each.pluginsResolved(project);
        }
    }

    private void fireFoldersResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
        if (projectWithChanges == null) {
            MavenProjectsTree.$$$reportNull$$$0(56);
        }
        for (Listener each : this.myListeners) {
            each.foldersResolved(projectWithChanges);
        }
    }

    private void fireArtifactsDownloaded(@NotNull MavenProject project) {
        if (project == null) {
            MavenProjectsTree.$$$reportNull$$$0(57);
        }
        for (Listener each : this.myListeners) {
            each.artifactsDownloaded(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenProjectsTree";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 13: 
            case 20: 
            case 21: 
            case 37: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 27: 
            case 32: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 9: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generalSettings";
                break;
            }
            case 10: 
            case 16: 
            case 29: 
            case 34: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddersManager";
                break;
            }
            case 11: 
            case 17: 
            case 30: 
            case 35: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 12: 
            case 19: 
            case 26: 
            case 31: 
            case 36: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProjects";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedder";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeMavenProject";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importingSettings";
                break;
            }
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embedderKind";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unignored";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updated";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectWithChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsTree";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterExclusions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootProject";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByBasedir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 43: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRootProject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isRootProject";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showNotificationInvalidConfig";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolvePlugins";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "resolveFolders";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "downloadSourcesAndJavadocs";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "groupByBasedir";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "executeWithEmbedder";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectsIgnoredStateChanged";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectsUpdated";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "fireProjectResolved";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "firePluginsResolved";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "fireFoldersResolved";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "fireArtifactsDownloaded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MavenCoordinateHashCodeStrategy
    implements TObjectHashingStrategy<MavenCoordinate> {
        private MavenCoordinateHashCodeStrategy() {
        }

        public int computeHashCode(MavenCoordinate object) {
            String artifactId = object.getArtifactId();
            return artifactId == null ? 0 : artifactId.hashCode();
        }

        public boolean equals(MavenCoordinate o1, MavenCoordinate o2) {
            return Comparing.equal((String)o1.getArtifactId(), (String)o2.getArtifactId()) && Comparing.equal((String)o1.getVersion(), (String)o2.getVersion()) && Comparing.equal((String)o1.getGroupId(), (String)o2.getGroupId());
        }
    }

    public static interface Listener
    extends EventListener {
        default public void profilesChanged() {
        }

        default public void projectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
            if (ignored == null) {
                Listener.$$$reportNull$$$0(0);
            }
            if (unignored == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
            if (updated == null) {
                Listener.$$$reportNull$$$0(2);
            }
            if (deleted == null) {
                Listener.$$$reportNull$$$0(3);
            }
        }

        default public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, @Nullable NativeMavenProjectHolder nativeMavenProject) {
            if (projectWithChanges == null) {
                Listener.$$$reportNull$$$0(4);
            }
        }

        default public void pluginsResolved(@NotNull MavenProject project) {
            if (project == null) {
                Listener.$$$reportNull$$$0(5);
            }
        }

        default public void foldersResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
            if (projectWithChanges == null) {
                Listener.$$$reportNull$$$0(6);
            }
        }

        default public void artifactsDownloaded(@NotNull MavenProject project) {
            if (project == null) {
                Listener.$$$reportNull$$$0(7);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignored";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unignored";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updated";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deleted";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectWithChanges";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/project/MavenProjectsTree$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectsIgnoredStateChanged";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectsUpdated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectResolved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pluginsResolved";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "foldersResolved";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "artifactsDownloaded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MavenProjectTimestamp {
        private final long myPomTimestamp;
        private final long myParentLastReadStamp;
        private final long myProfilesTimestamp;
        private final long myUserSettingsTimestamp;
        private final long myGlobalSettingsTimestamp;
        private final long myExplicitProfilesHashCode;
        private final long myJvmConfigTimestamp;
        private final long myMavenConfigTimestamp;

        private MavenProjectTimestamp(long pomTimestamp, long parentLastReadStamp, long profilesTimestamp, long userSettingsTimestamp, long globalSettingsTimestamp, long explicitProfilesHashCode, long jvmConfigTimestamp, long mavenConfigTimestamp) {
            this.myPomTimestamp = pomTimestamp;
            this.myParentLastReadStamp = parentLastReadStamp;
            this.myProfilesTimestamp = profilesTimestamp;
            this.myUserSettingsTimestamp = userSettingsTimestamp;
            this.myGlobalSettingsTimestamp = globalSettingsTimestamp;
            this.myExplicitProfilesHashCode = explicitProfilesHashCode;
            this.myJvmConfigTimestamp = jvmConfigTimestamp;
            this.myMavenConfigTimestamp = mavenConfigTimestamp;
        }

        public static MavenProjectTimestamp read(DataInputStream in) throws IOException {
            return new MavenProjectTimestamp(in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong(), in.readLong());
        }

        public void write(DataOutputStream out) throws IOException {
            out.writeLong(this.myPomTimestamp);
            out.writeLong(this.myParentLastReadStamp);
            out.writeLong(this.myProfilesTimestamp);
            out.writeLong(this.myUserSettingsTimestamp);
            out.writeLong(this.myGlobalSettingsTimestamp);
            out.writeLong(this.myExplicitProfilesHashCode);
            out.writeLong(this.myJvmConfigTimestamp);
            out.writeLong(this.myMavenConfigTimestamp);
        }

        public String toString() {
            return "(" + this.myPomTimestamp + ":" + this.myParentLastReadStamp + ":" + this.myProfilesTimestamp + ":" + this.myUserSettingsTimestamp + ":" + this.myGlobalSettingsTimestamp + ":" + this.myExplicitProfilesHashCode + ":" + this.myJvmConfigTimestamp + ":" + this.myMavenConfigTimestamp + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MavenProjectTimestamp timestamp = (MavenProjectTimestamp)o;
            if (this.myPomTimestamp != timestamp.myPomTimestamp) {
                return false;
            }
            if (this.myParentLastReadStamp != timestamp.myParentLastReadStamp) {
                return false;
            }
            if (this.myProfilesTimestamp != timestamp.myProfilesTimestamp) {
                return false;
            }
            if (this.myUserSettingsTimestamp != timestamp.myUserSettingsTimestamp) {
                return false;
            }
            if (this.myGlobalSettingsTimestamp != timestamp.myGlobalSettingsTimestamp) {
                return false;
            }
            if (this.myExplicitProfilesHashCode != timestamp.myExplicitProfilesHashCode) {
                return false;
            }
            if (this.myJvmConfigTimestamp != timestamp.myJvmConfigTimestamp) {
                return false;
            }
            return this.myMavenConfigTimestamp == timestamp.myMavenConfigTimestamp;
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (int)(this.myPomTimestamp ^ this.myPomTimestamp >>> 32);
            result = 31 * result + (int)(this.myParentLastReadStamp ^ this.myParentLastReadStamp >>> 32);
            result = 31 * result + (int)(this.myProfilesTimestamp ^ this.myProfilesTimestamp >>> 32);
            result = 31 * result + (int)(this.myUserSettingsTimestamp ^ this.myUserSettingsTimestamp >>> 32);
            result = 31 * result + (int)(this.myGlobalSettingsTimestamp ^ this.myGlobalSettingsTimestamp >>> 32);
            result = 31 * result + (int)(this.myExplicitProfilesHashCode ^ this.myExplicitProfilesHashCode >>> 32);
            result = 31 * result + (int)(this.myJvmConfigTimestamp ^ this.myJvmConfigTimestamp >>> 32);
            result = 31 * result + (int)(this.myMavenConfigTimestamp ^ this.myMavenConfigTimestamp >>> 32);
            return result;
        }
    }

    public static abstract class SimpleVisitor
    extends Visitor<Object> {
    }

    public static abstract class Visitor<Result> {
        private Result result;

        public boolean shouldVisit(MavenProject project) {
            return true;
        }

        public abstract void visit(MavenProject var1);

        public void leave(MavenProject node2) {
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public Result getResult() {
            return this.result;
        }

        public boolean isDone() {
            return this.result != null;
        }
    }

    public static interface EmbedderTask {
        public void run(MavenEmbedderWrapper var1) throws MavenProcessCanceledException;
    }

    private class UpdateContext {
        public final Map<MavenProject, MavenProjectChanges> updatedProjectsWithChanges = new LinkedHashMap<MavenProject, MavenProjectChanges>();
        public final Set<MavenProject> deletedProjects = new LinkedHashSet<MavenProject>();

        private UpdateContext() {
        }

        public void update(MavenProject project, MavenProjectChanges changes) {
            this.deletedProjects.remove(project);
            this.updatedProjectsWithChanges.put(project, changes.mergedWith(this.updatedProjectsWithChanges.get(project)));
        }

        public void deleted(MavenProject project) {
            this.updatedProjectsWithChanges.remove(project);
            this.deletedProjects.add(project);
        }

        public void deleted(Collection<MavenProject> projects) {
            for (MavenProject each : projects) {
                this.deleted(each);
            }
        }

        public void fireUpdatedIfNecessary() {
            if (this.updatedProjectsWithChanges.isEmpty() && this.deletedProjects.isEmpty()) {
                return;
            }
            ArrayList<MavenProject> mavenProjects = this.deletedProjects.isEmpty() ? Collections.emptyList() : new ArrayList<MavenProject>(this.deletedProjects);
            List updated = this.updatedProjectsWithChanges.isEmpty() ? Collections.emptyList() : MavenUtil.mapToList(this.updatedProjectsWithChanges);
            MavenProjectsTree.this.fireProjectsUpdated(updated, mavenProjects);
        }
    }
}

