/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion.model;

import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;

public class MavenRepositoryArtifactInfo
implements MavenCoordinate {
    private final String groupId;
    private final String artifactId;
    private final MavenDependencyCompletionItem[] items;
    private final boolean myOnlyLocal;

    public MavenRepositoryArtifactInfo(String groupId, String artifactId, MavenDependencyCompletionItem[] items) {
        this(false, groupId, artifactId, items);
    }

    public MavenRepositoryArtifactInfo(boolean onlyLocal, String groupId, String artifactId, MavenDependencyCompletionItem[] items) {
        this.myOnlyLocal = onlyLocal;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.items = items;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        if (this.items.length < 1) {
            return null;
        }
        return this.items[0].getVersion();
    }

    public MavenDependencyCompletionItem[] getItems() {
        return this.items;
    }

    public String toString() {
        return "maven(" + this.groupId + ':' + this.artifactId + ":" + this.getVersion() + " " + this.items.length + " total)";
    }
}

