/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion.intellij;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.onlinecompletion.intellij.MyErrorHandler;
import org.jetbrains.idea.maven.onlinecompletion.intellij.PackageSearchResultModel;
import org.jetbrains.idea.maven.onlinecompletion.intellij.PackageServiceConfig;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.maven.onlinecompletion.model.SearchParameters;

public class PackageSearchService {
    private static final MyErrorHandler<Throwable> myErrorHandler = new MyErrorHandler();
    private final Gson myGson = new Gson();
    private final PackageServiceConfig myPackageServiceConfig = new PackageServiceConfig();

    public Promise<Void> fullTextSearch(@NotNull String text, @NotNull SearchParameters parameters, @NotNull Consumer<MavenRepositoryArtifactInfo> consumer) {
        if (text == null) {
            PackageSearchService.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            PackageSearchService.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            PackageSearchService.$$$reportNull$$$0(2);
        }
        ProgressManager.checkCanceled();
        String url = this.createUrlFullTextSearch(text);
        return this.doRequest(parameters, consumer, url);
    }

    public Promise<Void> suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull SearchParameters parameters, @NotNull Consumer<MavenRepositoryArtifactInfo> consumer) {
        if (groupId == null) {
            PackageSearchService.$$$reportNull$$$0(3);
        }
        if (artifactId == null) {
            PackageSearchService.$$$reportNull$$$0(4);
        }
        if (parameters == null) {
            PackageSearchService.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            PackageSearchService.$$$reportNull$$$0(6);
        }
        ProgressManager.checkCanceled();
        String url = this.createUrlSuggestPrefix(groupId, artifactId);
        return this.doRequest(parameters, consumer, url);
    }

    private Promise<Void> doRequest(@NotNull SearchParameters parameters, @NotNull Consumer<MavenRepositoryArtifactInfo> consumer, String url) {
        if (parameters == null) {
            PackageSearchService.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            PackageSearchService.$$$reportNull$$$0(8);
        }
        if (url == null) {
            AsyncPromise result = new AsyncPromise();
            result.setResult(null);
            return result;
        }
        Promise<Void> promise = myErrorHandler.errorResult();
        if (promise != null) {
            return promise;
        }
        try {
            return ((Promise)HttpRequests.request((String)url).userAgent(this.myPackageServiceConfig.getUserAgent()).forceHttps(true).connectTimeout((int)parameters.getMillisToWait()).readTimeout((int)parameters.getMillisToWait()).connect(request -> this.process(parameters, consumer, request))).onSuccess(v -> myErrorHandler.markSuccess());
        }
        catch (IOException e) {
            AsyncPromise error = new AsyncPromise();
            error.onError(myErrorHandler);
            error.setError((Throwable)e);
            return error;
        }
    }

    @NotNull
    private Promise<Void> process(@NotNull SearchParameters parameters, @NotNull Consumer<MavenRepositoryArtifactInfo> consumer, HttpRequests.Request request) {
        if (parameters == null) {
            PackageSearchService.$$$reportNull$$$0(9);
        }
        if (consumer == null) {
            PackageSearchService.$$$reportNull$$$0(10);
        }
        AsyncPromise result = new AsyncPromise();
        result.onError(myErrorHandler);
        try {
            JsonReader reader = this.myGson.newJsonReader((Reader)request.getReader());
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if ("items".equals(name)) {
                    this.readVariants(reader, parameters, consumer);
                    continue;
                }
                reader.nextString();
            }
            result.setResult(null);
        }
        catch (Exception e) {
            result.setError((Throwable)e);
        }
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            PackageSearchService.$$$reportNull$$$0(11);
        }
        return asyncPromise;
    }

    private String createUrlFullTextSearch(@NotNull String coord) {
        String url;
        if (coord == null) {
            PackageSearchService.$$$reportNull$$$0(12);
        }
        if ((url = this.myPackageServiceConfig.getFullTextUrl()) == null) {
            return null;
        }
        return url + "?query=" + PackageSearchService.encode(coord.trim());
    }

    private String createUrlSuggestPrefix(@NotNull String groupId, @NotNull String artifactId) {
        String url;
        if (groupId == null) {
            PackageSearchService.$$$reportNull$$$0(13);
        }
        if (artifactId == null) {
            PackageSearchService.$$$reportNull$$$0(14);
        }
        if ((url = this.myPackageServiceConfig.getSuggestUrl()) == null) {
            return null;
        }
        String groupParam = StringUtil.isEmpty((String)groupId) ? "" : "groupId=" + PackageSearchService.encode(groupId.trim());
        String artifactParam = StringUtil.isEmpty((String)artifactId) ? "" : "artifactId=" + PackageSearchService.encode(artifactId.trim());
        return url + "?" + groupParam + "&" + artifactParam;
    }

    private void readVariants(JsonReader reader, SearchParameters parameters, Consumer<MavenRepositoryArtifactInfo> consumer) throws IOException {
        reader.beginArray();
        int results = 0;
        while (reader.hasNext() && results++ < parameters.getMaxResults()) {
            PackageSearchResultModel resultModel = (PackageSearchResultModel)this.myGson.fromJson(reader, PackageSearchResultModel.class);
            ProgressManager.checkCanceled();
            if (resultModel.versions == null || resultModel.versions.length < 1 || StringUtil.isEmpty((String)resultModel.groupId) || StringUtil.isEmpty((String)resultModel.artifactId)) continue;
            MavenDependencyCompletionItem[] items = new MavenDependencyCompletionItem[resultModel.versions.length];
            for (int i = 0; i < resultModel.versions.length; ++i) {
                items[i] = new MavenDependencyCompletionItem(resultModel.groupId, resultModel.artifactId, resultModel.versions[i], MavenDependencyCompletionItem.Type.REMOTE);
            }
            consumer.accept(new MavenRepositoryArtifactInfo(items[0].getGroupId(), items[0].getArtifactId(), items));
        }
    }

    @NotNull
    private static String encode(@NotNull String s) {
        String string;
        if (s == null) {
            PackageSearchService.$$$reportNull$$$0(15);
        }
        try {
            string = URLEncoder.encode(s.trim(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            PackageSearchService.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/onlinecompletion/intellij/PackageSearchService";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coord";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/onlinecompletion/intellij/PackageSearchService";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "encode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fullTextSearch";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestPrefix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doRequest";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 11: 
            case 16: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createUrlFullTextSearch";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createUrlSuggestPrefix";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "encode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

