/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenVersionComparable;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.onlinecompletion.DeduplicationCollector;
import org.jetbrains.idea.maven.onlinecompletion.DependencyCompletionProvider;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItemWithClass;
import org.jetbrains.idea.maven.onlinecompletion.model.SearchParameters;
import org.jetbrains.idea.maven.utils.MavenLog;

@ApiStatus.Experimental
public class OfflineSearchService
implements DependencyCompletionProvider {
    private static final DeduplicationCollector<MavenDependencyCompletionItem> GROUP_COLLECTOR = new DeduplicationCollector<MavenDependencyCompletionItem>(m -> m.getGroupId());
    private static final DeduplicationCollector<MavenDependencyCompletionItem> ARTIFACT_COLLECTOR = new DeduplicationCollector<MavenDependencyCompletionItem>(m -> m.getGroupId() + ":" + m.getArtifactId());
    private static final DeduplicationCollector VERSION_COLLECTOR = new DeduplicationCollector<MavenDependencyCompletionItem>(m -> m.getGroupId() + ":" + m.getArtifactId() + ":" + m.getVersion());
    private final List<DependencyCompletionProvider> myProviders;

    public OfflineSearchService(List<DependencyCompletionProvider> providers) {
        this.myProviders = providers;
    }

    @NotNull
    public List<MavenDependencyCompletionItem> findByTemplate(@NotNull String coord) {
        if (coord == null) {
            OfflineSearchService.$$$reportNull$$$0(0);
        }
        List<MavenDependencyCompletionItem> list = this.findByTemplate(coord, SearchParameters.DEFAULT);
        if (list == null) {
            OfflineSearchService.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<MavenDependencyCompletionItem> findByTemplate(@NotNull String coord, @NotNull SearchParameters parameters) {
        if (coord == null) {
            OfflineSearchService.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            OfflineSearchService.$$$reportNull$$$0(3);
        }
        ProgressManager.checkCanceled();
        MavenDependencyCompletionItem template = new MavenDependencyCompletionItem(coord, null);
        if (StringUtil.isEmpty((String)template.getGroupId())) {
            List<MavenDependencyCompletionItem> list = Collections.emptyList();
            if (list == null) {
                OfflineSearchService.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (StringUtil.isEmpty((String)template.getArtifactId())) {
            ArrayList<MavenDependencyCompletionItem> result = new ArrayList<MavenDependencyCompletionItem>();
            result.addAll(this.findGroupCandidates((MavenCoordinate)template, parameters));
            result.addAll(this.findArtifactCandidates((MavenCoordinate)template, parameters));
            ArrayList<MavenDependencyCompletionItem> arrayList = result;
            if (arrayList == null) {
                OfflineSearchService.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        if (StringUtil.isEmpty((String)template.getVersion())) {
            ArrayList<MavenDependencyCompletionItem> result = new ArrayList<MavenDependencyCompletionItem>();
            result.addAll(this.findArtifactCandidates((MavenCoordinate)template, parameters));
            result.addAll(this.findAllVersions((MavenCoordinate)template, parameters));
            ArrayList<MavenDependencyCompletionItem> arrayList = result;
            if (arrayList == null) {
                OfflineSearchService.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        List<MavenDependencyCompletionItem> list = this.findAllVersions((MavenCoordinate)template, parameters);
        if (list == null) {
            OfflineSearchService.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<MavenDependencyCompletionItem> findGroupCandidates(@NotNull MavenCoordinate template) {
        if (template == null) {
            OfflineSearchService.$$$reportNull$$$0(8);
        }
        List<MavenDependencyCompletionItem> list = this.findGroupCandidates(template, SearchParameters.DEFAULT);
        if (list == null) {
            OfflineSearchService.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    public List<MavenDependencyCompletionItem> findGroupCandidates(@NotNull MavenCoordinate template, @NotNull SearchParameters parameters) {
        if (template == null) {
            OfflineSearchService.$$$reportNull$$$0(10);
        }
        if (parameters == null) {
            OfflineSearchService.$$$reportNull$$$0(11);
        }
        return this.doQuery(parameters, template, (p, s) -> p.findGroupCandidates((MavenCoordinate)s, parameters), GROUP_COLLECTOR, OfflineSearchService.groupMatch(template.getGroupId()), OfflineSearchService.localFirstComparator());
    }

    @NotNull
    public List<MavenDependencyCompletionItem> findArtifactCandidates(@NotNull MavenCoordinate template) {
        if (template == null) {
            OfflineSearchService.$$$reportNull$$$0(12);
        }
        List<MavenDependencyCompletionItem> list = this.findArtifactCandidates(template, SearchParameters.DEFAULT);
        if (list == null) {
            OfflineSearchService.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @NotNull
    public List<MavenDependencyCompletionItem> findArtifactCandidates(@NotNull MavenCoordinate template, @NotNull SearchParameters parameters) {
        if (template == null) {
            OfflineSearchService.$$$reportNull$$$0(14);
        }
        if (parameters == null) {
            OfflineSearchService.$$$reportNull$$$0(15);
        }
        List<MavenDependencyCompletionItem> list = this.doQuery(parameters, template, (p, s) -> p.findArtifactCandidates((MavenCoordinate)s, parameters), ARTIFACT_COLLECTOR, OfflineSearchService.groupMatch(template.getGroupId()).and(OfflineSearchService.artifactMatch(template.getArtifactId())), OfflineSearchService.localFirstComparator());
        if (list == null) {
            OfflineSearchService.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public List<MavenDependencyCompletionItem> findAllVersions(@NotNull MavenCoordinate template) {
        if (template == null) {
            OfflineSearchService.$$$reportNull$$$0(17);
        }
        List<MavenDependencyCompletionItem> list = this.findAllVersions(template, SearchParameters.DEFAULT);
        if (list == null) {
            OfflineSearchService.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Override
    @NotNull
    public List<MavenDependencyCompletionItem> findAllVersions(@NotNull MavenCoordinate template, @NotNull SearchParameters parameters) {
        if (template == null) {
            OfflineSearchService.$$$reportNull$$$0(19);
        }
        if (parameters == null) {
            OfflineSearchService.$$$reportNull$$$0(20);
        }
        List<MavenDependencyCompletionItem> list = this.doQuery(parameters, template, (p, s) -> p.findAllVersions((MavenCoordinate)s, parameters), VERSION_COLLECTOR, OfflineSearchService.groupMatch(template.getGroupId()).and(OfflineSearchService.artifactMatch(template.getArtifactId())), OfflineSearchService.versionComparator());
        if (list == null) {
            OfflineSearchService.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Override
    @NotNull
    public List<MavenDependencyCompletionItemWithClass> findClassesByString(@NotNull String className, @NotNull SearchParameters parameters) {
        if (className == null) {
            OfflineSearchService.$$$reportNull$$$0(22);
        }
        if (parameters == null) {
            OfflineSearchService.$$$reportNull$$$0(23);
        }
        List<MavenDependencyCompletionItemWithClass> list = this.doQuery(parameters, className, (p, s) -> p.findClassesByString((String)s, parameters), VERSION_COLLECTOR, l -> true, OfflineSearchService.localFirstComparator());
        if (list == null) {
            OfflineSearchService.$$$reportNull$$$0(24);
        }
        return list;
    }

    private <PARAM, RESULT extends MavenDependencyCompletionItem> List<RESULT> doQuery(@NotNull SearchParameters parameters, PARAM template, ThrowingSearch<PARAM, RESULT> search2, Collector<RESULT, ?, List<RESULT>> collector, Predicate<RESULT> filter, Comparator<? super RESULT> comparator) {
        if (parameters == null) {
            OfflineSearchService.$$$reportNull$$$0(25);
        }
        Application application = ApplicationManager.getApplication();
        List<RESULT> result = this.myProviders.stream().map(provider -> application.executeOnPooledThread(() -> search2.search((DependencyCompletionProvider)provider, template))).map(f -> {
            try {
                return (List)f.get(parameters.getMillisToWait(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                MavenLog.LOG.debug((Throwable)e);
                return Collections.emptyList();
            }
        }).flatMap(l -> l.stream()).filter(filter).collect(collector);
        if (comparator != null) {
            Collections.sort(result, comparator);
        }
        return result;
    }

    private static <T extends MavenDependencyCompletionItem> Predicate<T> groupMatch(String groupId) {
        return ci -> StringUtil.isEmpty((String)groupId) || ci.getGroupId() != null && ci.getGroupId().contains(groupId);
    }

    private static <T extends MavenDependencyCompletionItem> Predicate<T> artifactMatch(String artifactId) {
        return ci -> StringUtil.isEmpty((String)artifactId) || ci.getGroupId() != null && ci.getArtifactId() != null && ci.getArtifactId().contains(artifactId);
    }

    private static <T extends MavenDependencyCompletionItem> Comparator<T> versionComparator() {
        return Comparator.comparing(o -> new MavenVersionComparable(o.getVersion()));
    }

    private static <T extends MavenDependencyCompletionItem> Comparator<T> localFirstComparator() {
        Comparator<MavenDependencyCompletionItem> result = Comparator.comparing(o -> {
            MavenDependencyCompletionItem.Type type = o.getType();
            return type == null ? Integer.MAX_VALUE : type.getWeight();
        });
        return result.reversed();
    }

    public List<DependencyCompletionProvider> getProviders() {
        return this.myProviders;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coord";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/onlinecompletion/OfflineSearchService";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 20: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/onlinecompletion/OfflineSearchService";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findByTemplate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findGroupCandidates";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findArtifactCandidates";
                break;
            }
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllVersions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesByString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findByTemplate";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findGroupCandidates";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findArtifactCandidates";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAllVersions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findClassesByString";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doQuery";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface ThrowingSearch<PARAM, RESULT extends MavenDependencyCompletionItem> {
        public List<RESULT> search(DependencyCompletionProvider var1, PARAM var2) throws IOException;
    }
}

