/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.onlinecompletion.DependencyCompletionProvider;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItemWithClass;
import org.jetbrains.idea.maven.onlinecompletion.model.SearchParameters;
import org.jetbrains.idea.maven.utils.MavenLog;

public class IndexBasedCompletionProvider
implements DependencyCompletionProvider {
    private final MavenIndex myIndex;
    private final MavenDependencyCompletionItem.Type resultingType;

    public IndexBasedCompletionProvider(@NotNull MavenIndex index) {
        if (index == null) {
            IndexBasedCompletionProvider.$$$reportNull$$$0(0);
        }
        this.myIndex = index;
        this.resultingType = this.myIndex.getKind() == MavenSearchIndex.Kind.LOCAL ? MavenDependencyCompletionItem.Type.LOCAL : MavenDependencyCompletionItem.Type.REMOTE;
    }

    @Override
    @NotNull
    public List<MavenDependencyCompletionItem> findGroupCandidates(MavenCoordinate template, SearchParameters parameters) {
        List list = ContainerUtil.map(this.myIndex.getGroupIds(), g -> new MavenDependencyCompletionItem((String)g, this.resultingType));
        if (list == null) {
            IndexBasedCompletionProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<MavenDependencyCompletionItem> findArtifactCandidates(MavenCoordinate template, SearchParameters parameters) throws IOException {
        List list = ContainerUtil.map(this.myIndex.getArtifactIds(template.getGroupId()), a -> new MavenDependencyCompletionItem(template.getGroupId(), (String)a, null, this.resultingType));
        if (list == null) {
            IndexBasedCompletionProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public List<MavenDependencyCompletionItem> findAllVersions(MavenCoordinate template, SearchParameters parameters) {
        List list = ContainerUtil.map(this.myIndex.getVersions(template.getGroupId(), template.getArtifactId()), v -> new MavenDependencyCompletionItem(template.getGroupId(), template.getArtifactId(), (String)v, this.resultingType));
        if (list == null) {
            IndexBasedCompletionProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public List<MavenDependencyCompletionItemWithClass> findClassesByString(@NotNull String str, SearchParameters parameters) {
        Query searchQuery;
        if (str == null) {
            IndexBasedCompletionProvider.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)str)) {
            List<MavenDependencyCompletionItemWithClass> list = Collections.emptyList();
            if (list == null) {
                IndexBasedCompletionProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        try {
            searchQuery = IndexBasedCompletionProvider.createSearchQuery(str);
        }
        catch (ParseException e) {
            MavenLog.LOG.debug((Throwable)e);
            List<MavenDependencyCompletionItemWithClass> list = Collections.emptyList();
            if (list == null) {
                IndexBasedCompletionProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = ContainerUtil.map(this.myIndex.search(searchQuery, parameters.getMaxResults()), r -> new MavenDependencyCompletionItemWithClass(r.getGroupId(), r.getArtifactId(), r.getVersion(), this.resultingType, Collections.singletonList(r.getClassNames())));
        if (list == null) {
            IndexBasedCompletionProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static Query createSearchQuery(@NotNull String str) throws ParseException {
        if (str == null) {
            IndexBasedCompletionProvider.$$$reportNull$$$0(8);
        }
        String[] patterns = str.split("\\.");
        StringBuilder builder = new StringBuilder();
        for (String pattern : patterns) {
            builder.append("c:").append(pattern).append(" OR ");
        }
        builder.append("fc:").append(str);
        return new QueryParser("c", (Analyzer)new StandardAnalyzer()).parse(builder.toString());
    }

    public MavenSearchIndex getIndex() {
        return this.myIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/onlinecompletion/IndexBasedCompletionProvider";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/onlinecompletion/IndexBasedCompletionProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findGroupCandidates";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findArtifactCandidates";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllVersions";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesByString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findClassesByString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSearchQuery";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

