/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.WaitFor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.onlinecompletion.DependencyCompletionProvider;
import org.jetbrains.idea.maven.onlinecompletion.DependencyCompletionProviderFactory;
import org.jetbrains.idea.maven.onlinecompletion.MavenDependencySearchStatisticsCollector;
import org.jetbrains.idea.maven.onlinecompletion.OfflineSearchService;
import org.jetbrains.idea.maven.onlinecompletion.intellij.PackageSearchService;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.maven.onlinecompletion.model.SearchParameters;

@ApiStatus.Experimental
public class DependencySearchService {
    private final Project myProject;
    private final PackageSearchService myPackageSearchService = new PackageSearchService();
    private OfflineSearchService myOfflineSearchService = new OfflineSearchService(Collections.emptyList());
    private volatile long myLastRequestedTime = -1L;

    public DependencySearchService(Project project) {
        this.myProject = project;
        this.reload();
    }

    public OfflineSearchService getOfflineSearchService() {
        return this.myOfflineSearchService;
    }

    public final void reload() {
        ArrayList<DependencyCompletionProvider> providers = new ArrayList<DependencyCompletionProvider>();
        List factoryList = DependencyCompletionProviderFactory.EP_NAME.getExtensionList();
        for (DependencyCompletionProviderFactory factory : factoryList) {
            if (!factory.isApplicable(this.myProject)) continue;
            providers.addAll(factory.getProviders(this.myProject));
        }
        this.myOfflineSearchService = new OfflineSearchService(providers);
    }

    public Promise<Void> fulltextSearch(@NotNull String template, @NotNull SearchParameters parameters, @NotNull Consumer<MavenRepositoryArtifactInfo> consumer) {
        if (template == null) {
            DependencySearchService.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            DependencySearchService.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            DependencySearchService.$$$reportNull$$$0(2);
        }
        if (this.skipRequest(parameters)) {
            return Promises.resolvedPromise(null);
        }
        this.myLastRequestedTime = System.currentTimeMillis();
        MavenDependencyCompletionItem localSearchItem = new MavenDependencyCompletionItem(template);
        CollectingConsumer collectingConsumer = new CollectingConsumer(consumer, parameters);
        Promise<Void> returnPromise = DependencySearchService.createPromiseWithStatisticHandlers(parameters, "fulltext");
        this.searchLocal(parameters, localSearchItem, collectingConsumer);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ProgressManager.checkCanceled();
            Promise<Void> promise = this.myPackageSearchService.fullTextSearch(template, parameters, d -> this.mergeWithVersionsInLocalCache((MavenRepositoryArtifactInfo)d, collectingConsumer));
            DependencySearchService.completeProcess(collectingConsumer, returnPromise, promise);
        });
        return returnPromise;
    }

    private boolean skipRequest(SearchParameters parameters) {
        return System.currentTimeMillis() - this.myLastRequestedTime < (long)parameters.getThrottleTime();
    }

    public Promise<Void> suggestPrefix(@NotNull String groupId, @NotNull String artifactId, @NotNull SearchParameters parameters, @NotNull Consumer<MavenRepositoryArtifactInfo> consumer) {
        if (groupId == null) {
            DependencySearchService.$$$reportNull$$$0(3);
        }
        if (artifactId == null) {
            DependencySearchService.$$$reportNull$$$0(4);
        }
        if (parameters == null) {
            DependencySearchService.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            DependencySearchService.$$$reportNull$$$0(6);
        }
        if (this.skipRequest(parameters)) {
            return Promises.resolvedPromise(null);
        }
        this.myLastRequestedTime = System.currentTimeMillis();
        MavenDependencyCompletionItem localSearchItem = new MavenDependencyCompletionItem(groupId, artifactId, null);
        CollectingConsumer collectingConsumer = new CollectingConsumer(consumer, parameters);
        Promise<Void> returnPromise = DependencySearchService.createPromiseWithStatisticHandlers(parameters, "suggestPrefix");
        this.searchLocal(parameters, localSearchItem, collectingConsumer);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ProgressManager.checkCanceled();
            Promise<Void> promise = this.myPackageSearchService.suggestPrefix(groupId, artifactId, parameters, d -> this.mergeWithVersionsInLocalCache((MavenRepositoryArtifactInfo)d, collectingConsumer));
            DependencySearchService.completeProcess(collectingConsumer, returnPromise, promise);
        });
        return returnPromise;
    }

    private static void completeProcess(CollectingConsumer collectingConsumer, Promise<Void> remotePromise, Promise<Void> promise) {
        promise.onProcessed(v -> collectingConsumer.consumeLocalOnly()).processed(remotePromise);
    }

    private void searchLocal(SearchParameters parameters, MavenDependencyCompletionItem localSearchItem, CollectingConsumer collectingConsumer) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<MavenDependencyCompletionItem> versions = this.getOfflineData((MavenCoordinate)localSearchItem, parameters);
            collectingConsumer.setLocalData(DependencySearchService.convertLocalItemsToArtifactInfo(versions));
        });
    }

    @NotNull
    private static Promise<Void> createPromiseWithStatisticHandlers(SearchParameters parameters, String prefix) {
        AsyncPromise remotePromise = new AsyncPromise();
        long timeStart = System.currentTimeMillis();
        remotePromise.onError(e -> MavenDependencySearchStatisticsCollector.notifyError(prefix, parameters, System.currentTimeMillis() - timeStart, e)).onSuccess(v -> MavenDependencySearchStatisticsCollector.notifySuccess(prefix, parameters, System.currentTimeMillis() - timeStart));
        AsyncPromise asyncPromise = remotePromise;
        if (asyncPromise == null) {
            DependencySearchService.$$$reportNull$$$0(7);
        }
        return asyncPromise;
    }

    private List<MavenDependencyCompletionItem> getOfflineData(MavenCoordinate coordinate, SearchParameters params) {
        if (StringUtil.isNotEmpty((String)coordinate.getVersion())) {
            return this.myOfflineSearchService.findAllVersions(coordinate, params);
        }
        if (StringUtil.isNotEmpty((String)coordinate.getArtifactId())) {
            return this.myOfflineSearchService.findArtifactCandidates(coordinate, params).stream().flatMap(md -> this.myOfflineSearchService.findAllVersions((MavenCoordinate)md, params).stream()).collect(Collectors.toList());
        }
        return this.myOfflineSearchService.findGroupCandidates(coordinate, params).stream().flatMap(md -> this.myOfflineSearchService.findArtifactCandidates((MavenCoordinate)md, params).stream()).flatMap(md -> this.myOfflineSearchService.findAllVersions((MavenCoordinate)md, params).stream()).collect(Collectors.toList());
    }

    private void mergeWithVersionsInLocalCache(MavenRepositoryArtifactInfo artifactInfo, Consumer<MavenRepositoryArtifactInfo> consumer) {
        Map offlineResults = this.myOfflineSearchService.findAllVersions(artifactInfo).stream().filter(v -> v.getVersion() != null).collect(Collectors.toMap(Function.identity(), Function.identity()));
        for (int i = 0; i < artifactInfo.getItems().length; ++i) {
            MavenDependencyCompletionItem replacement = (MavenDependencyCompletionItem)((Object)offlineResults.remove((Object)artifactInfo.getItems()[i]));
            if (replacement == null) continue;
            MavenDependencyCompletionItem old = artifactInfo.getItems()[i];
            artifactInfo.getItems()[i] = new MavenDependencyCompletionItem(old.getGroupId(), old.getArtifactId(), old.getVersion(), old.getPackaging(), old.getClassifier(), replacement.getType());
        }
        if (offlineResults.isEmpty()) {
            consumer.accept(artifactInfo);
        } else {
            MavenDependencyCompletionItem[] newArray = (MavenDependencyCompletionItem[])ArrayUtils.addAll((Object[])artifactInfo.getItems(), (Object[])offlineResults.values().toArray(new MavenDependencyCompletionItem[0]));
            Arrays.sort(newArray, Comparator.comparing(d -> d.getVersion(), VersionComparatorUtil.COMPARATOR.reversed()));
            consumer.accept(new MavenRepositoryArtifactInfo(artifactInfo.getGroupId(), artifactInfo.getArtifactId(), newArray));
        }
    }

    private static List<MavenRepositoryArtifactInfo> convertLocalItemsToArtifactInfo(List<MavenDependencyCompletionItem> items) {
        Map<Pair, List<MavenDependencyCompletionItem>> collect = items.stream().collect(Collectors.groupingBy(i -> new Pair((Object)i.getGroupId(), (Object)i.getArtifactId())));
        List map = ContainerUtil.map(collect.entrySet(), e -> new MavenRepositoryArtifactInfo(true, (String)((Pair)e.getKey()).first, (String)((Pair)e.getKey()).second, ((List)e.getValue()).toArray(new MavenDependencyCompletionItem[0])));
        Collections.sort(map, Comparator.comparing(d -> d.getVersion(), VersionComparatorUtil.COMPARATOR.reversed()));
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/onlinecompletion/DependencySearchService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/onlinecompletion/DependencySearchService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPromiseWithStatisticHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fulltextSearch";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "suggestPrefix";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CollectingConsumer
    implements Consumer<MavenRepositoryArtifactInfo> {
        private final Consumer<MavenRepositoryArtifactInfo> myConsumer;
        private final SearchParameters myParameters;
        private volatile List<MavenRepositoryArtifactInfo> myLocalData;
        private final Set<String> acceptedRemotely = Collections.newSetFromMap(new ConcurrentHashMap());
        private final Set<String> remoteGroups = Collections.newSetFromMap(new ConcurrentHashMap());

        CollectingConsumer(Consumer<MavenRepositoryArtifactInfo> consumer, SearchParameters parameters) {
            this.myConsumer = consumer;
            this.myParameters = parameters;
        }

        public void consumeLocalOnly() {
            new WaitFor((int)this.myParameters.getMillisToWait()){

                protected boolean condition() {
                    ProgressManager.checkCanceled();
                    return myLocalData != null;
                }
            };
            if (this.myLocalData == null) {
                return;
            }
            for (MavenRepositoryArtifactInfo info : this.myLocalData) {
                if (StringUtil.isEmpty((String)info.getArtifactId())) {
                    if (this.remoteGroups.contains(info.getGroupId())) continue;
                    this.myConsumer.accept(info);
                    continue;
                }
                String key = CollectingConsumer.getKey(info);
                if (this.acceptedRemotely.contains(key)) continue;
                this.myConsumer.accept(info);
            }
        }

        public void setLocalData(List<MavenRepositoryArtifactInfo> localData) {
            this.myLocalData = localData == null ? Collections.emptyList() : localData;
        }

        @Override
        public void accept(MavenRepositoryArtifactInfo info) {
            String key = CollectingConsumer.getKey(info);
            this.acceptedRemotely.add(key);
            this.remoteGroups.add(info.getGroupId());
            this.myConsumer.accept(info);
        }

        @NotNull
        private static String getKey(MavenRepositoryArtifactInfo info) {
            String string = info.getGroupId() + ":" + info.getArtifactId();
            if (string == null) {
                CollectingConsumer.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/onlinecompletion/DependencySearchService$CollectingConsumer", "getKey"));
        }
    }
}

