/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.onlinecompletion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;

class DeduplicationCollector<Result extends MavenDependencyCompletionItem>
implements Collector<Result, Map<String, Result>, List<Result>> {
    static final Set<Collector.Characteristics> CHARACTERISTICS = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.UNORDERED));
    private final Function<Result, String> myDeduplicationKey;

    DeduplicationCollector(Function<Result, String> deduplicationKey) {
        this.myDeduplicationKey = deduplicationKey;
    }

    @Override
    public Supplier<Map<String, Result>> supplier() {
        return () -> new HashMap();
    }

    @Override
    public BiConsumer<Map<String, Result>, Result> accumulator() {
        return (m, item) -> {
            String key;
            MavenDependencyCompletionItem present;
            if (item != null && m != null && ((present = (MavenDependencyCompletionItem)((Object)((Object)m.get(key = this.myDeduplicationKey.apply((Result)((Object)item)))))) == null || present.getType().getWeight() < item.getType().getWeight())) {
                m.put(key, item);
            }
        };
    }

    @Override
    public BinaryOperator<Map<String, Result>> combiner() {
        return (m, l) -> {
            for (MavenDependencyCompletionItem item : l.values()) {
                String key = this.myDeduplicationKey.apply((Result)((Object)item));
                MavenDependencyCompletionItem present = (MavenDependencyCompletionItem)((Object)((Object)m.get(key)));
                if (present != null && item.getType() == null || present != null && (present.getType() != null || item.getType() == null) && present.getType().getWeight() >= item.getType().getWeight()) continue;
                m.put(key, item);
            }
            return m;
        };
    }

    @Override
    public Function<Map<String, Result>, List<Result>> finisher() {
        return m -> new ArrayList(m.values());
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return CHARACTERISTICS;
    }
}

