/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.actions;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.MavenDataKeys;

public class MavenRunConfigurationMenu
extends DefaultActionGroup
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MavenRunConfigurationMenu.$$$reportNull$$$0(0);
        }
        for (AnAction action : this.getChildActionsOrStubs()) {
            if (!(action instanceof ExecuteMavenRunConfigurationAction)) continue;
            this.remove(action);
        }
        Project project = e.getProject();
        RunnerAndConfigurationSettings settings = (RunnerAndConfigurationSettings)e.getData(MavenDataKeys.RUN_CONFIGURATION);
        if (settings == null || project == null) {
            return;
        }
        Executor[] executors = ExecutorRegistry.getInstance().getRegisteredExecutors();
        int i = executors.length;
        while (--i >= 0) {
            Executor executor = executors[i];
            if (!executor.isApplicable(project)) continue;
            ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)settings.getConfiguration());
            ExecuteMavenRunConfigurationAction action = new ExecuteMavenRunConfigurationAction(executor, runner != null, settings);
            this.addAction(action, Constraints.FIRST);
        }
        super.update(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/navigator/actions/MavenRunConfigurationMenu", "update"));
    }

    private static class ExecuteMavenRunConfigurationAction
    extends AnAction {
        private final Executor myExecutor;
        private final boolean myEnabled;
        private final RunnerAndConfigurationSettings mySettings;

        ExecuteMavenRunConfigurationAction(Executor executor, boolean enabled, RunnerAndConfigurationSettings settings) {
            super(executor.getActionName(), null, executor.getIcon());
            this.myExecutor = executor;
            this.myEnabled = enabled;
            this.mySettings = settings;
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                ExecuteMavenRunConfigurationAction.$$$reportNull$$$0(0);
            }
            if (this.myEnabled) {
                ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)this.mySettings, (Executor)this.myExecutor);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecuteMavenRunConfigurationAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.myEnabled);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/navigator/actions/MavenRunConfigurationMenu$ExecuteMavenRunConfigurationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

