/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.MavenIndex;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.indices.MavenRepositoryProvider;
import org.jetbrains.idea.maven.indices.MavenSearchIndex;
import org.jetbrains.idea.maven.model.MavenCoordinate;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.onlinecompletion.DependencySearchService;
import org.jetbrains.idea.maven.onlinecompletion.OfflineSearchService;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.SearchParameters;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenSimpleProjectComponent;

public final class MavenProjectIndicesManager
extends MavenSimpleProjectComponent {
    private volatile List<MavenIndex> myProjectIndices = new ArrayList<MavenIndex>();
    private final DependencySearchService myDependencySearchService;
    private final MergingUpdateQueue myUpdateQueue;

    public boolean hasOfflineIndexes() {
        return !this.myProjectIndices.isEmpty();
    }

    public static MavenProjectIndicesManager getInstance(Project p) {
        return (MavenProjectIndicesManager)p.getComponent(MavenProjectIndicesManager.class);
    }

    public MavenProjectIndicesManager(Project project) {
        super(project);
        this.myUpdateQueue = new MavenMergingUpdateQueue(this.getClass().getSimpleName(), 1000, true, (Disposable)project);
        this.myDependencySearchService = new DependencySearchService(project);
        if (!this.isNormalProject()) {
            return;
        }
        this.doInit();
    }

    public void doInit() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleUpdateIndicesList();
        }
        this.getMavenProjectManager().addManagerListener(new MavenProjectsManager.Listener(){

            @Override
            public void activated() {
                MavenProjectIndicesManager.this.scheduleUpdateIndicesList();
            }
        });
        this.getMavenProjectManager().addProjectsTreeListener(new MavenProjectsTree.Listener(){

            @Override
            public void projectsUpdated(@NotNull List<Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
                if (updated == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (deleted == null) {
                    2.$$$reportNull$$$0(1);
                }
                MavenProjectIndicesManager.this.scheduleUpdateIndicesList();
            }

            @Override
            public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges, NativeMavenProjectHolder nativeMavenProject) {
                if (projectWithChanges == null) {
                    2.$$$reportNull$$$0(2);
                }
                MavenProjectIndicesManager.this.scheduleUpdateIndicesList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updated";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "deleted";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectWithChanges";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenProjectIndicesManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectsUpdated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectResolved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void scheduleUpdateIndicesList() {
        this.scheduleUpdateIndicesList(null);
    }

    public void scheduleUpdateIndicesList(final @Nullable Consumer<? super List<MavenIndex>> consumer) {
        this.myUpdateQueue.queue(new Update(this){

            public void run() {
                Set remoteRepositoriesIdsAndUrls = (Set)ReadAction.compute(() -> MavenProjectIndicesManager.this.myProject.isDisposed() ? null : MavenProjectIndicesManager.this.collectRemoteRepositoriesIdsAndUrls());
                File localRepository = (File)ReadAction.compute(() -> MavenProjectIndicesManager.this.myProject.isDisposed() ? null : MavenProjectIndicesManager.this.getLocalRepository());
                if (remoteRepositoriesIdsAndUrls == null || localRepository == null) {
                    return;
                }
                Iterator iterator = remoteRepositoriesIdsAndUrls.iterator();
                while (iterator.hasNext()) {
                    Pair next = (Pair)iterator.next();
                    if (!"central".equals(next.first) && !((String)next.second).contains("repo1.maven.org/maven2")) continue;
                    iterator.remove();
                }
                if (remoteRepositoriesIdsAndUrls.isEmpty()) {
                    MavenProjectIndicesManager.this.myProjectIndices.clear();
                } else {
                    MavenProjectIndicesManager.this.myProjectIndices = MavenIndicesManager.getInstance().ensureIndicesExist(MavenProjectIndicesManager.this.myProject, remoteRepositoriesIdsAndUrls);
                }
                MavenProjectIndicesManager.this.myDependencySearchService.reload();
                if (consumer != null) {
                    consumer.consume((Object)MavenProjectIndicesManager.this.myProjectIndices);
                }
            }
        });
    }

    private File getLocalRepository() {
        return MavenProjectsManager.getInstance(this.myProject).getLocalRepository();
    }

    private Set<Pair<String, String>> collectRemoteRepositoriesIdsAndUrls() {
        THashSet result = new THashSet();
        HashSet<MavenRemoteRepository> remoteRepositories = new HashSet<MavenRemoteRepository>(this.getMavenProjectManager().getRemoteRepositories());
        for (MavenRepositoryProvider repositoryProvider : (MavenRepositoryProvider[])MavenRepositoryProvider.EP_NAME.getExtensions()) {
            ContainerUtil.addAll(remoteRepositories, repositoryProvider.getRemoteRepositories(this.myProject));
        }
        for (MavenRemoteRepository each : remoteRepositories) {
            String id = each.getId();
            String url = each.getUrl();
            result.add(Pair.create((Object)id, (Object)url));
        }
        return result;
    }

    @Deprecated
    public List<MavenIndex> getIndices() {
        return new ArrayList<MavenIndex>(this.myProjectIndices);
    }

    public void scheduleUpdateAll() {
        MavenIndicesManager.getInstance().scheduleUpdate(this.myProject, this.myProjectIndices);
    }

    public void scheduleUpdate(List<MavenIndex> indices) {
        MavenIndicesManager.getInstance().scheduleUpdate(this.myProject, indices);
    }

    public MavenIndicesManager.IndexUpdatingState getUpdatingState(MavenSearchIndex index) {
        return MavenIndicesManager.getInstance().getUpdatingState(index);
    }

    private MavenProjectsManager getMavenProjectManager() {
        return MavenProjectsManager.getInstance(this.myProject);
    }

    public synchronized OfflineSearchService getOfflineSearchService() {
        return this.myDependencySearchService.getOfflineSearchService();
    }

    public synchronized DependencySearchService getDependencySearchService() {
        return this.myDependencySearchService;
    }

    @Deprecated
    public Set<String> getGroupIds() {
        return this.getGroupIds("");
    }

    @Deprecated
    public Set<String> getGroupIds(String pattern) {
        pattern = pattern == null ? "" : pattern;
        return this.getOfflineSearchService().findGroupCandidates((MavenCoordinate)new MavenDependencyCompletionItem(pattern)).stream().map(d -> d.getArtifactId()).collect(Collectors.toSet());
    }

    @Deprecated
    public Set<String> getArtifactIds(String groupId) {
        ProgressIndicatorProvider.checkCanceled();
        return this.getOfflineSearchService().findArtifactCandidates((MavenCoordinate)new MavenDependencyCompletionItem(groupId)).stream().map(d -> d.getArtifactId()).collect(Collectors.toSet());
    }

    @Deprecated
    public Set<String> getVersions(String groupId, String artifactId) {
        ProgressIndicatorProvider.checkCanceled();
        return this.getOfflineSearchService().findAllVersions((MavenCoordinate)new MavenDependencyCompletionItem(groupId, artifactId, null)).stream().map(d -> d.getVersion()).collect(Collectors.toSet());
    }

    @Deprecated
    public boolean hasGroupId(String groupId) {
        if (groupId == null) {
            return false;
        }
        ProgressIndicatorProvider.checkCanceled();
        if (this.hasProjectGroupId(groupId)) {
            return true;
        }
        return this.getOfflineSearchService().findGroupCandidates((MavenCoordinate)new MavenDependencyCompletionItem(groupId)).stream().anyMatch(p -> StringUtil.equals((CharSequence)groupId, (CharSequence)p.getGroupId()));
    }

    @Deprecated
    public boolean hasArtifactId(String groupId, String artifactId) {
        if (groupId == null || artifactId == null) {
            return false;
        }
        ProgressIndicatorProvider.checkCanceled();
        if (this.hasProjectArtifactId(groupId, artifactId)) {
            return true;
        }
        return !this.getOfflineSearchService().findAllVersions((MavenCoordinate)new MavenDependencyCompletionItem(groupId, artifactId, null), SearchParameters.DEFAULT).isEmpty();
    }

    @Deprecated
    public boolean hasVersion(String groupId, String artifactId, String version) {
        if (this.hasProjectVersion(groupId, artifactId, version)) {
            return true;
        }
        ProgressIndicatorProvider.checkCanceled();
        return this.getOfflineSearchService().findAllVersions((MavenCoordinate)new MavenDependencyCompletionItem(groupId, artifactId, null)).stream().anyMatch(s -> version.equals(s.getVersion()));
    }

    private Set<String> getProjectGroupIds() {
        THashSet result = new THashSet();
        for (MavenId each : this.getProjectsIds()) {
            result.add(each.getGroupId());
        }
        return result;
    }

    private Set<String> getProjectArtifactIds(String groupId) {
        THashSet result = new THashSet();
        for (MavenId each : this.getProjectsIds()) {
            if (!groupId.equals(each.getGroupId())) continue;
            result.add(each.getArtifactId());
        }
        return result;
    }

    private Set<String> getProjectVersions(String groupId, String artifactId) {
        THashSet result = new THashSet();
        for (MavenId each : this.getProjectsIds()) {
            if (!groupId.equals(each.getGroupId()) || !artifactId.equals(each.getArtifactId())) continue;
            result.add(each.getVersion());
        }
        return result;
    }

    private boolean hasProjectGroupId(String groupId) {
        return this.getProjectGroupIds().contains(groupId);
    }

    private boolean hasProjectArtifactId(String groupId, String artifactId) {
        return this.getProjectArtifactIds(groupId).contains(artifactId);
    }

    private boolean hasProjectVersion(String groupId, String artifactId, String version) {
        return this.getProjectVersions(groupId, artifactId).contains(version);
    }

    private Set<MavenId> getProjectsIds() {
        THashSet result = new THashSet();
        for (MavenProject each : MavenProjectsManager.getInstance(this.myProject).getProjects()) {
            result.add(each.getMavenId());
        }
        return result;
    }
}

