/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.idea.maven.indices.MavenClassSearchResult;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.indices.MavenSearcher;
import org.jetbrains.idea.maven.onlinecompletion.OfflineSearchService;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItem;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenDependencyCompletionItemWithClass;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.maven.onlinecompletion.model.SearchParameters;

public class MavenClassSearcher
extends MavenSearcher<MavenClassSearchResult> {
    public static final String TERM = "c";

    @Override
    protected List<MavenClassSearchResult> searchImpl(Project project, String pattern, int maxResult) {
        OfflineSearchService service = MavenProjectIndicesManager.getInstance(project).getOfflineSearchService();
        List<MavenDependencyCompletionItemWithClass> items = service.findClassesByString(this.preparePattern(pattern), new SearchParameters(1000, 10000L, true, 300));
        return this.processResults(items, maxResult);
    }

    protected String preparePattern(String pattern) {
        if ((pattern = StringUtil.toLowerCase((String)pattern)).trim().length() == 0) {
            return pattern;
        }
        List parts = StringUtil.split((String)pattern, (String)".");
        StringBuilder newPattern = new StringBuilder();
        for (int i = 0; i < parts.size() - 1; ++i) {
            String each = (String)parts.get(i);
            newPattern.append(each.trim());
            newPattern.append("*.");
        }
        String className = (String)parts.get(parts.size() - 1);
        boolean exactSearch = className.endsWith(" ");
        newPattern.append(className.trim());
        if (!exactSearch) {
            newPattern.append("*");
        }
        return newPattern.toString();
    }

    protected List<MavenClassSearchResult> processResults(List<MavenDependencyCompletionItemWithClass> searchResults, int maxResult) {
        HashMap<String, ArrayList<MavenDependencyCompletionItemWithClass>> classes = new HashMap<String, ArrayList<MavenDependencyCompletionItemWithClass>>();
        for (MavenDependencyCompletionItemWithClass item : searchResults) {
            for (String className : item.getNames()) {
                ArrayList<MavenDependencyCompletionItemWithClass> list = (ArrayList<MavenDependencyCompletionItemWithClass>)classes.get(className);
                if (list == null) {
                    list = new ArrayList<MavenDependencyCompletionItemWithClass>();
                    classes.put(className, list);
                }
                list.add(item);
            }
        }
        ArrayList<MavenClassSearchResult> results = new ArrayList<MavenClassSearchResult>();
        for (Map.Entry entry : classes.entrySet()) {
            String packageName;
            String className;
            int pos = ((String)entry.getKey()).lastIndexOf(".");
            if (pos == -1) {
                packageName = "default package";
                className = (String)entry.getKey();
            } else {
                packageName = ((String)entry.getKey()).substring(0, pos);
                className = ((String)entry.getKey()).substring(pos + 1);
            }
            MavenDependencyCompletionItem firstOfBunch = (MavenDependencyCompletionItem)((Object)((List)entry.getValue()).get(0));
            MavenDependencyCompletionItem[] items = ((List)entry.getValue()).toArray(new MavenDependencyCompletionItem[0]);
            Arrays.sort(items, Comparator.comparing(c -> c.getVersion(), VersionComparatorUtil.COMPARATOR.reversed()));
            MavenClassSearchResult classResult = new MavenClassSearchResult(new MavenRepositoryArtifactInfo(firstOfBunch.getGroupId(), firstOfBunch.getArtifactId(), items), className, packageName);
            results.add(classResult);
        }
        return results;
    }
}

