/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.WaitFor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.indices.MavenSearcher;
import org.jetbrains.idea.maven.onlinecompletion.DependencySearchService;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.maven.onlinecompletion.model.SearchParameters;

public class MavenArtifactSearcher
extends MavenSearcher<MavenArtifactSearchResult> {
    @Override
    protected List<MavenArtifactSearchResult> searchImpl(Project project, String pattern, int maxResult) {
        if (StringUtil.isEmpty((String)pattern)) {
            return Collections.emptyList();
        }
        ArrayList<MavenRepositoryArtifactInfo> searchResults = new ArrayList<MavenRepositoryArtifactInfo>();
        DependencySearchService searchService = MavenProjectIndicesManager.getInstance(project).getDependencySearchService();
        final Promise<Void> asyncPromise = searchService.fulltextSearch(pattern, SearchParameters.DEFAULT, mdci -> searchResults.add((MavenRepositoryArtifactInfo)mdci));
        new WaitFor((int)SearchParameters.DEFAULT.getMillisToWait()){

            protected boolean condition() {
                return asyncPromise.getState() != Promise.State.PENDING;
            }
        };
        return MavenArtifactSearcher.processResults(searchResults);
    }

    private static List<MavenArtifactSearchResult> processResults(List<MavenRepositoryArtifactInfo> searchResults) {
        return ContainerUtil.map(searchResults, MavenArtifactSearchResult::new);
    }
}

