/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.codeInsight.ExternalAnnotationsArtifactsResolver;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.ExternalAnnotationsImporter$postProcess$;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J0\u0010\u0013\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016Jj\u0010\u0014\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0016J\b\u0010\u001f\u001a\u00020\bH\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/idea/maven/importing/ExternalAnnotationsImporter;", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "()V", "myProcessedLibraries", "Ljava/util/HashSet;", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "Lkotlin/collections/HashSet;", "isApplicable", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "postProcess", "", "module", "Lcom/intellij/openapi/module/Module;", "changes", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "modifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "preProcess", "process", "rootModel", "Lorg/jetbrains/idea/maven/importing/MavenRootModelAdapter;", "mavenModel", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "mavenProjectToModuleName", "", "", "postTasks", "", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "processChangedModulesOnly", "Companion", "intellij.maven"})
public final class ExternalAnnotationsImporter
extends MavenImporter {
    private final HashSet<MavenArtifact> myProcessedLibraries;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public boolean isApplicable(@Nullable MavenProject mavenProject) {
        return super.isApplicable(mavenProject) && Registry.is((String)"external.system.import.resolve.annotations");
    }

    @Override
    public boolean processChangedModulesOnly() {
        return false;
    }

    @Override
    public void process(@Nullable IdeModifiableModelsProvider modifiableModelsProvider, @Nullable Module module, @Nullable MavenRootModelAdapter rootModel, @Nullable MavenProjectsTree mavenModel, @Nullable MavenProject mavenProject, @Nullable MavenProjectChanges changes, @Nullable Map<MavenProject, String> mavenProjectToModuleName, @Nullable List<MavenProjectsProcessorTask> postTasks) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void preProcess(@Nullable Module module, @Nullable MavenProject mavenProject, @Nullable MavenProjectChanges changes, @Nullable IdeModifiableModelsProvider modifiableModelsProvider) {
        block6: {
            block5: {
                if (module == null || mavenProject == null) break block5;
                MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(module.getProject());
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(module.project)");
                MavenImportingSettings mavenImportingSettings = mavenProjectsManager.getImportingSettings();
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenImportingSettings, (String)"MavenProjectsManager.get\u2026roject).importingSettings");
                if (mavenImportingSettings.isDownloadAnnotationsAutomatically()) break block6;
            }
            return;
        }
        RemoteRepositoriesConfiguration remoteRepositoriesConfiguration = RemoteRepositoriesConfiguration.getInstance((Project)module.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)remoteRepositoriesConfiguration, (String)"RemoteRepositoriesConfig\u2026tInstance(module.project)");
        RemoteRepositoriesConfiguration repoConfig = remoteRepositoriesConfiguration;
        boolean bl = false;
        HashSet hashSet = new HashSet();
        boolean bl2 = false;
        boolean bl3 = false;
        HashSet $this$apply = hashSet;
        boolean bl42 = false;
        $this$apply.addAll(repoConfig.getRepositories());
        Collection repositories = hashSet;
        List<MavenRemoteRepository> list = mavenProject.getRemoteRepositories();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"mavenProject.remoteRepositories");
        Iterable $this$mapTo$iv = list;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            MavenRemoteRepository bl42 = (MavenRemoteRepository)item$iv;
            Collection collection = repositories;
            boolean bl5 = false;
            void v4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
            String string = v4.getId();
            String string2 = it.getName();
            if (string2 == null) {
                string2 = it.getId();
            }
            RemoteRepositoryDescription remoteRepositoryDescription = new RemoteRepositoryDescription(string, string2, it.getUrl());
            collection.add(remoteRepositoryDescription);
        }
        repoConfig.setRepositories(CollectionsKt.toMutableList((Collection)repositories));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postProcess(@NotNull Module module, @NotNull MavenProject mavenProject, @NotNull MavenProjectChanges changes, @NotNull IdeModifiableModelsProvider modifiableModelsProvider) {
        void count;
        boolean bl;
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkParameterIsNotNull((Object)changes, (String)"changes");
        Intrinsics.checkParameterIsNotNull((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        ExtensionPointName extensionPointName = ExternalAnnotationsArtifactsResolver.EP_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"ExternalAnnotationsArtifactsResolver.EP_NAME");
        List list = extensionPointName.getExtensionList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ExternalAnnotationsArtif\u2026ver.EP_NAME.extensionList");
        ExternalAnnotationsArtifactsResolver externalAnnotationsArtifactsResolver = (ExternalAnnotationsArtifactsResolver)CollectionsKt.firstOrNull((List)list);
        if (externalAnnotationsArtifactsResolver == null) {
            return;
        }
        ExternalAnnotationsArtifactsResolver resolver = externalAnnotationsArtifactsResolver;
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        Project project2 = project;
        boolean bl2 = false;
        Map librariesMap = new LinkedHashMap();
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
        MavenImportingSettings mavenImportingSettings = mavenProjectsManager.getImportingSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenImportingSettings, (String)"MavenProjectsManager.get\u2026roject).importingSettings");
        if (!mavenImportingSettings.isDownloadAnnotationsAutomatically()) {
            return;
        }
        List<MavenArtifact> list2 = mavenProject.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"mavenProject.dependencies");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MavenArtifact)element$iv;
            bl = false;
            MavenArtifact mavenArtifact = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)mavenArtifact, (String)"it");
            Library library = modifiableModelsProvider.getLibraryByName(mavenArtifact.getLibraryName());
            if (library == null) continue;
            librariesMap.put(it, library);
        }
        Map $this$filterKeys$iv = librariesMap;
        boolean $i$f$filterKeys22 = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        it = $this$filterKeys$iv;
        bl = false;
        for (Map.Entry entry$iv : it.entrySet()) {
            MavenArtifact it2 = (MavenArtifact)entry$iv.getKey();
            boolean bl3 = false;
            if (!this.myProcessedLibraries.add(it2)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map toProcess = result$iv;
        if (toProcess.isEmpty()) {
            return;
        }
        int totalSize = toProcess.size();
        Ref.IntRef $i$f$filterKeys22 = new Ref.IntRef();
        $i$f$filterKeys22.element = 0;
        String title$iv = "Resolving external annotations";
        boolean cancellable$iv = true;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, title$iv, cancellable$iv, project2, title$iv, cancellable$iv, toProcess, resolver, project2, (Ref.IntRef)count, totalSize){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $title;
            final /* synthetic */ boolean $cancellable;
            final /* synthetic */ Map $toProcess$inlined;
            final /* synthetic */ ExternalAnnotationsArtifactsResolver $resolver$inlined;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Ref.IntRef $count$inlined;
            final /* synthetic */ int $totalSize$inlined;
            {
                this.$project = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                this.$cancellable = $captured_local_variable$3;
                this.$toProcess$inlined = map;
                this.$resolver$inlined = externalAnnotationsArtifactsResolver;
                this.$project$inlined = project;
                this.$count$inlined = intRef;
                this.$totalSize$inlined = n;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                ProgressIndicator indicator2 = indicator;
                boolean bl = false;
                indicator2.setIndeterminate(false);
                this.$toProcess$inlined.forEach((BiConsumer)new BiConsumer<MavenArtifact, Library>(indicator2, this){
                    final /* synthetic */ ProgressIndicator $indicator;
                    final /* synthetic */ postProcess$$inlined$runBackgroundableTask$1 this$0;
                    {
                        this.$indicator = progressIndicator;
                        this.this$0 = var2_2;
                    }

                    public final void accept(@NotNull MavenArtifact mavenArtifact, @NotNull Library library) {
                        Intrinsics.checkParameterIsNotNull((Object)mavenArtifact, (String)"mavenArtifact");
                        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
                        if (this.$indicator.isCanceled()) {
                            return;
                        }
                        this.$indicator.setText("Looking for annotations for '" + mavenArtifact.getLibraryName() + '\'');
                        String mavenId = mavenArtifact.getGroupId() + ':' + mavenArtifact.getArtifactId() + ':' + mavenArtifact.getVersion();
                        this.this$0.$resolver$inlined.resolve(this.this$0.$project$inlined, library, mavenId);
                        Ref.IntRef intRef = this.this$0.$count$inlined;
                        ++intRef.element;
                        this.$indicator.setFraction((double)intRef.element / (double)this.this$0.$totalSize$inlined);
                    }
                });
            }
        });
    }

    public ExternalAnnotationsImporter() {
        super("org.apache.maven.plugins", "maven-compiler-plugin");
        ExternalAnnotationsImporter externalAnnotationsImporter = this;
        boolean bl = false;
        HashSet hashSet = new HashSet();
        externalAnnotationsImporter.myProcessedLibraries = hashSet;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ExternalAnnotationsImporter.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Exter\u2026ionsImporter::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/importing/ExternalAnnotationsImporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.maven"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

