/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.parsers;

import com.intellij.build.events.MessageEvent;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.externalSystemIntegration.output.LogMessageType;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenLogEntryReader;
import org.jetbrains.idea.maven.externalSystemIntegration.output.parsers.MessageNotifier;

public class ErrorNotifier
extends MessageNotifier {
    private final Set<String> myMessagesToSkip = new HashSet<String>();

    public ErrorNotifier() {
        super(LogMessageType.ERROR, MessageEvent.Kind.ERROR, "Error");
        this.myMessagesToSkip.add("one error found");
        this.myMessagesToSkip.add("two errors found");
        this.myMessagesToSkip.add("COMPILATION ERROR :");
    }

    @Override
    @NotNull
    protected String getMessage(String line, List<MavenLogEntryReader.MavenLogEntry> toConcat) {
        String message = super.getMessage(line, toConcat);
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            if ("" == null) {
                ErrorNotifier.$$$reportNull$$$0(0);
            }
            return "";
        }
        if (this.myMessagesToSkip.contains((message = message.replace("-> [Help 1]", "")).trim())) {
            if ("" == null) {
                ErrorNotifier.$$$reportNull$$$0(1);
            }
            return "";
        }
        String string = message;
        if (string == null) {
            ErrorNotifier.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/externalSystemIntegration/output/parsers/ErrorNotifier", "getMessage"));
    }
}

