/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExecutor;
import org.jetbrains.idea.maven.execution.MavenExternalExecutor;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.SoutMavenConsole;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;

@State(name="MavenRunner", storages={@Storage(value="$WORKSPACE_FILE$")})
public class MavenRunner
implements PersistentStateComponent<MavenRunnerSettings> {
    private static final Logger LOG = Logger.getInstance(MavenRunner.class);
    private MavenRunnerSettings mySettings = new MavenRunnerSettings();
    private final Project myProject;

    public static MavenRunner getInstance(Project project) {
        return (MavenRunner)ServiceManager.getService((Project)project, MavenRunner.class);
    }

    public MavenRunner(Project project) {
        this.myProject = project;
    }

    public MavenRunnerSettings getSettings() {
        return this.mySettings;
    }

    @NotNull
    public MavenRunnerSettings getState() {
        MavenRunnerSettings mavenRunnerSettings = this.mySettings;
        if (mavenRunnerSettings == null) {
            MavenRunner.$$$reportNull$$$0(0);
        }
        return mavenRunnerSettings;
    }

    public void loadState(@NotNull MavenRunnerSettings settings) {
        if (settings == null) {
            MavenRunner.$$$reportNull$$$0(1);
        }
        this.mySettings = settings;
    }

    public void run(MavenRunnerParameters parameters, final MavenRunnerSettings settings, final Runnable onComplete) {
        FileDocumentManager.getInstance().saveAllDocuments();
        final MavenConsole console = MavenRunner.createConsole(this.myProject, parameters.getWorkingDirPath(), StringUtil.join(parameters.getGoals(), (String)", "), 0L);
        try {
            final MavenExecutor executor = this.createExecutor(parameters, null, settings, console);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, executor.getCaption(), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        try {
                            if (executor.execute(indicator) && onComplete != null) {
                                onComplete.run();
                            }
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            // empty catch block
                        }
                        MavenRunner.this.updateTargetFolders();
                    }
                    finally {
                        console.finish();
                    }
                }

                @NotNull
                public Task.NotificationInfo getNotificationInfo() {
                    Task.NotificationInfo notificationInfo = new Task.NotificationInfo("Maven", "Maven Task Finished", "");
                    if (notificationInfo == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return notificationInfo;
                }

                public boolean shouldStartInBackground() {
                    return settings.isRunMavenInBackground();
                }

                public void processSentToBackground() {
                    settings.setRunMavenInBackground(true);
                }

                public void processRestoredToForeground() {
                    settings.setRunMavenInBackground(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunner$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunner$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNotificationInfo";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "run";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
        catch (Exception e) {
            console.printException(e);
            console.finish();
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    public boolean runBatch(List<MavenRunnerParameters> commands, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, @Nullable String action, @Nullable ProgressIndicator indicator) {
        if (commands.isEmpty()) {
            return true;
        }
        return this.runBatch(commands, coreSettings, runnerSettings, action, indicator, MavenRunner.createConsole(this.myProject, this.myProject.getBasePath(), "Maven Batch", 0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runBatch(List<MavenRunnerParameters> commands, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, @Nullable String action, @Nullable ProgressIndicator indicator, @NotNull MavenConsole mavenConsole) {
        if (mavenConsole == null) {
            MavenRunner.$$$reportNull$$$0(2);
        }
        LOG.assertTrue(!ApplicationManager.getApplication().isReadAccessAllowed());
        if (commands.isEmpty()) {
            return true;
        }
        try {
            int count = 0;
            for (MavenRunnerParameters command : commands) {
                MavenExecutor executor;
                if (indicator != null) {
                    indicator.setFraction((double)count++ / (double)commands.size());
                }
                if ((executor = (MavenExecutor)ReadAction.compute(() -> {
                    if (this.myProject.isDisposed()) {
                        return null;
                    }
                    return this.createExecutor(command, coreSettings, runnerSettings, mavenConsole);
                })) == null) break;
                executor.setAction(action);
                if (executor.execute(indicator)) continue;
                this.updateTargetFolders();
                boolean bl = false;
                return bl;
            }
            this.updateTargetFolders();
        }
        finally {
            mavenConsole.finish();
        }
        return true;
    }

    public static MavenConsole createConsole(@NotNull Project project, @NotNull String workingDirPath, @NotNull String title, long executionId) {
        boolean isDisposed;
        if (project == null) {
            MavenRunner.$$$reportNull$$$0(3);
        }
        if (workingDirPath == null) {
            MavenRunner.$$$reportNull$$$0(4);
        }
        if (title == null) {
            MavenRunner.$$$reportNull$$$0(5);
        }
        if (isDisposed = ((Boolean)ReadAction.compute(() -> project.isDisposed())).booleanValue()) {
            return null;
        }
        return MavenRunner.doCreateConsole(title, workingDirPath, project, executionId);
    }

    private void updateTargetFolders() {
        if (this.myProject.isDisposed()) {
            return;
        }
        MavenProjectsManager.getInstance(this.myProject).updateProjectTargetFolders();
    }

    private static MavenConsole doCreateConsole(@NotNull String title, @NotNull String workingDirPath, Project project, long executionId) {
        if (title == null) {
            MavenRunner.$$$reportNull$$$0(6);
        }
        if (workingDirPath == null) {
            MavenRunner.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new SoutMavenConsole();
        }
        AtomicReference result = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> result.set(MavenConsole.createGuiMavenConsole(project, title, workingDirPath, ToolWindowId.RUN, executionId)));
        return (MavenConsole)result.get();
    }

    private MavenExecutor createExecutor(MavenRunnerParameters taskParameters, @Nullable MavenGeneralSettings coreSettings, @Nullable MavenRunnerSettings runnerSettings, @NotNull MavenConsole console) {
        if (console == null) {
            MavenRunner.$$$reportNull$$$0(8);
        }
        return new MavenExternalExecutor(this.myProject, taskParameters, coreSettings, runnerSettings, console);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenConsole";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runBatch";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCreateConsole";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

