/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.Filterable;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteConnectionCreator;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.buildtool.BuildToolConsoleProcessAdapter;
import org.jetbrains.idea.maven.buildtool.BuildViewMavenConsole;
import org.jetbrains.idea.maven.buildtool.MavenBuildEventProcessor;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPropertyResolver;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.execution.MavenApplicationConfigurationExecutionEnvironmentProvider;
import org.jetbrains.idea.maven.execution.MavenExternalExecutor;
import org.jetbrains.idea.maven.execution.MavenExternalParameters;
import org.jetbrains.idea.maven.execution.MavenResumeAction;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerParametersSettingEditor;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.MavenRunnerSettingsEditor;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenGeneralSettingsEditor;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenRunConfiguration
extends LocatableConfigurationBase
implements ModuleRunProfile {
    private MavenSettings mySettings;

    protected MavenRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
        this.mySettings = new MavenSettings(project);
    }

    public MavenRunConfiguration clone() {
        MavenRunConfiguration clone = (MavenRunConfiguration)super.clone();
        clone.mySettings = this.mySettings.clone();
        return clone;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(RunnerBundle.message("maven.runner.parameters.title", new Object[0]), (SettingsEditor)new MavenRunnerParametersSettingEditor(this.getProject()));
        group.addEditor(ProjectBundle.message("maven.tab.general", new Object[0]), (SettingsEditor)new MavenGeneralSettingsEditor(this.getProject()));
        group.addEditor(RunnerBundle.message("maven.tab.runner", new Object[0]), (SettingsEditor)new MavenRunnerSettingsEditor(this.getProject()));
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            MavenRunConfiguration.$$$reportNull$$$0(0);
        }
        return settingsEditorGroup;
    }

    public JavaParameters createJavaParameters(@Nullable Project project) throws ExecutionException {
        return MavenExternalParameters.createJavaParameters(project, this.mySettings.myRunnerParameters, this.mySettings.myGeneralSettings, this.mySettings.myRunnerSettings, this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            MavenRunConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            MavenRunConfiguration.$$$reportNull$$$0(2);
        }
        return new JavaCommandLineStateImpl(env, this.getName());
    }

    @NotNull
    public RemoteConnectionCreator createRemoteConnectionCreator(JavaParameters javaParameters) {
        ExecRemoteConnectionCreator execRemoteConnectionCreator = new ExecRemoteConnectionCreator(javaParameters, this);
        if (execRemoteConnectionCreator == null) {
            MavenRunConfiguration.$$$reportNull$$$0(3);
        }
        return execRemoteConnectionCreator;
    }

    private void updateProjectsFolders() {
        MavenProjectsManager.getInstance(this.getProject()).updateProjectTargetFolders();
    }

    @Nullable
    public MavenGeneralSettings getGeneralSettings() {
        return this.mySettings.myGeneralSettings;
    }

    public void setGeneralSettings(@Nullable MavenGeneralSettings settings) {
        this.mySettings.myGeneralSettings = settings;
    }

    @Nullable
    public MavenRunnerSettings getRunnerSettings() {
        return this.mySettings.myRunnerSettings;
    }

    public void setRunnerSettings(@Nullable MavenRunnerSettings settings) {
        this.mySettings.myRunnerSettings = settings;
    }

    public MavenRunnerParameters getRunnerParameters() {
        return this.mySettings.myRunnerParameters;
    }

    public void setRunnerParameters(MavenRunnerParameters p) {
        this.mySettings.myRunnerParameters = p;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            MavenRunConfiguration.$$$reportNull$$$0(4);
        }
        super.readExternal(element);
        Element mavenSettingsElement = element.getChild("MavenSettings");
        if (mavenSettingsElement != null) {
            this.mySettings = (MavenSettings)XmlSerializer.deserialize((Element)mavenSettingsElement, MavenSettings.class);
            if (this.mySettings.myRunnerParameters == null) {
                this.mySettings.myRunnerParameters = new MavenRunnerParameters();
            }
            this.mySettings.myRunnerParameters.fixAfterLoadingFromOldFormat();
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            MavenRunConfiguration.$$$reportNull$$$0(5);
        }
        super.writeExternal(element);
        element.addContent(XmlSerializer.serialize((Object)this.mySettings));
    }

    public String suggestedName() {
        return MavenRunConfigurationType.generateName(this.getProject(), this.mySettings.myRunnerParameters);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteConnectionCreator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MavenHandlerFilterSpyWrapper
    extends ProcessHandler {
        private final ProcessHandler myOriginalHandler;

        MavenHandlerFilterSpyWrapper(ProcessHandler original) {
            this.myOriginalHandler = original;
        }

        protected void destroyProcessImpl() {
            this.myOriginalHandler.destroyProcess();
        }

        protected void detachProcessImpl() {
            this.myOriginalHandler.detachProcess();
        }

        public boolean detachIsDefault() {
            return this.myOriginalHandler.detachIsDefault();
        }

        @Nullable
        public OutputStream getProcessInput() {
            return this.myOriginalHandler.getProcessInput();
        }

        public void addProcessListener(ProcessListener listener) {
            this.myOriginalHandler.addProcessListener(this.filtered(listener));
        }

        public void addProcessListener(@NotNull ProcessListener listener, @NotNull Disposable parentDisposable) {
            if (listener == null) {
                MavenHandlerFilterSpyWrapper.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                MavenHandlerFilterSpyWrapper.$$$reportNull$$$0(1);
            }
            this.myOriginalHandler.addProcessListener(this.filtered(listener), parentDisposable);
        }

        private ProcessListener filtered(ProcessListener listener) {
            return new ProcessListenerWithFilteredSpyOutput(listener);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentDisposable";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenHandlerFilterSpyWrapper";
            objectArray[2] = "addProcessListener";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class ProcessListenerWithFilteredSpyOutput
        implements ProcessListener {
            private final ProcessListener myListener;
            private final MavenExternalExecutor.MavenSimpleConsoleEventsBuffer mySimpleConsoleEventsBuffer;

            ProcessListenerWithFilteredSpyOutput(ProcessListener listener) {
                this.myListener = listener;
                this.mySimpleConsoleEventsBuffer = new MavenExternalExecutor.MavenSimpleConsoleEventsBuffer((l, k) -> this.myListener.onTextAvailable(new ProcessEvent((ProcessHandler)MavenHandlerFilterSpyWrapper.this, l), k), Registry.is((String)"maven.spy.events.debug"));
            }

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(0);
                }
                this.myListener.startNotified(event);
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(1);
                }
                this.myListener.processTerminated(event);
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(2);
                }
                this.myListener.processWillTerminate(event, willBeDestroyed);
            }

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(3);
                }
                if (outputType == null) {
                    ProcessListenerWithFilteredSpyOutput.$$$reportNull$$$0(4);
                }
                this.mySimpleConsoleEventsBuffer.addText(event.getText(), outputType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$MavenHandlerFilterSpyWrapper$ProcessListenerWithFilteredSpyOutput";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class JavaCommandLineStateImpl
    extends JavaCommandLineState
    implements RemoteConnectionCreator {
        private final String myName;
        private RemoteConnectionCreator myRemoteConnectionCreator;

        protected JavaCommandLineStateImpl(ExecutionEnvironment environment, String name) {
            if (environment == null) {
                JavaCommandLineStateImpl.$$$reportNull$$$0(0);
            }
            super(environment);
            this.myName = name;
        }

        protected JavaParameters createJavaParameters() throws ExecutionException {
            return MavenRunConfiguration.this.createJavaParameters(this.getEnvironment().getProject());
        }

        @NotNull
        public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
            AnAction[] anActionArray;
            DefaultBuildDescriptor descriptor;
            if (executor == null) {
                JavaCommandLineStateImpl.$$$reportNull$$$0(1);
            }
            if (runner == null) {
                JavaCommandLineStateImpl.$$$reportNull$$$0(2);
            }
            OSProcessHandler processHandler = this.startProcess();
            ExternalSystemTaskId taskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)MavenRunConfiguration.this.getProject());
            BuildView buildView = this.createBuildView(executor, taskId, (BuildDescriptor)(descriptor = new DefaultBuildDescriptor((Object)taskId, this.myName, this.getEnvironment().getProject().getBasePath(), System.currentTimeMillis())));
            if (buildView == null) {
                MavenLog.LOG.warn("buildView is null for " + this.myName);
            }
            MavenParsingContext context = this.initializeParsersAndAttachToProcess(buildView, taskId, (BuildDescriptor)descriptor, (ProcessHandler)processHandler);
            if (buildView != null) {
                AnAction[] anActionArray2 = new AnAction[1];
                anActionArray = anActionArray2;
                anActionArray2[0] = BuildTreeFilters.createFilteringActionsGroup((Filterable)buildView);
            } else {
                anActionArray = AnAction.EMPTY_ARRAY;
            }
            AnAction[] actions = anActionArray;
            DefaultExecutionResult res = new DefaultExecutionResult((ExecutionConsole)buildView, (ProcessHandler)processHandler, actions);
            if (MavenResumeAction.isApplicable(this.getEnvironment().getProject(), this.getJavaParameters(), MavenRunConfiguration.this)) {
                MavenResumeAction resumeAction = new MavenResumeAction(res.getProcessHandler(), runner, this.getEnvironment(), context);
                res.setRestartActions(new AnAction[]{resumeAction});
            }
            DefaultExecutionResult defaultExecutionResult = res;
            if (defaultExecutionResult == null) {
                JavaCommandLineStateImpl.$$$reportNull$$$0(3);
            }
            return defaultExecutionResult;
        }

        @Contract(value="null, _, _, _ -> null;_, _, _,_ -> _")
        @Nullable
        private MavenParsingContext initializeParsersAndAttachToProcess(@Nullable BuildView buildView, @NotNull ExternalSystemTaskId taskId, @NotNull BuildDescriptor descriptor, @NotNull ProcessHandler processHandler) throws ExecutionException {
            if (taskId == null) {
                JavaCommandLineStateImpl.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                JavaCommandLineStateImpl.$$$reportNull$$$0(5);
            }
            if (processHandler == null) {
                JavaCommandLineStateImpl.$$$reportNull$$$0(6);
            }
            if (buildView == null) {
                return null;
            }
            MavenBuildEventProcessor eventProcessor = new MavenBuildEventProcessor(MavenRunConfiguration.this.getProject(), MavenRunConfiguration.this.getProject().getBasePath(), (BuildProgressListener)buildView, descriptor, taskId);
            processHandler.addProcessListener((ProcessListener)new BuildToolConsoleProcessAdapter(eventProcessor, true));
            buildView.attachToProcess((ProcessHandler)new MavenHandlerFilterSpyWrapper(processHandler));
            return eventProcessor.getParsingContext();
        }

        @Nullable
        private BuildView createBuildView(@NotNull Executor executor, @NotNull ExternalSystemTaskId taskId, @NotNull BuildDescriptor descriptor) throws ExecutionException {
            ConsoleView console;
            if (executor == null) {
                JavaCommandLineStateImpl.$$$reportNull$$$0(7);
            }
            if (taskId == null) {
                JavaCommandLineStateImpl.$$$reportNull$$$0(8);
            }
            if (descriptor == null) {
                JavaCommandLineStateImpl.$$$reportNull$$$0(9);
            }
            if ((console = super.createConsole(executor)) == null) {
                return null;
            }
            return BuildViewMavenConsole.createBuildView(MavenRunConfiguration.this.getProject(), (ExecutionConsole)console, descriptor);
        }

        @NotNull
        protected OSProcessHandler startProcess() throws ExecutionException {
            ColoredProcessHandler result = new ColoredProcessHandler(this.createCommandLine()){

                @NotNull
                protected BaseOutputReader.Options readerOptions() {
                    BaseOutputReader.Options options = new BaseOutputReader.Options(){

                        public BaseDataReader.SleepingPolicy policy() {
                            return BaseDataReader.SleepingPolicy.BLOCKING;
                        }

                        public boolean splitToLines() {
                            return true;
                        }

                        public boolean sendIncompleteLines() {
                            return true;
                        }
                    };
                    if (options == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return options;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunConfiguration$JavaCommandLineStateImpl$1", "readerOptions"));
                }
            };
            result.setShouldDestroyProcessRecursively(true);
            result.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    MavenRunConfiguration.this.updateProjectsFolders();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/maven/execution/MavenRunConfiguration$JavaCommandLineStateImpl$2", "processTerminated"));
                }
            });
            ColoredProcessHandler coloredProcessHandler = result;
            if (coloredProcessHandler == null) {
                JavaCommandLineStateImpl.$$$reportNull$$$0(10);
            }
            return coloredProcessHandler;
        }

        public RemoteConnectionCreator getRemoteConnectionCreator() {
            if (this.myRemoteConnectionCreator == null) {
                try {
                    this.myRemoteConnectionCreator = MavenRunConfiguration.this.createRemoteConnectionCreator(this.getJavaParameters());
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("Cannot create java parameters", e);
                }
            }
            return this.myRemoteConnectionCreator;
        }

        @Nullable
        public RemoteConnection createRemoteConnection(ExecutionEnvironment environment) {
            return this.getRemoteConnectionCreator().createRemoteConnection(environment);
        }

        public boolean isPollConnection() {
            return this.getRemoteConnectionCreator().isPollConnection();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
                case 3: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$JavaCommandLineStateImpl";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskId";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunConfiguration$JavaCommandLineStateImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "execute";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startProcess";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 3: 
                case 10: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "initializeParsersAndAttachToProcess";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createBuildView";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ExecRemoteConnectionCreator
    implements RemoteConnectionCreator {
        private static final Pattern EXEC_MAVEN_PLUGIN_PATTERN = Pattern.compile("org[.]codehaus[.]mojo:exec-maven-plugin(:[\\d.]+)?:exec");
        private final JavaParameters myJavaParameters;
        private final MavenRunConfiguration myRunConfiguration;

        ExecRemoteConnectionCreator(JavaParameters javaParameters, MavenRunConfiguration runConfiguration) {
            this.myJavaParameters = javaParameters;
            this.myRunConfiguration = runConfiguration;
        }

        @Nullable
        public RemoteConnection createRemoteConnection(ExecutionEnvironment environment) {
            RemoteConnection connection;
            ParametersList programParametersList = this.myJavaParameters.getProgramParametersList();
            boolean execGoal = programParametersList.getList().stream().anyMatch(parameter -> parameter.equals("exec:exec") || EXEC_MAVEN_PLUGIN_PATTERN.matcher((CharSequence)parameter).matches());
            if (!execGoal) {
                return null;
            }
            Project project = this.myRunConfiguration.getProject();
            MavenRunnerParameters runnerParameters = this.myRunConfiguration.getRunnerParameters();
            JavaParameters parameters = new JavaParameters();
            try {
                parameters.setJdk(JavaParametersUtil.createProjectJdk((Project)project, null));
                connection = DebuggerManagerImpl.createDebugParameters((JavaParameters)parameters, (boolean)false, (int)DebuggerSettings.getInstance().getTransport(), (String)"", (boolean)false);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Cannot create debug connection", e);
            }
            String execArgsPrefix = "-Dexec.args=";
            int execArgsIndex = ContainerUtil.indexOf((List)programParametersList.getList(), s -> s.startsWith(execArgsPrefix));
            String execArgsStr = execArgsIndex != -1 ? programParametersList.get(execArgsIndex).substring(execArgsPrefix.length()) : ExecRemoteConnectionCreator.getExecArgsFromPomXml(project, runnerParameters);
            ParametersList execArgs = new ParametersList();
            execArgs.addAll(MavenApplicationConfigurationExecutionEnvironmentProvider.patchVmParameters(parameters.getVMParametersList()));
            execArgs.addParametersString(execArgsStr);
            String classPath = FileUtil.toSystemDependentName((String)parameters.getClassPath().getPathsString());
            if (StringUtil.isNotEmpty((String)classPath)) {
                ExecRemoteConnectionCreator.appendToClassPath(execArgs, classPath);
            }
            String execArgsCommandLineArg = execArgsPrefix + execArgs.getParametersString();
            if (execArgsIndex != -1) {
                programParametersList.set(execArgsIndex, execArgsCommandLineArg);
            } else {
                programParametersList.add(execArgsCommandLineArg);
            }
            return connection;
        }

        public boolean isPollConnection() {
            return true;
        }

        private static String getExecArgsFromPomXml(Project project, MavenRunnerParameters runnerParameters) {
            MavenDomProjectModel projectModel;
            String pomFileName;
            VirtualFile pomFile;
            VirtualFile workingDir = VfsUtil.findFileByIoFile((File)runnerParameters.getWorkingDirFile(), (boolean)false);
            if (workingDir != null && (pomFile = workingDir.findChild(pomFileName = StringUtil.defaultIfEmpty((String)runnerParameters.getPomFileName(), (String)"pom.xml"))) != null && (projectModel = MavenDomUtil.getMavenDomProjectModel(project, pomFile)) != null) {
                return StringUtil.notNullize((String)MavenPropertyResolver.resolve("${exec.args}", projectModel));
            }
            return "";
        }

        private static void appendToClassPath(ParametersList execArgs, String classPath) {
            List execArgsList = execArgs.getList();
            int classPathIndex = execArgsList.indexOf("-classpath");
            if (classPathIndex == -1) {
                classPathIndex = execArgsList.indexOf("-cp");
            }
            if (classPathIndex == -1) {
                execArgs.prependAll(new String[]{"-classpath", "%classpath" + File.pathSeparator + classPath});
            } else if (classPathIndex + 1 == execArgsList.size()) {
                execArgs.add("%classpath" + File.pathSeparator + classPath);
            } else {
                String oldClassPath = execArgs.get(classPathIndex + 1);
                execArgs.set(classPathIndex + 1, oldClassPath + File.pathSeparator + classPath);
            }
        }
    }

    public static class MavenSettings
    implements Cloneable {
        public static final String TAG = "MavenSettings";
        public MavenGeneralSettings myGeneralSettings;
        public MavenRunnerSettings myRunnerSettings;
        public MavenRunnerParameters myRunnerParameters;

        public MavenSettings() {
        }

        public MavenSettings(Project project) {
            this(null, null, new MavenRunnerParameters());
        }

        private MavenSettings(@Nullable MavenGeneralSettings cs, @Nullable MavenRunnerSettings rs, MavenRunnerParameters rp) {
            this.myGeneralSettings = cs == null ? null : cs.clone();
            this.myRunnerSettings = rs == null ? null : rs.clone();
            this.myRunnerParameters = rp.clone();
        }

        protected MavenSettings clone() {
            return new MavenSettings(this.myGeneralSettings, this.myRunnerSettings, this.myRunnerParameters);
        }
    }
}

