/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.ide.actions.runAnything.RunAnythingUtil;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProviderBase;
import com.intellij.ide.actions.runAnything.items.RunAnythingHelpItem;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import icons.OpenapiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenCommandLineOptions;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.RunAnythingMavenItem;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;

public class MavenRunAnythingProvider
extends RunAnythingProviderBase<String> {
    public static final String HELP_COMMAND = "mvn";

    @NotNull
    public RunAnythingItem getMainListItem(@NotNull DataContext dataContext, @NotNull String value) {
        if (dataContext == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(0);
        }
        if (value == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(1);
        }
        RunAnythingMavenItem runAnythingMavenItem = new RunAnythingMavenItem(this.getCommand(value), this.getIcon(value));
        if (runAnythingMavenItem == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(2);
        }
        return runAnythingMavenItem;
    }

    @NotNull
    public Collection<String> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        Module module;
        Project project;
        MavenProjectsManager projectsManager;
        if (dataContext == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(4);
        }
        if (!(projectsManager = MavenProjectsManager.getInstance(project = RunAnythingUtil.fetchProject((DataContext)dataContext))).isMavenizedProject()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenRunAnythingProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (this.getHelpCommand().startsWith(pattern)) {
            pattern = this.getHelpCommand();
        } else if (!pattern.startsWith(this.getHelpCommand())) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                MavenRunAnythingProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<MavenProject> mavenProjects = projectsManager.getRootProjects();
        boolean onlyOneMavenProject = mavenProjects.size() == 1;
        ArrayList<String> values = new ArrayList<String>();
        List params = StringUtil.split((String)pattern, (String)" ").stream().skip(1L).map(String::trim).collect(Collectors.toList());
        if (!onlyOneMavenProject && (params.isEmpty() || params.size() == 1 && !pattern.endsWith(" "))) {
            for (MavenProject mavenProject : mavenProjects) {
                Module module2 = projectsManager.findModule(mavenProject);
                if (module2 == null) continue;
                values.add(this.getHelpCommand() + " " + module2.getName());
            }
            if (params.isEmpty()) {
                ArrayList<String> arrayList = values;
                if (arrayList == null) {
                    MavenRunAnythingProvider.$$$reportNull$$$0(7);
                }
                return arrayList;
            }
        }
        Module module3 = module = onlyOneMavenProject ? projectsManager.findModule(mavenProjects.get(0)) : ModuleManager.getInstance((Project)project).findModuleByName((String)params.get(0));
        if (module != null) {
            MavenProject mavenProject;
            MavenProject mavenProject2 = mavenProject = onlyOneMavenProject ? mavenProjects.get(0) : projectsManager.findProject(module);
            if (mavenProject != null) {
                String prefix = StringUtil.notNullize((String)StringUtil.substringBeforeLast((String)pattern, (String)" "), (String)this.getHelpCommand()).trim() + " ";
                if (!onlyOneMavenProject && prefix.trim().equals(this.getHelpCommand())) {
                    prefix = prefix + module.getName() + " ";
                }
                if (pattern.startsWith(prefix) && StringUtil.trimStart((String)pattern, (String)prefix).startsWith("-")) {
                    boolean longName = StringUtil.trimStart((String)pattern, (String)prefix).startsWith("--");
                    Set options = params.stream().skip(onlyOneMavenProject ? 0L : 1L).map(MavenCommandLineOptions::findOption).filter(option -> option != null).collect(Collectors.toSet());
                    for (MavenCommandLineOptions.Option option2 : MavenCommandLineOptions.getAllOptions()) {
                        if (options.contains(option2)) continue;
                        values.add(prefix + option2.getName(longName));
                    }
                    Collections.sort(values, String::compareToIgnoreCase);
                } else {
                    HashSet goals = new HashSet(params.subList(onlyOneMavenProject ? 0 : 1, params.size()));
                    for (String phase : MavenConstants.BASIC_PHASES) {
                        if (goals.contains(phase)) continue;
                        values.add(prefix + phase);
                    }
                    for (MavenPlugin mavenPlugin : mavenProject.getDeclaredPlugins()) {
                        MavenPluginInfo pluginInfo = MavenArtifactUtil.readPluginInfo(projectsManager.getLocalRepository(), mavenPlugin.getMavenId());
                        if (pluginInfo == null) continue;
                        for (MavenPluginInfo.Mojo mojo2 : pluginInfo.getMojos()) {
                            if (goals.contains(mojo2.getDisplayName())) continue;
                            values.add(prefix + mojo2.getDisplayName());
                        }
                    }
                }
            }
        }
        ArrayList<String> arrayList = values;
        if (arrayList == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    public String findMatchingValue(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(9);
        }
        if (pattern == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(10);
        }
        return pattern.startsWith(this.getHelpCommand()) ? this.getCommand(pattern) : null;
    }

    @NotNull
    public String getCommand(@NotNull String value) {
        if (value == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(11);
        }
        String string = value;
        if (string == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getHelpCommand() {
        if (HELP_COMMAND == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(13);
        }
        return HELP_COMMAND;
    }

    @Nullable
    public Icon getHelpIcon() {
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    @Nullable
    public String getHelpGroupTitle() {
        return "Maven";
    }

    @Nullable
    public Icon getIcon(@NotNull String value) {
        if (value == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(14);
        }
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    @NotNull
    public String getCompletionGroupTitle() {
        if ("Maven goals" == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(15);
        }
        return "Maven goals";
    }

    @Nullable
    public RunAnythingHelpItem getHelpItem(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(16);
        }
        String placeholder = this.getHelpCommandPlaceholder(dataContext);
        String commandPrefix = this.getHelpCommand();
        return new RunAnythingHelpItem(placeholder, commandPrefix, this.getHelpDescription(), this.getHelpIcon());
    }

    @NotNull
    public String getHelpCommandPlaceholder() {
        String string = this.getHelpCommandPlaceholder(null);
        if (string == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(17);
        }
        return string;
    }

    public String getHelpCommandPlaceholder(@Nullable DataContext dataContext) {
        Project project;
        MavenProjectsManager projectsManager;
        if (dataContext != null && (projectsManager = MavenProjectsManager.getInstance(project = RunAnythingUtil.fetchProject((DataContext)dataContext))).isMavenizedProject()) {
            if (projectsManager.getRootProjects().size() > 1) {
                return "mvn <rootModuleName> <goals...> <options...>";
            }
            return "mvn <goals...> <options...>";
        }
        return "mvn <rootModuleName?> <goals...> <options...>";
    }

    public void execute(@NotNull DataContext dataContext, @NotNull String value) {
        Project project;
        MavenProjectsManager projectsManager;
        if (dataContext == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(18);
        }
        if (value == null) {
            MavenRunAnythingProvider.$$$reportNull$$$0(19);
        }
        if (!(projectsManager = MavenProjectsManager.getInstance(project = RunAnythingUtil.fetchProject((DataContext)dataContext))).isMavenizedProject()) {
            return;
        }
        List<MavenProject> mavenProjects = projectsManager.getRootProjects();
        boolean onlyOneMavenProject = mavenProjects.size() == 1;
        ArrayList<String> goals = new ArrayList<String>(ParametersListUtil.parse((String)StringUtil.trimStart((String)value, (String)this.getHelpCommand()).trim()));
        if (!goals.isEmpty()) {
            MavenProject mavenProject = null;
            if (onlyOneMavenProject) {
                mavenProject = mavenProjects.get(0);
            } else {
                String moduleName = (String)goals.remove(0);
                Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
                if (module != null) {
                    mavenProject = projectsManager.findProject(module);
                }
            }
            if (mavenProject != null) {
                MavenExplicitProfiles explicitProfiles = projectsManager.getExplicitProfiles();
                MavenRunnerParameters params = new MavenRunnerParameters(true, mavenProject.getDirectory(), mavenProject.getFile().getName(), goals, explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
                MavenRunner mavenRunner = MavenRunner.getInstance(project);
                mavenRunner.run(params, mavenRunner.getSettings(), null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 11: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunAnythingProvider";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunAnythingProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainListItem";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpCommand";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionGroupTitle";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpCommandPlaceholder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMainListItem";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingValue";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getHelpItem";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

