/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.refactorings.introduce;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.refactorings.introduce.IntroducePropertyDialog;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;

public class IntroducePropertyAction
extends BaseRefactoringAction {
    private static final String PREFIX = "${";
    private static final String SUFFIX = "}";

    public IntroducePropertyAction() {
        this.setInjectedContext(true);
    }

    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            IntroducePropertyAction.$$$reportNull$$$0(0);
        }
        return false;
    }

    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            IntroducePropertyAction.$$$reportNull$$$0(1);
        }
        return new MyRefactoringActionHandler();
    }

    protected boolean isAvailableForFile(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        return MavenDomUtil.isMavenFile(file) && virtualFile != null && virtualFile.getFileSystem() != JarFileSystem.getInstance();
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        if (element == null) {
            IntroducePropertyAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            IntroducePropertyAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            IntroducePropertyAction.$$$reportNull$$$0(4);
        }
        if (context == null) {
            IntroducePropertyAction.$$$reportNull$$$0(5);
        }
        if (!super.isAvailableOnElementInEditorAndFile(element, editor, file, context)) {
            return false;
        }
        return IntroducePropertyAction.getSelectedElementAndTextRange(editor, file) != null;
    }

    @Nullable
    static Pair<XmlElement, TextRange> getSelectedElementAndTextRange(Editor editor, PsiFile file) {
        int startOffset = editor.getSelectionModel().getSelectionStart();
        int endOffset = editor.getSelectionModel().getSelectionEnd();
        PsiElement elementAtStart = file.findElementAt(startOffset);
        if (elementAtStart == null) {
            return null;
        }
        PsiElement elementAtEnd = file.findElementAt(endOffset == startOffset ? endOffset : endOffset - 1);
        if (elementAtEnd == null) {
            return null;
        }
        PsiElement elementAt = PsiTreeUtil.findCommonParent((PsiElement)elementAtStart, (PsiElement)elementAtEnd);
        if (elementAt instanceof XmlToken) {
            elementAt = elementAt.getParent();
        }
        if (elementAt instanceof XmlText || elementAt instanceof XmlAttributeValue) {
            TextRange range = editor.getSelectionModel().hasSelection() ? new TextRange(startOffset, endOffset) : elementAt.getTextRange();
            return Pair.create((Object)((XmlElement)elementAt), (Object)range);
        }
        return null;
    }

    private static List<TextRange> getPropertiesTextRanges(String s) {
        int endOffset;
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int startOffset = s.indexOf(PREFIX);
        while (startOffset >= 0 && (endOffset = s.indexOf(SUFFIX, startOffset)) > startOffset) {
            if (s.substring(startOffset + PREFIX.length(), endOffset).contains(PREFIX)) {
                startOffset = s.indexOf(PREFIX, startOffset + 1);
                continue;
            }
            ranges.add(new TextRange(startOffset, endOffset));
            startOffset = s.indexOf(PREFIX, endOffset);
        }
        return ranges;
    }

    private static boolean isIntersectWithRanges(@NotNull Collection<TextRange> ranges, int start, int end) {
        if (ranges == null) {
            IntroducePropertyAction.$$$reportNull$$$0(6);
        }
        for (TextRange range : ranges) {
            if (start <= range.getStartOffset() && end >= range.getEndOffset() || end <= range.getStartOffset() || start >= range.getEndOffset()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledOnElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnElementInEditorAndFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isIntersectWithRanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyRefactoringActionHandler
    implements RefactoringActionHandler {
        private MyRefactoringActionHandler() {
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
            if (project == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(0);
            }
            MavenActionsUsagesCollector.trigger(project, MavenActionsUsagesCollector.ActionID.IntroducePropertyAction);
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            Pair<XmlElement, TextRange> elementAndRange = IntroducePropertyAction.getSelectedElementAndTextRange(editor, file);
            if (elementAndRange == null) {
                return;
            }
            XmlElement selectedElement = (XmlElement)elementAndRange.first;
            TextRange range = (TextRange)elementAndRange.second;
            String stringValue = selectedElement.getText();
            if (stringValue == null) {
                return;
            }
            MavenDomProjectModel model = MavenDomUtil.getMavenDomModel(file, MavenDomProjectModel.class);
            String selectedString = editor.getDocument().getText(range);
            List ranges = IntroducePropertyAction.getPropertiesTextRanges(stringValue);
            int offsetInElement = range.getStartOffset() - selectedElement.getTextOffset();
            if (model == null || StringUtil.isEmptyOrSpaces((String)selectedString) || IntroducePropertyAction.isIntersectWithRanges(ranges, offsetInElement, offsetInElement + selectedString.length())) {
                return;
            }
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            IntroducePropertyDialog dialog = new IntroducePropertyDialog(project, selectedElement, model, selectedString);
            dialog.show();
            if (dialog.getExitCode() != 0) {
                return;
            }
            String propertyName = dialog.getEnteredName();
            MavenDomProjectModel selectedProject = dialog.getSelectedProject();
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(MyRefactoringActionHandler.getFiles(file, selectedProject)).hasReadonlyFiles()) {
                return;
            }
            String replaceWith = IntroducePropertyAction.PREFIX + propertyName + IntroducePropertyAction.SUFFIX;
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replaceWith);
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                MyRefactoringActionHandler.createMavenProperty(selectedProject, propertyName, selectedString);
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            });
            MyRefactoringActionHandler.showFindUsages(project, propertyName, selectedString, replaceWith, selectedProject);
        }

        @NotNull
        private static List<VirtualFile> getFiles(PsiFile file, MavenDomProjectModel model) {
            VirtualFile vf;
            XmlElement xmlElement;
            HashSet virtualFiles = new HashSet();
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                virtualFiles.add(virtualFile);
            }
            if ((xmlElement = model.getXmlElement()) != null && (vf = xmlElement.getContainingFile().getVirtualFile()) != null) {
                virtualFiles.add(vf);
            }
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>((Collection<VirtualFile>)virtualFiles);
            if (arrayList == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static void createMavenProperty(@NotNull MavenDomProjectModel model, @NotNull String enteredName, @NotNull String selectedString) {
            if (model == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(2);
            }
            if (enteredName == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(3);
            }
            if (selectedString == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(4);
            }
            MavenDomProperties mavenDomProperties = model.getProperties();
            XmlTag xmlTag = mavenDomProperties.ensureTagExists();
            XmlTag propertyTag = xmlTag.createChildTag(enteredName, xmlTag.getNamespace(), selectedString, false);
            xmlTag.add((PsiElement)propertyTag);
        }

        private static void showFindUsages(@NotNull Project project, @NotNull String propertyName, @NotNull String selectedString, @NotNull String replaceWith, @NotNull MavenDomProjectModel model) {
            UsageViewManager manager;
            if (project == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(5);
            }
            if (propertyName == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(6);
            }
            if (selectedString == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(7);
            }
            if (replaceWith == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(8);
            }
            if (model == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(9);
            }
            if ((manager = UsageViewManager.getInstance((Project)project)) == null) {
                return;
            }
            MyRefactoringActionHandler.assureFindToolWindowRegistered(project);
            FindManager findManager = FindManager.getInstance((Project)project);
            FindModel findModel = MyRefactoringActionHandler.createFindModel(findManager, selectedString, replaceWith);
            UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation((boolean)true, (FindModel)findModel);
            FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation((Project)project, (boolean)true, (UsageViewPresentation)presentation);
            findManager.getFindInProjectModel().copyFrom(findModel);
            FindModel findModelCopy = findModel.clone();
            ReplaceInProjectManager.getInstance((Project)project).searchAndShowUsages(manager, (Factory)new MyUsageSearcherFactory(model, propertyName, selectedString), findModelCopy, presentation, processPresentation);
        }

        private static void assureFindToolWindowRegistered(@NotNull Project project) {
            if (project == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(10);
            }
            UsageViewContentManager uvm = UsageViewContentManager.getInstance((Project)project);
        }

        private static FindModel createFindModel(FindManager findManager, String selectedString, String replaceWith) {
            FindModel findModel = findManager.getFindInProjectModel().clone();
            findModel.setStringToFind(selectedString);
            findModel.setStringToReplace(replaceWith);
            findModel.setReplaceState(true);
            findModel.setPromptOnReplace(true);
            findModel.setCaseSensitive(true);
            findModel.setRegularExpressions(false);
            return findModel;
        }

        public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
            if (project == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(11);
            }
            if (elements == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(12);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enteredName";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedString";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replaceWith";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createMavenProperty";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "showFindUsages";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "assureFindToolWindowRegistered";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class MyUsageSearcherFactory
        implements Factory<UsageSearcher> {
            private final MavenDomProjectModel myModel;
            private final String myPropertyName;
            private final String mySelectedString;

            MyUsageSearcherFactory(MavenDomProjectModel model, String propertyName, String selectedString) {
                this.myModel = model;
                this.myPropertyName = propertyName;
                this.mySelectedString = selectedString;
            }

            public UsageSearcher create() {
                return new UsageSearcher(){
                    final Set<UsageInfo> usages = new HashSet();

                    public void generate(@NotNull Processor<Usage> processor) {
                        if (processor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().runReadAction(() -> {
                            this.collectUsages(myModel);
                            for (MavenDomProjectModel model : MavenDomProjectProcessorUtils.getChildrenProjects(myModel)) {
                                this.collectUsages(model);
                            }
                            for (UsageInfo usage : this.usages) {
                                processor.process(UsageInfo2UsageAdapter.CONVERTER.fun((Object)usage));
                            }
                        });
                    }

                    private void collectUsages(@NotNull MavenDomProjectModel model) {
                        XmlElement root;
                        if (model == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (model.isValid() && (root = model.getXmlElement()) != null) {
                            root.acceptChildren((PsiElementVisitor)new XmlElementVisitor(){

                                public void visitXmlText(XmlText text) {
                                    XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)text, XmlTag.class);
                                    if (xmlTag != null && !xmlTag.getName().equals(myPropertyName)) {
                                        usages.addAll(this.getUsages((XmlElement)text));
                                    }
                                }

                                public void visitXmlAttributeValue(XmlAttributeValue value) {
                                    XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class);
                                    if (xmlTag != null && !xmlTag.equals(root)) {
                                        usages.addAll(this.getUsages((XmlElement)value));
                                    }
                                }

                                public void visitXmlElement(XmlElement element) {
                                    element.acceptChildren((PsiElementVisitor)this);
                                }
                            });
                        }
                    }

                    @NotNull
                    private Set<UsageInfo> getUsages(@NotNull XmlElement xmlElement) {
                        int end;
                        String s;
                        if (xmlElement == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (StringUtil.isEmptyOrSpaces((String)(s = xmlElement.getText()))) {
                            Set<UsageInfo> set = Collections.emptySet();
                            if (set == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            return set;
                        }
                        int start = s.indexOf(mySelectedString);
                        if (start == -1) {
                            Set<UsageInfo> set = Collections.emptySet();
                            if (set == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            return set;
                        }
                        HashSet usages = new HashSet();
                        List ranges = IntroducePropertyAction.getPropertiesTextRanges(s);
                        TextRange elementTextRange = xmlElement.getTextRange();
                        PsiFile containingFile = xmlElement.getContainingFile();
                        do {
                            boolean isInsideProperty;
                            if (isInsideProperty = IntroducePropertyAction.isIntersectWithRanges(ranges, start, end = start + mySelectedString.length())) continue;
                            usages.add(new UsageInfo((PsiElement)containingFile, elementTextRange.getStartOffset() + start, elementTextRange.getStartOffset() + end));
                        } while ((start = s.indexOf(mySelectedString, end)) != -1);
                        HashSet hashSet = usages;
                        if (hashSet == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        return hashSet;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "processor";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "model";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "xmlElement";
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler$MyUsageSearcherFactory$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler$MyUsageSearcherFactory$1";
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getUsages";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "generate";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "collectUsages";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "getUsages";
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
            }
        }
    }
}

