/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.completion.MavenAbstractPluginExtensionCompletionContributor;
import org.jetbrains.idea.maven.dom.model.completion.MavenCoordinateCompletionContributor;
import org.jetbrains.idea.maven.dom.model.completion.insert.MavenArtifactIdInsertionHandler;
import org.jetbrains.idea.maven.onlinecompletion.DependencySearchService;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.maven.onlinecompletion.model.SearchParameters;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J4\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0014\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/maven/dom/model/completion/MavenArtifactIdCompletionContributor;", "Lorg/jetbrains/idea/maven/dom/model/completion/MavenCoordinateCompletionContributor;", "()V", "fillResults", "", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "coordinates", "Lorg/jetbrains/idea/maven/dom/model/MavenDomShortArtifactCoordinates;", "cld", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lorg/jetbrains/idea/maven/onlinecompletion/model/MavenRepositoryArtifactInfo;", "promise", "Lorg/jetbrains/concurrency/Promise;", "Ljava/lang/Void;", "find", "service", "Lorg/jetbrains/idea/maven/onlinecompletion/DependencySearchService;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "consumer", "Ljava/util/function/Consumer;", "validate", "", "groupId", "", "artifactId", "intellij.maven"})
public final class MavenArtifactIdCompletionContributor
extends MavenCoordinateCompletionContributor {
    @Override
    protected boolean validate(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
        return true;
    }

    @Override
    @NotNull
    protected Promise<Void> find(@NotNull DependencySearchService service, @NotNull MavenDomShortArtifactCoordinates coordinates, @NotNull CompletionParameters parameters, @NotNull Consumer<MavenRepositoryArtifactInfo> consumer) {
        Intrinsics.checkParameterIsNotNull((Object)service, (String)"service");
        Intrinsics.checkParameterIsNotNull((Object)coordinates, (String)"coordinates");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        SearchParameters searchParameters = this.createSearchParameters(parameters);
        GenericDomValue<String> genericDomValue = coordinates.getGroupId();
        Intrinsics.checkExpressionValueIsNotNull(genericDomValue, (String)"coordinates.groupId");
        String string = MavenCoordinateCompletionContributor.trimDummy(genericDomValue.getStringValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"trimDummy(coordinates.groupId.stringValue)");
        String groupId = string;
        GenericDomValue<String> genericDomValue2 = coordinates.getArtifactId();
        Intrinsics.checkExpressionValueIsNotNull(genericDomValue2, (String)"coordinates.artifactId");
        String string2 = MavenCoordinateCompletionContributor.trimDummy(genericDomValue2.getStringValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"trimDummy(coordinates.artifactId.stringValue)");
        String artifactId = string2;
        if (MavenAbstractPluginExtensionCompletionContributor.Companion.isPluginOrExtension(coordinates) && StringUtil.isEmpty((String)groupId)) {
            SearchParameters searchParameters2 = searchParameters;
            Intrinsics.checkExpressionValueIsNotNull((Object)searchParameters2, (String)"searchParameters");
            return (Promise)MavenAbstractPluginExtensionCompletionContributor.Companion.findPluginByArtifactId(service, artifactId, searchParameters2, consumer);
        }
        if (StringsKt.isBlank((CharSequence)groupId)) {
            Promise<Void> promise = service.fulltextSearch(artifactId, searchParameters, consumer);
            Intrinsics.checkExpressionValueIsNotNull(promise, (String)"service.fulltextSearch(a\u2026archParameters, consumer)");
            return promise;
        }
        Promise<Void> promise = service.suggestPrefix(groupId, artifactId, searchParameters, MavenCoordinateCompletionContributor.withPredicate(consumer, new Predicate<MavenRepositoryArtifactInfo>(searchParameters, groupId){
            final /* synthetic */ SearchParameters $searchParameters;
            final /* synthetic */ String $groupId;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean test(MavenRepositoryArtifactInfo it) {
                SearchParameters searchParameters = this.$searchParameters;
                Intrinsics.checkExpressionValueIsNotNull((Object)searchParameters, (String)"searchParameters");
                if (searchParameters.isShowAll()) return true;
                CharSequence charSequence = this.$groupId;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return true;
                }
                boolean bl2 = false;
                if (bl2) return true;
                MavenRepositoryArtifactInfo mavenRepositoryArtifactInfo = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)mavenRepositoryArtifactInfo, (String)"it");
                if (!Intrinsics.areEqual((Object)this.$groupId, (Object)mavenRepositoryArtifactInfo.getGroupId())) return false;
                return true;
            }
            {
                this.$searchParameters = searchParameters;
                this.$groupId = string;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull(promise, (String)"service.suggestPrefix(gr\u2026groupId == it.groupId }))");
        return promise;
    }

    @Override
    protected void fillResults(@NotNull CompletionResultSet result, @NotNull MavenDomShortArtifactCoordinates coordinates, @NotNull ConcurrentLinkedDeque<MavenRepositoryArtifactInfo> cld, @NotNull Promise<Void> promise) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)coordinates, (String)"coordinates");
        Intrinsics.checkParameterIsNotNull(cld, (String)"cld");
        Intrinsics.checkParameterIsNotNull(promise, (String)"promise");
        HashSet<String> set = new HashSet<String>();
        while (promise.getState() == Promise.State.PENDING || !cld.isEmpty()) {
            ProgressManager.checkCanceled();
            MavenRepositoryArtifactInfo item = cld.poll();
            if (item == null || !set.add(item.getArtifactId())) continue;
            result.addElement((LookupElement)MavenDependencyCompletionUtil.lookupElement(item, item.getArtifactId()).withInsertHandler(MavenArtifactIdInsertionHandler.INSTANCE));
        }
    }

    public MavenArtifactIdCompletionContributor() {
        super("artifactId");
    }
}

