/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;

public class ChooseFileIntentionAction
implements IntentionAction {
    private Supplier<VirtualFile[]> myFileChooser = null;

    @NotNull
    public String getFamilyName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            ChooseFileIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = MavenDomBundle.message("intention.choose.file", new Object[0]);
        if (string == null) {
            ChooseFileIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ChooseFileIntentionAction.$$$reportNull$$$0(2);
        }
        if (!MavenDomUtil.isMavenFile(file)) {
            return false;
        }
        MavenDomDependency dep = ChooseFileIntentionAction.getDependency(file, editor);
        return dep != null && "system".equals(dep.getScope().getStringValue());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        VirtualFile[] files;
        if (project == null) {
            ChooseFileIntentionAction.$$$reportNull$$$0(3);
        }
        MavenDomDependency dep = ChooseFileIntentionAction.getDependency(file, editor);
        if (this.myFileChooser == null) {
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, false, false);
            PsiFile currentValue = dep != null ? (PsiFile)dep.getSystemPath().getValue() : null;
            VirtualFile toSelect = currentValue == null ? null : currentValue.getVirtualFile();
            files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)toSelect);
        } else {
            files = this.myFileChooser.get();
        }
        if (files == null || files.length == 0) {
            return;
        }
        PsiFile selectedFile = PsiManager.getInstance((Project)project).findFile(files[0]);
        if (selectedFile == null) {
            return;
        }
        if (dep != null) {
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            WriteCommandAction.writeCommandAction((Project)project).run(() -> dep.getSystemPath().setValue((Object)selectedFile));
        }
    }

    public void setFileChooser(@Nullable Supplier<VirtualFile[]> fileChooser) {
        this.myFileChooser = fileChooser;
    }

    @Nullable
    private static MavenDomDependency getDependency(PsiFile file, Editor editor) {
        PsiElement el = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset());
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)el, XmlTag.class, (boolean)false);
        if (tag == null) {
            return null;
        }
        DomElement dom = DomManager.getDomManager((Project)el.getProject()).getDomElement(tag);
        if (dom == null) {
            return null;
        }
        return (MavenDomDependency)dom.getParentOfType(MavenDomDependency.class, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/intentions/ChooseFileIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/intentions/ChooseFileIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

