/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.ConvertContext;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesConverter;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.onlinecompletion.OfflineSearchService;

public class MavenArtifactCoordinatesVersionConverter
extends MavenArtifactCoordinatesConverter {
    private static final Pattern MAGIC_VERSION_PATTERN = Pattern.compile("\\s*(?:LATEST|RELEASE|[(\\[].*|.*-20\\d{6}\\.[0-2]\\d{5}-\\d+)\\s*");

    @Override
    protected boolean doIsValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
        if (StringUtil.isEmpty((String)id.getGroupId()) || StringUtil.isEmpty((String)id.getArtifactId()) || StringUtil.isEmpty((String)id.getVersion())) {
            return false;
        }
        if (MAGIC_VERSION_PATTERN.matcher(id.getVersion()).matches()) {
            return true;
        }
        return manager.hasVersion(id.getGroupId(), id.getArtifactId(), id.getVersion());
    }

    @Override
    protected Set<String> doGetVariants(MavenId id, OfflineSearchService searchService) {
        return Collections.emptySet();
    }
}

