/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.ConvertContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesConverter;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesHelper;
import org.jetbrains.idea.maven.dom.converters.MavenSmartConverter;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.onlinecompletion.OfflineSearchService;
import org.jetbrains.idea.maven.onlinecompletion.model.SearchParameters;
import org.jetbrains.idea.maven.project.MavenProject;

public class MavenArtifactCoordinatesGroupIdConverter
extends MavenArtifactCoordinatesConverter
implements MavenSmartConverter<String> {
    @Override
    protected boolean doIsValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
        if (StringUtil.isEmpty((String)id.getGroupId())) {
            return false;
        }
        if (manager.hasGroupId(id.getGroupId())) {
            return true;
        }
        MavenProject mavenProject = this.findMavenProject(context);
        if (mavenProject != null) {
            for (MavenArtifact artifact : mavenProject.findDependencies(id.getGroupId(), id.getArtifactId())) {
                if (!artifact.isResolved()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Set<String> doGetVariants(MavenId id, OfflineSearchService searchService) {
        return Collections.emptySet();
    }

    @Nullable
    public LookupElement createLookupElement(String s) {
        return null;
    }

    @Override
    public Collection<String> getSmartVariants(ConvertContext convertContext) {
        String artifactId = MavenArtifactCoordinatesHelper.getId(convertContext).getArtifactId();
        if (!StringUtil.isEmptyOrSpaces((String)artifactId)) {
            OfflineSearchService searchService = MavenProjectIndicesManager.getInstance(convertContext.getProject()).getOfflineSearchService();
            return searchService.findByTemplate(artifactId, SearchParameters.DEFAULT).stream().filter(p -> artifactId.equals(p.getArtifactId())).map(p -> p.getGroupId()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

