/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.compiler.tools.AndroidApkBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.builder.AndroidBuildTarget;
import org.jetbrains.jps.android.builder.AndroidBuildTargetType;
import org.jetbrains.jps.android.builder.AndroidDexBuildTarget;
import org.jetbrains.jps.android.builder.AndroidResourcePackagingBuildTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidPackagingBuildTarget
extends AndroidBuildTarget {
    public AndroidPackagingBuildTarget(@NotNull JpsModule module) {
        if (module == null) {
            AndroidPackagingBuildTarget.$$$reportNull$$$0(0);
        }
        super(MyTargetType.INSTANCE, module);
    }

    @NotNull
    public static String[] collectNativeLibsFolders(@NotNull JpsAndroidModuleExtension extension, boolean checkExistence) {
        if (extension == null) {
            AndroidPackagingBuildTarget.$$$reportNull$$$0(1);
        }
        ArrayList<String> result = new ArrayList<String>();
        File libsDir = extension.getNativeLibsDir();
        if (libsDir != null && (!checkExistence || libsDir.exists())) {
            result.add(libsDir.getPath());
        }
        for (JpsAndroidModuleExtension depExtension : AndroidJpsUtil.getAllAndroidDependencies(extension.getModule(), true)) {
            File depLibsDir = depExtension.getNativeLibsDir();
            if (depLibsDir == null || checkExistence && !depLibsDir.exists()) continue;
            result.add(depLibsDir.getPath());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(result);
        if (stringArray == null) {
            AndroidPackagingBuildTarget.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Override
    @NotNull
    protected List<BuildRootDescriptor> doComputeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        File resPackage = AndroidResourcePackagingBuildTarget.getOutputFile(dataPaths, this.myModule);
        File classesDexFile = AndroidDexBuildTarget.getOutputFile(dataPaths, this.myModule);
        ArrayList<BuildRootDescriptor> roots = new ArrayList<BuildRootDescriptor>();
        roots.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, resPackage));
        roots.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, classesDexFile));
        AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(this.myModule, null, null);
        if (platform != null) {
            for (String jarOrLibDir : AndroidJpsUtil.getExternalLibraries(dataPaths, this.myModule, platform, false, true, false)) {
                roots.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, new File(jarOrLibDir), false));
            }
        }
        for (File resourceRoot : AndroidJpsUtil.getJavaOutputRootsForModuleAndDependencies(this.myModule)) {
            roots.add((BuildRootDescriptor)new MyResourceRootDescriptor(this, resourceRoot));
        }
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        for (String nativeLibDir : AndroidPackagingBuildTarget.collectNativeLibsFolders(extension, false)) {
            roots.add((BuildRootDescriptor)new BuildRootDescriptorImpl((BuildTarget)this, new File(nativeLibDir)));
        }
        ArrayList<BuildRootDescriptor> arrayList = roots;
        if (arrayList == null) {
            AndroidPackagingBuildTarget.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        File moduleOutputDir = ProjectPaths.getModuleOutputDir((JpsModule)this.myModule, (boolean)false);
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        if (moduleOutputDir == null || extension == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                AndroidPackagingBuildTarget.$$$reportNull$$$0(4);
            }
            return list;
        }
        String outputPath = AndroidJpsUtil.getApkPath(extension, moduleOutputDir);
        if (outputPath == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                AndroidPackagingBuildTarget.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<File> list = Collections.singletonList(new File(outputPath));
        if (list == null) {
            AndroidPackagingBuildTarget.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    protected void fillDependencies(List<BuildTarget<?>> result) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        if (extension != null && !extension.isLibrary()) {
            result.add(new AndroidDexBuildTarget(this.myModule));
            result.add(new AndroidResourcePackagingBuildTarget(this.myModule));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/android/builder/AndroidPackagingBuildTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/android/builder/AndroidPackagingBuildTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectNativeLibsFolders";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeRootDescriptors";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectNativeLibsFolders";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResourceRootDescriptor
    extends BuildRootDescriptorImpl {
        private MyResourceRootDescriptor(BuildTarget target, File root) {
            super(target, root);
        }

        @NotNull
        public FileFilter createFileFilter() {
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return AndroidApkBuilder.checkFileForPackaging((File)file);
                }
            };
            if (fileFilter == null) {
                MyResourceRootDescriptor.$$$reportNull$$$0(0);
            }
            return fileFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidPackagingBuildTarget$MyResourceRootDescriptor", "createFileFilter"));
        }
    }

    public static class MyTargetType
    extends AndroidBuildTargetType<AndroidPackagingBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-packaging", "Packaging");
        }

        @Override
        public AndroidPackagingBuildTarget createBuildTarget(@NotNull JpsAndroidModuleExtension extension) {
            if (extension == null) {
                MyTargetType.$$$reportNull$$$0(0);
            }
            return new AndroidPackagingBuildTarget(extension.getModule());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/android/builder/AndroidPackagingBuildTarget$MyTargetType", "createBuildTarget"));
        }
    }
}

