/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.TextMateServiceImpl;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;

public class TextMateBundlesListPanel
implements Disposable {
    private static final String TEXTMATE_LAST_ADDED_BUNDLE = "textmate.last.added.bundle";
    private final CheckBoxList<BundleConfigBean> myBundlesList;
    private Collection<TextMateBundlesChangeStateListener> myListeners = new ArrayList<TextMateBundlesChangeStateListener>();

    public TextMateBundlesListPanel() {
        this.myBundlesList = new CheckBoxList<BundleConfigBean>(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value) {
                BundleConfigBean itemAt = (BundleConfigBean)TextMateBundlesListPanel.this.myBundlesList.getItemAt(index);
                if (itemAt != null) {
                    itemAt.setEnabled(value);
                }
            }
        }){

            @Nullable
            protected String getSecondaryText(int index) {
                BundleConfigBean bean = (BundleConfigBean)TextMateBundlesListPanel.this.myBundlesList.getItemAt(index);
                if (TextMateBundlesListPanel.isBuiltin(bean)) {
                    return "Built-in";
                }
                return bean != null ? bean.getPath() : null;
            }
        };
        this.myBundlesList.setSelectionMode(2);
        new ListSpeedSearch(this.myBundlesList, o -> ((JCheckBox)o).getText());
    }

    private static boolean isBuiltin(BundleConfigBean bean) {
        String path = bean != null ? bean.getPath() : null;
        return path != null && (path.startsWith(TextMateServiceImpl.PREINSTALLED_BUNDLES_PATH) || path.startsWith(TextMateServiceImpl.INSTALLED_BUNDLES_PATH));
    }

    @NotNull
    public Collection<BundleConfigBean> getState() {
        HashSet<BundleConfigBean> result = new HashSet<BundleConfigBean>();
        for (int i = 0; i < this.myBundlesList.getItemsCount(); ++i) {
            result.add((BundleConfigBean)this.myBundlesList.getItemAt(i));
        }
        HashSet<BundleConfigBean> hashSet = result;
        if (hashSet == null) {
            TextMateBundlesListPanel.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    public void setState(@NotNull Collection<BundleConfigBean> configBeans) {
        if (configBeans == null) {
            TextMateBundlesListPanel.$$$reportNull$$$0(1);
        }
        this.myBundlesList.clear();
        for (BundleConfigBean bean : ContainerUtil.sorted(configBeans, Comparator.comparing(BundleConfigBean::getName))) {
            this.myBundlesList.addItem((Object)bean.copy(), bean.getName(), bean.isEnabled());
        }
    }

    public JPanel createMainComponent() {
        return ToolbarDecorator.createDecorator(this.myBundlesList).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List bundlesToDelete = ContainerUtil.findAll((Collection)TextMateBundlesListPanel.this.myBundlesList.getSelectedValuesList(), JCheckBox.class);
                if (bundlesToDelete.isEmpty()) {
                    return;
                }
                String title = bundlesToDelete.size() > 1 ? "Remove Bundles?" : "Remove Bundle?";
                String message = StringUtil.join((Collection)bundlesToDelete, AbstractButton::getText, (String)"\n");
                if (Messages.showYesNoDialog((String)message, (String)title, (String)"Remove", (String)"Cancel", null) != 0) {
                    return;
                }
                ListUtil.removeSelectedItems((JList)TextMateBundlesListPanel.this.myBundlesList);
                TextMateBundlesListPanel.this.fireStateChanged();
            }
        }).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                VirtualFile[] bundleDirectories;
                String lastAddedBundle;
                FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(FileChooserDescriptorFactory.createMultipleFoldersDescriptor(), null, (Component)TextMateBundlesListPanel.this.myBundlesList);
                VirtualFile fileToSelect = null;
                int itemsCount = TextMateBundlesListPanel.this.myBundlesList.getItemsCount();
                if (itemsCount > 0 && StringUtil.isNotEmpty((String)(lastAddedBundle = PropertiesComponent.getInstance().getValue(TextMateBundlesListPanel.TEXTMATE_LAST_ADDED_BUNDLE)))) {
                    fileToSelect = LocalFileSystem.getInstance().findFileByPath(lastAddedBundle);
                }
                if ((bundleDirectories = fileChooser.choose(null, new VirtualFile[]{fileToSelect})).length > 0) {
                    StringBuilder errorMessage = new StringBuilder();
                    for (VirtualFile bundleDirectory : bundleDirectories) {
                        PropertiesComponent.getInstance().setValue(TextMateBundlesListPanel.TEXTMATE_LAST_ADDED_BUNDLE, bundleDirectory.getPath());
                        ThrowableComputable readBundleProcess = () -> TextMateService.getInstance().createBundle(bundleDirectory);
                        Bundle bundle = null;
                        try {
                            bundle = (Bundle)ProgressManager.getInstance().runProcessWithProgressSynchronously(readBundleProcess, "Add Bundle", true, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String bundleDirectoryPath = bundleDirectory.getPath();
                        if (bundle != null) {
                            boolean alreadyAdded = false;
                            for (int i = 0; i < TextMateBundlesListPanel.this.myBundlesList.getItemsCount(); ++i) {
                                BundleConfigBean item = (BundleConfigBean)TextMateBundlesListPanel.this.myBundlesList.getItemAt(i);
                                if (item == null || !FileUtil.toSystemIndependentName((String)bundleDirectoryPath).equals(item.getPath())) continue;
                                TextMateBundlesListPanel.this.myBundlesList.clearSelection();
                                TextMateBundlesListPanel.this.myBundlesList.setSelectedIndex(i);
                                UIUtil.scrollListToVisibleIfNeeded((JList)TextMateBundlesListPanel.this.myBundlesList);
                                alreadyAdded = true;
                                break;
                            }
                            if (alreadyAdded) continue;
                            TextMateBundlesListPanel.this.myBundlesList.addItem((Object)new BundleConfigBean(bundle.getName(), bundleDirectoryPath, true), bundle.getName(), true);
                            TextMateBundlesListPanel.this.fireStateChanged();
                            continue;
                        }
                        if (errorMessage.length() == 0) {
                            errorMessage.append("Can't read following bundles:");
                        }
                        errorMessage.append('\n').append(bundleDirectoryPath);
                    }
                    if (errorMessage.length() > 0) {
                        Messages.showErrorDialog((String)errorMessage.toString(), (String)"TextMate Bundle Error");
                    }
                }
            }
        }).setRemoveActionUpdater(e -> {
            for (int index : this.myBundlesList.getSelectedIndices()) {
                if (!TextMateBundlesListPanel.isBuiltin((BundleConfigBean)this.myBundlesList.getItemAt(index))) continue;
                return false;
            }
            return true;
        }).disableUpDownActions().createPanel();
    }

    private void fireStateChanged() {
        for (TextMateBundlesChangeStateListener listener : this.myListeners) {
            listener.stateChanged();
        }
    }

    public boolean isModified(@NotNull Collection<BundleConfigBean> bundles) {
        if (bundles == null) {
            TextMateBundlesListPanel.$$$reportNull$$$0(2);
        }
        return !this.getState().equals(new HashSet<BundleConfigBean>(bundles));
    }

    public void dispose() {
        this.myListeners.clear();
        this.myListeners = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/configuration/TextMateBundlesListPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configBeans";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/configuration/TextMateBundlesListPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface TextMateBundlesChangeStateListener {
        public void stateChanged();
    }
}

