/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.bundles.BundleFactory;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;
import org.jetbrains.plugins.textmate.configuration.TextMateSettings;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.editor.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTable;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateCustomTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateEmulatedTheme;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTheme;
import org.jetbrains.plugins.textmate.plist.CompositePlistReader;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;

public class TextMateServiceImpl
extends TextMateService {
    private static boolean ourBuiltinBundlesDisabled;
    private final AtomicBoolean myInitialized = new AtomicBoolean(false);
    private final Map<String, TextMateCustomTextAttributes> myCustomHighlightingColors = new HashMap<String, TextMateCustomTextAttributes>();
    private final PlistReader myPlistReader = new CompositePlistReader();
    private final BundleFactory myBundleFactory = new BundleFactory(this.myPlistReader);
    private final TextMateSyntaxTable mySyntaxTable = new TextMateSyntaxTable();
    private final Map<String, TextMateTheme> myThemeHashMap = new HashMap<String, TextMateTheme>();
    private final SnippetsRegistry mySnippetsRegistry = new SnippetsRegistry();
    private final PreferencesRegistry myPreferencesRegistry = new PreferencesRegistry();
    private final ShellVariablesRegistry myShellVariablesRegistry = new ShellVariablesRegistry();
    private final Map<String, String> myExtensionsMapping = new THashMap();
    @NonNls
    private static final String PREINSTALLED_THEMES_PATH;
    @NonNls
    private static final String INSTALLED_THEMES_PATH;
    @NonNls
    public static final String PREINSTALLED_BUNDLES_PATH;
    @NonNls
    public static final String INSTALLED_BUNDLES_PATH;
    private final Set<TextMateService.TextMateBundleListener> myListeners = new HashSet<TextMateService.TextMateBundleListener>();

    @Override
    public void registerEnabledBundles() {
        this.doRegisterEnabledBundles();
    }

    private void doRegisterEnabledBundles() {
        TextMateSettings settings = TextMateSettings.getInstance();
        if (settings == null) {
            return;
        }
        if (!ourBuiltinBundlesDisabled) {
            TextMateServiceImpl.loadBuiltinBundles(settings);
        }
        THashMap newExtensionsMapping = new THashMap();
        for (BundleConfigBean bundleConfigBean : settings.getBundles()) {
            boolean result;
            if (!bundleConfigBean.isEnabled() || (result = this.registerBundle(LocalFileSystem.getInstance().findFileByPath(bundleConfigBean.getPath()), (THashMap<String, String>)newExtensionsMapping))) continue;
            Notifications.Bus.notify((Notification)new Notification("TextMate Bundles", "TextMate bundle load error", "Bundle " + bundleConfigBean.getName() + " can't be registered", NotificationType.ERROR, null));
        }
        if (!this.myExtensionsMapping.equals(newExtensionsMapping)) {
            this.myExtensionsMapping.clear();
            this.myExtensionsMapping.putAll((Map<String, String>)newExtensionsMapping);
            if (!newExtensionsMapping.isEmpty()) {
                TextMateServiceImpl.fireFileTypesChangedEvent();
            }
        }
    }

    private static void fireFileTypesChangedEvent() {
        TransactionGuard.getInstance().submitTransactionLater((Disposable)ApplicationManager.getApplication(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
            fileTypeManager.fireBeforeFileTypesChanged();
            fileTypeManager.fireFileTypesChanged();
        }));
    }

    private static void loadBuiltinBundles(TextMateSettings settings) {
        File[] files;
        File bundles = new File(INSTALLED_BUNDLES_PATH);
        if (!bundles.exists() || !bundles.isDirectory()) {
            bundles = new File(PREINSTALLED_BUNDLES_PATH);
        }
        if ((files = bundles.listFiles()) == null) {
            LOG.warn("Missing builtin bundles, checked: \n" + INSTALLED_BUNDLES_PATH + "\n" + PREINSTALLED_BUNDLES_PATH);
            return;
        }
        TextMateSettings.TextMateSettingsState state = settings.getState();
        state = state == null ? new TextMateSettings.TextMateSettingsState() : state;
        ArrayList<BundleConfigBean> newBundles = new ArrayList<BundleConfigBean>(state.getBundles());
        for (File file : files) {
            if (file.getName().startsWith(".")) continue;
            String path = FileUtil.toSystemIndependentName((String)file.getPath());
            BundleConfigBean existing = (BundleConfigBean)ContainerUtil.find(state.getBundles(), bundle -> bundle.getPath().equals(path));
            if (existing != null) continue;
            newBundles.add(new BundleConfigBean(file.getName(), path, true));
        }
        state.setBundles(newBundles);
        settings.loadState(state);
    }

    @Override
    public void unregisterAllBundles() {
        this.myExtensionsMapping.clear();
        this.myPreferencesRegistry.clear();
        this.myCustomHighlightingColors.clear();
        this.mySyntaxTable.clear();
        this.mySnippetsRegistry.clear();
        this.myShellVariablesRegistry.clear();
    }

    @Override
    public void addListener(@NotNull TextMateService.TextMateBundleListener listener) {
        if (listener == null) {
            TextMateServiceImpl.$$$reportNull$$$0(0);
        }
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull TextMateService.TextMateBundleListener listener) {
        if (listener == null) {
            TextMateServiceImpl.$$$reportNull$$$0(1);
        }
        this.myListeners.remove(listener);
    }

    @Override
    public void clearListeners() {
        this.myListeners.clear();
    }

    @Override
    @NotNull
    public PlistReader getPlistReader() {
        PlistReader plistReader = this.myPlistReader;
        if (plistReader == null) {
            TextMateServiceImpl.$$$reportNull$$$0(2);
        }
        return plistReader;
    }

    @Override
    @NotNull
    public Map<String, TextMateCustomTextAttributes> getCustomHighlightingColors() {
        this.ensureInitialized();
        Map<String, TextMateCustomTextAttributes> map = this.myCustomHighlightingColors;
        if (map == null) {
            TextMateServiceImpl.$$$reportNull$$$0(3);
        }
        return map;
    }

    @Override
    @NotNull
    public List<Preferences> getPreferencesForSelector(@NotNull String selector) {
        if (selector == null) {
            TextMateServiceImpl.$$$reportNull$$$0(4);
        }
        this.ensureInitialized();
        List<Preferences> list = this.myPreferencesRegistry.getPreferences(selector);
        if (list == null) {
            TextMateServiceImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @Nullable
    public TextMateShellVariable getVariable(@NotNull String name, @NotNull EditorEx editor) {
        if (name == null) {
            TextMateServiceImpl.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            TextMateServiceImpl.$$$reportNull$$$0(7);
        }
        this.ensureInitialized();
        return this.myShellVariablesRegistry.getVariableValue(name, TextMateEditorUtils.getCurrentScopeSelector(editor));
    }

    @Override
    @NotNull
    public SnippetsRegistry getSnippetsRegistry() {
        this.ensureInitialized();
        SnippetsRegistry snippetsRegistry = this.mySnippetsRegistry;
        if (snippetsRegistry == null) {
            TextMateServiceImpl.$$$reportNull$$$0(8);
        }
        return snippetsRegistry;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByFileName(@NotNull CharSequence fileName) {
        if (fileName == null) {
            TextMateServiceImpl.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmpty((CharSequence)fileName)) {
            return null;
        }
        this.ensureInitialized();
        Ref result = Ref.create();
        TextMateEditorUtils.processExtensions(fileName, (Processor<? super CharSequence>)((Processor)extension -> {
            result.set((Object)this.getLanguageDescriptorByExtension((CharSequence)extension));
            return result.isNull();
        }));
        return (TextMateLanguageDescriptor)result.get();
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByExtension(@Nullable CharSequence extension) {
        if (StringUtil.isEmpty((CharSequence)extension)) {
            return null;
        }
        this.ensureInitialized();
        String scopeName = this.myExtensionsMapping.get(extension.toString());
        return StringUtil.isNotEmpty((String)scopeName) ? new TextMateLanguageDescriptor(scopeName, this.mySyntaxTable.getSyntax(scopeName)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerTheme(@Nullable VirtualFile themeFile) {
        if (themeFile == null || !themeFile.isValid()) {
            return false;
        }
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        synchronized (map) {
            try {
                TextMateTheme theme = TextMateTheme.load(this.myPlistReader.read(themeFile.getInputStream()));
                if (theme != TextMateTheme.EMPTY_THEME) {
                    this.myThemeHashMap.put(theme.getName(), theme);
                    for (TextMateService.TextMateBundleListener listener : this.myListeners) {
                        listener.colorSchemeChanged();
                    }
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public String[] getThemeNames() {
        this.ensureInitialized();
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        // MONITORENTER : map
        String[] stringArray = ArrayUtilRt.toStringArray(this.myThemeHashMap.keySet());
        // MONITOREXIT : map
        if (stringArray != null) return stringArray;
        TextMateServiceImpl.$$$reportNull$$$0(10);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public TextMateTheme getCurrentTheme() {
        this.ensureInitialized();
        if (Registry.is((String)"textmate.theme.emulation")) {
            TextMateTheme textMateTheme = TextMateEmulatedTheme.THEME;
            if (textMateTheme != null) return textMateTheme;
            TextMateServiceImpl.$$$reportNull$$$0(11);
            return textMateTheme;
        }
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        // MONITORENTER : map
        String currentIdeaSchemeName = SchemeManager.getDisplayName((Scheme)EditorColorsManager.getInstance().getGlobalScheme());
        String textmateSchemeName = TextMateSettings.getInstance().getTextMateThemeName(currentIdeaSchemeName, this);
        String schemeName = this.myThemeHashMap.containsKey(textmateSchemeName) ? textmateSchemeName : "Mac Classic";
        TextMateTheme scheme = this.myThemeHashMap.get(schemeName);
        TextMateTheme textMateTheme = scheme != null ? scheme : TextMateTheme.EMPTY_THEME;
        // MONITOREXIT : map
        if (textMateTheme != null) return textMateTheme;
        TextMateServiceImpl.$$$reportNull$$$0(12);
        return textMateTheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadThemesFromDisk() {
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        synchronized (map) {
            this.myThemeHashMap.clear();
        }
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (application.isDisposed()) {
                return;
            }
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            VirtualFile themesDirectory = (VirtualFile)ObjectUtils.chooseNotNull((Object)fileSystem.findFileByPath(INSTALLED_THEMES_PATH), (Object)fileSystem.findFileByPath(PREINSTALLED_THEMES_PATH));
            if (themesDirectory != null) {
                VirtualFile finalThemesDirectory = themesDirectory;
                Runnable reloadThemes = () -> {
                    if (application.isDisposed()) {
                        return;
                    }
                    Map<String, TextMateTheme> map = this.myThemeHashMap;
                    synchronized (map) {
                        if (finalThemesDirectory.isValid()) {
                            for (VirtualFile themeFile : finalThemesDirectory.getChildren()) {
                                this.registerTheme(themeFile);
                            }
                        }
                    }
                };
                themesDirectory.refresh(true, false, () -> application.executeOnPooledThread(reloadThemes));
            }
        });
    }

    @Override
    @Nullable
    public Bundle createBundle(@Nullable VirtualFile directory) {
        String path;
        if (directory != null && directory.isInLocalFileSystem() && (path = directory.getCanonicalPath()) != null) {
            return this.myBundleFactory.fromDirectory(new File(path));
        }
        return null;
    }

    private void ensureInitialized() {
        if (this.myInitialized.compareAndSet(false, true)) {
            this.doRegisterEnabledBundles();
        }
    }

    private boolean registerBundle(@Nullable VirtualFile directory, @NotNull THashMap<String, String> extensionsMapping) {
        Bundle bundle;
        if (extensionsMapping == null) {
            TextMateServiceImpl.$$$reportNull$$$0(13);
        }
        if ((bundle = this.createBundle(directory)) != null) {
            this.registerLanguageSupport(bundle, extensionsMapping);
            this.registerPreferences(bundle);
            this.registerSnippets(bundle);
            this.registerThemes(bundle);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerThemes(@NotNull Bundle bundle) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(14);
        }
        Map<String, TextMateTheme> map = this.myThemeHashMap;
        synchronized (map) {
            for (File themeFile : bundle.getThemeFiles()) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)themeFile, (boolean)true);
                this.registerTheme(virtualFile);
            }
        }
    }

    private void registerSnippets(@NotNull Bundle bundle) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(15);
        }
        for (File snippetFile : bundle.getSnippetFiles()) {
            try {
                TextMateSnippet snippet = PreferencesReadUtil.loadSnippet(snippetFile, this.myPlistReader.read(snippetFile));
                if (snippet == null) continue;
                this.mySnippetsRegistry.register(snippet);
            }
            catch (IOException e) {
                LOG.debug("Can't load textmate preferences file: " + snippetFile.getPath());
            }
        }
    }

    private void registerPreferences(@NotNull Bundle bundle) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(16);
        }
        for (File preferenceFile : bundle.getPreferenceFiles()) {
            try {
                for (Pair<String, Plist> settingsPair : bundle.loadPreferenceFile(preferenceFile)) {
                    if (settingsPair == null) continue;
                    this.myPreferencesRegistry.fillFromPList((String)settingsPair.first, (Plist)settingsPair.second);
                    this.myShellVariablesRegistry.fillVariablesFromPlist((String)settingsPair.first, (Plist)settingsPair.second);
                    this.readCustomHighlightingColors((String)settingsPair.first, (Plist)settingsPair.second);
                }
            }
            catch (IOException e) {
                LOG.debug("Can't load textmate preferences file: " + preferenceFile.getPath());
            }
        }
    }

    private void readCustomHighlightingColors(@NotNull String scopeName, @NotNull Plist preferencesPList) {
        TextAttributes textAttributes;
        boolean hasHighlightingSettings;
        if (scopeName == null) {
            TextMateServiceImpl.$$$reportNull$$$0(17);
        }
        if (preferencesPList == null) {
            TextMateServiceImpl.$$$reportNull$$$0(18);
        }
        if (hasHighlightingSettings = PreferencesReadUtil.fillTextAttributes(textAttributes = new TextAttributes(), preferencesPList, null)) {
            double backgroundAlpha = PreferencesReadUtil.getBackgroundAlpha(preferencesPList);
            this.myCustomHighlightingColors.put(scopeName, new TextMateCustomTextAttributes(textAttributes, backgroundAlpha));
        }
    }

    private void registerLanguageSupport(@NotNull Bundle bundle, @NotNull THashMap<String, String> extensionsMapping) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(19);
        }
        if (extensionsMapping == null) {
            TextMateServiceImpl.$$$reportNull$$$0(20);
        }
        for (File grammarFile : bundle.getGrammarFiles()) {
            try {
                Plist plist = this.myPlistReader.read(grammarFile);
                String rootScopeName = this.mySyntaxTable.loadSyntax(plist);
                Collection<String> extensions = bundle.getExtensions(grammarFile, plist);
                for (String extension : extensions) {
                    extensionsMapping.put((Object)extension, (Object)rootScopeName);
                }
            }
            catch (IOException e) {
                LOG.warn("Can't load textmate language file: " + grammarFile.getPath());
            }
        }
    }

    public static void disableBuiltinBundles(Disposable disposable) {
        ourBuiltinBundlesDisabled = true;
        TextMateService.getInstance().unregisterAllBundles();
        TextMateService.getInstance().registerEnabledBundles();
        Disposer.register((Disposable)disposable, () -> {
            ourBuiltinBundlesDisabled = false;
            TextMateService.getInstance().unregisterAllBundles();
            TextMateService.getInstance().registerEnabledBundles();
        });
    }

    static {
        PREINSTALLED_THEMES_PATH = FileUtil.join((String[])new String[]{PathManager.getCommunityHomePath(), "plugins", "textmate", "lib", "themes"});
        INSTALLED_THEMES_PATH = FileUtil.join((String[])new String[]{PathManager.getPluginsPath(), "textmate", "lib", "themes"});
        PREINSTALLED_BUNDLES_PATH = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{PathManager.getCommunityHomePath(), "plugins", "textmate", "lib", "bundles"}));
        INSTALLED_BUNDLES_PATH = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{PathManager.getPluginsPath(), "textmate", "lib", "bundles"}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/TextMateServiceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsMapping";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferencesPList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/TextMateServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlistReader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomHighlightingColors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferencesForSelector";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnippetsRegistry";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemeNames";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTheme";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPreferencesForSelector";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDescriptorByFileName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerBundle";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerThemes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerSnippets";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "registerPreferences";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readCustomHighlightingColors";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerLanguageSupport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

