/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceData;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0003H\u0002\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u000eH\u0002\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u0006\u0012\u0002\b\u00030\u0011H\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0011\u00a8\u0006\u0013"}, d2={"isApplicableCallForBuilderInference", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isCoroutineCallWithAdditionalInference", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "isGoodCallForOldCoroutines", "resultingDescriptor", "containsTypeTemplate", "Lorg/jetbrains/kotlin/types/KotlinType;", "getCoroutineInferenceData", "Lorg/jetbrains/kotlin/resolve/calls/inference/CoroutineInferenceData;", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "isResultWithCoroutineInference", "frontend"})
public final class CoroutineInferenceUtilKt {
    private static final boolean containsTypeTemplate(@NotNull KotlinType $this$containsTypeTemplate) {
        return TypeUtilsKt.contains($this$containsTypeTemplate, (Function1<? super UnwrappedType, Boolean>)((Function1)containsTypeTemplate.1.INSTANCE));
    }

    public static final boolean isApplicableCallForBuilderInference(@NotNull CallableDescriptor descriptor2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (!languageVersionSettings.supportsFeature(LanguageFeature.ExperimentalBuilderInference)) {
            return CoroutineInferenceUtilKt.isGoodCallForOldCoroutines(descriptor2);
        }
        if (DescriptorUtilsKt.isExtension(descriptor2) && !AnnotationsForResolveKt.hasBuilderInferenceAnnotation(descriptor2)) {
            Annotated annotated = descriptor2.getExtensionReceiverParameter();
            return annotated != null && (annotated = annotated.getType()) != null && !CoroutineInferenceUtilKt.containsTypeTemplate((KotlinType)annotated);
        }
        KotlinType kotlinType2 = descriptor2.getReturnType();
        if (kotlinType2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"descriptor.returnType ?: return false");
        KotlinType returnType2 = kotlinType2;
        return !CoroutineInferenceUtilKt.containsTypeTemplate(returnType2);
    }

    private static final boolean isGoodCallForOldCoroutines(CallableDescriptor resultingDescriptor) {
        boolean bl;
        block6: {
            KotlinType kotlinType2 = resultingDescriptor.getReturnType();
            if (kotlinType2 == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"resultingDescriptor.returnType ?: return false");
            KotlinType returnType2 = kotlinType2;
            if (CoroutineInferenceUtilKt.containsTypeTemplate(returnType2)) {
                return false;
            }
            if (!(resultingDescriptor instanceof FunctionDescriptor) || ((FunctionDescriptor)resultingDescriptor).isSuspend()) {
                return true;
            }
            List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)resultingDescriptor).getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resultingDescriptor.valueParameters");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    ValueParameterDescriptor valueParameterDescriptor = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"it");
                    KotlinType kotlinType3 = valueParameterDescriptor.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"it.type");
                    if (!CoroutineInferenceUtilKt.containsTypeTemplate(kotlinType3)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCoroutineCallWithAdditionalInference(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument2, @NotNull LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (languageVersionSettings.supportsFeature(LanguageFeature.ExperimentalBuilderInference)) {
            if (!AnnotationsForResolveKt.hasBuilderInferenceAnnotation(parameterDescriptor)) return false;
            if (!CoroutineUtilKt.getHasFunctionOrSuspendFunctionType(parameterDescriptor)) return false;
            bl = true;
        } else {
            bl = CoroutineUtilKt.getHasSuspendFunctionType(parameterDescriptor);
        }
        boolean parameterHasOptIn = bl;
        if (!parameterHasOptIn) return false;
        if (!(argument2.getArgumentExpression() instanceof KtLambdaExpression)) return false;
        KotlinType kotlinType2 = parameterDescriptor.getType();
        boolean bl2 = false;
        boolean bl3 = false;
        KotlinType it = kotlinType2;
        boolean bl4 = false;
        KotlinType kotlinType3 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"it");
        if (!FunctionTypesKt.isBuiltinFunctionalType(kotlinType3)) return false;
        if (FunctionTypesKt.getReceiverTypeFromFunctionType(it) == null) return false;
        return true;
    }

    public static final boolean isResultWithCoroutineInference(@NotNull OverloadResolutionResultsImpl<?> $this$isResultWithCoroutineInference) {
        Intrinsics.checkParameterIsNotNull($this$isResultWithCoroutineInference, (String)"$this$isResultWithCoroutineInference");
        return CoroutineInferenceUtilKt.getCoroutineInferenceData($this$isResultWithCoroutineInference) != null;
    }

    private static final CoroutineInferenceData getCoroutineInferenceData(@NotNull OverloadResolutionResultsImpl<?> $this$getCoroutineInferenceData) {
        if (!$this$getCoroutineInferenceData.isSingleResult()) {
            return null;
        }
        getCoroutineInferenceData.1 $fun$getData$1 = getCoroutineInferenceData.1.INSTANCE;
        ResolvedCall resolvedCall2 = $this$getCoroutineInferenceData.getResultingCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall2, (String)"resultingCall");
        CoroutineInferenceData coroutineInferenceData = $fun$getData$1.invoke(resolvedCall2.getDispatchReceiver());
        if (coroutineInferenceData == null) {
            ResolvedCall resolvedCall3 = $this$getCoroutineInferenceData.getResultingCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall3, (String)"resultingCall");
            coroutineInferenceData = $fun$getData$1.invoke(resolvedCall3.getExtensionReceiver());
        }
        return coroutineInferenceData;
    }

    public static final /* synthetic */ CoroutineInferenceData access$getCoroutineInferenceData(OverloadResolutionResultsImpl $this$access_u24getCoroutineInferenceData) {
        return CoroutineInferenceUtilKt.getCoroutineInferenceData($this$access_u24getCoroutineInferenceData);
    }
}

