/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.ExpressionKotlinCallArgumentImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/NullableVarargArgumentCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class NullableVarargArgumentCallChecker
implements CallChecker {
    public static final NullableVarargArgumentCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
            return;
        }
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            this.check(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getFunctionCall(), reportOn, context2);
            return;
        }
        if (!(resolvedCall2 instanceof NewResolvedCallImpl)) {
            return;
        }
        for (ResolvedCallArgument argument2 : ((NewResolvedCallImpl)resolvedCall2).getArgumentMappingByOriginal().values()) {
            for (KotlinCallArgument arg : argument2.getArguments()) {
                LeafPsiElement spreadElement;
                if (!arg.isSpread() || !(arg instanceof ExpressionKotlinCallArgumentImpl)) continue;
                if (((ExpressionKotlinCallArgumentImpl)arg).getValueArgument().getSpreadElement() == null) {
                    continue;
                }
                ReceiverValueWithSmartCastInfo $this$safeAs$iv = ((ExpressionKotlinCallArgumentImpl)arg).getReceiver();
                boolean $i$f$safeAs = false;
                ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo = $this$safeAs$iv;
                if (!(receiverValueWithSmartCastInfo instanceof ReceiverValueWithSmartCastInfo)) {
                    receiverValueWithSmartCastInfo = null;
                }
                if (receiverValueWithSmartCastInfo == null) {
                    continue;
                }
                ReceiverValueWithSmartCastInfo receiver2 = receiverValueWithSmartCastInfo;
                UnwrappedType type2 = ArgumentsUtilsKt.getStableType(receiver2);
                if (type2 instanceof FlexibleType || !TypeUtils.isNullableType(type2)) continue;
                context2.getTrace().report(Errors.SPREAD_OF_NULLABLE.on((LeafPsiElement)((PsiElement)spreadElement)));
            }
        }
    }

    private NullableVarargArgumentCallChecker() {
    }

    static {
        NullableVarargArgumentCallChecker nullableVarargArgumentCallChecker;
        INSTANCE = nullableVarargArgumentCallChecker = new NullableVarargArgumentCallChecker();
    }
}

