/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorCallExpressionImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012J1\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H\u0082\bJ\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/ErrorExpressionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "ignoreErrors", "", "getIgnoreErrors", "()Z", "generateErrorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ktCall", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "generateErrorExpression", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "body", "Lkotlin/Function0;", "generateErrorSimpleName", "ktName", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getErrorExpressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "ir.psi2ir"})
public final class ErrorExpressionGenerator
extends StatementGeneratorExtension {
    private final boolean getIgnoreErrors() {
        return this.getContext().getConfiguration().getIgnoreErrors();
    }

    private final IrExpression generateErrorExpression(KtElement ktElement, Exception e, Function0<? extends IrExpression> body2) {
        int $i$f$generateErrorExpression = 0;
        if (!this.getIgnoreErrors()) {
            Exception exception = e;
            throw (Throwable)new RuntimeException((exception != null ? exception.getMessage() : null) + ": " + ktElement.getClass().getSimpleName() + ":\n" + ktElement.getText(), e);
        }
        return (IrExpression)body2.invoke();
    }

    static /* synthetic */ IrExpression generateErrorExpression$default(ErrorExpressionGenerator this_, KtElement ktElement, Exception e, Function0 body2, int n, Object object) {
        if ((n & 2) != 0) {
            e = null;
        }
        boolean $i$f$generateErrorExpression = false;
        if (!this_.getIgnoreErrors()) {
            Exception exception = e;
            throw (Throwable)new RuntimeException((exception != null ? exception.getMessage() : null) + ": " + ktElement.getClass().getSimpleName() + ":\n" + ktElement.getText(), e);
        }
        return (IrExpression)body2.invoke();
    }

    @NotNull
    public final IrExpression generateErrorExpression(@NotNull KtElement ktElement, @NotNull Exception e) {
        String string;
        IrType irType;
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)ktElement, (String)"ktElement");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        ErrorExpressionGenerator this_$iv = this;
        boolean $i$f$generateErrorExpression = false;
        if (this_$iv.getIgnoreErrors()) {
            KotlinType kotlinType2;
            boolean bl = false;
            if (ktElement instanceof KtExpression) {
                kotlinType2 = this.getErrorExpressionType((KtExpression)ktElement);
            } else {
                SimpleType simpleType2 = ErrorUtils.createErrorType("");
                Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"ErrorUtils.createErrorType(\"\")");
                kotlinType2 = simpleType2;
            }
            KotlinType errorExpressionType = kotlinType2;
            n2 = PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)ktElement);
            n = PsiUtilsKt.getEndOffset((PsiElement)ktElement);
            irType = this.toIrType(errorExpressionType);
            string = e.getMessage();
            if (string == null) {
                string = "";
            }
        } else {
            throw (Throwable)new RuntimeException(e.getMessage() + ": " + ktElement.getClass().getSimpleName() + ":\n" + ktElement.getText(), e);
        }
        return new IrErrorExpressionImpl(n2, n, irType, string);
    }

    @NotNull
    public final IrExpression generateErrorCall(@NotNull KtCallExpression ktCall) {
        IrErrorCallExpressionImpl irErrorCall;
        Intrinsics.checkParameterIsNotNull((Object)ktCall, (String)"ktCall");
        ErrorExpressionGenerator this_$iv = this;
        Exception e$iv = null;
        boolean $i$f$generateErrorExpression = false;
        if (this_$iv.getIgnoreErrors()) {
            IrExpression irExpression;
            boolean bl = false;
            IrType type2 = this.toIrType(this.getErrorExpressionType(ktCall));
            IrErrorCallExpressionImpl irErrorCallExpressionImpl = irErrorCall = new IrErrorCallExpressionImpl(PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)ktCall), PsiUtilsKt.getEndOffset((PsiElement)ktCall), type2, "");
            PsiElement psiElement2 = ktCall.getParent();
            if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
                psiElement2 = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement2;
            if (ktDotQualifiedExpression != null) {
                KtDotQualifiedExpression ktDotQualifiedExpression2 = ktDotQualifiedExpression;
                IrErrorCallExpressionImpl irErrorCallExpressionImpl2 = irErrorCallExpressionImpl;
                boolean bl2 = false;
                boolean bl3 = false;
                KtDotQualifiedExpression $this$run = ktDotQualifiedExpression2;
                boolean bl4 = false;
                IrExpression irExpression2 = this.genExpr($this$run.getReceiverExpression());
                irErrorCallExpressionImpl = irErrorCallExpressionImpl2;
                irExpression = irExpression2;
            } else {
                irExpression = null;
            }
            irErrorCallExpressionImpl.setExplicitReceiver(irExpression);
            List<KtValueArgument> list2 = ktCall.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ktCall.valueArguments");
            Collection collection = list2;
            List<KtLambdaArgument> list3 = ktCall.getLambdaArguments();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"ktCall.lambdaArguments");
            Iterable $this$forEach$iv = CollectionsKt.plus((Collection)collection, (Iterable)list3);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtValueArgument it = (KtValueArgument)element$iv;
                boolean bl5 = false;
                KtExpression ktArgument = it.getArgumentExpression();
                if (ktArgument == null) continue;
                irErrorCall.addArgument(this.genExpr(ktArgument));
            }
        } else {
            throw (Throwable)new RuntimeException(null + ": " + ((KtElement)ktCall).getClass().getSimpleName() + ":\n" + ((KtElement)ktCall).getText(), e$iv);
        }
        return irErrorCall;
    }

    private final KotlinType getErrorExpressionType(KtExpression ktExpression) {
        KotlinType kotlinType2 = GeneratorKt.getInferredTypeWithImplicitCasts(this, ktExpression);
        if (kotlinType2 == null) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("");
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"ErrorUtils.createErrorType(\"\")");
            kotlinType2 = simpleType2;
        }
        return kotlinType2;
    }

    @NotNull
    public final IrExpression generateErrorSimpleName(@NotNull KtSimpleNameExpression ktName) {
        IrExpression irExpression;
        IrErrorCallExpressionImpl irErrorCallExpressionImpl;
        IrErrorCallExpressionImpl irErrorCall;
        Intrinsics.checkParameterIsNotNull((Object)ktName, (String)"ktName");
        ErrorExpressionGenerator this_$iv = this;
        Exception e$iv = null;
        boolean $i$f$generateErrorExpression = false;
        if (this_$iv.getIgnoreErrors()) {
            boolean bl = false;
            IrType type2 = this.toIrType(this.getErrorExpressionType(ktName));
            irErrorCallExpressionImpl = irErrorCall = new IrErrorCallExpressionImpl(PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)ktName), PsiUtilsKt.getEndOffset((PsiElement)ktName), type2, "");
            PsiElement psiElement2 = ktName.getParent();
            if (!(psiElement2 instanceof KtDotQualifiedExpression)) {
                psiElement2 = null;
            }
            KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement2;
            if (ktDotQualifiedExpression != null) {
                KtDotQualifiedExpression ktDotQualifiedExpression2 = ktDotQualifiedExpression;
                IrErrorCallExpressionImpl irErrorCallExpressionImpl2 = irErrorCallExpressionImpl;
                boolean bl2 = false;
                boolean bl3 = false;
                KtDotQualifiedExpression ktParent = ktDotQualifiedExpression2;
                boolean bl4 = false;
                IrExpression irExpression2 = Intrinsics.areEqual((Object)ktParent.getReceiverExpression(), (Object)ktName) ? null : this.genExpr(ktParent.getReceiverExpression());
                irErrorCallExpressionImpl = irErrorCallExpressionImpl2;
                irExpression = irExpression2;
            } else {
                irExpression = null;
            }
        } else {
            throw (Throwable)new RuntimeException(null + ": " + ((KtElement)ktName).getClass().getSimpleName() + ":\n" + ((KtElement)ktName).getText(), e$iv);
        }
        irErrorCallExpressionImpl.setExplicitReceiver(irExpression);
        return irErrorCall;
    }

    public ErrorExpressionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }
}

