/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.nullabilityAnalysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.AnalysisContext;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.Constraint;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.ConstraintBound;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.ConstraintCameFrom;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.ConstraintsKt;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.EqualConstraint;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.LiteralBound;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.Nullability;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.Printer;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.Solver;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.Solver$getTypeVariableAsEqualsOrUpperBound$;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.SubtypeConstraint;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariable;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariableBound;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0012\u0010\u000e\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012H\u0002J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\f*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001a\u0010\u001a\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u001a\u0010\u001c\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u001a\u0010\u001d\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u001a\u0010\u001e\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001b\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\r0\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/Solver;", "", "analysisContext", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/AnalysisContext;", "printConstraints", "", "(Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/AnalysisContext;Z)V", "printer", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/Printer;", "solveConstraints", "", "constraints", "", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/Constraint;", "cleanConstraints", "", "fixedNullability", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/Nullability;", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/ConstraintBound;", "getConstraintsWithNotNullUpperBound", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/SubtypeConstraint;", "cameFrom", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/ConstraintCameFrom;", "getConstraintsWithNullableLowerBound", "getTypeVariableAsEqualsOrUpperBound", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/TypeVariable;", "handleConstraintsWithNotNullUpperBound", "step", "handleConstraintsWithNullableLowerBound", "handleEqualConstraints", "printDebugInfo", "", "substituteConstraints", "nj2k-services"})
public final class Solver {
    private final Printer printer;
    private final AnalysisContext analysisContext;
    private final boolean printConstraints;

    private final void printDebugInfo(@NotNull List<? extends Constraint> $this$printDebugInfo, int step2) {
        Printer printer = this.printer;
        boolean bl = false;
        boolean bl2 = false;
        Printer $this$with = printer;
        boolean bl3 = false;
        if (this.printConstraints) {
            String string = "Step " + step2 + ':';
            boolean bl4 = false;
            System.out.println((Object)string);
            string = $this$with.listConstrains$nj2k_services($this$printDebugInfo);
            bl4 = false;
            System.out.println((Object)string);
            boolean bl5 = false;
            System.out.println();
            String string2 = "type variables:";
            bl4 = false;
            System.out.println((Object)string2);
            for (TypeVariable typeVariable2 : this.analysisContext.getTypeElementToTypeVariable().values()) {
                String string3 = $this$with.getName$nj2k_services(typeVariable2) + " := " + (Object)((Object)typeVariable2.getNullability());
                boolean bl6 = false;
                System.out.println((Object)string3);
            }
            string2 = "---------------\n";
            boolean bl7 = false;
            System.out.println((Object)string2);
        }
    }

    public final void solveConstraints(@NotNull List<? extends Constraint> constraints) {
        boolean somethingChanged;
        Intrinsics.checkParameterIsNotNull(constraints, (String)"constraints");
        List mutableConstraints = CollectionsKt.toMutableList((Collection)constraints);
        ConstraintCameFrom currentStep = (ConstraintCameFrom)((Object)ArraysKt.first((Object[])ConstraintCameFrom.values()));
        int i2 = 0;
        do {
            TypeVariable typeVariable2;
            somethingChanged = false;
            int n = 0;
            boolean bl = false;
            List $this$with = mutableConstraints;
            boolean bl2 = false;
            this.printDebugInfo($this$with, i2);
            somethingChanged = this.handleConstraintsWithNullableLowerBound($this$with, currentStep);
            somethingChanged = this.handleConstraintsWithNotNullUpperBound($this$with, currentStep) || somethingChanged;
            somethingChanged = this.handleEqualConstraints($this$with, currentStep) || somethingChanged;
            somethingChanged = this.substituteConstraints($this$with) || somethingChanged;
            this.cleanConstraints($this$with);
            if (!somethingChanged && currentStep.ordinal() < ArraysKt.getLastIndex((Object[])ConstraintCameFrom.values())) {
                currentStep = ConstraintCameFrom.values()[currentStep.ordinal() + 1];
                somethingChanged = true;
            }
            if (!somethingChanged && (typeVariable2 = this.getTypeVariableAsEqualsOrUpperBound(mutableConstraints)) != null) {
                ConstraintsKt.setNullabilityIfNotFixed(typeVariable2, Nullability.NOT_NULL);
                somethingChanged = true;
            }
            n = i2;
            i2 = n + 1;
        } while (somethingChanged);
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanConstraints(@NotNull List<Constraint> $this$cleanConstraints) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = CollectionsKt.distinct((Iterable)$this$cleanConstraints);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Constraint constraint = (Constraint)element$iv$iv;
            boolean bl = false;
            if (constraint instanceof SubtypeConstraint && ((SubtypeConstraint)constraint).getLowerBound() instanceof LiteralBound && ((SubtypeConstraint)constraint).getUpperBound() instanceof LiteralBound) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newConstraints = (List)destination$iv$iv;
        if (newConstraints.size() < $this$cleanConstraints.size()) {
            $this$cleanConstraints.clear();
            $this$cleanConstraints.addAll(newConstraints);
        }
    }

    private final boolean handleConstraintsWithNullableLowerBound(@NotNull List<Constraint> $this$handleConstraintsWithNullableLowerBound, ConstraintCameFrom step2) {
        boolean somethingChanged = false;
        List<SubtypeConstraint> nullableConstraints = this.getConstraintsWithNullableLowerBound($this$handleConstraintsWithNullableLowerBound, step2);
        Collection object2 = nullableConstraints;
        boolean bl = false;
        if (!object2.isEmpty()) {
            Collection collection = $this$handleConstraintsWithNullableLowerBound;
            bl = false;
            CollectionsKt.removeAll((Collection)collection, (Iterable)nullableConstraints);
            for (SubtypeConstraint subtypeConstraint : nullableConstraints) {
                ConstraintBound upperBound = subtypeConstraint.component2();
                if (!(upperBound instanceof TypeVariableBound)) continue;
                somethingChanged = true;
                ConstraintsKt.setNullabilityIfNotFixed(((TypeVariableBound)upperBound).getTypeVariable(), Nullability.NULLABLE);
            }
        }
        return somethingChanged;
    }

    private final boolean handleConstraintsWithNotNullUpperBound(@NotNull List<Constraint> $this$handleConstraintsWithNotNullUpperBound, ConstraintCameFrom step2) {
        boolean somethingChanged = false;
        List<SubtypeConstraint> nullableConstraints = this.getConstraintsWithNotNullUpperBound($this$handleConstraintsWithNotNullUpperBound, step2);
        Collection object2 = nullableConstraints;
        boolean bl = false;
        if (!object2.isEmpty()) {
            Collection collection = $this$handleConstraintsWithNotNullUpperBound;
            bl = false;
            CollectionsKt.removeAll((Collection)collection, (Iterable)nullableConstraints);
            for (SubtypeConstraint subtypeConstraint : nullableConstraints) {
                ConstraintBound lowerBound = subtypeConstraint.component1();
                if (!(lowerBound instanceof TypeVariableBound)) continue;
                somethingChanged = true;
                ConstraintsKt.setNullabilityIfNotFixed(((TypeVariableBound)lowerBound).getTypeVariable(), Nullability.NOT_NULL);
            }
        }
        return somethingChanged;
    }

    private final Nullability fixedNullability(@NotNull ConstraintBound $this$fixedNullability) {
        return $this$fixedNullability instanceof LiteralBound ? ((LiteralBound)$this$fixedNullability).getNullability() : ($this$fixedNullability instanceof TypeVariableBound && ConstraintsKt.isFixed(((TypeVariableBound)$this$fixedNullability).getTypeVariable()) ? ((TypeVariableBound)$this$fixedNullability).getTypeVariable().getNullability() : null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean handleEqualConstraints(@NotNull List<Constraint> $this$handleEqualConstraints, ConstraintCameFrom step2) {
        ConstraintBound $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        boolean somethingChanged = false;
        Iterable $this$filterIsInstance$iv = $this$handleEqualConstraints;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof EqualConstraint)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = iterator2.next();
            EqualConstraint it = (EqualConstraint)element$iv$iv;
            boolean bl = false;
            if (!(it.getCameFrom().compareTo((Enum)step2) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List equalsConstraints = (List)destination$iv$iv;
        $this$filter$iv = equalsConstraints;
        boolean bl = false;
        if (!$this$filter$iv.isEmpty()) {
            for (EqualConstraint constraint : equalsConstraints) {
                void leftBound;
                Object object = constraint;
                $this$filterTo$iv$iv = ((EqualConstraint)object).component1();
                ConstraintBound rightBound = ((EqualConstraint)object).component2();
                if (leftBound instanceof TypeVariableBound && this.fixedNullability(rightBound) != null) {
                    object = $this$handleEqualConstraints;
                    boolean bl2 = false;
                    object.remove(constraint);
                    somethingChanged = true;
                    TypeVariable typeVariable2 = ((TypeVariableBound)leftBound).getTypeVariable();
                    Nullability nullability2 = this.fixedNullability(rightBound);
                    if (nullability2 == null) {
                        Intrinsics.throwNpe();
                    }
                    ConstraintsKt.setNullabilityIfNotFixed(typeVariable2, nullability2);
                    continue;
                }
                if (!(rightBound instanceof TypeVariableBound) || this.fixedNullability((ConstraintBound)leftBound) == null) continue;
                object = $this$handleEqualConstraints;
                boolean bl3 = false;
                object.remove(constraint);
                somethingChanged = true;
                TypeVariable typeVariable3 = ((TypeVariableBound)rightBound).getTypeVariable();
                Nullability nullability3 = this.fixedNullability((ConstraintBound)leftBound);
                if (nullability3 == null) {
                    Intrinsics.throwNpe();
                }
                ConstraintsKt.setNullabilityIfNotFixed(typeVariable3, nullability3);
            }
        }
        return somethingChanged;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean substituteConstraints(@NotNull List<? extends Constraint> $this$substituteConstraints) {
        boolean somethingChanged = false;
        for (Constraint constraint : $this$substituteConstraints) {
            void lower2;
            if (!(constraint instanceof SubtypeConstraint)) continue;
            SubtypeConstraint subtypeConstraint = (SubtypeConstraint)constraint;
            ConstraintBound constraintBound = subtypeConstraint.component1();
            ConstraintBound upper = subtypeConstraint.component2();
            if (lower2 instanceof TypeVariableBound && ConstraintsKt.isFixed(((TypeVariableBound)lower2).getTypeVariable())) {
                somethingChanged = true;
                ((SubtypeConstraint)constraint).setLowerBound(new LiteralBound(((TypeVariableBound)lower2).getTypeVariable().getNullability()));
            }
            if (!(upper instanceof TypeVariableBound) || !ConstraintsKt.isFixed(((TypeVariableBound)upper).getTypeVariable())) continue;
            somethingChanged = true;
            ((SubtypeConstraint)constraint).setUpperBound(new LiteralBound(((TypeVariableBound)upper).getTypeVariable().getNullability()));
        }
        return somethingChanged;
    }

    /*
     * Unable to fully structure code
     */
    private final List<SubtypeConstraint> getConstraintsWithNullableLowerBound(@NotNull List<? extends Constraint> $this$getConstraintsWithNullableLowerBound, ConstraintCameFrom cameFrom) {
        $this$filterIsInstance$iv = $this$getConstraintsWithNullableLowerBound;
        $i$f$filterIsInstance = false;
        var5_5 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SubtypeConstraint)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            constraint = (SubtypeConstraint)element$iv$iv;
            $i$a$-filter-Solver$getConstraintsWithNullableLowerBound$1 = false;
            if (constraint.getCameFrom().compareTo((Enum)cameFrom) > 0) ** GOTO lbl-1000
            $this$safeAs$iv = constraint.getLowerBound();
            $i$f$safeAs = false;
            v0 = $this$safeAs$iv;
            if (!(v0 instanceof LiteralBound)) {
                v0 = null;
            }
            v1 = (LiteralBound)v0;
            if ((v1 != null ? v1.getNullability() : null) == Nullability.NULLABLE) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final List<SubtypeConstraint> getConstraintsWithNotNullUpperBound(@NotNull List<? extends Constraint> $this$getConstraintsWithNotNullUpperBound, ConstraintCameFrom cameFrom) {
        $this$filterIsInstance$iv = $this$getConstraintsWithNotNullUpperBound;
        $i$f$filterIsInstance = false;
        var5_5 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SubtypeConstraint)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            constraint = (SubtypeConstraint)element$iv$iv;
            $i$a$-filter-Solver$getConstraintsWithNotNullUpperBound$1 = false;
            if (constraint.getCameFrom().compareTo((Enum)cameFrom) > 0) ** GOTO lbl-1000
            $this$safeAs$iv = constraint.getUpperBound();
            $i$f$safeAs = false;
            v0 = $this$safeAs$iv;
            if (!(v0 instanceof LiteralBound)) {
                v0 = null;
            }
            v1 = (LiteralBound)v0;
            if ((v1 != null ? v1.getNullability() : null) == Nullability.NOT_NULL) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final TypeVariable getTypeVariableAsEqualsOrUpperBound(@NotNull List<? extends Constraint> $this$getTypeVariableAsEqualsOrUpperBound) {
        Object object;
        Object v1;
        boolean $i$f$firstIsInstanceOrNull;
        Sequence $this$firstIsInstanceOrNull$iv;
        boolean $i$f$filterIsInstance;
        Sequence $this$filterIsInstance$iv;
        block5: {
            $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)$this$getTypeVariableAsEqualsOrUpperBound);
            $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getTypeVariableAsEqualsOrUpperBound$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            $this$firstIsInstanceOrNull$iv = SequencesKt.map((Sequence)sequence2, (Function1)getTypeVariableAsEqualsOrUpperBound.1.INSTANCE);
            $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof TypeVariableBound)) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        if ((object = (TypeVariableBound)v1) == null || (object = ((TypeVariableBound)object).getTypeVariable()) == null) {
            Object v4;
            block6: {
                $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)$this$getTypeVariableAsEqualsOrUpperBound);
                $i$f$filterIsInstance = false;
                Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getTypeVariableAsEqualsOrUpperBound$$inlined$filterIsInstance$2.INSTANCE);
                if (sequence3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                $this$firstIsInstanceOrNull$iv = SequencesKt.flatMap((Sequence)sequence3, (Function1)getTypeVariableAsEqualsOrUpperBound.2.INSTANCE);
                $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof TypeVariableBound)) continue;
                    v4 = element$iv;
                    break block6;
                }
                v4 = null;
            }
            TypeVariableBound typeVariableBound = v4;
            object = typeVariableBound != null ? typeVariableBound.getTypeVariable() : null;
        }
        return object;
    }

    public Solver(@NotNull AnalysisContext analysisContext, boolean printConstraints) {
        Intrinsics.checkParameterIsNotNull((Object)analysisContext, (String)"analysisContext");
        this.analysisContext = analysisContext;
        this.printConstraints = printConstraints;
        this.printer = new Printer(this.analysisContext);
    }
}

