/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.nullabilityAnalysis;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.nj2k.JKElementInfoLabel;
import org.jetbrains.kotlin.nj2k.JKElementInfoStorageKt;
import org.jetbrains.kotlin.nj2k.NewJ2kConverterContext;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.AnalysisContext;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.AnalysisScope;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.ClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.ConstraintsKt;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.FunctionCallTypeArgumentTarget;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.JavaClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.KtClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.NullabilityAnalysisKt;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.NullabilityAnalysisKt$$special$;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.NullabilityAnalysisKt$WhenMappings;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeParameterClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariable;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariableOwner;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.UnknownClassReference;
import org.jetbrains.kotlin.nj2k.postProcessing.UtilsKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0005H\u0000\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\tH\u0002\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u000bH\u0000\u001a.\u0010\f\u001a\u00020\u0001*\u00020\t2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"changeNullability", "", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/TypeVariable;", "toNullable", "", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "classReference", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/ClassReference;", "clearUndefinedLabels", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/AnalysisScope;", "fixTypeVariablesNullability", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/AnalysisContext;", "prepareTypeElements", "prepareTypeElement", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/nj2k/NewJ2kConverterContext;", "conversionContext", "nj2k-services"})
public final class NullabilityAnalysisKt {
    public static final void changeNullability(@NotNull TypeVariable $this$changeNullability, boolean toNullable) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)$this$changeNullability, (String)"$this$changeNullability");
            KtTypeElement ktTypeElement = $this$changeNullability.getTypeElement();
            if (ktTypeElement == null) break block0;
            NullabilityAnalysisKt.changeNullability(ktTypeElement, toNullable);
        }
    }

    public static final void changeNullability(@NotNull KtTypeElement $this$changeNullability, boolean toNullable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$changeNullability, (String)"$this$changeNullability");
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)$this$changeNullability, false, 2, null);
        if ($this$changeNullability instanceof KtNullableType && !toNullable) {
            KtTypeElement ktTypeElement = ((KtNullableType)$this$changeNullability).getInnerType();
            if (ktTypeElement == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeElement, (String)"innerType!!");
            String string = ktTypeElement.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"innerType!!.text");
            KtTypeElement ktTypeElement2 = factory2.createType(string).getTypeElement();
            if (ktTypeElement2 == null) {
                Intrinsics.throwNpe();
            }
            $this$changeNullability.replace((PsiElement)ktTypeElement2);
        }
        if (!($this$changeNullability instanceof KtNullableType) && toNullable) {
            KtTypeElement ktTypeElement = factory2.createType($this$changeNullability.getText() + '?').getTypeElement();
            if (ktTypeElement == null) {
                Intrinsics.throwNpe();
            }
            $this$changeNullability.replace((PsiElement)ktTypeElement);
        }
    }

    public static final void fixTypeVariablesNullability(@NotNull AnalysisContext $this$fixTypeVariablesNullability) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fixTypeVariablesNullability, (String)"$this$fixTypeVariablesNullability");
        if ($this$fixTypeVariablesNullability.getTypeElementToTypeVariable().isEmpty()) {
            return;
        }
        Comparator deepComparator2 = fixTypeVariablesNullability.deepComparator.1.INSTANCE;
        for (TypeVariableOwner typeVariableOwner : $this$fixTypeVariablesNullability.getTypeVariableOwners()) {
            for (TypeVariable typeVariable2 : CollectionsKt.sortedWith((Iterable)CollectionsKt.plus((Collection)ConstraintsKt.innerTypeVariables(typeVariableOwner), (Iterable)ConstraintsKt.getAllTypeVariables(typeVariableOwner)), (Comparator)deepComparator2)) {
                switch (NullabilityAnalysisKt$WhenMappings.$EnumSwitchMapping$0[typeVariable2.getNullability().ordinal()]) {
                    case 1: {
                        NullabilityAnalysisKt.changeNullability(typeVariable2, false);
                        break;
                    }
                    case 2: {
                        NullabilityAnalysisKt.changeNullability(typeVariable2, true);
                        break;
                    }
                    case 3: {
                        if (typeVariableOwner instanceof FunctionCallTypeArgumentTarget) {
                            NullabilityAnalysisKt.changeNullability(typeVariable2, false);
                            break;
                        }
                        NullabilityAnalysisKt.changeNullability(typeVariable2, true);
                    }
                }
            }
        }
    }

    @NotNull
    public static final ClassReference classReference(@NotNull KtTypeElement $this$classReference) {
        ClassReference classReference2;
        KtElement ktElement;
        KtUserType ktUserType2;
        Intrinsics.checkParameterIsNotNull((Object)$this$classReference, (String)"$this$classReference");
        KtTypeElement ktTypeElement = $this$classReference;
        if (ktTypeElement instanceof KtNullableType) {
            KtTypeElement ktTypeElement2 = ((KtNullableType)$this$classReference).getInnerType();
            if (ktTypeElement2 != null) {
                KtTypeElement $this$safeAs$iv = ktTypeElement2;
                boolean $i$f$safeAs = false;
                KtTypeElement ktTypeElement3 = $this$safeAs$iv;
                if (!(ktTypeElement3 instanceof KtUserType)) {
                    ktTypeElement3 = null;
                }
                ktUserType2 = (KtUserType)ktTypeElement3;
            } else {
                ktUserType2 = null;
            }
        } else {
            ktUserType2 = ktElement = ktTypeElement instanceof KtUserType ? (KtUserType)$this$classReference : null;
        }
        PsiElement target = ktUserType2 != null && (ktElement = ktElement.getReferenceExpression()) != null ? UtilsKt.resolve((KtReferenceExpression)ktElement) : null;
        ktTypeElement = target;
        if (ktTypeElement instanceof KtClassOrObject) {
            classReference2 = new KtClassReference((KtClassOrObject)target);
        } else if (ktTypeElement instanceof PsiClass) {
            classReference2 = new JavaClassReference((PsiClass)target);
        } else if (ktTypeElement instanceof KtTypeAlias) {
            KtElement ktElement2 = ((KtTypeAlias)target).getTypeReference();
            if ((ktElement2 != null && (ktElement2 = ktElement2.getTypeElement()) != null ? NullabilityAnalysisKt.classReference((KtTypeElement)ktElement2) : (classReference2 = null)) == null) {
                Intrinsics.throwNpe();
            }
        } else if (ktTypeElement instanceof KtTypeParameter) {
            classReference2 = new TypeParameterClassReference((KtTypeParameter)target);
        } else {
            String string = $this$classReference.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
            classReference2 = new UnknownClassReference(string);
        }
        return classReference2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void prepareTypeElements(@NotNull AnalysisScope $this$prepareTypeElements, Function2<? super KtTypeElement, ? super NewJ2kConverterContext, Unit> prepareTypeElement, NewJ2kConverterContext conversionContext) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$prepareTypeElements;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$forEachDescendantOfType$iv$iv$iv;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            PsiElement $this$collectDescendantsOfType$iv = it;
            Function1 predicate$iv = $special$$inlined$collectDescendantsOfType$1.INSTANCE;
            boolean $i$f$collectDescendantsOfType = false;
            PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
            boolean $i$f$collectDescendantsOfType2 = false;
            ArrayList result$iv$iv = new ArrayList();
            PsiElement psiElement2 = $this$collectDescendantsOfType$iv$iv;
            Function1 action$iv$iv$iv = (Function1)new Function1<KtTypeReference, Unit>(predicate$iv, result$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ ArrayList $result;
                {
                    this.$predicate = function1;
                    this.$result = arrayList;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                        this.$result.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            $this$forEachDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $captured_local_variable$1;
                }

                public void visitElement(@NotNull PsiElement element3) {
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    PsiElement it = element3;
                    boolean bl = false;
                    super.visitElement(element3);
                    if (element3 instanceof KtTypeReference) {
                        this.$action.invoke((Object)element3);
                    }
                }
            });
            Iterable list$iv$iv = result$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List typeElements = (List)destination$iv$iv;
        Iterable $this$forEach$iv = typeElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtTypeElement typeElement;
            KtTypeReference typeReference2 = (KtTypeReference)element$iv;
            boolean bl = false;
            if (typeReference2.getTypeElement() == null) {
                continue;
            }
            PsiElement $this$parentOfType$iv = (PsiElement)typeElement;
            boolean $i$f$parentOfType = false;
            if (PsiTreeUtilKt.parentOfType((PsiElement)$this$parentOfType$iv, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(KtSuperTypeCallEntry.class)}) != null) continue;
            prepareTypeElement.invoke((Object)typeElement, (Object)conversionContext);
        }
    }

    private static final void clearUndefinedLabels(@NotNull AnalysisScope $this$clearUndefinedLabels) {
        boolean bl = false;
        List comments = new ArrayList();
        Iterable $this$forEach$iv = $this$clearUndefinedLabels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement element3 = (PsiElement)element$iv;
            boolean bl2 = false;
            element3.accept(new PsiElementVisitor(comments){
                final /* synthetic */ List $comments$inlined;
                {
                    this.$comments$inlined = list2;
                }

                public void visitElement(@NotNull PsiElement element3) {
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    element3.acceptChildren((PsiElementVisitor)this);
                }

                public void visitComment(@NotNull PsiComment comment) {
                    Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
                    String string = comment.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"comment.text");
                    String string2 = JKElementInfoStorageKt.asLabel(string);
                    if (Intrinsics.areEqual((Object)(string2 != null ? JKElementInfoLabel.box-impl(string2) : null), null) ^ true) {
                        Collection collection = this.$comments$inlined;
                        boolean bl = false;
                        collection.add(comment);
                    }
                }
            });
        }
        $this$forEach$iv = comments;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiComment it = (PsiComment)element$iv;
            boolean bl3 = false;
            it.delete();
        }
    }

    public static final /* synthetic */ void access$prepareTypeElements(AnalysisScope $this$access_u24prepareTypeElements, Function2 prepareTypeElement, NewJ2kConverterContext conversionContext) {
        NullabilityAnalysisKt.prepareTypeElements($this$access_u24prepareTypeElements, (Function2<? super KtTypeElement, ? super NewJ2kConverterContext, Unit>)prepareTypeElement, conversionContext);
    }

    public static final /* synthetic */ void access$clearUndefinedLabels(AnalysisScope $this$access_u24clearUndefinedLabels) {
        NullabilityAnalysisKt.clearUndefinedLabels($this$access_u24clearUndefinedLabels);
    }
}

