/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.nullabilityAnalysis;

import com.intellij.psi.PsiTypeParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.BoundType;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.ClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.ConstraintBound;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.DescriptorClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.GenericBoundType;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.JavaClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.KtClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.LiteralBound;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.LiteralBoundType;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.MultipleTypeVariablesOwner;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.Nullability;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.SingleTypeVariableOwner;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.StarProjectionBoundType;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeParameterClassReference;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariable;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariableBound;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariableBoundType;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariableOwner;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariableTypeParameter;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.TypeVariableTypeParameterWithTypeParameter;
import org.jetbrains.kotlin.nj2k.nullabilityAnalysis.UnknownClassReference;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0002H\u0000\u001a\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\fH\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\f\u0010\u0019\u001a\u00020\u0015*\u00020\u001aH\u0002\u001a(\u0010\u001b\u001a\u0002H\u001c\"\n\b\u0000\u0010\u001c\u0018\u0001*\u00020\b*\u0002H\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0080\b\u00a2\u0006\u0002\u0010\u001d\"\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0019\u0010\u0006\u001a\u00020\u0007*\u00020\b8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0018\u0010\u000b\u001a\u00020\f*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u001e"}, d2={"allTypeVariables", "", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/TypeVariable;", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/TypeVariableOwner;", "getAllTypeVariables", "(Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/TypeVariableOwner;)Ljava/util/List;", "bound", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/ConstraintBound;", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/BoundType;", "getBound", "(Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/BoundType;)Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/ConstraintBound;", "isFixed", "", "(Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/TypeVariable;)Z", "innerTypeVariables", "nullableForTrue", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/Nullability;", "setNullabilityIfNotFixed", "", "nullability", "typeParametersVariance", "Lorg/jetbrains/kotlin/types/Variance;", "Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/ClassReference;", "parameterIndex", "", "variance", "Lcom/intellij/psi/PsiTypeParameter;", "withForcedNullability", "T", "(Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/BoundType;Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/Nullability;)Lorg/jetbrains/kotlin/nj2k/nullabilityAnalysis/BoundType;", "nj2k-services"})
public final class ConstraintsKt {
    @NotNull
    public static final List<TypeVariable> getAllTypeVariables(@NotNull TypeVariableOwner $this$allTypeVariables) {
        List<TypeVariable> list2;
        Intrinsics.checkParameterIsNotNull((Object)$this$allTypeVariables, (String)"$this$allTypeVariables");
        TypeVariableOwner typeVariableOwner = $this$allTypeVariables;
        if (typeVariableOwner instanceof SingleTypeVariableOwner) {
            list2 = CollectionsKt.listOf((Object)((SingleTypeVariableOwner)$this$allTypeVariables).getTypeVariable());
        } else if (typeVariableOwner instanceof MultipleTypeVariablesOwner) {
            list2 = ((MultipleTypeVariablesOwner)$this$allTypeVariables).getTypeVariables();
        } else {
            String string = "TypeVariableOwner should be either SingleTypeVariableOwner or MultipleTypeVariablesOwner";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return list2;
    }

    @NotNull
    public static final ConstraintBound getBound(@NotNull BoundType $this$bound) {
        ConstraintBound constraintBound;
        int $i$f$getBound = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$bound, (String)"$this$bound");
        if ($this$bound.getForcedNullabilityTo() != null) {
            Nullability nullability2 = $this$bound.getForcedNullabilityTo();
            if (nullability2 == null) {
                Intrinsics.throwNpe();
            }
            constraintBound = new LiteralBound(nullability2);
        } else if ($this$bound instanceof TypeVariableBoundType) {
            constraintBound = new TypeVariableBound(((TypeVariableBoundType)$this$bound).getTypeVariable());
        } else if ($this$bound instanceof LiteralBoundType) {
            constraintBound = new LiteralBound(ConstraintsKt.nullableForTrue(((LiteralBoundType)$this$bound).isNull()));
        } else if ($this$bound instanceof GenericBoundType) {
            constraintBound = new LiteralBound(ConstraintsKt.nullableForTrue(((GenericBoundType)$this$bound).isNull()));
        } else if ($this$bound instanceof StarProjectionBoundType) {
            constraintBound = new LiteralBound(Nullability.NULLABLE);
        } else {
            String string = "Bad bound type " + $this$bound;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return constraintBound;
    }

    private static final <T extends BoundType> T withForcedNullability(@NotNull T $this$withForcedNullability, Nullability nullability2) {
        T t;
        int $i$f$withForcedNullability = 0;
        if ($this$withForcedNullability.getForcedNullabilityTo() == nullability2 || nullability2 == null) {
            t = $this$withForcedNullability;
        } else {
            T t2 = $this$withForcedNullability;
            Object object = t2 instanceof GenericBoundType ? (BoundType)new GenericBoundType($this$withForcedNullability.getClassReference(), $this$withForcedNullability.getTypeParameters(), nullability2, ((GenericBoundType)$this$withForcedNullability).isNull()) : (t2 instanceof TypeVariableBoundType ? (BoundType)new TypeVariableBoundType(((TypeVariableBoundType)$this$withForcedNullability).getTypeVariable(), nullability2) : (t2 instanceof LiteralBoundType ? $this$withForcedNullability : $this$withForcedNullability));
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            t = object;
        }
        return t;
    }

    private static final Variance variance(@NotNull PsiTypeParameter $this$variance) {
        return Variance.INVARIANT;
    }

    @NotNull
    public static final Variance typeParametersVariance(@NotNull ClassReference $this$typeParametersVariance, int parameterIndex2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$this$typeParametersVariance, (String)"$this$typeParametersVariance");
        ClassReference classReference2 = $this$typeParametersVariance;
        if (classReference2 instanceof KtClassReference) {
            List<KtTypeParameter> list2 = ((KtClassReference)$this$typeParametersVariance).getKlass().getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"klass.typeParameters");
            Object object2 = (KtTypeParameter)CollectionsKt.getOrNull(list2, (int)parameterIndex2);
            if (object2 == null || (object2 = object2.getVariance()) == null) {
                object2 = Variance.INVARIANT;
            }
            object = object2;
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"klass.typeParameters.get\u2026nce ?: Variance.INVARIANT");
        } else if (classReference2 instanceof JavaClassReference) {
            Object[] objectArray = ((JavaClassReference)$this$typeParametersVariance).getKlass().getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"klass.typeParameters");
            object = (PsiTypeParameter)ArraysKt.getOrNull((Object[])objectArray, (int)parameterIndex2);
            if (object == null || (object = ConstraintsKt.variance((PsiTypeParameter)object)) == null) {
                object = Variance.INVARIANT;
            }
        } else if (classReference2 instanceof DescriptorClassReference) {
            TypeConstructor typeConstructor2 = ((DescriptorClassReference)$this$typeParametersVariance).getDescriptor().getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"descriptor.typeConstructor");
            TypeParameterDescriptor typeParameterDescriptor = typeConstructor2.getParameters().get(parameterIndex2);
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"descriptor.typeConstruct\u2026arameters[parameterIndex]");
            Variance variance = typeParameterDescriptor.getVariance();
            object = variance;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)variance), (String)"descriptor.typeConstruct\u2026[parameterIndex].variance");
        } else if (classReference2 instanceof TypeParameterClassReference) {
            object = Variance.INVARIANT;
        } else if (classReference2 instanceof UnknownClassReference) {
            object = Variance.INVARIANT;
        } else {
            String string = "Bad class reference `" + $this$typeParametersVariance + '`';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return object;
    }

    public static final void setNullabilityIfNotFixed(@NotNull TypeVariable $this$setNullabilityIfNotFixed, @NotNull Nullability nullability2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setNullabilityIfNotFixed, (String)"$this$setNullabilityIfNotFixed");
        Intrinsics.checkParameterIsNotNull((Object)((Object)nullability2), (String)"nullability");
        if (!ConstraintsKt.isFixed($this$setNullabilityIfNotFixed)) {
            $this$setNullabilityIfNotFixed.setNullability(nullability2);
        }
    }

    public static final boolean isFixed(@NotNull TypeVariable $this$isFixed) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isFixed, (String)"$this$isFixed");
        return $this$isFixed.getNullability() != Nullability.UNKNOWN;
    }

    @NotNull
    public static final Nullability nullableForTrue(boolean $this$nullableForTrue) {
        return $this$nullableForTrue ? Nullability.NULLABLE : Nullability.NOT_NULL;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeVariable> innerTypeVariables(@NotNull TypeVariableOwner $this$innerTypeVariables) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)$this$innerTypeVariables, (String)"$this$innerTypeVariables");
        TypeVariableOwner typeVariableOwner = $this$innerTypeVariables;
        if (typeVariableOwner instanceof SingleTypeVariableOwner) {
            list2 = ConstraintsKt.innerTypeVariables(((SingleTypeVariableOwner)$this$innerTypeVariables).getTypeVariable());
        } else if (typeVariableOwner instanceof MultipleTypeVariablesOwner) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ((MultipleTypeVariablesOwner)$this$innerTypeVariables).getTypeVariables();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                TypeVariable it = (TypeVariable)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ConstraintsKt.innerTypeVariables(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            String string = "";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeVariable> innerTypeVariables(@NotNull TypeVariable $this$innerTypeVariables) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$innerTypeVariables, (String)"$this$innerTypeVariables");
        Iterable $this$flatMap$iv = $this$innerTypeVariables.getTypeParameters();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            boolean bl;
            TypeVariableTypeParameterWithTypeParameter typeVariableTypeParameterWithTypeParameter;
            TypeVariableTypeParameter typeParameter = (TypeVariableTypeParameter)element$iv$iv;
            boolean bl2 = false;
            TypeVariableTypeParameter $this$safeAs$iv = typeParameter;
            boolean $i$f$safeAs = false;
            TypeVariableTypeParameter typeVariableTypeParameter = $this$safeAs$iv;
            if (!(typeVariableTypeParameter instanceof TypeVariableTypeParameterWithTypeParameter)) {
                typeVariableTypeParameter = null;
            }
            TypeVariableTypeParameterWithTypeParameter typeVariableTypeParameterWithTypeParameter2 = (TypeVariableTypeParameterWithTypeParameter)typeVariableTypeParameter;
            if (typeVariableTypeParameterWithTypeParameter2 != null) {
                typeVariableTypeParameterWithTypeParameter = typeVariableTypeParameterWithTypeParameter2;
                bl = false;
                boolean bl3 = false;
                TypeVariableTypeParameterWithTypeParameter typeVariableTypeParameter2 = typeVariableTypeParameterWithTypeParameter;
                boolean bl4 = false;
                list2 = CollectionsKt.plus((Collection)ConstraintsKt.innerTypeVariables(typeVariableTypeParameter2.getTypeVariable()), (Iterable)CollectionsKt.listOfNotNull((Object)typeVariableTypeParameter2.getTypeVariable()));
            } else {
                list2 = null;
            }
            typeVariableTypeParameterWithTypeParameter = list2;
            bl = false;
            Object object = typeVariableTypeParameterWithTypeParameter;
            if (object == null) {
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

