/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaMember;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.NonReportingOverrideStrategy;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.serialization.deserialization.ErrorReporter;

public final class DescriptorResolverUtils {
    private DescriptorResolverUtils() {
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Collection<D> resolveOverridesForNonStaticMembers(@NotNull Name name2, @NotNull Collection<D> membersFromSupertypes, @NotNull Collection<D> membersFromCurrent, @NotNull ClassDescriptor classDescriptor2, @NotNull ErrorReporter errorReporter) {
        if (name2 == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(0);
        }
        if (membersFromSupertypes == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(1);
        }
        if (membersFromCurrent == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(2);
        }
        if (classDescriptor2 == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(3);
        }
        if (errorReporter == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(4);
        }
        return DescriptorResolverUtils.resolveOverrides(name2, membersFromSupertypes, membersFromCurrent, classDescriptor2, errorReporter, false);
    }

    @NotNull
    public static <D extends CallableMemberDescriptor> Collection<D> resolveOverridesForStaticMembers(@NotNull Name name2, @NotNull Collection<D> membersFromSupertypes, @NotNull Collection<D> membersFromCurrent, @NotNull ClassDescriptor classDescriptor2, @NotNull ErrorReporter errorReporter) {
        if (name2 == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(5);
        }
        if (membersFromSupertypes == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(6);
        }
        if (membersFromCurrent == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(7);
        }
        if (classDescriptor2 == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(8);
        }
        if (errorReporter == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(9);
        }
        return DescriptorResolverUtils.resolveOverrides(name2, membersFromSupertypes, membersFromCurrent, classDescriptor2, errorReporter, true);
    }

    @NotNull
    private static <D extends CallableMemberDescriptor> Collection<D> resolveOverrides(@NotNull Name name2, @NotNull Collection<D> membersFromSupertypes, @NotNull Collection<D> membersFromCurrent, @NotNull ClassDescriptor classDescriptor2, final @NotNull ErrorReporter errorReporter, final boolean isStaticContext) {
        if (name2 == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(10);
        }
        if (membersFromSupertypes == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(11);
        }
        if (membersFromCurrent == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(12);
        }
        if (classDescriptor2 == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(13);
        }
        if (errorReporter == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(14);
        }
        final LinkedHashSet result2 = new LinkedHashSet();
        OverridingUtil.generateOverridesInFunctionGroup(name2, membersFromSupertypes, membersFromCurrent, classDescriptor2, new NonReportingOverrideStrategy(){

            @Override
            public void addFakeOverride(@NotNull CallableMemberDescriptor fakeOverride) {
                if (fakeOverride == null) {
                    1.$$$reportNull$$$0(0);
                }
                OverridingUtil.resolveUnknownVisibilityForMember(fakeOverride, new Function1<CallableMemberDescriptor, Unit>(){

                    public Unit invoke(@NotNull CallableMemberDescriptor descriptor2) {
                        if (descriptor2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        errorReporter.reportCannotInferVisibility(descriptor2);
                        return Unit.INSTANCE;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/load/java/components/DescriptorResolverUtils$1$1", "invoke"));
                    }
                });
                result2.add(fakeOverride);
            }

            @Override
            public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                if (fromSuper == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (fromCurrent == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            @Override
            public void setOverriddenDescriptors(@NotNull CallableMemberDescriptor member, @NotNull Collection<? extends CallableMemberDescriptor> overridden) {
                if (member == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (overridden == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (isStaticContext && member.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                    return;
                }
                super.setOverriddenDescriptors(member, overridden);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fakeOverride";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fromSuper";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fromCurrent";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "member";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "overridden";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/load/java/components/DescriptorResolverUtils$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addFakeOverride";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "conflict";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setOverriddenDescriptors";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(15);
        }
        return linkedHashSet;
    }

    @Nullable
    public static ValueParameterDescriptor getAnnotationParameterByName(@NotNull Name name2, @NotNull ClassDescriptor annotationClass) {
        Collection<ClassConstructorDescriptor> constructors2;
        if (name2 == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(16);
        }
        if (annotationClass == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(17);
        }
        if ((constructors2 = annotationClass.getConstructors()).size() != 1) {
            return null;
        }
        for (ValueParameterDescriptor parameter : constructors2.iterator().next().getValueParameters()) {
            if (!parameter.getName().equals(name2)) continue;
            return parameter;
        }
        return null;
    }

    public static boolean isObjectMethodInInterface(@NotNull JavaMember member) {
        if (member == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(18);
        }
        return member.getContainingClass().isInterface() && member instanceof JavaMethod && DescriptorResolverUtils.isObjectMethod((JavaMethod)member);
    }

    private static boolean isObjectMethod(@NotNull JavaMethod method) {
        String name2;
        if (method == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(19);
        }
        if ((name2 = method.getName().asString()).equals("toString") || name2.equals("hashCode")) {
            return method.getValueParameters().isEmpty();
        }
        if (name2.equals("equals")) {
            return DescriptorResolverUtils.isMethodWithOneObjectParameter(method);
        }
        return false;
    }

    private static boolean isMethodWithOneObjectParameter(@NotNull JavaMethod method) {
        JavaClassifier classifier;
        JavaType type2;
        List<JavaValueParameter> parameters2;
        if (method == null) {
            DescriptorResolverUtils.$$$reportNull$$$0(20);
        }
        if ((parameters2 = method.getValueParameters()).size() == 1 && (type2 = parameters2.get(0).getType()) instanceof JavaClassifierType && (classifier = ((JavaClassifierType)type2).getClassifier()) instanceof JavaClass) {
            FqName classFqName = ((JavaClass)classifier).getFqName();
            return classFqName != null && classFqName.asString().equals("java.lang.Object");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersFromSupertypes";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersFromCurrent";
                break;
            }
            case 3: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 4: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorReporter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/load/java/components/DescriptorResolverUtils";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/load/java/components/DescriptorResolverUtils";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveOverrides";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveOverridesForNonStaticMembers";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveOverridesForStaticMembers";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveOverrides";
                break;
            }
            case 15: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationParameterByName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isObjectMethodInInterface";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isObjectMethod";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isMethodWithOneObjectParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

