/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.clean.ReferenceTracker;
import org.jetbrains.kotlin.js.inline.clean.RemoveUnusedLocalFunctionDeclarationsKt;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u001c\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000e2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/UnusedInstanceCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "()V", "removableDeclarations", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "getRemovableDeclarations", "()Ljava/util/List;", "tracker", "Lorg/jetbrains/kotlin/js/inline/clean/ReferenceTracker;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "isLocalFunctionDeclaration", "", "jsVar", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "visit", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "js.translator"})
final class UnusedInstanceCollector
extends JsVisitorWithContextImpl {
    private final ReferenceTracker<JsName, JsStatement> tracker = new ReferenceTracker();

    @NotNull
    public final List<JsStatement> getRemovableDeclarations() {
        return this.tracker.getRemovable();
    }

    public boolean visit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx2) {
        JsStatement currentStatement;
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx2, (String)"ctx");
        if (!this.isLocalFunctionDeclaration(x)) {
            return super.visit(x, ctx2);
        }
        JsName jsName = x.getName();
        if (jsName == null) {
            Intrinsics.throwNpe();
        }
        JsName name2 = jsName;
        JsContext<JsStatement> jsContext = this.getLastStatementLevelContext();
        Intrinsics.checkExpressionValueIsNotNull(jsContext, (String)"lastStatementLevelContext");
        JsContext<JsStatement> statementContext = jsContext;
        JsStatement jsStatement = currentStatement = statementContext.getCurrentNode();
        if (jsStatement == null) {
            Intrinsics.throwNpe();
        }
        this.tracker.addCandidateForRemoval(name2, (JsStatement)((JsNode)jsStatement));
        Set<JsName> references2 = CollectUtilsKt.collectUsedNames(x);
        Iterable $this$forEach$iv = references2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsName it = (JsName)element$iv;
            boolean bl = false;
            this.tracker.addRemovableReference(name2, it);
        }
        return false;
    }

    public boolean visit(@NotNull JsNameRef x, @NotNull JsContext<?> ctx2) {
        Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
        Intrinsics.checkParameterIsNotNull(ctx2, (String)"ctx");
        JsNameRef q2 = x;
        while (q2 != null) {
            JsExpression jsExpression;
            if (q2.getName() != null) {
                JsName jsName;
                boolean bl = false;
                boolean bl2 = false;
                JsName it = jsName;
                boolean bl3 = false;
                JsName jsName2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"it");
                this.tracker.markReachable(jsName2);
            }
            if (!((jsExpression = q2.getQualifier()) instanceof JsNameRef)) {
                jsExpression = null;
            }
            q2 = (JsNameRef)jsExpression;
        }
        return false;
    }

    private final boolean isLocalFunctionDeclaration(JsVars.JsVar jsVar) {
        JsName name2 = jsVar.getName();
        JsExpression expr2 = jsVar.getInitExpression();
        if (expr2 instanceof JsNameRef) {
            boolean bl;
            JsName jsName = ((JsNameRef)expr2).getName();
            if (jsName != null) {
                JsName jsName2 = jsName;
                boolean bl2 = false;
                boolean bl3 = false;
                JsName it = jsName2;
                boolean bl4 = false;
                JsName jsName3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsName3, (String)"it");
                bl = this.tracker.isReferenceToRemovableCandidate(jsName3);
            } else {
                bl = false;
            }
            if (bl) {
                return true;
            }
        }
        JsName jsName = name2;
        JsNode staticRef = jsName != null ? MetadataProperties.getStaticRef(jsName) : null;
        return staticRef != null && Intrinsics.areEqual((Object)staticRef, (Object)expr2) && RemoveUnusedLocalFunctionDeclarationsKt.access$isFunctionReference(expr2);
    }
}

