/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.impl.IrDynamicTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrErrorTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeBuilder;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.ir.util.ConstantValueGenerator;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.util.ScopedTypeParametersResolver;
import org.jetbrains.kotlin.ir.util.TypeParametersResolver;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00016B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ*\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001cH\u0086\b\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aJ\u000e\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u0018\u0010&\u001a\u00020*2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u000201H\u0002J\u001c\u00102\u001a\b\u0012\u0004\u0012\u0002030.2\f\u00104\u001a\b\u0012\u0004\u0012\u0002050.H\u0002R\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/ir/util/TypeTranslator;", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "typeParametersResolver", "Lorg/jetbrains/kotlin/ir/util/TypeParametersResolver;", "enterTableScope", "", "(Lorg/jetbrains/kotlin/ir/util/ReferenceSymbolTable;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/ir/util/TypeParametersResolver;Z)V", "constantValueGenerator", "Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;", "getConstantValueGenerator", "()Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;", "setConstantValueGenerator", "(Lorg/jetbrains/kotlin/ir/util/ConstantValueGenerator;)V", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "typeApproximatorForNI", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "buildWithScope", "T", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "builder", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "enterScope", "", "irElement", "leaveScope", "resolveTypeParameter", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "translateType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "ktType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/ir/types/IrTypeProjection;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "translateTypeAnnotations", "", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "annotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "translateTypeArguments", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "arguments", "Lorg/jetbrains/kotlin/types/TypeProjection;", "LegacyTypeApproximation", "ir.tree"})
public final class TypeTranslator {
    private final TypeApproximator typeApproximatorForNI;
    @NotNull
    public ConstantValueGenerator constantValueGenerator;
    private final ReferenceSymbolTable symbolTable;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    private final TypeParametersResolver typeParametersResolver;
    private final boolean enterTableScope;

    @NotNull
    public final ConstantValueGenerator getConstantValueGenerator() {
        ConstantValueGenerator constantValueGenerator = this.constantValueGenerator;
        if (constantValueGenerator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"constantValueGenerator");
        }
        return constantValueGenerator;
    }

    public final void setConstantValueGenerator(@NotNull ConstantValueGenerator constantValueGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)constantValueGenerator, (String)"<set-?>");
        this.constantValueGenerator = constantValueGenerator;
    }

    public final void enterScope(@NotNull IrTypeParametersContainer irElement) {
        Intrinsics.checkParameterIsNotNull((Object)irElement, (String)"irElement");
        this.typeParametersResolver.enterTypeParameterScope(irElement);
        if (this.enterTableScope) {
            this.symbolTable.enterScope(irElement.getDescriptor());
        }
    }

    public final void leaveScope(@NotNull IrTypeParametersContainer irElement) {
        Intrinsics.checkParameterIsNotNull((Object)irElement, (String)"irElement");
        this.typeParametersResolver.leaveTypeParameterScope();
        if (this.enterTableScope) {
            this.symbolTable.leaveScope(irElement.getDescriptor());
        }
    }

    public final <T> T buildWithScope(@NotNull IrTypeParametersContainer container2, @NotNull Function0<? extends T> builder) {
        int $i$f$buildWithScope = 0;
        Intrinsics.checkParameterIsNotNull((Object)container2, (String)"container");
        Intrinsics.checkParameterIsNotNull(builder, (String)"builder");
        this.enterScope(container2);
        Object result2 = builder.invoke();
        this.leaveScope(container2);
        return (T)result2;
    }

    private final IrTypeParameterSymbol resolveTypeParameter(TypeParameterDescriptor typeParameterDescriptor) {
        IrTypeParameterSymbol irTypeParameterSymbol = this.typeParametersResolver.resolveScopedTypeParameter(typeParameterDescriptor);
        if (irTypeParameterSymbol == null) {
            irTypeParameterSymbol = this.symbolTable.referenceTypeParameter(typeParameterDescriptor);
        }
        return irTypeParameterSymbol;
    }

    @NotNull
    public final IrType translateType(@NotNull KotlinType ktType) {
        Intrinsics.checkParameterIsNotNull((Object)ktType, (String)"ktType");
        return this.translateType(ktType, Variance.INVARIANT).getType();
    }

    private final IrTypeProjection translateType(KotlinType ktType, Variance variance) {
        KotlinType approximatedType = new LegacyTypeApproximation().approximate(ktType);
        if (KotlinTypeKt.isError(approximatedType)) {
            return new IrErrorTypeImpl(approximatedType, this.translateTypeAnnotations(approximatedType.getAnnotations()), variance);
        }
        if (DynamicTypesKt.isDynamic(approximatedType)) {
            return new IrDynamicTypeImpl(approximatedType, this.translateTypeAnnotations(approximatedType.getAnnotations()), variance);
        }
        if (FlexibleTypesKt.isFlexible(approximatedType)) {
            return this.translateType(FlexibleTypesKt.upperIfFlexible(approximatedType), variance);
        }
        TypeConstructor ktTypeConstructor = approximatedType.getConstructor();
        ClassifierDescriptor classifierDescriptor = ktTypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw (Throwable)((Object)new AssertionError((Object)("No descriptor for type " + approximatedType)));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor, (String)"ktTypeConstructor.declar\u2026 type $approximatedType\")");
        ClassifierDescriptor ktTypeDescriptor = classifierDescriptor;
        IrSimpleTypeBuilder irSimpleTypeBuilder = new IrSimpleTypeBuilder();
        boolean bl = false;
        boolean bl2 = false;
        IrSimpleTypeBuilder $this$apply = irSimpleTypeBuilder;
        boolean bl3 = false;
        $this$apply.setKotlinType(approximatedType);
        $this$apply.setHasQuestionMark(approximatedType.isMarkedNullable());
        $this$apply.setVariance(variance);
        ClassifierDescriptor classifierDescriptor2 = ktTypeDescriptor;
        if (classifierDescriptor2 instanceof TypeParameterDescriptor) {
            $this$apply.setClassifier(this.resolveTypeParameter((TypeParameterDescriptor)ktTypeDescriptor));
            $this$apply.setAnnotations(this.translateTypeAnnotations(approximatedType.getAnnotations()));
        } else if (classifierDescriptor2 instanceof ClassDescriptor) {
            $this$apply.setClassifier(this.symbolTable.referenceClass((ClassDescriptor)ktTypeDescriptor));
            $this$apply.setArguments(this.translateTypeArguments(approximatedType.getArguments()));
            $this$apply.setAnnotations(this.translateTypeAnnotations(approximatedType.getAnnotations()));
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unexpected type descriptor " + ktTypeDescriptor + " :: " + Reflection.getOrCreateKotlinClass(ktTypeDescriptor.getClass()))));
        }
        return IrSimpleTypeImplKt.buildTypeProjection(irSimpleTypeBuilder);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrConstructorCall> translateTypeAnnotations(Annotations annotations2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = annotations2;
        ConstantValueGenerator constantValueGenerator = this.constantValueGenerator;
        if (constantValueGenerator == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"constantValueGenerator");
        }
        ConstantValueGenerator constantValueGenerator2 = constantValueGenerator;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrConstructorCall irConstructorCall = constantValueGenerator2.generateAnnotationConstructorCall((AnnotationDescriptor)p1);
            collection.add(irConstructorCall);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrTypeArgument> translateTypeArguments(List<? extends TypeProjection> arguments2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = arguments2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument;
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it.isStarProjection()) {
                irTypeArgument = IrStarProjectionImpl.INSTANCE;
            } else {
                KotlinType kotlinType2 = it.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"it.type");
                Variance variance = it.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)variance), (String)"it.projectionKind");
                irTypeArgument = this.translateType(kotlinType2, variance);
            }
            IrTypeArgument irTypeArgument2 = irTypeArgument;
            collection.add(irTypeArgument2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public TypeTranslator(@NotNull ReferenceSymbolTable symbolTable, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull KotlinBuiltIns builtIns, @NotNull TypeParametersResolver typeParametersResolver, boolean enterTableScope) {
        Intrinsics.checkParameterIsNotNull((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        Intrinsics.checkParameterIsNotNull((Object)typeParametersResolver, (String)"typeParametersResolver");
        this.symbolTable = symbolTable;
        this.languageVersionSettings = languageVersionSettings;
        this.typeParametersResolver = typeParametersResolver;
        this.enterTableScope = enterTableScope;
        this.typeApproximatorForNI = new TypeApproximator(builtIns);
    }

    public /* synthetic */ TypeTranslator(ReferenceSymbolTable referenceSymbolTable, LanguageVersionSettings languageVersionSettings, KotlinBuiltIns kotlinBuiltIns, TypeParametersResolver typeParametersResolver, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 8) != 0) {
            typeParametersResolver = new ScopedTypeParametersResolver();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(referenceSymbolTable, languageVersionSettings, kotlinBuiltIns, typeParametersResolver, bl);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/ir/util/TypeTranslator$LegacyTypeApproximation;", "", "(Lorg/jetbrains/kotlin/ir/util/TypeTranslator;)V", "approximate", "Lorg/jetbrains/kotlin/types/KotlinType;", "ktType", "approximateByKotlinRules", "ir.tree"})
    private final class LegacyTypeApproximation {
        @NotNull
        public final KotlinType approximate(@NotNull KotlinType ktType) {
            Intrinsics.checkParameterIsNotNull((Object)ktType, (String)"ktType");
            KotlinType properlyApproximatedType = this.approximateByKotlinRules(ktType);
            TypeConstructor typeConstructor2 = properlyApproximatedType.getConstructor();
            if (typeConstructor2 instanceof IntersectionTypeConstructor) {
                KotlinType kotlinType2 = CommonSupertypes.commonSupertype(((IntersectionTypeConstructor)typeConstructor2).getSupertypes());
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"CommonSupertypes.commonS\u2026peConstructor.supertypes)");
                KotlinType commonSupertype = kotlinType2;
                return this.approximate(TypeUtilsKt.replaceArgumentsWithStarProjections(commonSupertype));
            }
            return properlyApproximatedType;
        }

        private final KotlinType approximateByKotlinRules(KotlinType ktType) {
            if (ktType.getConstructor().isDenotable()) {
                return ktType;
            }
            return TypeTranslator.this.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference) ? (KotlinType)TypeTranslator.this.typeApproximatorForNI.approximateDeclarationType(ktType, false, TypeTranslator.this.getLanguageVersionSettings()) : CapturedTypeApproximationKt.approximateCapturedTypes(ktType).getUpper();
        }
    }
}

