/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.DescriptorsRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt$sam$org_jetbrains_kotlin_utils_DFS_Neighbors$0;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\f\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\f*\u00020\n\u001a\n\u0010\r\u001a\u00020\f*\u00020\n\u001a\n\u0010\u000e\u001a\u00020\f*\u00020\n\u001a\n\u0010\u000f\u001a\u00020\f*\u00020\n\u001a\n\u0010\u0010\u001a\u00020\f*\u00020\n\u001a\n\u0010\u0011\u001a\u00020\f*\u00020\n\u001a\u001a\u0010\u0012\u001a\u00020\f*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001\u001a\n\u0010\u0016\u001a\u00020\f*\u00020\n\u001a\n\u0010\u0017\u001a\u00020\f*\u00020\n\u001a\n\u0010\u0018\u001a\u00020\f*\u00020\n\u001a\n\u0010\u0019\u001a\u00020\f*\u00020\n\u001a\n\u0010\u001a\u001a\u00020\f*\u00020\n\u001a\u0017\u0010\u001b\u001a\n \u001c*\u0004\u0018\u00010\f0\f*\u00020\n\u00a2\u0006\u0002\u0010\u001d\u001a!\u0010\u001e\u001a\u00020\f*\u00020\n2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\f0 H\u0082\b\u001a\n\u0010\"\u001a\u00020\f*\u00020\n\u001a\n\u0010#\u001a\u00020\f*\u00020\n\u001a&\u0010$\u001a\u00020\n*\u00020\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0&\u001a\u001e\u0010$\u001a\u00020\n*\u00020\n2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\n0*\u001a\u0010\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0&*\u00020\n\u001a\u0010\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0&*\u00020\n\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006."}, d2={"kotlinCoroutinesPackageFqn", "Lorg/jetbrains/kotlin/name/FqName;", "getKotlinCoroutinesPackageFqn", "()Lorg/jetbrains/kotlin/name/FqName;", "kotlinPackageFqn", "getKotlinPackageFqn", "kotlinReflectionPackageFqn", "getKotlinReflectionPackageFqn", "getPrimitiveArrayElementType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isFunction", "", "isFunctionOrKFunction", "isFunctionTypeOrSubtype", "isInterface", "isKClass", "isKFunction", "isNameInPackage", "prefix", "", "packageFqName", "isNonPrimitiveArray", "isNullable", "isPrimitiveArray", "isSuspendFunction", "isThrowable", "isThrowableTypeOrSubtype", "kotlin.jvm.PlatformType", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Ljava/lang/Boolean;", "isTypeFromKotlinPackage", "namePredicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "isTypeParameter", "isUnsigned", "substitute", "params", "", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "arguments", "substitutionMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "superTypes", "typeParameterSuperTypes", "ir.backend.common"})
public final class IrTypeUtilsKt {
    @NotNull
    private static final FqName kotlinPackageFqn;
    @NotNull
    private static final FqName kotlinReflectionPackageFqn;
    @NotNull
    private static final FqName kotlinCoroutinesPackageFqn;

    @NotNull
    public static final FqName getKotlinPackageFqn() {
        return kotlinPackageFqn;
    }

    @NotNull
    public static final FqName getKotlinReflectionPackageFqn() {
        return kotlinReflectionPackageFqn;
    }

    @NotNull
    public static final FqName getKotlinCoroutinesPackageFqn() {
        return kotlinCoroutinesPackageFqn;
    }

    public static final boolean isFunction(@NotNull IrType $this$isFunction) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isFunction, (String)"$this$isFunction");
        return IrTypeUtilsKt.isNameInPackage($this$isFunction, "Function", kotlinPackageFqn);
    }

    public static final boolean isKClass(@NotNull IrType $this$isKClass) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isKClass, (String)"$this$isKClass");
        return IrTypeUtilsKt.isNameInPackage($this$isKClass, "KClass", kotlinReflectionPackageFqn);
    }

    public static final boolean isKFunction(@NotNull IrType $this$isKFunction) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isKFunction, (String)"$this$isKFunction");
        return IrTypeUtilsKt.isNameInPackage($this$isKFunction, "KFunction", kotlinReflectionPackageFqn);
    }

    public static final boolean isSuspendFunction(@NotNull IrType $this$isSuspendFunction) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isSuspendFunction, (String)"$this$isSuspendFunction");
        return IrTypeUtilsKt.isNameInPackage($this$isSuspendFunction, "SuspendFunction", kotlinCoroutinesPackageFqn);
    }

    public static final boolean isNameInPackage(@NotNull IrType $this$isNameInPackage, @NotNull String prefix, @NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNameInPackage, (String)"$this$isNameInPackage");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isNameInPackage);
        if (irClassifierSymbol == null) {
            return false;
        }
        IrClassifierSymbol classifier = irClassifierSymbol;
        String string = classifier.getDescriptor().getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classifier.descriptor.name.asString()");
        String name2 = string;
        if (!StringsKt.startsWith$default((String)name2, (String)prefix, (boolean)false, (int)2, null)) {
            return false;
        }
        IrSymbolOwner irSymbolOwner = classifier.getOwner();
        if (irSymbolOwner == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        }
        IrDeclaration declaration2 = (IrDeclaration)((Object)irSymbolOwner);
        IrDeclarationParent irDeclarationParent = declaration2.getParent();
        if (!(irDeclarationParent instanceof IrPackageFragment)) {
            irDeclarationParent = null;
        }
        IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
        if (irPackageFragment == null) {
            return false;
        }
        IrPackageFragment parent2 = irPackageFragment;
        return Intrinsics.areEqual((Object)parent2.getFqName(), (Object)packageFqName);
    }

    @NotNull
    public static final List<IrType> superTypes(@NotNull IrType $this$superTypes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$superTypes, (String)"$this$superTypes");
        Object object = IrTypesKt.getClassifierOrNull($this$superTypes);
        if (object == null || (object = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.superTypes((IrClassifierSymbol)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final List<IrType> typeParameterSuperTypes(@NotNull IrType $this$typeParameterSuperTypes) {
        List<IrType> list2;
        IrClassifierSymbol classifier;
        Intrinsics.checkParameterIsNotNull((Object)$this$typeParameterSuperTypes, (String)"$this$typeParameterSuperTypes");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$typeParameterSuperTypes);
        if (irClassifierSymbol == null) {
            return CollectionsKt.emptyList();
        }
        IrClassifierSymbol irClassifierSymbol2 = classifier = irClassifierSymbol;
        if (irClassifierSymbol2 instanceof IrTypeParameterSymbol) {
            list2 = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes();
        } else if (irClassifierSymbol2 instanceof IrClassSymbol) {
            list2 = CollectionsKt.emptyList();
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return list2;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull IrType $this$isFunctionTypeOrSubtype) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isFunctionTypeOrSubtype, (String)"$this$isFunctionTypeOrSubtype");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)$this$isFunctionTypeOrSubtype), isFunctionTypeOrSubtype.1.INSTANCE, isFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"DFS.ifAny(listOf(this), \u2026) }, { it.isFunction() })");
        return bl;
    }

    public static final boolean isTypeParameter(@NotNull IrType $this$isTypeParameter) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isTypeParameter, (String)"$this$isTypeParameter");
        return IrTypesKt.getClassifierOrNull($this$isTypeParameter) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isInterface(@NotNull IrType $this$isInterface) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isInterface, (String)"$this$isInterface");
        Object object = IrTypesKt.getClassOrNull($this$isInterface);
        return (object != null && (object = (IrClass)object.getOwner()) != null ? object.getKind() : null) == ClassKind.INTERFACE;
    }

    public static final boolean isFunctionOrKFunction(@NotNull IrType $this$isFunctionOrKFunction) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isFunctionOrKFunction, (String)"$this$isFunctionOrKFunction");
        return IrTypeUtilsKt.isFunction($this$isFunctionOrKFunction) || IrTypeUtilsKt.isKFunction($this$isFunctionOrKFunction);
    }

    public static final boolean isNullable(@NotNull IrType $this$isNullable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNullable, (String)"$this$isNullable");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)$this$isNullable), isNullable.1.INSTANCE, isNullable.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"DFS.ifAny(listOf(this), \u2026is IrDynamicType\n    }\n})");
        return bl;
    }

    public static final boolean isThrowable(@NotNull IrType $this$isThrowable) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isThrowable, (String)"$this$isThrowable");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isThrowable;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            if (!(irClassifierSymbol instanceof IrClassSymbol)) {
                irClassifierSymbol = null;
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)name2.asString(), (Object)"Throwable")) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    if (!(irDeclarationParent instanceof IrPackageFragment)) {
                        irDeclarationParent = null;
                    }
                    IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual((Object)parent$iv.getFqName(), (Object)IrTypeUtilsKt.getKotlinPackageFqn());
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static final Boolean isThrowableTypeOrSubtype(@NotNull IrType $this$isThrowableTypeOrSubtype) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isThrowableTypeOrSubtype, (String)"$this$isThrowableTypeOrSubtype");
        Collection collection = CollectionsKt.listOf((Object)$this$isThrowableTypeOrSubtype);
        Object object = isThrowableTypeOrSubtype.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new IrTypeUtilsKt$sam$org_jetbrains_kotlin_utils_DFS_Neighbors$0(function1);
        }
        return DFS.ifAny(collection, (DFS.Neighbors)object, isThrowableTypeOrSubtype.2.INSTANCE);
    }

    public static final boolean isUnsigned(@NotNull IrType $this$isUnsigned) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isUnsigned, (String)"$this$isUnsigned");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isUnsigned;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            if (!(irClassifierSymbol instanceof IrClassSymbol)) {
                irClassifierSymbol = null;
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!UnsignedTypes.INSTANCE.isShortNameOfUnsignedType(name2)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    if (!(irDeclarationParent instanceof IrPackageFragment)) {
                        irDeclarationParent = null;
                    }
                    IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual((Object)parent$iv.getFqName(), (Object)IrTypeUtilsKt.getKotlinPackageFqn());
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isTypeFromKotlinPackage(@NotNull IrType $this$isTypeFromKotlinPackage, Function1<? super Name, Boolean> namePredicate2) {
        int $i$f$isTypeFromKotlinPackage = 0;
        if ($this$isTypeFromKotlinPackage instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage).getClassifier();
            if (!(irClassifierSymbol instanceof IrClassSymbol)) {
                irClassifierSymbol = null;
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
            if (irClassSymbol == null) {
                return false;
            }
            IrClassSymbol classClassifier = irClassSymbol;
            if (!((Boolean)namePredicate2.invoke((Object)((IrClass)classClassifier.getOwner()).getName())).booleanValue()) {
                return false;
            }
            IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier.getOwner()).getParent();
            if (!(irDeclarationParent instanceof IrPackageFragment)) {
                irDeclarationParent = null;
            }
            IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
            if (irPackageFragment == null) {
                return false;
            }
            IrPackageFragment parent2 = irPackageFragment;
            return Intrinsics.areEqual((Object)parent2.getFqName(), (Object)IrTypeUtilsKt.getKotlinPackageFqn());
        }
        return false;
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isPrimitiveArray, (String)"$this$isPrimitiveArray");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isPrimitiveArray;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            if (!(irClassifierSymbol instanceof IrClassSymbol)) {
                irClassifierSymbol = null;
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name it = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!KotlinBuiltIns.FQ_NAMES.primitiveArrayTypeShortNames.contains(it)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    if (!(irDeclarationParent instanceof IrPackageFragment)) {
                        irDeclarationParent = null;
                    }
                    IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual((Object)parent$iv.getFqName(), (Object)IrTypeUtilsKt.getKotlinPackageFqn());
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final PrimitiveType getPrimitiveArrayElementType(@NotNull IrType $this$getPrimitiveArrayElementType) {
        PrimitiveType primitiveType;
        Intrinsics.checkParameterIsNotNull((Object)$this$getPrimitiveArrayElementType, (String)"$this$getPrimitiveArrayElementType");
        IrType irType = $this$getPrimitiveArrayElementType;
        if (!(irType instanceof IrSimpleType)) {
            irType = null;
        }
        IrSimpleType irSimpleType = (IrSimpleType)irType;
        if (irSimpleType != null) {
            Object object;
            IrSimpleType irSimpleType2 = irSimpleType;
            boolean bl = false;
            boolean bl2 = false;
            IrSimpleType it = irSimpleType2;
            boolean bl3 = false;
            IrSymbolOwner irSymbolOwner = it.getClassifier().getOwner();
            if (!(irSymbolOwner instanceof IrClass)) {
                irSymbolOwner = null;
            }
            if ((object = (IrClass)irSymbolOwner) != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null && (object = ((FqName)object).toUnsafe()) != null) {
                Object object2 = object;
                boolean bl4 = false;
                boolean bl5 = false;
                Object fqn = object2;
                boolean bl6 = false;
                primitiveType = KotlinBuiltIns.FQ_NAMES.arrayClassFqNameToPrimitiveType.get(fqn);
            } else {
                primitiveType = null;
            }
        } else {
            primitiveType = null;
        }
        return primitiveType;
    }

    public static final boolean isNonPrimitiveArray(@NotNull IrType $this$isNonPrimitiveArray) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNonPrimitiveArray, (String)"$this$isNonPrimitiveArray");
        return (IrTypePredicatesKt.isArray($this$isNonPrimitiveArray) || IrTypePredicatesKt.isNullableArray($this$isNonPrimitiveArray)) && !IrTypeUtilsKt.isPrimitiveArray($this$isNonPrimitiveArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType substitute(@NotNull IrType $this$substitute, @NotNull List<? extends IrTypeParameter> params2, @NotNull List<? extends IrType> arguments2) {
        Collection<IrTypeParameterSymbol> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$substitute, (String)"$this$substitute");
        Intrinsics.checkParameterIsNotNull(params2, (String)"params");
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        Iterable iterable = params2;
        IrType irType = $this$substitute;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrTypeParameterSymbol irTypeParameterSymbol = (IrTypeParameterSymbol)it.getSymbol();
            collection.add(irTypeParameterSymbol);
        }
        collection = (List)destination$iv$iv;
        return IrTypeUtilsKt.substitute(irType, MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)collection, (Iterable)arguments2)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType substitute(@NotNull IrType $this$substitute, @NotNull Map<IrTypeParameterSymbol, ? extends IrType> substitutionMap) {
        void $this$mapTo$iv$iv;
        IrConstructorCall irConstructorCall;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)$this$substitute, (String)"$this$substitute");
        Intrinsics.checkParameterIsNotNull(substitutionMap, (String)"substitutionMap");
        if (!($this$substitute instanceof IrSimpleType)) {
            return $this$substitute;
        }
        Object object = substitutionMap;
        IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$substitute).getClassifier();
        boolean bl = false;
        IrType irType = object.get(irClassifierSymbol);
        if (irType != null) {
            object = irType;
            boolean bl2 = false;
            bl = false;
            Object it = object;
            boolean bl3 = false;
            return it;
        }
        Iterable $this$map$iv = ((IrSimpleType)$this$substitute).getArguments();
        boolean $i$f$map = false;
        Iterable it = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it2;
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            irConstructorCall = it2 instanceof IrTypeProjection ? (IrTypeArgument)IrSimpleTypeImplKt.makeTypeProjection(IrTypeUtilsKt.substitute(((IrTypeProjection)it2).getType(), substitutionMap), ((IrTypeProjection)it2).getVariance()) : it2;
            collection.add(irConstructorCall);
        }
        List newArguments2 = (List)destination$iv$iv;
        Iterable $this$map$iv2 = $this$substitute.getAnnotations();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            IrConstructorCall bl4 = (IrConstructorCall)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            IrElement $this$deepCopyWithSymbols$iv = (IrElement)it3;
            IrDeclarationParent initialParent$iv = null;
            DescriptorsRemapper descriptorRemapper$iv = DescriptorsRemapper.Default.INSTANCE;
            boolean $i$f$deepCopyWithSymbols = false;
            DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(descriptorRemapper$iv);
            IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols$iv, symbolRemapper$iv);
            DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
            IrElement irElement = PatchDeclarationParentsKt.patchDeclarationParents($this$deepCopyWithSymbols$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv, typeRemapper$iv, null, 4, null), null), initialParent$iv);
            if (irElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConstructorCall");
            }
            irConstructorCall = (IrConstructorCall)irElement;
            collection.add(irConstructorCall);
        }
        List newAnnotations = (List)destination$iv$iv2;
        return new IrSimpleTypeImpl(((IrSimpleType)$this$substitute).getClassifier(), ((IrSimpleType)$this$substitute).getHasQuestionMark(), newArguments2, newAnnotations);
    }

    static {
        FqName fqName2 = FqName.fromSegments(CollectionsKt.listOf((Object)"kotlin"));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.fromSegments(listOf(\"kotlin\"))");
        kotlinPackageFqn = fqName2;
        FqName fqName3 = kotlinPackageFqn.child(Name.identifier("reflect"));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"kotlinPackageFqn.child(Name.identifier(\"reflect\"))");
        kotlinReflectionPackageFqn = fqName3;
        FqName fqName4 = kotlinPackageFqn.child(Name.identifier("coroutines"));
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName4, (String)"kotlinPackageFqn.child(N\u2026identifier(\"coroutines\"))");
        kotlinCoroutinesPackageFqn = fqName4;
    }
}

