/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.AbstractIncrementalCache;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.IncrementalJsCacheKt;
import org.jetbrains.kotlin.incremental.InlineFunctionsMap;
import org.jetbrains.kotlin.incremental.PackageMetadataMap;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.TranslationResultMap;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.incremental.storage.BasicMap;
import org.jetbrains.kotlin.incremental.storage.DirtyClassesFqNameMap;
import org.jetbrains.kotlin.incremental.storage.FileToPathConverter;
import org.jetbrains.kotlin.incremental.storage.SourceToFqNameMap;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 52\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00015B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020(J\u0016\u0010,\u001a\u00020&2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040.H\u0016J\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020100J\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001200J\u0018\u00102\u001a\u00020&2\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u0002H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00040\rj\b\u0012\u0004\u0012\u00020\u0004`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020 X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache;", "Lorg/jetbrains/kotlin/incremental/AbstractIncrementalCache;", "Lorg/jetbrains/kotlin/name/FqName;", "cachesDir", "Ljava/io/File;", "pathConverter", "Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/storage/FileToPathConverter;)V", "dirtyOutputClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "getDirtyOutputClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/DirtyClassesFqNameMap;", "dirtyPackages", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "dirtySources", "value", "", "header", "getHeader", "()[B", "setHeader", "([B)V", "headerFile", "getHeaderFile", "()Ljava/io/File;", "inlineFunctions", "Lorg/jetbrains/kotlin/incremental/InlineFunctionsMap;", "packageMetadata", "Lorg/jetbrains/kotlin/incremental/PackageMetadataMap;", "sourceToClassesMap", "Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "getSourceToClassesMap$kotlin_build_common", "()Lorg/jetbrains/kotlin/incremental/storage/SourceToFqNameMap;", "translationResults", "Lorg/jetbrains/kotlin/incremental/TranslationResultMap;", "clearCacheForRemovedClasses", "", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "compareAndUpdate", "incrementalResults", "Lorg/jetbrains/kotlin/incremental/js/IncrementalResultsConsumerImpl;", "markDirty", "removedAndCompiledSources", "", "nonDirtyPackageParts", "", "Lorg/jetbrains/kotlin/incremental/js/TranslationResultValue;", "registerOutputForFile", "srcFile", "name", "Companion", "kotlin-build-common"})
public class IncrementalJsCache
extends AbstractIncrementalCache<FqName> {
    @NotNull
    private final SourceToFqNameMap sourceToClassesMap;
    @NotNull
    private final DirtyClassesFqNameMap dirtyOutputClassesMap;
    private final TranslationResultMap translationResults;
    private final InlineFunctionsMap inlineFunctions;
    private final PackageMetadataMap packageMetadata;
    private final HashSet<File> dirtySources;
    private final HashSet<String> dirtyPackages;
    private static final String TRANSLATION_RESULT_MAP = "translation-result";
    private static final String INLINE_FUNCTIONS = "inline-functions";
    private static final String HEADER_FILE_NAME = "header.meta";
    private static final String PACKAGE_META_FILE = "packages-meta";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public SourceToFqNameMap getSourceToClassesMap$kotlin_build_common() {
        return this.sourceToClassesMap;
    }

    @NotNull
    public DirtyClassesFqNameMap getDirtyOutputClassesMap$kotlin_build_common() {
        return this.dirtyOutputClassesMap;
    }

    private final File getHeaderFile() {
        return new File(this.getCachesDir(), HEADER_FILE_NAME);
    }

    @NotNull
    public final byte[] getHeader() {
        return FilesKt.readBytes((File)this.getHeaderFile());
    }

    public final void setHeader(@NotNull byte[] value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.getCachesDir().mkdirs();
        FilesKt.writeBytes((File)this.getHeaderFile(), (byte[])value2);
    }

    @Override
    public void markDirty(@NotNull Collection<? extends File> removedAndCompiledSources) {
        Intrinsics.checkParameterIsNotNull(removedAndCompiledSources, (String)"removedAndCompiledSources");
        Iterable $this$forEach$iv = removedAndCompiledSources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File sourceFile = (File)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = this.getSourceToClassesMap$kotlin_build_common().get(sourceFile);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                FqName it = (FqName)element$iv2;
                boolean bl2 = false;
                Collection collection = this.dirtyPackages;
                Object object = FqNamesUtilKt.parentOrNull(it);
                if (object == null || (object = ((FqName)object).asString()) == null) {
                    object = "";
                }
                Object object2 = object;
                boolean bl3 = false;
                collection.add(object2);
            }
        }
        super.markDirty(removedAndCompiledSources);
        this.dirtySources.addAll(removedAndCompiledSources);
    }

    /*
     * WARNING - void declaration
     */
    public final void compareAndUpdate(@NotNull IncrementalResultsConsumerImpl incrementalResults, @NotNull ChangesCollector changesCollector) {
        Object srcFile;
        Map.Entry<Object, Object> entry;
        Map.Entry<Object, Object> entry2;
        Map<File, TranslationResultValue> translatedFiles;
        Intrinsics.checkParameterIsNotNull((Object)incrementalResults, (String)"incrementalResults");
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        Map<File, TranslationResultValue> map2 = translatedFiles = incrementalResults.getPackageParts();
        boolean bl = false;
        Iterator<Map.Entry<Object, Object>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            void binaryAst;
            void binaryMetadata;
            boolean bl2;
            Object it;
            Map<ClassId, ProtoData> map3;
            byte[] inlineData;
            block8: {
                block7: {
                    entry = entry2 = iterator2.next();
                    boolean bl3 = false;
                    srcFile = entry.getKey();
                    entry = entry2;
                    bl3 = false;
                    TranslationResultValue data = entry.getValue();
                    this.dirtySources.remove(srcFile);
                    TranslationResultValue translationResultValue = data;
                    entry = (Map.Entry<Object, Object>)translationResultValue.component1();
                    byte[] byArray = translationResultValue.component2();
                    inlineData = translationResultValue.component3();
                    map3 = this.translationResults.get((File)srcFile);
                    if (map3 == null) break block7;
                    byte[] byArray2 = ((TranslationResultValue)((Object)map3)).getMetadata();
                    map3 = (Map<ClassId, ProtoData>)byArray2;
                    if (byArray2 == null) break block7;
                    Map<ClassId, ProtoData> map4 = map3;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    it = map4;
                    bl2 = false;
                    map3 = IncrementalJsCacheKt.getProtoData((File)srcFile, (byte[])it);
                    if (map3 != null) break block8;
                }
                map3 = MapsKt.emptyMap();
            }
            Map<ClassId, ProtoData> oldProtoMap = map3;
            Map<ClassId, ProtoData> newProtoMap = IncrementalJsCacheKt.getProtoData((File)srcFile, (byte[])binaryMetadata);
            it = newProtoMap;
            bl2 = false;
            Iterator iterator3 = it.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry entry3;
                Map.Entry entry4 = entry3 = iterator3.next();
                boolean bl6 = false;
                ClassId classId = (ClassId)entry4.getKey();
                entry4 = entry3;
                bl6 = false;
                ProtoData protoData = (ProtoData)entry4.getValue();
                FqName fqName2 = classId.asSingleFqName();
                Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.asSingleFqName()");
                this.registerOutputForFile((File)srcFile, fqName2);
                if (!(protoData instanceof ClassProtoData)) continue;
                this.addToClassStorage(((ClassProtoData)protoData).getProto(), ((ClassProtoData)protoData).getNameResolver(), (File)srcFile);
            }
            for (ClassId classId : SetsKt.plus(oldProtoMap.keySet(), (Iterable)newProtoMap.keySet())) {
                ChangesCollector.collectProtoChanges$default(changesCollector, oldProtoMap.get(classId), newProtoMap.get(classId), false, 4, null);
            }
            this.translationResults.put((File)srcFile, (byte[])binaryMetadata, (byte[])binaryAst, inlineData);
        }
        srcFile = incrementalResults.getInlineFunctions();
        boolean data = false;
        iterator2 = srcFile.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = entry2 = iterator2.next();
            boolean bl7 = false;
            srcFile = entry.getKey();
            entry = entry2;
            bl7 = false;
            Map inlineDeclarations = (Map)((Object)entry.getValue());
            this.inlineFunctions.process((File)srcFile, inlineDeclarations, changesCollector);
        }
        srcFile = incrementalResults.getPackageMetadata();
        boolean inlineDeclarations = false;
        iterator2 = srcFile.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = entry2 = iterator2.next();
            boolean bl8 = false;
            String packageName = (String)entry.getKey();
            entry = entry2;
            bl8 = false;
            byte[] metadata = (byte[])entry.getValue();
            this.packageMetadata.put(packageName, metadata);
            this.dirtyPackages.remove(packageName);
        }
    }

    private final void registerOutputForFile(File srcFile, FqName name2) {
        this.getSourceToClassesMap$kotlin_build_common().add(srcFile, name2);
        this.getDirtyOutputClassesMap$kotlin_build_common().notDirty(name2);
    }

    @Override
    public void clearCacheForRemovedClasses(@NotNull ChangesCollector changesCollector) {
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        Iterable $this$forEach$iv = this.dirtySources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (File)element$iv;
            boolean bl = false;
            this.translationResults.remove((File)it, changesCollector);
            this.inlineFunctions.remove((File)it);
        }
        this.removeAllFromClassStorage(this.getDirtyOutputClassesMap$kotlin_build_common().getDirtyOutputClasses(), changesCollector);
        $this$forEach$iv = this.dirtyPackages;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            this.packageMetadata.remove((String)it);
        }
        this.dirtySources.clear();
        this.getDirtyOutputClassesMap$kotlin_build_common().clean();
        this.dirtyPackages.clear();
    }

    @NotNull
    public final Map<File, TranslationResultValue> nonDirtyPackageParts() {
        boolean bl = false;
        HashMap<File, TranslationResultValue> hashMap = new HashMap<File, TranslationResultValue>();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap<File, TranslationResultValue> $this$apply = hashMap;
        boolean bl4 = false;
        for (File file2 : this.translationResults.keys()) {
            if (this.dirtySources.contains(file2)) continue;
            TranslationResultValue translationResultValue = this.translationResults.get(file2);
            if (translationResultValue == null) {
                Intrinsics.throwNpe();
            }
            $this$apply.put(file2, translationResultValue);
        }
        return hashMap;
    }

    @NotNull
    public final Map<String, byte[]> packageMetadata() {
        boolean bl = false;
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap<String, byte[]> $this$apply = hashMap;
        boolean bl4 = false;
        for (String fqNameString : this.packageMetadata.keys()) {
            if (this.dirtyPackages.contains(fqNameString)) continue;
            byte[] byArray = this.packageMetadata.get(fqNameString);
            if (byArray == null) {
                Intrinsics.throwNpe();
            }
            $this$apply.put(fqNameString, byArray);
        }
        return hashMap;
    }

    public IncrementalJsCache(@NotNull File cachesDir, @NotNull FileToPathConverter pathConverter) {
        Intrinsics.checkParameterIsNotNull((Object)cachesDir, (String)"cachesDir");
        Intrinsics.checkParameterIsNotNull((Object)pathConverter, (String)"pathConverter");
        super(cachesDir, pathConverter);
        this.sourceToClassesMap = (SourceToFqNameMap)this.registerMap((BasicMap)new SourceToFqNameMap(this.getStorageFile(AbstractIncrementalCache.Companion.getSOURCE_TO_CLASSES()), pathConverter));
        this.dirtyOutputClassesMap = (DirtyClassesFqNameMap)this.registerMap((BasicMap)new DirtyClassesFqNameMap(this.getStorageFile(AbstractIncrementalCache.Companion.getDIRTY_OUTPUT_CLASSES())));
        this.translationResults = (TranslationResultMap)this.registerMap((BasicMap)new TranslationResultMap(this.getStorageFile(TRANSLATION_RESULT_MAP), pathConverter));
        this.inlineFunctions = (InlineFunctionsMap)this.registerMap((BasicMap)new InlineFunctionsMap(this.getStorageFile(INLINE_FUNCTIONS), pathConverter));
        this.packageMetadata = (PackageMetadataMap)this.registerMap((BasicMap)new PackageMetadataMap(this.getStorageFile(PACKAGE_META_FILE)));
        IncrementalJsCache incrementalJsCache = this;
        boolean bl = false;
        HashSet hashSet = new HashSet();
        incrementalJsCache.dirtySources = hashSet;
        incrementalJsCache = this;
        bl = false;
        hashSet = new HashSet();
        incrementalJsCache.dirtyPackages = hashSet;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/incremental/IncrementalJsCache$Companion;", "", "()V", "HEADER_FILE_NAME", "", "INLINE_FUNCTIONS", "PACKAGE_META_FILE", "TRANSLATION_RESULT_MAP", "hasHeaderFile", "", "cachesDir", "Ljava/io/File;", "kotlin-build-common"})
    public static final class Companion {
        public final boolean hasHeaderFile(@NotNull File cachesDir) {
            Intrinsics.checkParameterIsNotNull((Object)cachesDir, (String)"cachesDir");
            return new File(cachesDir, IncrementalJsCache.HEADER_FILE_NAME).exists();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

