/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.location.ScriptExpectedLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesManager;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007JJ\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001a\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\r\u001a\u00020\u0004H\u0007J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\"\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u0004H\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/util/ProjectRootsUtil;", "", "()V", "isInContent", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "includeProjectSource", "includeLibrarySource", "includeLibraryClasses", "includeScriptDependencies", "includeScriptsOutsideSourceRoots", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "element", "Lcom/intellij/psi/PsiElement;", "isInContentWithoutScriptDefinitionCheck", "isInProjectOrLibSource", "isInProjectOrLibraryClassFile", "isInProjectOrLibraryContent", "isInProjectSource", "isLibraryClassFile", "isLibraryFile", "isLibrarySourceFile", "isProjectSourceFile", "idea-core"})
public final class ProjectRootsUtil {
    public static final ProjectRootsUtil INSTANCE;

    @JvmStatic
    public static final boolean isInContent(@NotNull Project project, @NotNull VirtualFile file2, boolean includeProjectSource, boolean includeLibrarySource, boolean includeLibraryClasses, boolean includeScriptDependencies, boolean includeScriptsOutsideSourceRoots, @NotNull ProjectFileIndex fileIndex) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileIndex, (String)"fileIndex");
        KotlinScriptDefinition scriptDefinition = DefinitionsKt.findScriptDefinition((VirtualFile)file2, (Project)project);
        if (scriptDefinition != null) {
            List scriptScope = scriptDefinition.getScriptExpectedLocations();
            boolean includeAll = scriptScope.contains(ScriptExpectedLocation.Everywhere) || scriptScope.contains(ScriptExpectedLocation.Project) || ScratchUtil.isScratch((VirtualFile)file2);
            return INSTANCE.isInContentWithoutScriptDefinitionCheck(project, file2, includeProjectSource && (includeAll || scriptScope.contains(ScriptExpectedLocation.SourcesOnly) || scriptScope.contains(ScriptExpectedLocation.TestsOnly)), includeLibrarySource && (includeAll || scriptScope.contains(ScriptExpectedLocation.Libraries)), includeLibraryClasses && (includeAll || scriptScope.contains(ScriptExpectedLocation.Libraries)), includeScriptDependencies && (includeAll || scriptScope.contains(ScriptExpectedLocation.Libraries)), includeScriptsOutsideSourceRoots && includeAll, fileIndex);
        }
        return INSTANCE.isInContentWithoutScriptDefinitionCheck(project, file2, includeProjectSource, includeLibrarySource, includeLibraryClasses, includeScriptDependencies, false, fileIndex);
    }

    public static /* synthetic */ boolean isInContent$default(Project project, VirtualFile virtualFile2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ProjectFileIndex projectFileIndex, int n, Object object) {
        if ((n & 0x80) != 0) {
            ProjectFileIndex projectFileIndex2 = ProjectFileIndex.SERVICE.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex2, (String)"ProjectFileIndex.SERVICE.getInstance(project)");
            projectFileIndex = projectFileIndex2;
        }
        return ProjectRootsUtil.isInContent(project, virtualFile2, bl, bl2, bl3, bl4, bl5, projectFileIndex);
    }

    private final boolean isInContentWithoutScriptDefinitionCheck(Project project, VirtualFile file2, boolean includeProjectSource, boolean includeLibrarySource, boolean includeLibraryClasses, boolean includeScriptDependencies, boolean includeScriptsOutsideSourceRoots, ProjectFileIndex fileIndex) {
        ScriptDependenciesManager scriptConfigurationManager;
        if (includeProjectSource && ProjectRootsUtilKt.isInSourceContentWithoutInjected((FileIndex)fileIndex, file2)) {
            return true;
        }
        if (includeScriptsOutsideSourceRoots) {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
            if (projectRootManager.getFileIndex().isInContent(file2) || ScratchUtil.isScratch((VirtualFile)file2)) {
                return true;
            }
            Object object = DefinitionsKt.findScriptDefinition((VirtualFile)file2, (Project)project);
            return object != null && (object = object.getScriptExpectedLocations()) != null && object.contains(ScriptExpectedLocation.Everywhere);
        }
        if (!includeLibraryClasses && !includeLibrarySource) {
            return false;
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getNameSequence());
        Intrinsics.checkExpressionValueIsNotNull((Object)fileType, (String)"FileTypeManager.getInsta\u2026leName(file.nameSequence)");
        FileType fileType2 = fileType;
        boolean canContainClassFiles = Intrinsics.areEqual((Object)fileType2, (Object)ArchiveFileType.INSTANCE) || file2.isDirectory();
        boolean isBinary = ProjectRootsUtilKt.isKotlinBinary(fileType2);
        ScriptDependenciesManager scriptDependenciesManager = scriptConfigurationManager = includeScriptDependencies ? ScriptDependenciesManager.Companion.getInstance(project) : null;
        if (includeLibraryClasses && (isBinary || canContainClassFiles)) {
            if (fileIndex.isInLibraryClasses(file2)) {
                return true;
            }
            ScriptDependenciesManager scriptDependenciesManager2 = scriptConfigurationManager;
            if (scriptDependenciesManager2 != null && (scriptDependenciesManager2 = scriptDependenciesManager2.getAllScriptsClasspathScope()) != null) {
                if (scriptDependenciesManager2.contains(file2)) {
                    return true;
                }
            }
        }
        if (includeLibrarySource && !isBinary) {
            if (fileIndex.isInLibrarySource(file2)) {
                return true;
            }
            ScriptDependenciesManager scriptDependenciesManager3 = scriptConfigurationManager;
            if (scriptDependenciesManager3 != null && (scriptDependenciesManager3 = scriptDependenciesManager3.getAllLibrarySourcesScope()) != null) {
                if (scriptDependenciesManager3.contains(file2)) {
                    if (!ProjectRootsUtilKt.isInSourceContentWithoutInjected((FileIndex)fileIndex, file2)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static /* synthetic */ boolean isInContentWithoutScriptDefinitionCheck$default(ProjectRootsUtil projectRootsUtil, Project project, VirtualFile virtualFile2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, ProjectFileIndex projectFileIndex, int n, Object object) {
        if ((n & 0x80) != 0) {
            ProjectFileIndex projectFileIndex2 = ProjectFileIndex.SERVICE.getInstance((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex2, (String)"ProjectFileIndex.SERVICE.getInstance(project)");
            projectFileIndex = projectFileIndex2;
        }
        return projectRootsUtil.isInContentWithoutScriptDefinitionCheck(project, virtualFile2, bl, bl2, bl3, bl4, bl5, projectFileIndex);
    }

    @JvmStatic
    public static final boolean isInContent(@NotNull PsiElement element3, boolean includeProjectSource, boolean includeLibrarySource, boolean includeLibraryClasses, boolean includeScriptDependencies, boolean includeScriptsOutsideSourceRoots) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(element3, includeProjectSource, includeLibrarySource, includeLibraryClasses, includeScriptDependencies, includeScriptsOutsideSourceRoots){
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ boolean $includeProjectSource;
            final /* synthetic */ boolean $includeLibrarySource;
            final /* synthetic */ boolean $includeLibraryClasses;
            final /* synthetic */ boolean $includeScriptDependencies;
            final /* synthetic */ boolean $includeScriptsOutsideSourceRoots;

            public final boolean invoke() {
                Object object;
                PsiElement psiElement2 = this.$element;
                if (psiElement2 instanceof PsiDirectory) {
                    object = ((PsiDirectory)this.$element).getVirtualFile();
                } else {
                    PsiFile psiFile = this.$element.getContainingFile();
                    object = psiFile != null ? psiFile.getVirtualFile() : null;
                }
                if (object == null) {
                    return false;
                }
                VirtualFile virtualFile2 = object;
                Project project = this.$element.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
                Project project2 = project;
                return ProjectRootsUtil.isInContent$default(project2, virtualFile2, this.$includeProjectSource, this.$includeLibrarySource, this.$includeLibraryClasses, this.$includeScriptDependencies, this.$includeScriptsOutsideSourceRoots, null, 128, null);
            }
            {
                this.$element = psiElement2;
                this.$includeProjectSource = bl;
                this.$includeLibrarySource = bl2;
                this.$includeLibraryClasses = bl3;
                this.$includeScriptDependencies = bl4;
                this.$includeScriptsOutsideSourceRoots = bl5;
                super(0);
            }
        });
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isInProjectSource(@NotNull PsiElement element3, boolean includeScriptsOutsideSourceRoots) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return ProjectRootsUtil.isInContent(element3, true, false, false, false, includeScriptsOutsideSourceRoots);
    }

    public static /* synthetic */ boolean isInProjectSource$default(PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ProjectRootsUtil.isInProjectSource(psiElement2, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isInProjectSource(@NotNull PsiElement element3) {
        return ProjectRootsUtil.isInProjectSource$default(element3, false, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isProjectSourceFile(@NotNull Project project, @NotNull VirtualFile file2, boolean includeScriptsOutsideSourceRoots) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return ProjectRootsUtil.isInContent$default(project, file2, true, false, false, false, includeScriptsOutsideSourceRoots, null, 128, null);
    }

    public static /* synthetic */ boolean isProjectSourceFile$default(Project project, VirtualFile virtualFile2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return ProjectRootsUtil.isProjectSourceFile(project, virtualFile2, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isProjectSourceFile(@NotNull Project project, @NotNull VirtualFile file2) {
        return ProjectRootsUtil.isProjectSourceFile$default(project, file2, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isInProjectOrLibSource(@NotNull PsiElement element3, boolean includeScriptsOutsideSourceRoots) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return ProjectRootsUtil.isInContent(element3, true, true, false, false, includeScriptsOutsideSourceRoots);
    }

    public static /* synthetic */ boolean isInProjectOrLibSource$default(PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ProjectRootsUtil.isInProjectOrLibSource(psiElement2, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean isInProjectOrLibSource(@NotNull PsiElement element3) {
        return ProjectRootsUtil.isInProjectOrLibSource$default(element3, false, 2, null);
    }

    @JvmStatic
    public static final boolean isInProjectOrLibraryContent(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return ProjectRootsUtil.isInContent(element3, true, true, true, true, false);
    }

    @JvmStatic
    public static final boolean isInProjectOrLibraryClassFile(@NotNull PsiElement element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return ProjectRootsUtil.isInContent(element3, true, false, true, false, false);
    }

    @JvmStatic
    public static final boolean isLibraryClassFile(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return ProjectRootsUtil.isInContent$default(project, file2, false, false, true, true, false, null, 128, null);
    }

    @JvmStatic
    public static final boolean isLibrarySourceFile(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return ProjectRootsUtil.isInContent$default(project, file2, false, true, false, true, false, null, 128, null);
    }

    @JvmStatic
    public static final boolean isLibraryFile(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return ProjectRootsUtil.isInContent$default(project, file2, false, true, true, true, false, null, 128, null);
    }

    private ProjectRootsUtil() {
    }

    static {
        ProjectRootsUtil projectRootsUtil;
        INSTANCE = projectRootsUtil = new ProjectRootsUtil();
    }
}

