/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.StrictEqualityTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeNullability;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a \u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u0002\u001a\u00020\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u0007\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u000f\u001a\u00020\u0007*\u00020\u0007\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0007\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0007\u001a\u0018\u0010\u0014\u001a\u00020\u0007*\u00020\u00132\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a8\u0006\u0015"}, d2={"combineIfNoConflicts", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "other", "freeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "fuzzyExtensionReceiverType", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "fuzzyReturnType", "hasConflictWith", "", "Lorg/jetbrains/kotlin/types/TypeSubstitution;", "isAlmostEverything", "makeNotNullable", "makeNullable", "nullability", "Lorg/jetbrains/kotlin/types/typeUtil/TypeNullability;", "presentationType", "Lorg/jetbrains/kotlin/types/KotlinType;", "toFuzzyType", "ide-common"})
@JvmName(name="FuzzyTypeUtils")
public final class FuzzyTypeUtils {
    @Nullable
    public static final FuzzyType fuzzyReturnType(@NotNull CallableDescriptor $this$fuzzyReturnType) {
        FuzzyType fuzzyType;
        Intrinsics.checkParameterIsNotNull((Object)$this$fuzzyReturnType, (String)"$this$fuzzyReturnType");
        KotlinType kotlinType2 = $this$fuzzyReturnType.getReturnType();
        if (kotlinType2 != null) {
            List<TypeParameterDescriptor> list2 = $this$fuzzyReturnType.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"typeParameters");
            fuzzyType = FuzzyTypeUtils.toFuzzyType(kotlinType2, (Collection<? extends TypeParameterDescriptor>)list2);
        } else {
            fuzzyType = null;
        }
        return fuzzyType;
    }

    @Nullable
    public static final FuzzyType fuzzyExtensionReceiverType(@NotNull CallableDescriptor $this$fuzzyExtensionReceiverType) {
        FuzzyType fuzzyType;
        Intrinsics.checkParameterIsNotNull((Object)$this$fuzzyExtensionReceiverType, (String)"$this$fuzzyExtensionReceiverType");
        Annotated annotated = $this$fuzzyExtensionReceiverType.getExtensionReceiverParameter();
        if (annotated != null && (annotated = annotated.getType()) != null) {
            List<TypeParameterDescriptor> list2 = $this$fuzzyExtensionReceiverType.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"typeParameters");
            fuzzyType = FuzzyTypeUtils.toFuzzyType((KotlinType)annotated, (Collection<? extends TypeParameterDescriptor>)list2);
        } else {
            fuzzyType = null;
        }
        return fuzzyType;
    }

    @NotNull
    public static final FuzzyType makeNotNullable(@NotNull FuzzyType $this$makeNotNullable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$makeNotNullable, (String)"$this$makeNotNullable");
        return FuzzyTypeUtils.toFuzzyType(TypeUtilsKt.makeNotNullable($this$makeNotNullable.getType()), (Collection<? extends TypeParameterDescriptor>)$this$makeNotNullable.getFreeParameters());
    }

    @NotNull
    public static final FuzzyType makeNullable(@NotNull FuzzyType $this$makeNullable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$makeNullable, (String)"$this$makeNullable");
        return FuzzyTypeUtils.toFuzzyType(TypeUtilsKt.makeNullable($this$makeNullable.getType()), (Collection<? extends TypeParameterDescriptor>)$this$makeNullable.getFreeParameters());
    }

    @NotNull
    public static final TypeNullability nullability(@NotNull FuzzyType $this$nullability) {
        Intrinsics.checkParameterIsNotNull((Object)$this$nullability, (String)"$this$nullability");
        return TypeUtilsKt.nullability($this$nullability.getType());
    }

    public static final boolean isAlmostEverything(@NotNull FuzzyType $this$isAlmostEverything) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAlmostEverything, (String)"$this$isAlmostEverything");
        if ($this$isAlmostEverything.getFreeParameters().isEmpty()) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = $this$isAlmostEverything.getType().getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
            classifierDescriptor = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
        if (typeParameterDescriptor == null) {
            return false;
        }
        TypeParameterDescriptor typeParameter = typeParameterDescriptor;
        if (!$this$isAlmostEverything.getFreeParameters().contains(typeParameter)) {
            return false;
        }
        List<KotlinType> list2 = typeParameter.getUpperBounds();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"typeParameter.upperBounds");
        KotlinType kotlinType2 = (KotlinType)CollectionsKt.singleOrNull(list2);
        return kotlinType2 != null ? TypeUtilsKt.isAnyOrNullableAny(kotlinType2) : false;
    }

    @NotNull
    public static final KotlinType presentationType(@NotNull FuzzyType $this$presentationType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$presentationType, (String)"$this$presentationType");
        if ($this$presentationType.getFreeParameters().isEmpty()) {
            return $this$presentationType.getType();
        }
        HashMap map2 = new HashMap();
        Iterable iterable = $this$presentationType.getType().getArguments();
        List<TypeParameterDescriptor> list2 = $this$presentationType.getType().getConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"type.constructor.parameters");
        for (Pair pair2 : CollectionsKt.zip((Iterable)iterable, (Iterable)list2)) {
            TypeParameterDescriptor equalToFreeParameter;
            Object v3;
            TypeParameterDescriptor typeParameter;
            block5: {
                TypeProjection argument2 = (TypeProjection)pair2.component1();
                typeParameter = (TypeParameterDescriptor)pair2.component2();
                if (argument2.getProjectionKind() != Variance.INVARIANT) continue;
                Iterable $this$firstOrNull$iv = $this$presentationType.getFreeParameters();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl = false;
                    SimpleType simpleType2 = it.getDefaultType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"it.defaultType");
                    if (!StrictEqualityTypeChecker.INSTANCE.strictEqualTypes((UnwrappedType)simpleType2, argument2.getType().unwrap())) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            if ((TypeParameterDescriptor)v3 == null) {
                continue;
            }
            Map map3 = map2;
            TypeConstructor typeConstructor2 = equalToFreeParameter.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"equalToFreeParameter.typeConstructor");
            TypeParameterDescriptor typeParameterDescriptor = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"typeParameter");
            SimpleType simpleType3 = typeParameterDescriptor.getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"typeParameter.defaultType");
            map3.put(typeConstructor2, TypeUtilsKt.createProjection(simpleType3, Variance.INVARIANT, null));
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(map2);
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitutor2, (String)"TypeSubstitutor.create(map)");
        TypeSubstitutor substitutor3 = typeSubstitutor2;
        KotlinType kotlinType2 = substitutor3.substitute($this$presentationType.getType(), Variance.INVARIANT);
        if (kotlinType2 == null) {
            Intrinsics.throwNpe();
        }
        return kotlinType2;
    }

    @NotNull
    public static final FuzzyType toFuzzyType(@NotNull KotlinType $this$toFuzzyType, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toFuzzyType, (String)"$this$toFuzzyType");
        Intrinsics.checkParameterIsNotNull(freeParameters, (String)"freeParameters");
        return new FuzzyType($this$toFuzzyType, freeParameters);
    }

    public static final boolean hasConflictWith(@NotNull TypeSubstitution $this$hasConflictWith, @NotNull TypeSubstitution other, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$this$hasConflictWith, (String)"$this$hasConflictWith");
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            Intrinsics.checkParameterIsNotNull(freeParameters, (String)"freeParameters");
            Iterable $this$any$iv = freeParameters;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeProjection substituted2;
                    TypeProjection substituted1;
                    SimpleType type2;
                    TypeParameterDescriptor parameter = (TypeParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)parameter.getDefaultType(), (String)"parameter.defaultType");
                    boolean bl3 = $this$hasConflictWith.get(type2) == null ? false : (other.get(type2) == null ? false : !StrictEqualityTypeChecker.INSTANCE.strictEqualTypes(substituted1.getType().unwrap(), substituted2.getType().unwrap()) || substituted1.getProjectionKind() != substituted2.getProjectionKind());
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final TypeSubstitutor combineIfNoConflicts(@NotNull TypeSubstitutor $this$combineIfNoConflicts, @NotNull TypeSubstitutor other, @NotNull Collection<? extends TypeParameterDescriptor> freeParameters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$combineIfNoConflicts, (String)"$this$combineIfNoConflicts");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull(freeParameters, (String)"freeParameters");
        TypeSubstitution typeSubstitution = $this$combineIfNoConflicts.getSubstitution();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitution, (String)"this.substitution");
        TypeSubstitution typeSubstitution2 = other.getSubstitution();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeSubstitution2, (String)"other.substitution");
        if (FuzzyTypeUtils.hasConflictWith(typeSubstitution, typeSubstitution2, freeParameters)) {
            return null;
        }
        return TypeSubstitutor.createChainedSubstitutor($this$combineIfNoConflicts.getSubstitution(), other.getSubstitution());
    }
}

